/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import gnu.java.lang.CPStringBuilder;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;

public class MaskFormatter
extends DefaultFormatter {
    private static final char NUM_CHAR = '#';
    private static final char ESCAPE_CHAR = '\'';
    private static final char UPPERCASE_CHAR = 'U';
    private static final char LOWERCASE_CHAR = 'L';
    private static final char ALPHANUM_CHAR = 'A';
    private static final char LETTER_CHAR = '?';
    private static final char ANYTHING_CHAR = '*';
    private static final char HEX_CHAR = 'H';
    private String mask;
    private String invalidChars;
    private String validChars;
    private String placeHolder;
    private char placeHolderChar = (char)32;
    private boolean valueContainsLiteralCharacters = true;
    private static String hexString = "0123456789abcdefABCDEF";
    int maskLength = 0;

    public MaskFormatter() {
        this.setAllowsInvalid(false);
    }

    public MaskFormatter(String string) throws ParseException {
        this();
        this.setMask(string);
    }

    public String getMask() {
        return this.mask;
    }

    public String getInvalidCharacters() {
        return this.invalidChars;
    }

    public void setInvalidCharacters(String string) {
        this.invalidChars = string;
    }

    public String getValidCharacters() {
        return this.validChars;
    }

    public void setValidCharacters(String string) {
        this.validChars = string;
    }

    public String getPlaceholder() {
        return this.placeHolder;
    }

    public void setPlaceholder(String string) {
        this.placeHolder = string;
    }

    public char getPlaceholderCharacter() {
        return this.placeHolderChar;
    }

    public void setPlaceholderCharacter(char c) {
        this.placeHolderChar = c;
    }

    public boolean getValueContainsLiteralCharacters() {
        return this.valueContainsLiteralCharacters;
    }

    public void setValueContainsLiteralCharacters(boolean bl) {
        this.valueContainsLiteralCharacters = bl;
    }

    public void setMask(String string) throws ParseException {
        this.mask = string;
        int n = string.length() - 1;
        this.maskLength = 0;
        for (int i = 0; i <= n; ++i) {
            if (string.charAt(i) == '\'') {
                if (i != n) {
                    ++this.maskLength;
                }
                ++i;
                continue;
            }
            ++this.maskLength;
        }
    }

    public void install(JFormattedTextField jFormattedTextField) {
        super.install(jFormattedTextField);
        if (jFormattedTextField != null) {
            try {
                this.valueToString(jFormattedTextField.getValue());
            }
            catch (ParseException parseException) {
                jFormattedTextField.setText("");
                this.setEditValid(false);
            }
        }
    }

    public Object stringToValue(String string) throws ParseException {
        return super.stringToValue(this.convertStringToValue(string));
    }

    private String convertStringToValue(String string) throws ParseException {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        int n = this.mask.length();
        int n2 = 0;
        block10: for (int i = 0; i < n; ++i) {
            char c;
            boolean bl;
            char c2 = this.mask.charAt(i);
            if (n2 < string.length()) {
                bl = false;
                c = string.charAt(n2);
                if (c2 != '\'' && c2 != c) {
                    if (this.invalidChars != null && this.invalidChars.indexOf(c) != -1) {
                        throw new ParseException("Invalid character: " + c, n2);
                    }
                    if (this.validChars != null && this.validChars.indexOf(c) == -1) {
                        throw new ParseException("Invalid character: " + c, n2);
                    }
                }
            } else if (this.placeHolder != null && n2 < this.placeHolder.length()) {
                bl = true;
                c = this.placeHolder.charAt(n2);
            } else {
                bl = true;
                c = this.placeHolderChar;
            }
            switch (c2) {
                case '#': {
                    if (!Character.isDigit(c)) {
                        throw new ParseException("Number expected: " + c, n2);
                    }
                    cPStringBuilder.append(c);
                    ++n2;
                    continue block10;
                }
                case 'U': {
                    if (!Character.isLetter(c)) {
                        throw new ParseException("Letter expected", n2);
                    }
                    cPStringBuilder.append(Character.toUpperCase(c));
                    ++n2;
                    continue block10;
                }
                case 'L': {
                    if (!Character.isLetter(c)) {
                        throw new ParseException("Letter expected", n2);
                    }
                    cPStringBuilder.append(Character.toLowerCase(c));
                    ++n2;
                    continue block10;
                }
                case 'A': {
                    if (!Character.isLetterOrDigit(c)) {
                        throw new ParseException("Letter or number expected", n2);
                    }
                    cPStringBuilder.append(c);
                    ++n2;
                    continue block10;
                }
                case '?': {
                    if (!Character.isLetter(c)) {
                        throw new ParseException("Letter expected", n2);
                    }
                    cPStringBuilder.append(c);
                    ++n2;
                    continue block10;
                }
                case 'H': {
                    if (hexString.indexOf(c) == -1 && !bl) {
                        throw new ParseException("Hexadecimal character expected", n2);
                    }
                    cPStringBuilder.append(c);
                    ++n2;
                    continue block10;
                }
                case '*': {
                    cPStringBuilder.append(c);
                    ++n2;
                    continue block10;
                }
                case '\'': {
                    if (++i < n) {
                        c2 = this.mask.charAt(i);
                        if (!bl && this.getValueContainsLiteralCharacters() && c != c2) {
                            throw new ParseException("Invalid character: " + c, n2);
                        }
                        if (this.getValueContainsLiteralCharacters()) {
                            cPStringBuilder.append(c2);
                        }
                        ++n2;
                        continue block10;
                    }
                    if (bl) continue block10;
                    throw new ParseException("Bad match at trailing escape: ", n2);
                }
                default: {
                    if (!bl && this.getValueContainsLiteralCharacters() && c != c2) {
                        throw new ParseException("Invalid character: " + c, n2);
                    }
                    if (this.getValueContainsLiteralCharacters()) {
                        cPStringBuilder.append(c2);
                    }
                    ++n2;
                }
            }
        }
        return cPStringBuilder.toString();
    }

    public String valueToString(Object object) throws ParseException {
        String string = object != null ? object.toString() : "";
        return this.convertValueToString(string);
    }

    private String convertValueToString(String string) throws ParseException {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        int n = this.mask.length();
        int n2 = 0;
        block10: for (int i = 0; i < n; ++i) {
            char c;
            boolean bl;
            char c2 = this.mask.charAt(i);
            if (n2 < string.length()) {
                bl = false;
                c = string.charAt(n2);
                if (c2 != '\'' && c != c2) {
                    if (this.invalidChars != null && this.invalidChars.indexOf(c) != -1) {
                        throw new ParseException("Invalid character: " + c, n2);
                    }
                    if (this.validChars != null && this.validChars.indexOf(c) == -1) {
                        throw new ParseException("Invalid character: " + c + " maskChar: " + c2, n2);
                    }
                }
            } else if (this.placeHolder != null && n2 < this.placeHolder.length()) {
                bl = true;
                c = this.placeHolder.charAt(n2);
            } else {
                bl = true;
                c = this.placeHolderChar;
            }
            switch (c2) {
                case '#': {
                    if (!bl && !Character.isDigit(c)) {
                        throw new ParseException("Number expected: " + c, n2);
                    }
                    cPStringBuilder.append(c);
                    ++n2;
                    continue block10;
                }
                case 'U': {
                    if (!Character.isLetter(c)) {
                        throw new ParseException("Letter expected", n2);
                    }
                    cPStringBuilder.append(Character.toUpperCase(c));
                    ++n2;
                    continue block10;
                }
                case 'L': {
                    if (!Character.isLetter(c)) {
                        throw new ParseException("Letter expected", n2);
                    }
                    cPStringBuilder.append(Character.toLowerCase(c));
                    ++n2;
                    continue block10;
                }
                case 'A': {
                    if (!Character.isLetterOrDigit(c)) {
                        throw new ParseException("Letter or number expected", n2);
                    }
                    cPStringBuilder.append(c);
                    ++n2;
                    continue block10;
                }
                case '?': {
                    if (!Character.isLetter(c)) {
                        throw new ParseException("Letter expected", n2);
                    }
                    cPStringBuilder.append(c);
                    ++n2;
                    continue block10;
                }
                case 'H': {
                    if (hexString.indexOf(c) == -1 && !bl) {
                        throw new ParseException("Hexadecimal character expected", n2);
                    }
                    cPStringBuilder.append(c);
                    ++n2;
                    continue block10;
                }
                case '*': {
                    cPStringBuilder.append(c);
                    ++n2;
                    continue block10;
                }
                case '\'': {
                    if (++i >= n) continue block10;
                    c2 = this.mask.charAt(i);
                    if (!bl && this.getValueContainsLiteralCharacters() && c != c2) {
                        throw new ParseException("Invalid character: " + c, n2);
                    }
                    if (this.getValueContainsLiteralCharacters()) {
                        ++n2;
                    }
                    cPStringBuilder.append(c2);
                    continue block10;
                }
                default: {
                    if (!bl && this.getValueContainsLiteralCharacters() && c != c2) {
                        throw new ParseException("Invalid character: " + c, n2);
                    }
                    if (this.getValueContainsLiteralCharacters()) {
                        ++n2;
                    }
                    cPStringBuilder.append(c2);
                }
            }
        }
        return cPStringBuilder.toString();
    }
}

