/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.Toolkit;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.ViewFactory;

public class LabelView
extends GlyphView {
    Color background;
    Color foreground;
    Font font;
    boolean strikeThrough;
    boolean underline;
    boolean subscript;
    boolean superscript;
    private boolean valid = false;

    public LabelView(Element element) {
        super(element);
    }

    protected void setPropertiesFromAttributes() {
        AttributeSet attributeSet = this.getAttributes();
        this.setStrikeThrough(StyleConstants.isStrikeThrough(attributeSet));
        this.setSubscript(StyleConstants.isSubscript(attributeSet));
        this.setSuperscript(StyleConstants.isSuperscript(attributeSet));
        this.setUnderline(StyleConstants.isUnderline(attributeSet));
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            StyledDocument styledDocument = (StyledDocument)document;
            this.font = styledDocument.getFont(attributeSet);
            this.background = attributeSet.isDefined(StyleConstants.Background) ? styledDocument.getBackground(attributeSet) : null;
            this.foreground = styledDocument.getForeground(attributeSet);
        }
        this.valid = true;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.valid = false;
        super.changedUpdate(documentEvent, shape, viewFactory);
    }

    public Color getBackground() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.background;
    }

    protected void setBackground(Color color) {
        this.background = color;
    }

    public Color getForeground() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.foreground;
    }

    public Font getFont() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.font;
    }

    protected FontMetrics getFontMetrics() {
        Container container;
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        FontMetrics fontMetrics = (container = this.getContainer()) != null ? container.getFontMetrics(this.font) : Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        return fontMetrics;
    }

    public boolean isUnderline() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.underline;
    }

    protected void setUnderline(boolean bl) {
        this.underline = bl;
    }

    public boolean isSubscript() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.subscript;
    }

    protected void setSubscript(boolean bl) {
        this.subscript = bl;
    }

    public boolean isSuperscript() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.superscript;
    }

    protected void setSuperscript(boolean bl) {
        this.superscript = bl;
    }

    public boolean isStrikeThrough() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.strikeThrough;
    }

    protected void setStrikeThrough(boolean bl) {
        this.strikeThrough = bl;
    }
}

