/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import gnu.java.lang.CPStringBuilder;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public abstract class JTextComponent
extends JComponent
implements Scrollable,
Accessible {
    private static final long serialVersionUID = -8796518220218978795L;
    public static final String DEFAULT_KEYMAP = "default";
    public static final String FOCUS_ACCELERATOR_KEY = "focusAcceleratorKey";
    private static DefaultTransferHandler defaultTransferHandler;
    private static Hashtable keymaps;
    private Keymap keymap;
    private char focusAccelerator = '\u0000';
    private NavigationFilter navigationFilter;
    Document doc;
    Caret caret;
    boolean editable;
    private Highlighter highlighter;
    private Color caretColor;
    private Color disabledTextColor;
    private Color selectedTextColor;
    private Color selectionColor;
    private Insets margin;
    private boolean dragEnabled;

    public static Keymap getKeymap(String string) {
        return (Keymap)keymaps.get(string);
    }

    public static Keymap removeKeymap(String string) {
        Keymap keymap = (Keymap)keymaps.get(string);
        keymaps.remove(string);
        return keymap;
    }

    public static Keymap addKeymap(String string, Keymap keymap) {
        DefaultKeymap defaultKeymap = new DefaultKeymap(string);
        defaultKeymap.setResolveParent(keymap);
        if (string != null) {
            keymaps.put(string, defaultKeymap);
        }
        return defaultKeymap;
    }

    public Keymap getKeymap() {
        return this.keymap;
    }

    public void setKeymap(Keymap keymap) {
        KeymapWrapper keymapWrapper = keymap == null ? null : new KeymapWrapper(keymap);
        InputMap inputMap = this.getInputMap(0);
        if (inputMap == null) {
            this.setInputMap(0, keymapWrapper);
        } else {
            while (inputMap.getParent() != null && !(inputMap.getParent() instanceof KeymapWrapper) && !(inputMap.getParent() instanceof InputMapUIResource)) {
                inputMap = inputMap.getParent();
            }
            if (inputMap.getParent() == null) {
                inputMap.setParent(keymapWrapper);
            } else if (inputMap.getParent() instanceof KeymapWrapper) {
                if (keymapWrapper == null) {
                    inputMap.setParent(inputMap.getParent().getParent());
                } else {
                    keymapWrapper.setParent(inputMap.getParent().getParent());
                    inputMap.setParent(keymapWrapper);
                }
            } else if (inputMap.getParent() instanceof InputMapUIResource && keymapWrapper != null) {
                keymapWrapper.setParent(inputMap.getParent());
                inputMap.setParent(keymapWrapper);
            }
        }
        KeymapActionMap keymapActionMap = keymap == null ? null : new KeymapActionMap(keymap);
        ActionMap actionMap = this.getActionMap();
        if (actionMap == null) {
            this.setActionMap(keymapActionMap);
        } else {
            while (actionMap.getParent() != null && !(actionMap.getParent() instanceof KeymapActionMap) && !(actionMap.getParent() instanceof ActionMapUIResource)) {
                actionMap = actionMap.getParent();
            }
            if (actionMap.getParent() == null) {
                actionMap.setParent(keymapActionMap);
            } else if (actionMap.getParent() instanceof KeymapActionMap) {
                if (keymapActionMap == null) {
                    actionMap.setParent(actionMap.getParent().getParent());
                } else {
                    keymapActionMap.setParent(actionMap.getParent().getParent());
                    actionMap.setParent(keymapActionMap);
                }
            } else if (actionMap.getParent() instanceof ActionMapUIResource && keymapActionMap != null) {
                keymapActionMap.setParent(actionMap.getParent());
                actionMap.setParent(keymapActionMap);
            }
        }
        Keymap keymap2 = this.keymap;
        this.keymap = keymap;
        this.firePropertyChange("keymap", keymap2, keymap);
    }

    public static void loadKeymap(Keymap keymap, KeyBinding[] keyBindingArray, Action[] actionArray) {
        int n;
        Hashtable<Object, Action> hashtable = new Hashtable<Object, Action>(actionArray.length);
        for (n = 0; n < actionArray.length; ++n) {
            hashtable.put(actionArray[n].getValue("Name"), actionArray[n]);
        }
        for (n = 0; n < keyBindingArray.length; ++n) {
            if (!hashtable.containsKey(keyBindingArray[n].actionName)) continue;
            keymap.addActionForKeyStroke(keyBindingArray[n].key, (Action)hashtable.get(keyBindingArray[n].actionName));
        }
    }

    public Action[] getActions() {
        return this.getUI().getEditorKit(this).getActions();
    }

    public JTextComponent() {
        Keymap keymap = JTextComponent.getKeymap(DEFAULT_KEYMAP);
        if (keymap == null) {
            keymap = JTextComponent.addKeymap(DEFAULT_KEYMAP, null);
            keymap.setDefaultAction(new DefaultEditorKit.DefaultKeyTypedAction());
        }
        this.setFocusable(true);
        this.setEditable(true);
        this.enableEvents(8L);
        this.setOpaque(true);
        this.updateUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocument(Document document) {
        Document document2 = this.doc;
        try {
            if (document2 instanceof AbstractDocument) {
                ((AbstractDocument)document2).readLock();
            }
            this.doc = document;
            this.firePropertyChange("document", document2, document);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (document2 instanceof AbstractDocument) {
                ((AbstractDocument)document2).readUnlock();
            }
            throw throwable;
        }
        if (document2 instanceof AbstractDocument) {
            ((AbstractDocument)document2).readUnlock();
        }
        this.revalidate();
        this.repaint();
    }

    public Document getDocument() {
        return this.doc;
    }

    public AccessibleContext getAccessibleContext() {
        return new AccessibleJTextComponent();
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setText(String string) {
        try {
            if (this.doc instanceof AbstractDocument) {
                ((AbstractDocument)this.doc).replace(0, this.doc.getLength(), string, null);
            } else {
                this.doc.remove(0, this.doc.getLength());
                this.doc.insertString(0, string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            throw (InternalError)new InternalError().initCause(badLocationException);
        }
    }

    public String getText() {
        if (this.doc == null) {
            return null;
        }
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.getDocument().getText(n, n2);
    }

    public String getSelectedText() {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd() - n;
        if (n2 <= 0) {
            return null;
        }
        try {
            return this.doc.getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String getUIClassID() {
        return "TextComponentUI";
    }

    protected String paramString() {
        return super.paramString();
    }

    public TextUI getUI() {
        return (TextUI)this.ui;
    }

    public void setUI(TextUI textUI) {
        super.setUI(textUI);
    }

    public void updateUI() {
        this.setUI((TextUI)UIManager.getUI(this));
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width / 10;
        }
        if (n == 1) {
            return rectangle.height / 10;
        }
        throw new IllegalArgumentException("orientation must be either javax.swing.SwingConstants.VERTICAL or javax.swing.SwingConstants.HORIZONTAL");
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width;
        }
        if (n == 1) {
            return rectangle.height;
        }
        throw new IllegalArgumentException("orientation must be either javax.swing.SwingConstants.VERTICAL or javax.swing.SwingConstants.HORIZONTAL");
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        boolean bl2 = this.editable;
        this.editable = bl;
        this.firePropertyChange("editable", bl2, bl);
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret caret) {
        if (this.caret != null) {
            this.caret.deinstall(this);
        }
        Caret caret2 = this.caret;
        this.caret = caret;
        if (this.caret != null) {
            this.caret.install(this);
        }
        this.firePropertyChange("caret", caret2, caret);
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color color) {
        Color color2 = this.caretColor;
        this.caretColor = color;
        this.firePropertyChange("caretColor", color2, color);
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(Color color) {
        Color color2 = this.disabledTextColor;
        this.disabledTextColor = color;
        this.firePropertyChange("disabledTextColor", color2, color);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(Color color) {
        Color color2 = this.selectedTextColor;
        this.selectedTextColor = color;
        this.firePropertyChange("selectedTextColor", color2, color);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        Color color2 = this.selectionColor;
        this.selectionColor = color;
        this.firePropertyChange("selectionColor", color2, color);
    }

    public int getCaretPosition() {
        return this.caret.getDot();
    }

    public void setCaretPosition(int n) {
        if (this.doc == null) {
            return;
        }
        if (n < 0 || n > this.doc.getLength()) {
            throw new IllegalArgumentException();
        }
        this.caret.setDot(n);
    }

    public void moveCaretPosition(int n) {
        if (this.doc == null) {
            return;
        }
        if (n < 0 || n > this.doc.getLength()) {
            throw new IllegalArgumentException();
        }
        this.caret.moveDot(n);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter highlighter) {
        if (this.highlighter != null) {
            this.highlighter.deinstall(this);
        }
        Highlighter highlighter2 = this.highlighter;
        this.highlighter = highlighter;
        if (this.highlighter != null) {
            this.highlighter.install(this);
        }
        this.firePropertyChange("highlighter", highlighter2, highlighter);
    }

    public int getSelectionStart() {
        return Math.min(this.caret.getDot(), this.caret.getMark());
    }

    public void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd());
    }

    public int getSelectionEnd() {
        return Math.max(this.caret.getDot(), this.caret.getMark());
    }

    public void setSelectionEnd(int n) {
        this.select(this.getSelectionStart(), n);
    }

    public void select(int n, int n2) {
        int n3 = this.doc.getLength();
        n = Math.max(n, 0);
        n = Math.min(n, n3);
        n2 = Math.max(n2, n);
        n2 = Math.min(n2, n3);
        this.setCaretPosition(n);
        this.moveCaretPosition(n2);
    }

    public void selectAll() {
        this.select(0, this.doc.getLength());
    }

    public synchronized void replaceSelection(String string) {
        int n = this.caret.getDot();
        int n2 = this.caret.getMark();
        if (string == null) {
            this.caret.setDot(n);
            return;
        }
        try {
            int n3 = this.getSelectionStart();
            int n4 = this.getSelectionEnd();
            if (n != n2) {
                this.doc.remove(n3, n4 - n3);
            }
            this.doc.insertString(n3, string, null);
            n = n3 + string.length();
            this.setCaretPosition(n);
            this.caret.setMagicCaretPosition(this.modelToView(n).getLocation());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        boolean bl = false;
        Container container = this.getParent();
        if (container instanceof JViewport) {
            bl = ((JViewport)container).getExtentSize().width > this.getPreferredSize().width;
        }
        return bl;
    }

    public void addCaretListener(CaretListener caretListener) {
        this.listenerList.add(CaretListener.class, caretListener);
    }

    public void removeCaretListener(CaretListener caretListener) {
        this.listenerList.remove(CaretListener.class, caretListener);
    }

    public CaretListener[] getCaretListeners() {
        return (CaretListener[])this.getListeners(CaretListener.class);
    }

    protected void fireCaretUpdate(CaretEvent caretEvent) {
        CaretListener[] caretListenerArray = this.getCaretListeners();
        for (int i = 0; i < caretListenerArray.length; ++i) {
            caretListenerArray[i].caretUpdate(caretEvent);
        }
    }

    public void addInputMethodListener(InputMethodListener inputMethodListener) {
        this.listenerList.add(InputMethodListener.class, inputMethodListener);
    }

    public void removeInputMethodListener(InputMethodListener inputMethodListener) {
        this.listenerList.remove(InputMethodListener.class, inputMethodListener);
    }

    public InputMethodListener[] getInputMethodListeners() {
        return (InputMethodListener[])this.getListeners(InputMethodListener.class);
    }

    public Rectangle modelToView(int n) throws BadLocationException {
        return this.getUI().modelToView(this, n);
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public int viewToModel(Point point) {
        return this.getUI().viewToModel(this, point);
    }

    public void copy() {
        if (this.isEnabled()) {
            this.doTransferAction("copy", TransferHandler.getCopyAction());
        }
    }

    public void cut() {
        if (this.editable && this.isEnabled()) {
            this.doTransferAction("cut", TransferHandler.getCutAction());
        }
    }

    public void paste() {
        if (this.editable && this.isEnabled()) {
            this.doTransferAction("paste", TransferHandler.getPasteAction());
        }
    }

    private void doTransferAction(String string, Action action) {
        if (this.getTransferHandler() == null) {
            if (defaultTransferHandler == null) {
                defaultTransferHandler = new DefaultTransferHandler();
            }
            this.setTransferHandler(defaultTransferHandler);
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, action.getValue("Name").toString());
        action.actionPerformed(actionEvent);
    }

    public void setFocusAccelerator(char c) {
        if (this.focusAccelerator == c) {
            return;
        }
        char c2 = this.focusAccelerator;
        this.focusAccelerator = c;
        this.firePropertyChange(FOCUS_ACCELERATOR_KEY, c2, c);
    }

    public char getFocusAccelerator() {
        return this.focusAccelerator;
    }

    public NavigationFilter getNavigationFilter() {
        return this.navigationFilter;
    }

    public void setNavigationFilter(NavigationFilter navigationFilter) {
        this.navigationFilter = navigationFilter;
    }

    public void read(Reader reader, Object object) throws IOException {
        int n;
        Object object2;
        if (object != null && (object2 = this.getDocument()) != null) {
            object2.putProperty("stream", object);
        }
        object2 = new CPStringBuilder();
        while ((n = reader.read()) >= 0) {
            ((CPStringBuilder)object2).append((char)n);
        }
        this.setText(((CPStringBuilder)object2).toString());
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.getText());
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getUI().getToolTipText(this, mouseEvent.getPoint());
    }

    static {
        keymaps = new Hashtable();
    }

    class DefaultTransferHandler
    extends TransferHandler {
        DefaultTransferHandler() {
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (!jTextComponent.isEnabled() || !jTextComponent.isEditable() || dataFlavorArray == null) {
                return false;
            }
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                return true;
            }
            return false;
        }

        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            int n2;
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            int n3 = jTextComponent.getSelectionStart();
            if (n3 == (n2 = jTextComponent.getSelectionEnd())) {
                return;
            }
            try {
                String string = jTextComponent.getDocument().getText(n3, n2);
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, null);
                if (n == 2) {
                    JTextComponent.this.doc.remove(n3, n2 - n3);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public int getSourceActions() {
            return 0;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            DataFlavor dataFlavor = null;
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            if (dataFlavorArray == null) {
                return false;
            }
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                dataFlavor = dataFlavorArray[i];
            }
            if (dataFlavor == null) {
                return false;
            }
            try {
                JTextComponent jTextComponent = (JTextComponent)jComponent;
                String string = (String)transferable.getTransferData(dataFlavor);
                jTextComponent.replaceSelection(string);
                return true;
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
            return false;
        }
    }

    static class DefaultKeymap
    implements Keymap {
        String name;
        Keymap parent;
        Hashtable map;
        Action defaultAction;

        public DefaultKeymap(String string) {
            this.name = string;
            this.map = new Hashtable();
        }

        public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
            this.map.put(keyStroke, action);
        }

        public Action getAction(KeyStroke keyStroke) {
            if (this.map.containsKey(keyStroke)) {
                return (Action)this.map.get(keyStroke);
            }
            if (this.parent != null) {
                return this.parent.getAction(keyStroke);
            }
            return null;
        }

        public Action[] getBoundActions() {
            Action[] actionArray = new Action[this.map.size()];
            Enumeration enumeration = this.map.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                actionArray[n++] = (Action)enumeration.nextElement();
            }
            return actionArray;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] keyStrokeArray = new KeyStroke[this.map.size()];
            Enumeration enumeration = this.map.keys();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                keyStrokeArray[n++] = (KeyStroke)enumeration.nextElement();
            }
            return keyStrokeArray;
        }

        public Action getDefaultAction() {
            return this.defaultAction;
        }

        public KeyStroke[] getKeyStrokesForAction(Action action) {
            int n = 0;
            Enumeration enumeration = this.map.keys();
            while (enumeration.hasMoreElements()) {
                if (!this.map.get(enumeration.nextElement()).equals(action)) continue;
                ++n;
            }
            KeyStroke[] keyStrokeArray = new KeyStroke[n];
            n = 0;
            enumeration = this.map.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
                if (!this.map.get(keyStroke).equals(action)) continue;
                keyStrokeArray[n++] = keyStroke;
            }
            return keyStrokeArray;
        }

        public String getName() {
            return this.name;
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public boolean isLocallyDefined(KeyStroke keyStroke) {
            return this.map.containsKey(keyStroke);
        }

        public void removeBindings() {
            this.map.clear();
        }

        public void removeKeyStrokeBinding(KeyStroke keyStroke) {
            this.map.remove(keyStroke);
        }

        public void setDefaultAction(Action action) {
            this.defaultAction = action;
        }

        public void setResolveParent(Keymap keymap) {
            this.parent = keymap;
        }
    }

    private class KeymapActionMap
    extends ActionMap {
        Keymap map;

        public KeymapActionMap(Keymap keymap) {
            this.map = keymap;
        }

        public Action get(Object object) {
            if (object instanceof Action) {
                return (Action)object;
            }
            return super.get(object);
        }

        public int size() {
            return this.map.getBoundKeyStrokes().length + super.size();
        }

        public Object[] keys() {
            int n;
            Object[] objectArray = super.keys();
            KeyStroke[] keyStrokeArray = this.map.getBoundKeyStrokes();
            Object[] objectArray2 = new Object[objectArray.length + keyStrokeArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                objectArray2[n] = objectArray[n];
            }
            for (n = 0; n < keyStrokeArray.length; ++n) {
                objectArray2[n + objectArray.length] = keyStrokeArray[n];
            }
            return objectArray2;
        }

        public Object[] allKeys() {
            int n;
            Object[] objectArray = super.allKeys();
            KeyStroke[] keyStrokeArray = this.map.getBoundKeyStrokes();
            Object[] objectArray2 = new Object[objectArray.length + keyStrokeArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                objectArray2[n] = objectArray[n];
            }
            for (n = 0; n < keyStrokeArray.length; ++n) {
                objectArray2[n + objectArray.length] = keyStrokeArray[n];
            }
            return objectArray2;
        }
    }

    private class KeymapWrapper
    extends InputMap {
        Keymap map;

        public KeymapWrapper(Keymap keymap) {
            this.map = keymap;
        }

        public int size() {
            return this.map.getBoundKeyStrokes().length + super.size();
        }

        public Object get(KeyStroke keyStroke) {
            Action action = null;
            Keymap keymap = this.map;
            while (action == null && keymap != null) {
                action = keymap.getAction(keyStroke);
                if (action == null && keyStroke.getKeyEventType() == 400) {
                    action = keymap.getDefaultAction();
                }
                if (action != null) continue;
                keymap = keymap.getResolveParent();
            }
            if (action == null) {
                return super.get(keyStroke);
            }
            return action;
        }

        public KeyStroke[] keys() {
            int n;
            KeyStroke[] keyStrokeArray = super.keys();
            KeyStroke[] keyStrokeArray2 = this.map.getBoundKeyStrokes();
            KeyStroke[] keyStrokeArray3 = new KeyStroke[keyStrokeArray.length + keyStrokeArray2.length];
            for (n = 0; n < keyStrokeArray.length; ++n) {
                keyStrokeArray3[n] = keyStrokeArray[n];
            }
            for (n = 0; n < keyStrokeArray2.length; ++n) {
                keyStrokeArray3[n + keyStrokeArray.length] = keyStrokeArray2[n];
            }
            return keyStrokeArray3;
        }

        public KeyStroke[] allKeys() {
            int n;
            KeyStroke[] keyStrokeArray = super.allKeys();
            KeyStroke[] keyStrokeArray2 = this.map.getBoundKeyStrokes();
            int n2 = 0;
            int n3 = 0;
            if (keyStrokeArray != null) {
                n2 = keyStrokeArray.length;
            }
            if (keyStrokeArray2 != null) {
                n3 = keyStrokeArray2.length;
            }
            KeyStroke[] keyStrokeArray3 = new KeyStroke[n2 + n3];
            for (n = 0; n < n2; ++n) {
                keyStrokeArray3[n] = keyStrokeArray[n];
            }
            for (n = 0; n < n3; ++n) {
                keyStrokeArray3[n + n2] = keyStrokeArray2[n];
            }
            return keyStrokeArray3;
        }
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke keyStroke, String string) {
            this.key = keyStroke;
            this.actionName = string;
        }
    }

    public class AccessibleJTextComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    CaretListener,
    DocumentListener,
    AccessibleAction,
    AccessibleEditableText {
        private static final long serialVersionUID = 7664188944091413696L;
        private int caretDot;

        public AccessibleJTextComponent() {
            JTextComponent.this.addCaretListener(this);
            this.caretDot = this.getCaretPosition();
        }

        public int getCaretPosition() {
            return JTextComponent.this.getCaretPosition();
        }

        public String getSelectedText() {
            return JTextComponent.this.getSelectedText();
        }

        public int getSelectionStart() {
            if (this.getSelectedText() == null || JTextComponent.this.getText().equals("")) {
                return 0;
            }
            return JTextComponent.this.getSelectionStart();
        }

        public int getSelectionEnd() {
            return JTextComponent.this.getSelectionEnd();
        }

        public void caretUpdate(CaretEvent caretEvent) {
            int n = caretEvent.getDot();
            int n2 = caretEvent.getMark();
            if (this.caretDot != n) {
                this.firePropertyChange("AccessibleCaret", new Integer(this.caretDot), new Integer(n));
                this.caretDot = n;
            }
            if (n2 != n) {
                this.firePropertyChange("AccessibleSelection", null, this.getSelectedText());
            }
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JTextComponent.this.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleEditableText getAccessibleEditableText() {
            return this;
        }

        public AccessibleText getAccessibleText() {
            return this;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.firePropertyChange("AccessibleText", null, new Integer(documentEvent.getOffset()));
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.firePropertyChange("AccessibleText", null, new Integer(documentEvent.getOffset()));
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.firePropertyChange("AccessibleText", null, new Integer(documentEvent.getOffset()));
        }

        public int getIndexAtPoint(Point point) {
            return JTextComponent.this.viewToModel(point);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Rectangle getCharacterBounds(int n) {
            Rectangle rectangle = null;
            if (n < 0) return rectangle;
            if (n >= JTextComponent.this.doc.getLength() - 1) return rectangle;
            if (JTextComponent.this.doc instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.doc).readLock();
            }
            try {
                block5: {
                    try {
                        TextUI textUI = JTextComponent.this.getUI();
                        if (textUI == null) break block5;
                        Rectangle rectangle2 = new Rectangle();
                        Insets insets = JTextComponent.this.getInsets();
                        rectangle2.x = insets.left;
                        rectangle2.y = insets.top;
                        rectangle2.width = JTextComponent.this.getWidth() - insets.left - insets.right;
                        rectangle2.height = JTextComponent.this.getHeight() - insets.top - insets.bottom;
                        View view = textUI.getRootView(JTextComponent.this);
                        if (view == null) break block5;
                        view.setSize(rectangle2.width, rectangle2.height);
                        Shape shape = view.modelToView(n, Position.Bias.Forward, n + 1, Position.Bias.Backward, rectangle2);
                        if (shape == null) break block5;
                        rectangle = shape.getBounds();
                    }
                    catch (BadLocationException badLocationException) {
                        Object var9_10 = null;
                        if (!(JTextComponent.this.doc instanceof AbstractDocument)) return rectangle;
                        ((AbstractDocument)JTextComponent.this.doc).readUnlock();
                        return rectangle;
                    }
                }
                Object var9_9 = null;
                if (!(JTextComponent.this.doc instanceof AbstractDocument)) return rectangle;
                ((AbstractDocument)JTextComponent.this.doc).readUnlock();
                return rectangle;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (!(JTextComponent.this.doc instanceof AbstractDocument)) throw throwable;
                ((AbstractDocument)JTextComponent.this.doc).readUnlock();
                throw throwable;
            }
        }

        public int getCharCount() {
            return JTextComponent.this.getText().length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getCharacterAttribute(int n) {
            AttributeSet attributeSet;
            if (JTextComponent.this.doc instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.doc).readLock();
            }
            try {
                Element element = JTextComponent.this.doc.getDefaultRootElement();
                while (!element.isLeaf()) {
                    int n2 = element.getElementIndex(n);
                    element = element.getElement(n2);
                }
                attributeSet = element.getAttributes();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (JTextComponent.this.doc instanceof AbstractDocument) {
                    ((AbstractDocument)JTextComponent.this.doc).readUnlock();
                }
                throw throwable;
            }
            if (JTextComponent.this.doc instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.doc).readUnlock();
            }
            return attributeSet;
        }

        public String getAtIndex(int n, int n2) {
            return this.getAtIndexImpl(n, n2, 0);
        }

        public String getAfterIndex(int n, int n2) {
            return this.getAtIndexImpl(n, n2, 1);
        }

        public String getBeforeIndex(int n, int n2) {
            return this.getAtIndexImpl(n, n2, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getAtIndexImpl(int n, int n2, int n3) {
            String string = null;
            if (JTextComponent.this.doc instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.doc).readLock();
            }
            try {
                try {
                    BreakIterator breakIterator = null;
                    switch (n) {
                        case 1: {
                            breakIterator = BreakIterator.getCharacterInstance(this.getLocale());
                            break;
                        }
                        case 2: {
                            breakIterator = BreakIterator.getWordInstance(this.getLocale());
                            break;
                        }
                        case 3: {
                            breakIterator = BreakIterator.getSentenceInstance(this.getLocale());
                            break;
                        }
                    }
                    String string2 = JTextComponent.this.doc.getText(0, JTextComponent.this.doc.getLength() - 1);
                    breakIterator.setText(string2);
                    int n4 = n2;
                    int n5 = n2;
                    switch (n3) {
                        case 0: {
                            if (breakIterator.isBoundary(n2)) {
                                n4 = n2;
                                n5 = breakIterator.following(n2);
                                break;
                            }
                            n4 = breakIterator.preceding(n2);
                            n5 = breakIterator.next();
                            break;
                        }
                        case 1: {
                            n4 = breakIterator.following(n2);
                            n5 = breakIterator.next();
                            break;
                        }
                        case -1: {
                            n5 = breakIterator.preceding(n2);
                            n4 = breakIterator.previous();
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    string = string2.substring(n4, n5);
                }
                catch (BadLocationException badLocationException) {
                    Object var10_11 = null;
                    if (!(JTextComponent.this.doc instanceof AbstractDocument)) return string;
                    ((AbstractDocument)JTextComponent.this.doc).readUnlock();
                    return string;
                }
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (!(JTextComponent.this.doc instanceof AbstractDocument)) throw throwable;
                ((AbstractDocument)JTextComponent.this.doc).readUnlock();
                throw throwable;
            }
            if (!(JTextComponent.this.doc instanceof AbstractDocument)) return string;
            ((AbstractDocument)JTextComponent.this.doc).readUnlock();
            return string;
        }

        public int getAccessibleActionCount() {
            return JTextComponent.this.getActions().length;
        }

        public String getAccessibleActionDescription(int n) {
            String string = null;
            Action[] actionArray = JTextComponent.this.getActions();
            if (n >= 0 && n < actionArray.length) {
                string = (String)actionArray[n].getValue("Name");
            }
            return string;
        }

        public boolean doAccessibleAction(int n) {
            boolean bl = false;
            Action[] actionArray = JTextComponent.this.getActions();
            if (n >= 0 && n < actionArray.length) {
                ActionEvent actionEvent = new ActionEvent(JTextComponent.this, 1001, null);
                actionArray[n].actionPerformed(actionEvent);
                bl = true;
            }
            return bl;
        }

        public void setTextContents(String string) {
            JTextComponent.this.setText(string);
        }

        public void insertTextAtIndex(int n, String string) {
            try {
                JTextComponent.this.doc.insertString(n, string, null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public String getTextRange(int n, int n2) {
            try {
                return JTextComponent.this.getText(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }

        public void delete(int n, int n2) {
            this.replaceText(n, n2, "");
        }

        public void cut(int n, int n2) {
            JTextComponent.this.select(n, n2);
            JTextComponent.this.cut();
        }

        public void paste(int n) {
            JTextComponent.this.setCaretPosition(n);
            JTextComponent.this.paste();
        }

        public void replaceText(int n, int n2, String string) {
            JTextComponent.this.select(n, n2);
            JTextComponent.this.replaceSelection(string);
        }

        public void selectText(int n, int n2) {
            JTextComponent.this.select(n, n2);
        }

        public void setAttributes(int n, int n2, AttributeSet attributeSet) {
            if (JTextComponent.this.doc instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)JTextComponent.this.doc;
                styledDocument.setCharacterAttributes(n, n2 - n, attributeSet, true);
            }
        }
    }
}

