/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class FlowView
extends BoxView {
    static final FlowStrategy sharedStrategy = new FlowStrategy();
    protected int layoutSpan;
    protected View layoutPool;
    protected FlowStrategy strategy = sharedStrategy;

    public FlowView(Element element, int n) {
        super(element, n);
        this.layoutSpan = Short.MAX_VALUE;
    }

    public int getFlowAxis() {
        int n = this.getAxis();
        int n2 = n == 0 ? 1 : 0;
        return n2;
    }

    public int getFlowSpan(int n) {
        return this.layoutSpan;
    }

    public int getFlowStart(int n) {
        return 0;
    }

    protected abstract View createRow();

    protected void loadChildren(ViewFactory viewFactory) {
        if (this.layoutPool == null) {
            this.layoutPool = new LogicalView(this.getElement());
        }
        this.layoutPool.setParent(this);
        this.strategy.insertUpdate(this, null, null);
    }

    protected void layout(int n, int n2) {
        int n3 = this.getFlowAxis();
        int n4 = n3 == 0 ? n : n2;
        if (this.layoutSpan != n4) {
            this.layoutChanged(n3);
            this.layoutChanged(this.getAxis());
            this.layoutSpan = n4;
        }
        if (!this.isLayoutValid(n3)) {
            View view;
            int n5 = this.getAxis();
            int n6 = n5 == 0 ? this.getWidth() : this.getHeight();
            this.strategy.layout(this);
            int n7 = (int)this.getPreferredSpan(n5);
            if (n6 != n7 && (view = this.getParent()) != null) {
                view.preferenceChanged(this, n5 == 0, n5 == 1);
            }
        }
        super.layout(n, n2);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.insertUpdate(documentEvent, shape, viewFactory);
        this.strategy.insertUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.removeUpdate(documentEvent, shape, viewFactory);
        this.strategy.removeUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.changedUpdate(documentEvent, shape, viewFactory);
        this.strategy.changedUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    protected int getViewIndexAtPosition(int n) {
        if (!this.isAllocationValid()) {
            this.layout(this.getWidth(), this.getHeight());
        }
        int n2 = this.getViewCount();
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            int n4 = view.getStartOffset();
            int n5 = view.getEndOffset();
            if (n4 > n || n5 <= n) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = sizeRequirements;
        if (sizeRequirements2 == null) {
            sizeRequirements2 = new SizeRequirements();
        }
        sizeRequirements2.minimum = (int)this.layoutPool.getMinimumSpan(n);
        sizeRequirements2.preferred = Math.max(sizeRequirements2.minimum, (int)this.layoutPool.getPreferredSpan(n));
        sizeRequirements2.maximum = Integer.MAX_VALUE;
        sizeRequirements2.alignment = 0.5f;
        return sizeRequirements2;
    }

    class LogicalView
    extends CompositeView {
        LogicalView(Element element) {
            super(element);
        }

        public AttributeSet getAttributes() {
            View view = this.getParent();
            return view != null ? view.getAttributes() : null;
        }

        protected void childAllocation(int n, Rectangle rectangle) {
        }

        protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
            return null;
        }

        protected boolean isAfter(int n, int n2, Rectangle rectangle) {
            return false;
        }

        protected boolean isBefore(int n, int n2, Rectangle rectangle) {
            return false;
        }

        public float getPreferredSpan(int n) {
            float f = 0.0f;
            float f2 = 0.0f;
            int n2 = this.getViewCount();
            for (int i = 0; i < n2; ++i) {
                View view = this.getView(i);
                f2 += view.getPreferredSpan(n);
                if (view.getBreakWeight(n, 0.0f, 2.1474836E9f) < 3000) continue;
                f = Math.max(f, f2);
                f2 = 0.0f;
            }
            f = Math.max(f, f2);
            return f;
        }

        public float getMinimumSpan(int n) {
            float f = 0.0f;
            float f2 = 0.0f;
            boolean bl = true;
            int n2 = this.getViewCount();
            for (int i = 0; i < n2; ++i) {
                View view = this.getView(i);
                if (view.getBreakWeight(n, 0.0f, 2.1474836E9f) == 0) {
                    f2 += view.getPreferredSpan(n);
                    bl = false;
                    continue;
                }
                if (bl) continue;
                f = Math.max(f2, f);
                bl = true;
                f2 = 0.0f;
            }
            f = Math.max(f, f2);
            return f;
        }

        public void paint(Graphics graphics, Shape shape) {
        }

        protected void loadChildren(ViewFactory viewFactory) {
            Element element = this.getElement();
            if (element.isLeaf()) {
                LabelView labelView = new LabelView(element);
                this.append(labelView);
            } else {
                super.loadChildren(viewFactory);
            }
        }

        protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            view.setParent(this);
            super.forwardUpdateToView(view, documentEvent, shape, viewFactory);
        }

        protected int getViewIndexAtPosition(int n) {
            int n2 = 0;
            if (!this.getElement().isLeaf()) {
                n2 = super.getViewIndexAtPosition(n);
            }
            return n2;
        }
    }

    public static class FlowStrategy {
        public void insertUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            if (rectangle == null) {
                flowView.layoutChanged(0);
                flowView.layoutChanged(1);
            } else {
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }

        public void removeUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            if (rectangle == null) {
                flowView.layoutChanged(0);
                flowView.layoutChanged(1);
            } else {
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }

        public void changedUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            if (rectangle == null) {
                flowView.layoutChanged(0);
                flowView.layoutChanged(1);
            } else {
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }

        protected View getLogicalView(FlowView flowView) {
            return flowView.layoutPool;
        }

        public void layout(FlowView flowView) {
            View view;
            int n;
            int n2 = flowView.getStartOffset();
            int n3 = flowView.getEndOffset();
            View view2 = this.getLogicalView(flowView);
            int n4 = view2.getViewCount();
            for (n = 0; n < n4; ++n) {
                view = view2.getView(n);
                view.setParent(view2);
            }
            flowView.removeAll();
            n = 0;
            while (n2 < n3) {
                view = flowView.createRow();
                flowView.append(view);
                int n5 = this.layoutRow(flowView, n, n2);
                if (view.getViewCount() == 0) {
                    view.append(this.createView(flowView, n2, Integer.MAX_VALUE, n));
                    n5 = view.getEndOffset();
                }
                if (n2 < n5) {
                    n2 = n5;
                } else assert (false) : "May not happen";
                ++n;
            }
        }

        protected int layoutRow(FlowView flowView, int n, int n2) {
            View view;
            View view2 = flowView.getView(n);
            int n3 = flowView.getFlowAxis();
            int n4 = flowView.getFlowSpan(n);
            int n5 = flowView.getFlowStart(n);
            int n6 = flowView.getEndOffset();
            int n7 = n5;
            int n8 = n4;
            TabExpander tabExpander = flowView instanceof TabExpander ? (TabExpander)((Object)flowView) : null;
            boolean bl = false;
            while (!(n2 >= n6 || n4 < 0 || (view = this.createView(flowView, n2, n4, n)) == null || n4 == 0 && view.getPreferredSpan(n3) > 0.0f)) {
                int n9 = n3 == 0 && view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(n5, tabExpander) : (int)view.getPreferredSpan(n3);
                int n10 = view.getBreakWeight(n3, n2, n4);
                if (n10 >= 3000) {
                    int n11 = view2.getViewCount();
                    if (n11 > 0) {
                        n9 = (view = view.breakView(n3, n2, n5, n4)) != null ? (n3 == 0 && view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(n5, tabExpander) : (int)view.getPreferredSpan(n3)) : 0;
                    }
                    bl = true;
                }
                n4 -= n9;
                n5 += n9;
                if (view != null) {
                    view2.append(view);
                    n2 = view.getEndOffset();
                }
                if (!bl) continue;
                break;
            }
            if (n4 < 0) {
                this.adjustRow(flowView, n, n8, n7);
            } else if (view2.getViewCount() == 0) {
                view = this.createView(flowView, n2, Integer.MAX_VALUE, n);
                view2.append(view);
            }
            return view2.getEndOffset();
        }

        protected View createView(FlowView flowView, int n, int n2, int n3) {
            int n4;
            View view = this.getLogicalView(flowView);
            View view2 = view.getView(n4 = view.getViewIndex(n, Position.Bias.Forward));
            if (view2.getStartOffset() != n) {
                view2 = view2.createFragment(n, view2.getEndOffset());
            }
            return view2;
        }

        protected void adjustRow(FlowView flowView, int n, int n2, int n3) {
            View view;
            int n4;
            int n5 = flowView.getFlowAxis();
            View view2 = flowView.getView(n);
            int n6 = view2.getViewCount();
            int n7 = -1;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                int n11;
                view = view2.getView(n4);
                int n12 = view.getBreakWeight(n5, n3 + n10, n11 = n2 - n10);
                if (n12 >= n8 && n12 > 0) {
                    n7 = n4;
                    n9 = n10;
                    n8 = n12;
                    if (n12 >= 3000) break;
                }
                n10 = (int)((float)n10 + view.getPreferredSpan(n5));
            }
            if (n7 >= 0) {
                n4 = n2 - n9;
                view = view2.getView(n7);
                View view3 = view.breakView(n5, view.getStartOffset(), n3 + n9, n4);
                View view4 = this.getLogicalView(flowView);
                for (int i = n7; i < n6; ++i) {
                    View view5 = view2.getView(i);
                    if (this.contains(view4, view5)) {
                        view5.setParent(view4);
                        continue;
                    }
                    if (view5.getViewCount() <= 0) continue;
                    this.reparent(view5, view4);
                }
                view2.replace(n7, n6 - n7, new View[]{view3});
            }
        }

        private boolean contains(View view, View view2) {
            boolean bl = false;
            int n = view.getViewCount();
            for (int i = 0; i < n && !bl; ++i) {
                if (view.getView(i) != view2) continue;
                bl = true;
            }
            return bl;
        }

        private void reparent(View view, View view2) {
            int n = view.getViewCount();
            for (int i = 0; i < n; ++i) {
                View view3 = view.getView(i);
                if (this.contains(view2, view3)) {
                    view3.setParent(view2);
                    continue;
                }
                this.reparent(view3, view2);
            }
        }
    }
}

