/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public class DefaultHighlighter
extends LayeredHighlighter {
    public static final LayeredHighlighter.LayerPainter DefaultPainter = new DefaultHighlightPainter(null);
    private JTextComponent textComponent;
    private ArrayList highlights = new ArrayList();
    private boolean drawsLayeredHighlights = true;

    public boolean getDrawsLayeredHighlights() {
        return this.drawsLayeredHighlights;
    }

    public void setDrawsLayeredHighlights(boolean bl) {
        this.drawsLayeredHighlights = bl;
    }

    private void checkPositions(int n, int n2) throws BadLocationException {
        if (n < 0) {
            throw new BadLocationException("DefaultHighlighter", n);
        }
        if (n2 < n) {
            throw new BadLocationException("DefaultHighlighter", n2);
        }
    }

    public void install(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        this.removeAllHighlights();
    }

    public void deinstall(JTextComponent jTextComponent) {
        this.textComponent = null;
    }

    public Object addHighlight(int n, int n2, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
        this.checkPositions(n, n2);
        Document document = this.textComponent.getDocument();
        Position position = document.createPosition(n);
        Position position2 = document.createPosition(n2);
        HighlightEntry highlightEntry = this.getDrawsLayeredHighlights() && highlightPainter instanceof LayeredHighlighter.LayerPainter ? new LayerHighlightEntry(position, position2, highlightPainter) : new HighlightEntry(position, position2, highlightPainter);
        this.highlights.add(highlightEntry);
        this.textComponent.getUI().damageRange(this.textComponent, n, n2);
        return highlightEntry;
    }

    public void removeHighlight(Object object) {
        HighlightEntry highlightEntry = (HighlightEntry)object;
        if (highlightEntry instanceof LayerHighlightEntry) {
            LayerHighlightEntry layerHighlightEntry = (LayerHighlightEntry)highlightEntry;
            Rectangle rectangle = layerHighlightEntry.paintRect;
            this.textComponent.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.textComponent.getUI().damageRange(this.textComponent, highlightEntry.getStartOffset(), highlightEntry.getEndOffset());
        }
        this.highlights.remove(object);
    }

    public void removeAllHighlights() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        for (HighlightEntry highlightEntry : this.highlights) {
            Object object;
            if (highlightEntry instanceof LayerHighlightEntry) {
                object = (LayerHighlightEntry)highlightEntry;
                Rectangle rectangle = ((LayerHighlightEntry)object).paintRect;
                n = Math.min(rectangle.x, n);
                n2 = Math.max(rectangle.x + rectangle.width, n2);
                n3 = Math.min(rectangle.y, n3);
                n4 = Math.max(rectangle.y + rectangle.height, n4);
            } else if (n5 == -1 || n6 == -1) {
                n5 = highlightEntry.getStartOffset();
                n6 = highlightEntry.getEndOffset();
            } else {
                n5 = Math.min(n5, highlightEntry.getStartOffset());
                n6 = Math.max(n6, highlightEntry.getEndOffset());
            }
            if (n != n2 && n3 != n4) {
                this.textComponent.repaint(n, n3, n2 - n, n4 - n3);
            }
            if (n5 == -1 || n6 == -1) continue;
            object = this.textComponent.getUI();
            ((TextUI)object).damageRange(this.textComponent, n5, n6);
        }
        this.highlights.clear();
    }

    public Highlighter.Highlight[] getHighlights() {
        return this.highlights.toArray(new Highlighter.Highlight[this.highlights.size()]);
    }

    public void changeHighlight(Object object, int n, int n2) throws BadLocationException {
        Document document = this.textComponent.getDocument();
        TextUI textUI = this.textComponent.getUI();
        if (object instanceof LayerHighlightEntry) {
            LayerHighlightEntry layerHighlightEntry = (LayerHighlightEntry)object;
            Rectangle rectangle = layerHighlightEntry.paintRect;
            if (rectangle.width > 0 && rectangle.height > 0) {
                this.textComponent.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            rectangle.width = 0;
            rectangle.height = 0;
            layerHighlightEntry.p0 = document.createPosition(n);
            layerHighlightEntry.p1 = document.createPosition(n2);
            textUI.damageRange(this.textComponent, Math.min(n, n2), Math.max(n, n2));
        } else if (object instanceof HighlightEntry) {
            HighlightEntry highlightEntry = (HighlightEntry)object;
            int n3 = highlightEntry.getStartOffset();
            int n4 = highlightEntry.getEndOffset();
            if (n3 == n) {
                textUI.damageRange(this.textComponent, Math.min(n4, n2), Math.max(n4, n2));
            } else if (n2 == n4) {
                textUI.damageRange(this.textComponent, Math.min(n3, n), Math.max(n3, n));
            } else {
                textUI.damageRange(this.textComponent, n3, n4);
                textUI.damageRange(this.textComponent, n, n2);
            }
            highlightEntry.p0 = document.createPosition(n);
            highlightEntry.p1 = document.createPosition(n2);
        }
    }

    public void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        for (Object e : this.highlights) {
            if (!(e instanceof LayerHighlightEntry)) continue;
            LayerHighlightEntry layerHighlightEntry = (LayerHighlightEntry)e;
            int n3 = layerHighlightEntry.getStartOffset();
            int n4 = layerHighlightEntry.getEndOffset();
            if ((n >= n3 || n2 <= n3) && (n < n3 || n >= n4)) continue;
            layerHighlightEntry.paintLayeredHighlight(graphics, n, n2, shape, jTextComponent, view);
        }
    }

    public void paint(Graphics graphics) {
        int n = this.highlights.size();
        if (n == 0) {
            return;
        }
        Insets insets = this.textComponent.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, this.textComponent.getWidth() - insets.left - insets.right, this.textComponent.getHeight() - insets.top - insets.bottom);
        for (int i = 0; i < n; ++i) {
            HighlightEntry highlightEntry = (HighlightEntry)this.highlights.get(i);
            if (highlightEntry instanceof LayerHighlightEntry) continue;
            highlightEntry.painter.paint(graphics, highlightEntry.getStartOffset(), highlightEntry.getEndOffset(), rectangle, this.textComponent);
        }
    }

    private class LayerHighlightEntry
    extends HighlightEntry {
        Rectangle paintRect;

        LayerHighlightEntry(Position position, Position position2, Highlighter.HighlightPainter highlightPainter) {
            super(position, position2, highlightPainter);
            this.paintRect = new Rectangle();
        }

        void paintLayeredHighlight(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            n = Math.max(this.getStartOffset(), n);
            n2 = Math.min(this.getEndOffset(), n2);
            Highlighter.HighlightPainter highlightPainter = this.getPainter();
            if (highlightPainter instanceof LayeredHighlighter.LayerPainter) {
                LayeredHighlighter.LayerPainter layerPainter = (LayeredHighlighter.LayerPainter)highlightPainter;
                Shape shape2 = layerPainter.paintLayer(graphics, n, n2, shape, jTextComponent, view);
                Rectangle rectangle = shape2 instanceof Rectangle && this.paintRect != null ? (Rectangle)shape2 : shape2.getBounds();
                this.paintRect = this.paintRect.width == 0 || this.paintRect.height == 0 ? rectangle.getBounds() : SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.paintRect);
            }
        }
    }

    private class HighlightEntry
    implements Highlighter.Highlight {
        Position p0;
        Position p1;
        Highlighter.HighlightPainter painter;

        public HighlightEntry(Position position, Position position2, Highlighter.HighlightPainter highlightPainter) {
            this.p0 = position;
            this.p1 = position2;
            this.painter = highlightPainter;
        }

        public int getStartOffset() {
            return this.p0.getOffset();
        }

        public int getEndOffset() {
            return this.p1.getOffset();
        }

        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }

    public static class DefaultHighlightPainter
    extends LayeredHighlighter.LayerPainter {
        private Color color;

        public DefaultHighlightPainter(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            if (n == n2) {
                return;
            }
            Rectangle rectangle = shape.getBounds();
            Color color = this.getColor();
            if (color == null) {
                color = jTextComponent.getSelectionColor();
            }
            graphics.setColor(color);
            TextUI textUI = jTextComponent.getUI();
            try {
                Rectangle rectangle2 = textUI.modelToView(jTextComponent, n, null);
                Rectangle rectangle3 = textUI.modelToView(jTextComponent, n2, null);
                if (rectangle2.y == rectangle3.y) {
                    SwingUtilities.computeUnion(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle3);
                    SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle3);
                    graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                } else {
                    int n3 = rectangle.x + rectangle.width - rectangle2.x;
                    graphics.fillRect(rectangle2.x, rectangle2.y, n3, rectangle2.height);
                    if (rectangle2.y + rectangle2.height != rectangle3.y) {
                        graphics.fillRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle3.y - rectangle2.y - rectangle2.height);
                    }
                    graphics.fillRect(rectangle.x, rectangle3.y, rectangle3.x - rectangle.x, rectangle3.height);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            Color color = this.getColor();
            if (color == null) {
                color = jTextComponent.getSelectionColor();
            }
            graphics.setColor(color);
            Rectangle rectangle = null;
            if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
                rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            } else {
                try {
                    Shape shape2 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                    rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (rectangle != null) {
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            return rectangle;
        }
    }
}

