/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class CompositeView
extends View {
    private View[] children;
    private int numChildren;
    private final Rectangle insideAllocation = new Rectangle();
    private short top = 0;
    private short bottom = 0;
    private short left = 0;
    private short right = 0;

    public CompositeView(Element element) {
        super(element);
        this.children = new View[0];
    }

    protected void loadChildren(ViewFactory viewFactory) {
        if (viewFactory != null) {
            Element element = this.getElement();
            int n = element.getElementCount();
            View[] viewArray = new View[n];
            for (int i = 0; i < n; ++i) {
                View view;
                Element element2 = element.getElement(i);
                viewArray[i] = view = viewFactory.create(element2);
            }
            this.replace(0, 0, viewArray);
        }
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null && this.numChildren == 0) {
            this.loadChildren(this.getViewFactory());
        }
    }

    public int getViewCount() {
        return this.numChildren;
    }

    public View getView(int n) {
        return this.children[n];
    }

    public void replace(int n, int n2, View[] viewArray) {
        int n3;
        int n4;
        if (viewArray == null) {
            viewArray = new View[]{};
        }
        int n5 = n + n2;
        for (n4 = n; n4 < n5; ++n4) {
            if (this.children[n4].getParent() == this) {
                this.children[n4].setParent(null);
            }
            this.children[n4] = null;
        }
        n4 = viewArray.length - n2;
        int n6 = n + n2;
        int n7 = this.numChildren - n6;
        int n8 = n6 + n4;
        if (this.numChildren + n4 > this.children.length) {
            n3 = Math.max(2 * this.children.length, this.numChildren + n4);
            View[] viewArray2 = new View[n3];
            System.arraycopy(this.children, 0, viewArray2, 0, n);
            System.arraycopy(viewArray, 0, viewArray2, n, viewArray.length);
            System.arraycopy(this.children, n6, viewArray2, n8, n7);
            this.children = viewArray2;
        } else {
            System.arraycopy(this.children, n6, this.children, n8, n7);
            System.arraycopy(viewArray, 0, this.children, n, viewArray.length);
        }
        this.numChildren += n4;
        for (n3 = 0; n3 < viewArray.length; ++n3) {
            viewArray[n3].setParent(this);
        }
    }

    public Shape getChildAllocation(int n, Shape shape) {
        Rectangle rectangle = this.getInsideAllocation(shape);
        this.childAllocation(n, rectangle);
        return rectangle;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Shape shape2;
        View view;
        int n2;
        boolean bl = bias == Position.Bias.Backward;
        int n3 = bl ? Math.max(0, n - 1) : n;
        Shape shape3 = null;
        if (!(bl && n3 < this.getStartOffset() || (n2 = this.getViewIndexAtPosition(n3)) == -1 || n2 >= this.getViewCount() || (view = this.getView(n2)) == null || n3 < view.getStartOffset() || n3 >= view.getEndOffset() || (shape2 = this.getChildAllocation(n2, shape)) == null || (shape3 = view.modelToView(n, shape2, bias)) != null || view.getEndOffset() != n || ++n2 >= this.getViewCount())) {
            view = this.getView(n2);
            shape2 = this.getChildAllocation(n2, shape);
            shape3 = view.modelToView(n, shape2, bias);
        }
        if (shape3 == null) {
            throw new BadLocationException("Position " + n + " is not represented by view.", n);
        }
        return shape3;
    }

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        return super.modelToView(n, bias, n2, bias2, shape);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        if (f >= 0.0f && f2 >= 0.0f) {
            Rectangle rectangle = this.getInsideAllocation(shape);
            View view = this.getViewAtPoint((int)f, (int)f2, rectangle);
            return view.viewToModel(f, f2, rectangle, biasArray);
        }
        return 0;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3 = -1;
        switch (n2) {
            case 3: 
            case 7: {
                n3 = this.getNextEastWestVisualPositionFrom(n, bias, shape, n2, biasArray);
                break;
            }
            case 1: 
            case 5: {
                n3 = this.getNextNorthSouthVisualPositionFrom(n, bias, shape, n2, biasArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for direction.");
            }
        }
        return n3;
    }

    public int getViewIndex(int n, Position.Bias bias) {
        if (bias == Position.Bias.Backward) {
            --n;
        }
        int n2 = -1;
        if (n >= this.getStartOffset() && n < this.getEndOffset()) {
            n2 = this.getViewIndexAtPosition(n);
        }
        return n2;
    }

    protected abstract boolean isBefore(int var1, int var2, Rectangle var3);

    protected abstract boolean isAfter(int var1, int var2, Rectangle var3);

    protected abstract View getViewAtPoint(int var1, int var2, Rectangle var3);

    protected abstract void childAllocation(int var1, Rectangle var2);

    protected View getViewAtPosition(int n, Rectangle rectangle) {
        View view = null;
        int n2 = this.getViewIndexAtPosition(n);
        if (n2 >= 0 && n2 < this.getViewCount() && rectangle != null) {
            view = this.getView(n2);
            this.childAllocation(n2, rectangle);
        }
        return view;
    }

    protected int getViewIndexAtPosition(int n) {
        Element element = this.getElement();
        return element.getElementIndex(n);
    }

    protected Rectangle getInsideAllocation(Shape shape) {
        if (shape == null) {
            return null;
        }
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        Rectangle rectangle2 = this.insideAllocation;
        rectangle2.x = rectangle.x + this.getLeftInset();
        rectangle2.y = rectangle.y + this.getTopInset();
        rectangle2.width = rectangle.width - this.getLeftInset() - this.getRightInset();
        rectangle2.height = rectangle.height - this.getTopInset() - this.getBottomInset();
        return rectangle2;
    }

    protected void setParagraphInsets(AttributeSet attributeSet) {
        this.top = (short)StyleConstants.getSpaceAbove(attributeSet);
        this.bottom = (short)StyleConstants.getSpaceBelow(attributeSet);
        this.left = (short)StyleConstants.getLeftIndent(attributeSet);
        this.right = (short)StyleConstants.getRightIndent(attributeSet);
    }

    protected void setInsets(short s, short s2, short s3, short s4) {
        this.top = s;
        this.left = s2;
        this.bottom = s3;
        this.right = s4;
    }

    protected short getLeftInset() {
        return this.left;
    }

    protected short getRightInset() {
        return this.right;
    }

    protected short getTopInset() {
        return this.top;
    }

    protected short getBottomInset() {
        return this.bottom;
    }

    protected int getNextNorthSouthVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3 = this.getViewIndex(n, bias);
        View view = null;
        if (n3 == -1) {
            return n;
        }
        switch (n2) {
            case 1: {
                if (n3 <= 0) {
                    return n;
                }
                view = this.getView(n3 - 1);
                break;
            }
            case 5: {
                if (n3 >= this.getViewCount() - 1) {
                    return n;
                }
                view = this.getView(n3 + 1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
    }

    protected int getNextEastWestVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        View view = null;
        switch (n2) {
            case 3: {
                int n3 = this.getViewIndex(n + 1, bias);
                if (n3 == -1) {
                    return n;
                }
                view = this.getView(n3);
                break;
            }
            case 7: {
                int n4 = this.getViewIndex(n - 1, bias);
                if (n4 == -1) {
                    return n;
                }
                view = this.getView(n4);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
    }

    protected boolean flipEastAndWestAtEnds(int n, Position.Bias bias) {
        return false;
    }
}

