/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import gnu.java.lang.CPStringBuilder;
import java.awt.font.TextAttribute;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocument
implements Document,
Serializable {
    private static final long serialVersionUID = 6842927725919637215L;
    protected static final String BAD_LOCATION = "document location failure";
    public static final String BidiElementName = "bidi level";
    public static final String ContentElementName = "content";
    public static final String ParagraphElementName = "paragraph";
    public static final String SectionElementName = "section";
    public static final String ElementNameAttribute = "$ename";
    private static final String BidiRootName = "bidi root";
    private static final String AsyncLoadPriority = "load priority";
    private static final String I18N = "i18n";
    Content content;
    AttributeContext context;
    DocumentFilter documentFilter;
    Dictionary properties;
    protected EventListenerList listenerList = new EventListenerList();
    private Thread currentWriter = null;
    private int numReaders = 0;
    private int numWriters = 0;
    private DocumentFilter.FilterBypass bypass;
    private BidiRootElement bidiRoot;
    private transient boolean notifyListeners;

    protected AbstractDocument(Content content) {
        this(content, StyleContext.getDefaultStyleContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractDocument(Content content, AttributeContext attributeContext) {
        this.content = content;
        this.context = attributeContext;
        this.bidiRoot = new BidiRootElement();
        this.putProperty(I18N, Boolean.FALSE);
        this.writeLock();
        try {
            Element[] elementArray = new Element[]{new BidiElement((Element)this.bidiRoot, 0, 1, 0)};
            this.bidiRoot.replace(0, 0, elementArray);
            Object var5_4 = null;
            this.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeUnlock();
            throw throwable;
        }
    }

    private DocumentFilter.FilterBypass getBypass() {
        if (this.bypass == null) {
            this.bypass = new Bypass();
        }
        return this.bypass;
    }

    public abstract Element getParagraphElement(int var1);

    @Override
    public abstract Element getDefaultRootElement();

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return new BranchElement(element, attributeSet);
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        return new LeafElement(element, attributeSet, n, n2);
    }

    @Override
    public synchronized Position createPosition(int n) throws BadLocationException {
        return this.content.createPosition(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        this.notifyListeners = true;
        try {
            DocumentListener[] documentListenerArray = this.getDocumentListeners();
            for (int i = 0; i < documentListenerArray.length; ++i) {
                documentListenerArray[i].changedUpdate(documentEvent);
            }
            Object var5_4 = null;
            this.notifyListeners = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.notifyListeners = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        this.notifyListeners = true;
        try {
            DocumentListener[] documentListenerArray = this.getDocumentListeners();
            for (int i = 0; i < documentListenerArray.length; ++i) {
                documentListenerArray[i].insertUpdate(documentEvent);
            }
            Object var5_4 = null;
            this.notifyListeners = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.notifyListeners = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        this.notifyListeners = true;
        try {
            DocumentListener[] documentListenerArray = this.getDocumentListeners();
            for (int i = 0; i < documentListenerArray.length; ++i) {
                documentListenerArray[i].removeUpdate(documentEvent);
            }
            Object var5_4 = null;
            this.notifyListeners = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.notifyListeners = false;
            throw throwable;
        }
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
        UndoableEditListener[] undoableEditListenerArray = this.getUndoableEditListeners();
        for (int i = 0; i < undoableEditListenerArray.length; ++i) {
            undoableEditListenerArray[i].undoableEditHappened(undoableEditEvent);
        }
    }

    public int getAsynchronousLoadPriority() {
        Object object = this.getProperty(AsyncLoadPriority);
        int n = -1;
        if (object != null) {
            n = (Integer)object;
        }
        return n;
    }

    protected final AttributeContext getAttributeContext() {
        return this.context;
    }

    public Element getBidiRootElement() {
        return this.bidiRoot;
    }

    protected final Content getContent() {
        return this.content;
    }

    protected final synchronized Thread getCurrentWriter() {
        return this.currentWriter;
    }

    public Dictionary<Object, Object> getDocumentProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties;
    }

    @Override
    public final Position getEndPosition() {
        Position position;
        try {
            position = this.createPosition(this.content.length());
        }
        catch (BadLocationException badLocationException) {
            position = null;
        }
        return position;
    }

    @Override
    public int getLength() {
        return this.content.length() - 1;
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    @Override
    public final Object getProperty(Object object) {
        Object var2_2 = null;
        if (this.properties != null) {
            var2_2 = this.properties.get(object);
        }
        return var2_2;
    }

    @Override
    public Element[] getRootElements() {
        Element[] elementArray = new Element[]{this.getDefaultRootElement(), this.getBidiRootElement()};
        return elementArray;
    }

    @Override
    public final Position getStartPosition() {
        Position position;
        try {
            position = this.createPosition(0);
        }
        catch (BadLocationException badLocationException) {
            position = null;
        }
        return position;
    }

    @Override
    public String getText(int n, int n2) throws BadLocationException {
        return this.content.getString(n, n2);
    }

    @Override
    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        this.content.getChars(n, n2, segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null || string.length() == 0) {
            return;
        }
        this.writeLock();
        try {
            if (this.documentFilter == null) {
                this.insertStringImpl(n, string, attributeSet);
            } else {
                this.documentFilter.insertString(this.getBypass(), n, string, attributeSet);
            }
            Object var5_4 = null;
            this.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeUnlock();
            throw throwable;
        }
    }

    void insertStringImpl(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null || string.length() == 0) {
            return;
        }
        DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(n, string.length(), DocumentEvent.EventType.INSERT);
        UndoableEdit undoableEdit = this.content.insertString(n, string);
        if (undoableEdit != null) {
            defaultDocumentEvent.addEdit(undoableEdit);
        }
        if (this.getProperty(I18N).equals(Boolean.FALSE)) {
            Object object = this.getProperty(TextAttribute.RUN_DIRECTION);
            if (TextAttribute.RUN_DIRECTION_RTL.equals(object)) {
                this.putProperty(I18N, Boolean.TRUE);
            } else {
                char[] cArray = string.toCharArray();
                if (Bidi.requiresBidi(cArray, 0, cArray.length)) {
                    this.putProperty(I18N, Boolean.TRUE);
                }
            }
        }
        this.insertUpdate(defaultDocumentEvent, attributeSet);
        this.fireInsertUpdate(defaultDocumentEvent);
        if (undoableEdit != null) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, undoableEdit));
        }
    }

    protected void insertUpdate(DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        if (Boolean.TRUE.equals(this.getProperty(I18N))) {
            this.updateBidi(defaultDocumentEvent);
        }
    }

    protected void postRemoveUpdate(DefaultDocumentEvent defaultDocumentEvent) {
        if (Boolean.TRUE.equals(this.getProperty(I18N))) {
            this.updateBidi(defaultDocumentEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void putProperty(Object object, Object object2) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if (object2 == null) {
            this.properties.remove(object);
        } else {
            this.properties.put(object, object2);
        }
        if (TextAttribute.RUN_DIRECTION.equals(object)) {
            if (TextAttribute.RUN_DIRECTION_RTL.equals(object2) && Boolean.FALSE.equals(this.getProperty(I18N))) {
                this.putProperty(I18N, Boolean.TRUE);
            }
            if (Boolean.TRUE.equals(this.getProperty(I18N))) {
                this.writeLock();
                try {
                    DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(0, this.getLength(), DocumentEvent.EventType.INSERT);
                    this.updateBidi(defaultDocumentEvent);
                    Object var5_4 = null;
                    this.writeUnlock();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.writeUnlock();
                    throw throwable;
                }
            }
        }
    }

    private void updateBidi(DefaultDocumentEvent defaultDocumentEvent) {
        int n;
        Element[] elementArray;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        DocumentEvent.EventType eventType = defaultDocumentEvent.getType();
        if (eventType == DocumentEvent.EventType.INSERT || eventType == DocumentEvent.EventType.CHANGE) {
            int n6 = defaultDocumentEvent.getOffset();
            n3 = n6 + defaultDocumentEvent.getLength();
            n4 = this.getParagraphElement(n6).getStartOffset();
            n5 = this.getParagraphElement(n3).getEndOffset();
        } else if (eventType == DocumentEvent.EventType.REMOVE) {
            Element element = this.getParagraphElement(defaultDocumentEvent.getOffset());
            n4 = element.getStartOffset();
            n5 = element.getEndOffset();
        } else assert (false) : "Unknown event type";
        Bidi[] bidiArray = this.getBidis(n4, n5);
        n3 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        ArrayList<BidiElement> arrayList = new ArrayList<BidiElement>();
        for (n2 = 0; n2 < bidiArray.length; ++n2) {
            elementArray = bidiArray[n2];
            n = elementArray.getRunCount();
            for (int i = 0; i < n; ++i) {
                int n12;
                AttributeSet attributeSet;
                Element element;
                int n13;
                if (i == 0 && n2 == 0) {
                    if (n4 > 0) {
                        n3 = n13 = this.bidiRoot.getElementIndex(n4 - 1);
                        element = this.bidiRoot.getElement(n13);
                        attributeSet = element.getAttributes();
                        n12 = StyleConstants.getBidiLevel(attributeSet);
                        if (n12 == elementArray.getRunLevel(i)) {
                            n9 = element.getStartOffset() - n4;
                            n10 = elementArray.getRunLimit(i);
                            n11 = elementArray.getRunLevel(i);
                        } else if (element.getEndOffset() > n4) {
                            n9 = 0;
                            n10 = elementArray.getRunLimit(i);
                            n11 = elementArray.getRunLevel(i);
                            arrayList.add(new BidiElement((Element)this.bidiRoot, element.getStartOffset(), n4, n12));
                        } else {
                            n9 = 0;
                            n10 = elementArray.getRunLimit(i);
                            n11 = elementArray.getRunLevel(i);
                            ++n3;
                        }
                    } else {
                        n9 = 0;
                        n10 = elementArray.getRunLimit(i);
                        n11 = elementArray.getRunLevel(i);
                        n3 = 0;
                    }
                }
                if (n2 == bidiArray.length - 1 && i == n - 1) {
                    if (n5 <= this.getLength()) {
                        int n14;
                        n13 = this.bidiRoot.getElementIndex(n5);
                        element = this.bidiRoot.getElement(n13);
                        attributeSet = element.getAttributes();
                        n12 = StyleConstants.getBidiLevel(attributeSet);
                        int n15 = elementArray.getRunLevel(i);
                        if (n11 == n15 && n15 == n12) {
                            if (n9 + n4 == element.getStartOffset()) {
                                n7 = n13 - 1;
                                continue;
                            }
                            arrayList.add(new BidiElement((Element)this.bidiRoot, n4 + n9, element.getEndOffset(), n15));
                            n7 = n13;
                            continue;
                        }
                        if (n11 == n15) {
                            n14 = n8 + elementArray.getRunLimit(i);
                            arrayList.add(new BidiElement((Element)this.bidiRoot, n4 + n9, n4 + n14, n15));
                            if (n4 + n14 == element.getStartOffset()) {
                                n7 = n13 - 1;
                                continue;
                            }
                            arrayList.add(new BidiElement((Element)this.bidiRoot, n4 + n14, element.getEndOffset(), n12));
                            n7 = n13;
                            continue;
                        }
                        if (n15 == n12) {
                            arrayList.add(new BidiElement((Element)this.bidiRoot, n4 + n9, n4 + n10, n11));
                            arrayList.add(new BidiElement((Element)this.bidiRoot, n4 + n10, element.getEndOffset(), n15));
                            n7 = n13;
                            continue;
                        }
                        n14 = n8 + elementArray.getRunLimit(i);
                        arrayList.add(new BidiElement((Element)this.bidiRoot, n4 + n9, n4 + n10, n11));
                        arrayList.add(new BidiElement((Element)this.bidiRoot, n4 + n10, n4 + n14, n15));
                        arrayList.add(new BidiElement((Element)this.bidiRoot, n4 + n14, element.getEndOffset(), n12));
                        n7 = n13;
                        continue;
                    }
                    n7 = this.bidiRoot.getElementIndex(n5);
                    n13 = elementArray.getRunLevel(i);
                    int n16 = n8 + elementArray.getRunLimit(i);
                    if (n13 == n11) {
                        n10 = n8 + n16;
                        arrayList.add(new BidiElement((Element)this.bidiRoot, n4 + n9, n4 + n16, n13));
                        continue;
                    }
                    arrayList.add(new BidiElement((Element)this.bidiRoot, n4 + n9, n4 + n10, n11));
                    arrayList.add(new BidiElement((Element)this.bidiRoot, n4 + n10, n4 + n16, n13));
                    continue;
                }
                n13 = elementArray.getRunLevel(i);
                int n17 = elementArray.getRunLimit(i);
                if (n13 == n11) {
                    n10 = n8 + n17;
                    continue;
                }
                arrayList.add(new BidiElement((Element)this.bidiRoot, n4 + n9, n4 + n10, n11));
                n9 = n10;
                n10 = n8 + n17;
                n11 = n13;
            }
            n8 += elementArray.getLength();
        }
        n2 = 0;
        if (this.bidiRoot.getElementCount() > 0) {
            n2 = n7 - n3 + 1;
        }
        elementArray = new Element[n2];
        for (n = 0; n < n2; ++n) {
            elementArray[n] = this.bidiRoot.getElement(n3 + n);
        }
        Element[] elementArray2 = new Element[arrayList.size()];
        elementArray2 = arrayList.toArray(elementArray2);
        ElementEdit elementEdit = new ElementEdit(this.bidiRoot, n3, elementArray, elementArray2);
        defaultDocumentEvent.addEdit(elementEdit);
        this.bidiRoot.replace(n3, n2, elementArray2);
    }

    private Bidi[] getBidis(int n, int n2) {
        Boolean bl = null;
        Object object = this.getProperty(TextAttribute.RUN_DIRECTION);
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        ArrayList<Bidi> arrayList = new ArrayList<Bidi>();
        Segment segment = new Segment();
        int n3 = n;
        while (n3 < n2) {
            Boolean bl2;
            int n4;
            block6: {
                Element element = this.getParagraphElement(n3);
                int n5 = element.getStartOffset();
                n4 = element.getEndOffset();
                bl2 = bl;
                object = element.getAttributes().getAttribute(TextAttribute.RUN_DIRECTION);
                if (object instanceof Boolean) {
                    bl2 = (Boolean)object;
                }
                try {
                    this.getText(n5, n4 - n5, segment);
                }
                catch (BadLocationException badLocationException) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError((Object)"Must not happen");
                }
            }
            int n6 = -2;
            if (bl2 != null) {
                n6 = TextAttribute.RUN_DIRECTION_LTR.equals(bl2) ? 0 : 1;
            }
            Bidi bidi = new Bidi(segment.array, segment.offset, null, 0, segment.count, n6);
            arrayList.add(bidi);
            n3 = n4;
        }
        Bidi[] bidiArray = new Bidi[arrayList.size()];
        bidiArray = arrayList.toArray(bidiArray);
        return bidiArray;
    }

    public final synchronized void readLock() {
        try {
            while (this.currentWriter != null) {
                if (this.currentWriter == Thread.currentThread()) {
                    return;
                }
                this.wait();
            }
            ++this.numReaders;
        }
        catch (InterruptedException interruptedException) {
            throw new Error("Interrupted during grab read lock");
        }
    }

    public final synchronized void readUnlock() {
        if (this.currentWriter == Thread.currentThread()) {
            return;
        }
        if (this.numReaders <= 0) {
            throw new IllegalStateException("document lock failure");
        }
        --this.numReaders;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int n, int n2) throws BadLocationException {
        this.writeLock();
        try {
            DocumentFilter documentFilter = this.getDocumentFilter();
            if (documentFilter == null) {
                this.removeImpl(n, n2);
            } else {
                documentFilter.remove(this.getBypass(), n, n2);
            }
            Object var5_4 = null;
            this.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeUnlock();
            throw throwable;
        }
    }

    void removeImpl(int n, int n2) throws BadLocationException {
        if (n2 > 0) {
            if (n < 0 || n > this.getLength()) {
                throw new BadLocationException("Invalid remove position", n);
            }
            if (n + n2 > this.getLength()) {
                throw new BadLocationException("Invalid remove length", n);
            }
            DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(n, n2, DocumentEvent.EventType.REMOVE);
            this.removeUpdate(defaultDocumentEvent);
            UndoableEdit undoableEdit = this.content.remove(n, n2);
            this.postRemoveUpdate(defaultDocumentEvent);
            this.fireRemoveUpdate(defaultDocumentEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        if (n2 == 0 && (string == null || string.length() == 0)) {
            return;
        }
        this.writeLock();
        try {
            if (this.documentFilter == null) {
                this.remove(n, n2);
                this.insertString(n, string, attributeSet);
            } else {
                this.documentFilter.replace(this.getBypass(), n, n2, string, attributeSet);
            }
            Object var6_5 = null;
            this.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.writeUnlock();
            throw throwable;
        }
    }

    void replaceImpl(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        this.removeImpl(n, n2);
        this.insertStringImpl(n, string, attributeSet);
    }

    @Override
    public void addDocumentListener(DocumentListener documentListener) {
        this.listenerList.add(DocumentListener.class, documentListener);
    }

    @Override
    public void removeDocumentListener(DocumentListener documentListener) {
        this.listenerList.remove(DocumentListener.class, documentListener);
    }

    public DocumentListener[] getDocumentListeners() {
        return (DocumentListener[])this.getListeners(DocumentListener.class);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.add(UndoableEditListener.class, undoableEditListener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.remove(UndoableEditListener.class, undoableEditListener);
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        return (UndoableEditListener[])this.getListeners(UndoableEditListener.class);
    }

    protected void removeUpdate(DefaultDocumentEvent defaultDocumentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Runnable runnable) {
        this.readLock();
        try {
            runnable.run();
            Object var3_2 = null;
            this.readUnlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.readUnlock();
            throw throwable;
        }
    }

    public void setAsynchronousLoadPriority(int n) {
        Integer n2 = n >= 0 ? new Integer(n) : null;
        this.putProperty(AsyncLoadPriority, n2);
    }

    public void setDocumentProperties(Dictionary<Object, Object> dictionary) {
        this.properties = dictionary;
    }

    protected final synchronized void writeLock() {
        try {
            while (this.numReaders > 0 || this.currentWriter != null) {
                if (Thread.currentThread() == this.currentWriter) {
                    if (this.notifyListeners) {
                        throw new IllegalStateException("Mutation during notify");
                    }
                    ++this.numWriters;
                    return;
                }
                this.wait();
            }
            this.currentWriter = Thread.currentThread();
            this.numWriters = 1;
        }
        catch (InterruptedException interruptedException) {
            throw new Error("Interupted during grab write lock");
        }
    }

    protected final synchronized void writeUnlock() {
        if (--this.numWriters <= 0) {
            this.numWriters = 0;
            this.currentWriter = null;
            this.notifyAll();
        }
    }

    public DocumentFilter getDocumentFilter() {
        return this.documentFilter;
    }

    public void setDocumentFilter(DocumentFilter documentFilter) {
        this.documentFilter = documentFilter;
    }

    public void dump(PrintStream printStream) {
        ((AbstractElement)this.getDefaultRootElement()).dump(printStream, 0);
        ((AbstractElement)this.getBidiRootElement()).dump(printStream, 0);
    }

    class Bypass
    extends DocumentFilter.FilterBypass {
        Bypass() {
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            AbstractDocument.this.insertStringImpl(n, string, attributeSet);
        }

        public void remove(int n, int n2) throws BadLocationException {
            AbstractDocument.this.removeImpl(n, n2);
        }

        public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            AbstractDocument.this.replaceImpl(n, n2, string, attributeSet);
        }
    }

    private class BidiElement
    extends LeafElement {
        BidiElement(Element element, int n, int n2, int n3) {
            super(element, new SimpleAttributeSet(), n, n2);
            this.addAttribute(StyleConstants.BidiLevel, new Integer(n3));
        }

        public String getName() {
            return AbstractDocument.BidiElementName;
        }
    }

    private class BidiRootElement
    extends BranchElement {
        BidiRootElement() {
            super(null, null);
        }

        public String getName() {
            return AbstractDocument.BidiRootName;
        }
    }

    public class LeafElement
    extends AbstractElement {
        private static final long serialVersionUID = -8906306331347768017L;
        private Position startPos;
        private Position endPos;

        public LeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
            super(element, attributeSet);
            try {
                this.startPos = AbstractDocument.this.createPosition(n);
                this.endPos = AbstractDocument.this.createPosition(n2);
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError((Object)("BadLocationException thrown here. start=" + n + ", end=" + n2 + ", length=" + AbstractDocument.this.getLength()));
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
        }

        public Enumeration children() {
            return null;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public Element getElement(int n) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int n) {
            return -1;
        }

        public int getEndOffset() {
            return this.endPos.getOffset();
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                string = AbstractDocument.ContentElementName;
            }
            return string;
        }

        public int getStartOffset() {
            return this.startPos.getOffset();
        }

        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            return "LeafElement(" + this.getName() + ") " + this.getStartOffset() + "," + this.getEndOffset() + "\n";
        }
    }

    public static class ElementEdit
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        private static final long serialVersionUID = -1216620962142928304L;
        private Element elem;
        private int index;
        private Element[] removed;
        private Element[] added;

        public ElementEdit(Element element, int n, Element[] elementArray, Element[] elementArray2) {
            this.elem = element;
            this.index = n;
            this.removed = elementArray;
            this.added = elementArray2;
        }

        public Element[] getChildrenAdded() {
            return this.added;
        }

        public Element[] getChildrenRemoved() {
            return this.removed;
        }

        public Element getElement() {
            return this.elem;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public class DefaultDocumentEvent
    extends CompoundEdit
    implements DocumentEvent {
        private static final long serialVersionUID = 5230037221564563284L;
        private static final int THRESHOLD = 10;
        private int offset;
        private int length;
        private DocumentEvent.EventType type;
        private HashMap changes;
        private boolean modified;

        public DefaultDocumentEvent(int n, int n2, DocumentEvent.EventType eventType) {
            this.offset = n;
            this.length = n2;
            this.type = eventType;
            this.modified = false;
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (this.changes == null && this.edits.size() > 10) {
                this.changes = new HashMap();
                int n = this.edits.size();
                for (int i = 0; i < n; ++i) {
                    Object t = this.edits.elementAt(i);
                    if (!(t instanceof DocumentEvent.ElementChange)) continue;
                    DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)t;
                    this.changes.put(elementChange.getElement(), elementChange);
                }
            }
            if (this.changes != null && undoableEdit instanceof DocumentEvent.ElementChange) {
                DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)((Object)undoableEdit);
                this.changes.put(elementChange.getElement(), elementChange);
            }
            return super.addEdit(undoableEdit);
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public DocumentEvent.EventType getType() {
            return this.type;
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            DocumentEvent.ElementChange elementChange = null;
            if (this.changes != null) {
                elementChange = (DocumentEvent.ElementChange)this.changes.get(element);
            } else {
                int n = this.edits.size();
                for (int i = 0; i < n && elementChange == null; ++i) {
                    DocumentEvent.ElementChange elementChange2;
                    Object t = this.edits.get(i);
                    if (!(t instanceof DocumentEvent.ElementChange) || !element.equals((elementChange2 = (DocumentEvent.ElementChange)t).getElement())) continue;
                    elementChange = elementChange2;
                }
            }
            return elementChange;
        }

        public String toString() {
            return this.edits.toString();
        }
    }

    public class BranchElement
    extends AbstractElement {
        private static final long serialVersionUID = -6037216547466333183L;
        private Element[] children;
        private int numChildren;
        private int lastIndex;

        public BranchElement(Element element, AttributeSet attributeSet) {
            super(element, attributeSet);
            this.children = new Element[1];
            this.numChildren = 0;
            this.lastIndex = -1;
        }

        public Enumeration children() {
            if (this.numChildren == 0) {
                return null;
            }
            Vector<Element> vector = new Vector<Element>();
            for (int i = 0; i < this.numChildren; ++i) {
                vector.add(this.children[i]);
            }
            return vector.elements();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public Element getElement(int n) {
            if (n < 0 || n >= this.numChildren) {
                return null;
            }
            return this.children[n];
        }

        public int getElementCount() {
            return this.numChildren;
        }

        public int getElementIndex(int n) {
            int n2 = 0;
            int n3 = this.numChildren - 1;
            int n4 = -1;
            int n5 = this.getStartOffset();
            if (this.numChildren == 0) {
                n4 = 0;
            } else if (n >= this.getEndOffset()) {
                n4 = this.numChildren - 1;
            } else {
                int n6;
                if (this.lastIndex >= n2 && this.lastIndex <= n3) {
                    Element element = this.getElement(this.lastIndex);
                    n5 = element.getStartOffset();
                    n6 = element.getEndOffset();
                    if (n >= n5 && n < n6) {
                        n4 = this.lastIndex;
                    } else if (n < n5) {
                        n3 = this.lastIndex;
                    } else {
                        n2 = this.lastIndex;
                    }
                }
                int n7 = 0;
                while (n2 <= n3 && n4 == -1) {
                    n7 = n2 + (n3 - n2) / 2;
                    Element element = this.getElement(n7);
                    n5 = element.getStartOffset();
                    n6 = element.getEndOffset();
                    if (n >= n5 && n < n6) {
                        n4 = n7;
                        continue;
                    }
                    if (n < n5) {
                        n3 = n7 - 1;
                        continue;
                    }
                    n2 = n7 + 1;
                }
                if (n4 == -1) {
                    n4 = n < n5 ? n7 : n7 + 1;
                }
                this.lastIndex = n4;
            }
            return n4;
        }

        public int getEndOffset() {
            Element element = this.numChildren > 0 ? this.children[this.numChildren - 1] : this.children[0];
            return element.getEndOffset();
        }

        public String getName() {
            return AbstractDocument.ParagraphElementName;
        }

        public int getStartOffset() {
            return this.children[0].getStartOffset();
        }

        public boolean isLeaf() {
            return false;
        }

        public Element positionToElement(int n) {
            for (int i = 0; i < this.numChildren; ++i) {
                Element element = this.children[i];
                if (element.getStartOffset() > n || n >= element.getEndOffset()) continue;
                return element;
            }
            return null;
        }

        public void replace(int n, int n2, Element[] elementArray) {
            int n3 = elementArray.length - n2;
            int n4 = n + n2;
            int n5 = n4 + n3;
            int n6 = this.numChildren - n4;
            if (this.numChildren + n3 > this.children.length) {
                int n7 = Math.max(2 * this.children.length, this.numChildren + n3);
                Element[] elementArray2 = new Element[n7];
                System.arraycopy(this.children, 0, elementArray2, 0, n);
                System.arraycopy(elementArray, 0, elementArray2, n, elementArray.length);
                System.arraycopy(this.children, n4, elementArray2, n5, n6);
                this.children = elementArray2;
            } else {
                System.arraycopy(this.children, n4, this.children, n5, n6);
                System.arraycopy(elementArray, 0, this.children, n, elementArray.length);
            }
            this.numChildren += n3;
        }

        public String toString() {
            return "BranchElement(" + this.getName() + ") " + this.getStartOffset() + "," + this.getEndOffset() + "\n";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractElement
    implements Element,
    MutableAttributeSet,
    TreeNode,
    Serializable {
        private static final long serialVersionUID = 1712240033321461704L;
        int count;
        int offset;
        AttributeSet attributes;
        Element element_parent;
        TreeNode tree_parent;
        Vector tree_children;

        public AbstractElement(Element element, AttributeSet attributeSet) {
            this.element_parent = element;
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.getEmptySet();
            if (attributeSet != null) {
                this.addAttributes(attributeSet);
            }
        }

        @Override
        public abstract Enumeration children();

        @Override
        public abstract boolean getAllowsChildren();

        @Override
        public TreeNode getChildAt(int n) {
            return (TreeNode)this.tree_children.get(n);
        }

        @Override
        public int getChildCount() {
            return this.tree_children.size();
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            return this.tree_children.indexOf(treeNode);
        }

        @Override
        public TreeNode getParent() {
            return this.tree_parent;
        }

        @Override
        public abstract boolean isLeaf();

        @Override
        public void addAttribute(Object object, Object object2) {
            this.attributes = AbstractDocument.this.getAttributeContext().addAttribute(this.attributes, object, object2);
        }

        @Override
        public void addAttributes(AttributeSet attributeSet) {
            this.attributes = AbstractDocument.this.getAttributeContext().addAttributes(this.attributes, attributeSet);
        }

        @Override
        public void removeAttribute(Object object) {
            this.attributes = AbstractDocument.this.getAttributeContext().removeAttribute(this.attributes, object);
        }

        @Override
        public void removeAttributes(AttributeSet attributeSet) {
            this.attributes = AbstractDocument.this.getAttributeContext().removeAttributes(this.attributes, attributeSet);
        }

        @Override
        public void removeAttributes(Enumeration<?> enumeration) {
            this.attributes = AbstractDocument.this.getAttributeContext().removeAttributes(this.attributes, enumeration);
        }

        @Override
        public void setResolveParent(AttributeSet attributeSet) {
            this.attributes = AbstractDocument.this.getAttributeContext().addAttribute(this.attributes, ResolveAttribute, attributeSet);
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        @Override
        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        @Override
        public Object getAttribute(Object object) {
            AttributeSet attributeSet;
            Object object2 = this.attributes.getAttribute(object);
            if (object2 == null && (attributeSet = this.getResolveParent()) != null) {
                object2 = attributeSet.getAttribute(object);
            }
            return object2;
        }

        @Override
        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        @Override
        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        @Override
        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        @Override
        public AttributeSet getAttributes() {
            return this;
        }

        @Override
        public Document getDocument() {
            return AbstractDocument.this;
        }

        @Override
        public abstract Element getElement(int var1);

        @Override
        public String getName() {
            return (String)this.attributes.getAttribute(AbstractDocument.ElementNameAttribute);
        }

        @Override
        public Element getParentElement() {
            return this.element_parent;
        }

        @Override
        public abstract int getEndOffset();

        @Override
        public abstract int getElementCount();

        @Override
        public abstract int getElementIndex(int var1);

        @Override
        public abstract int getStartOffset();

        public void dump(PrintStream printStream, int n) {
            Object object;
            int n2;
            CPStringBuilder cPStringBuilder = new CPStringBuilder();
            for (n2 = 0; n2 < n; ++n2) {
                cPStringBuilder.append(' ');
            }
            cPStringBuilder.append('<');
            cPStringBuilder.append(this.getName());
            if (this.getAttributeCount() > 0) {
                cPStringBuilder.append('\n');
                Enumeration<?> enumeration = this.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    for (int i = 0; i < n + 2; ++i) {
                        cPStringBuilder.append(' ');
                    }
                    Object obj = enumeration.nextElement();
                    cPStringBuilder.append(obj);
                    cPStringBuilder.append('=');
                    object = this.getAttribute(obj);
                    cPStringBuilder.append(object);
                    cPStringBuilder.append('\n');
                }
            }
            if (this.getAttributeCount() > 0) {
                for (n2 = 0; n2 < n; ++n2) {
                    cPStringBuilder.append(' ');
                }
            }
            cPStringBuilder.append(">\n");
            if (this.isLeaf()) {
                for (n2 = 0; n2 < n + 2; ++n2) {
                    cPStringBuilder.append(' ');
                }
                n2 = this.getStartOffset();
                int n3 = this.getEndOffset();
                cPStringBuilder.append('[');
                cPStringBuilder.append(n2);
                cPStringBuilder.append(',');
                cPStringBuilder.append(n3);
                cPStringBuilder.append("][");
                try {
                    cPStringBuilder.append(this.getDocument().getText(n2, n3 - n2));
                }
                catch (BadLocationException badLocationException) {
                    AssertionError assertionError = new AssertionError((Object)"BadLocationException must not be thrown here.");
                    ((Throwable)((Object)assertionError)).initCause(badLocationException);
                    throw assertionError;
                }
                cPStringBuilder.append("]\n");
            }
            printStream.print(cPStringBuilder.toString());
            n2 = this.getElementCount();
            for (int i = 0; i < n2; ++i) {
                object = this.getElement(i);
                if (!(object instanceof AbstractElement)) continue;
                ((AbstractElement)object).dump(printStream, n + 2);
            }
        }
    }

    public static interface Content {
        public Position createPosition(int var1) throws BadLocationException;

        public int length();

        public UndoableEdit insertString(int var1, String var2) throws BadLocationException;

        public UndoableEdit remove(int var1, int var2) throws BadLocationException;

        public String getString(int var1, int var2) throws BadLocationException;

        public void getChars(int var1, int var2, Segment var3) throws BadLocationException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AttributeContext {
        public AttributeSet addAttribute(AttributeSet var1, Object var2, Object var3);

        public AttributeSet addAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet getEmptySet();

        public void reclaim(AttributeSet var1);

        public AttributeSet removeAttribute(AttributeSet var1, Object var2);

        public AttributeSet removeAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet removeAttributes(AttributeSet var1, Enumeration<?> var2);
    }
}

