/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import gnu.java.lang.CPStringBuilder;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableModel
implements TableModel,
Serializable {
    static final long serialVersionUID = -5798593159423650347L;
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public String getColumnName(int n) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        while (n >= 0) {
            cPStringBuilder.insert(0, (char)(65 + n % 26));
            n = n / 26 - 1;
        }
        return cPStringBuilder.toString();
    }

    public int findColumn(String string) {
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.getColumnName(i);
            if (!string.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.add(TableModelListener.class, tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.remove(TableModelListener.class, tableModelListener);
    }

    public TableModelListener[] getTableModelListeners() {
        return (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this, 0, Integer.MAX_VALUE));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsInserted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 1));
    }

    public void fireTableRowsUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 0));
    }

    public void fireTableRowsDeleted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, -1));
    }

    public void fireTableCellUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n, n2));
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            TableModelListener tableModelListener = (TableModelListener)objectArray[i + 1];
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }
}

