/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolTipUI;

public class MetalToolTipUI
extends BasicToolTipUI {
    public static final int padSpaceBetweenStrings = 12;
    private static MetalToolTipUI instance;
    private boolean isAcceleratorHidden;
    private String acceleratorString;
    private String acceleratorDelimiter;
    private Font acceleratorFont;
    private Color acceleratorForeground;
    private Border activeBorder = UIManager.getBorder("ToolTip.border");
    private Border inactiveBorder = UIManager.getBorder("ToolTip.borderInactive");

    public MetalToolTipUI() {
        this.isAcceleratorHidden = UIManager.getBoolean("ToolTip.hideAccelerator");
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        this.acceleratorForeground = UIManager.getColor("MenuItem.acceleratorForeground");
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (instance == null) {
            instance = new MetalToolTipUI();
        }
        return instance;
    }

    public String getAcceleratorString() {
        return this.acceleratorString;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            if (jComponent.isEnabled()) {
                jComponent.setBorder(this.activeBorder);
            } else {
                jComponent.setBorder(this.inactiveBorder);
            }
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (jComponent.getBorder() instanceof UIResource) {
            jComponent.setBorder(null);
        }
    }

    protected boolean isAcceleratorHidden() {
        return this.isAcceleratorHidden;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        String string = this.getAcceleratorString();
        if (string != null && !string.equals("")) {
            FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
            dimension.width += fontMetrics.stringWidth(string);
        }
        return dimension;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
    }

    private String fetchAcceleratorString(JComponent jComponent) {
        String string = null;
        if (jComponent instanceof JToolTip) {
            JToolTip jToolTip = (JToolTip)jComponent;
            JComponent jComponent2 = jToolTip.getComponent();
            KeyStroke keyStroke = null;
            int n = 0;
            if (jComponent2 instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)jComponent2;
                keyStroke = jMenuItem.getAccelerator();
                if (keyStroke == null) {
                    n = jMenuItem.getMnemonic();
                }
            } else if (jComponent2 instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)jComponent2;
                n = abstractButton.getMnemonic();
            }
            if (n > 0) {
                keyStroke = KeyStroke.getKeyStroke(Character.toUpperCase((char)n), 8, false);
            }
            if (keyStroke != null) {
                string = this.acceleratorToString(keyStroke);
            }
        }
        return string;
    }

    private String acceleratorToString(KeyStroke keyStroke) {
        String string = "";
        int n = keyStroke.getModifiers();
        char c = keyStroke.getKeyChar();
        int n2 = keyStroke.getKeyCode();
        if (n != 0) {
            string = KeyEvent.getKeyModifiersText(n) + this.acceleratorDelimiter;
        }
        if (n2 == 0) {
            return string + c;
        }
        return string + KeyEvent.getKeyText(n2);
    }
}

