/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;
import javax.swing.plaf.metal.OceanTheme;

public class MetalToolBarUI
extends BasicToolBarUI {
    protected ContainerListener contListener;
    protected PropertyChangeListener rolloverListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalToolBarUI();
    }

    protected PropertyChangeListener createRolloverListener() {
        return null;
    }

    protected ContainerListener createContainerListener() {
        return null;
    }

    protected Border createNonRolloverBorder() {
        return MetalBorders.getToolbarButtonBorder();
    }

    protected void setDragOffset(Point point) {
        if (this.dragWindow != null) {
            this.dragWindow.setOffset(point);
        }
    }

    protected MouseInputListener createDockingListener() {
        return new MetalDockingListener(this.toolBar);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JToolBar) {
            JToolBar jToolBar = (JToolBar)jComponent;
            jToolBar.setRollover(UIManager.getBoolean("ToolBar.isRollover"));
        }
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent instanceof JToolBar) {
            JToolBar jToolBar = (JToolBar)jComponent;
            jToolBar.setRollover(false);
        }
        super.uninstallUI(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme && UIManager.get("MenuBar.gradient") != null) {
            if (jComponent.isOpaque()) {
                MetalUtils.paintGradient(graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), 1, "MenuBar.gradient");
            }
            this.paint(graphics, jComponent);
        } else {
            super.update(graphics, jComponent);
        }
    }

    protected class MetalDockingListener
    extends BasicToolBarUI.DockingListener {
        public MetalDockingListener(JToolBar jToolBar) {
            super(jToolBar);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            MetalToolBarUI.this.setDragOffset(new Point(mouseEvent.getX(), mouseEvent.getY()));
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
        }
    }

    protected class MetalRolloverListener
    extends BasicToolBarUI.PropertyListener {
        protected MetalRolloverListener() {
        }
    }

    protected class MetalContainerListener
    extends BasicToolBarUI.ToolBarContListener {
        protected MetalContainerListener() {
        }
    }
}

