/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalSplitPaneUI;
import javax.swing.plaf.metal.MetalUtils;

class MetalSplitPaneDivider
extends BasicSplitPaneDivider {
    static final byte[][] BUTTON_SPRITE_L = new byte[][]{{0, 0, 0, 2, 0, 0, 0, 0}, {0, 0, 2, 1, 1, 0, 0, 0}, {0, 2, 1, 1, 1, 1, 0, 0}, {2, 1, 1, 1, 1, 1, 1, 0}, {0, 3, 3, 3, 3, 3, 3, 3}};
    static final byte[][] BUTTON_SPRITE_R = new byte[][]{{2, 2, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 1, 1, 1, 1, 3}, {0, 0, 1, 1, 1, 1, 3, 0}, {0, 0, 0, 1, 1, 3, 0, 0}, {0, 0, 0, 0, 3, 0, 0, 0}};
    Color dark;
    Color light;
    JSplitPane splitPane;
    int orientation;

    public MetalSplitPaneDivider(MetalSplitPaneUI metalSplitPaneUI, Color color, Color color2) {
        super(metalSplitPaneUI);
        this.splitPane = ((BasicSplitPaneDivider)this).splitPane;
        this.orientation = ((BasicSplitPaneDivider)this).orientation;
        this.light = color;
        this.dark = color2;
    }

    public void paint(Graphics graphics) {
        Border border;
        Dimension dimension = this.getSize();
        if (this.splitPane.hasFocus()) {
            graphics.setColor(UIManager.getColor("SplitPane.dividerFocusColor"));
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if ((border = this.getBorder()) != null) {
            border.paintBorder(this, graphics, 0, 0, dimension.width, dimension.height);
        }
        Insets insets = this.getInsets();
        MetalUtils.fillMetalPattern(this.splitPane, graphics, insets.left + 2, insets.top + 2, dimension.width - insets.left - insets.right - 4, dimension.height - insets.top - insets.bottom - 4, this.light, this.dark);
        super.paint(graphics);
    }

    protected JButton createLeftOneTouchButton() {
        MetalOneTouchButton metalOneTouchButton = new MetalOneTouchButton(0);
        metalOneTouchButton.setMinimumSize(new Dimension(6, 6));
        metalOneTouchButton.setRequestFocusEnabled(false);
        return metalOneTouchButton;
    }

    protected JButton createRightOneTouchButton() {
        MetalOneTouchButton metalOneTouchButton = new MetalOneTouchButton(1);
        metalOneTouchButton.setMinimumSize(new Dimension(6, 6));
        metalOneTouchButton.setRequestFocusEnabled(false);
        return metalOneTouchButton;
    }

    private class MetalOneTouchButton
    extends JButton {
        static final int LEFT = 0;
        static final int RIGHT = 1;
        private Color[] colors;
        private int direction;

        MetalOneTouchButton(int n) {
            this.direction = n;
            this.colors = new Color[4];
        }

        public void setBorder(Border border) {
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paint(Graphics graphics) {
            block7: {
                if (MetalSplitPaneDivider.this.splitPane == null) break block7;
                this.colors[0] = this.getBackground();
                this.colors[1] = MetalLookAndFeel.getPrimaryControlDarkShadow();
                this.colors[2] = MetalLookAndFeel.getPrimaryControlInfo();
                this.colors[3] = MetalLookAndFeel.getPrimaryControlHighlight();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.getModel().isPressed()) {
                    this.colors[1] = this.colors[2];
                }
                byte[][] byArray = this.direction == 0 ? BUTTON_SPRITE_L : BUTTON_SPRITE_R;
                if (MetalSplitPaneDivider.this.orientation == 0) {
                    for (int i = 0; i < byArray.length; ++i) {
                        byte[] byArray2 = byArray[i];
                        for (int j = 0; j < byArray2.length; ++j) {
                            byte by = byArray2[j];
                            if (by == 0) continue;
                            graphics.setColor(this.colors[by]);
                            graphics.fillRect(j + 1, i + 1, 1, 1);
                        }
                    }
                } else {
                    for (int i = 0; i < byArray.length; ++i) {
                        byte[] byArray3 = byArray[i];
                        for (int j = 0; j < byArray3.length; ++j) {
                            byte by = byArray3[j];
                            if (by == 0) continue;
                            graphics.setColor(this.colors[by]);
                            graphics.fillRect(i + 1, j + 1, 1, 1);
                        }
                    }
                }
            }
        }
    }
}

