/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;

public class MetalInternalFrameUI
extends BasicInternalFrameUI {
    protected static String IS_PALETTE = "JInternalFrame.isPalette";
    private PropertyChangeListener paletteListener;

    public MetalInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalInternalFrameUI((JInternalFrame)jComponent);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        JInternalFrame jInternalFrame = (JInternalFrame)jComponent;
        boolean bl = false;
        Boolean bl2 = (Boolean)jInternalFrame.getClientProperty(IS_PALETTE);
        if (bl2 != null) {
            bl = bl2;
        }
        this.setPalette(bl);
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new MetalInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    public void setPalette(boolean bl) {
        MetalInternalFrameTitlePane metalInternalFrameTitlePane = (MetalInternalFrameTitlePane)this.northPane;
        metalInternalFrameTitlePane.setPalette(bl);
        if (bl) {
            this.frame.setBorder(new MetalBorders.PaletteBorder());
        } else {
            this.frame.setBorder(new MetalBorders.InternalFrameBorder());
        }
    }

    protected void installListeners() {
        super.installListeners();
        this.paletteListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(IS_PALETTE)) {
                    if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                        MetalInternalFrameUI.this.setPalette(true);
                    } else {
                        MetalInternalFrameUI.this.setPalette(false);
                    }
                }
            }
        };
        this.frame.addPropertyChangeListener(this.paletteListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.frame.removePropertyChangeListener(IS_PALETTE, this.paletteListener);
        this.paletteListener = null;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.frame);
        if (actionMap != null) {
            actionMap.remove("showSystemMenu");
        }
    }
}

