/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxIcon;

public class MetalComboBoxUI
extends BasicComboBoxUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalComboBoxUI();
    }

    protected ComboBoxEditor createEditor() {
        return new MetalComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return super.createPopup();
    }

    protected JButton createArrowButton() {
        MetalComboBoxButton metalComboBoxButton = new MetalComboBoxButton(this.comboBox, new MetalComboBoxIcon(), this.currentValuePane, this.listBox);
        metalComboBoxButton.setMargin(new Insets(0, 1, 1, 3));
        return metalComboBoxButton;
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeListener();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected void editablePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.arrowButton instanceof MetalComboBoxButton) {
            MetalComboBoxButton metalComboBoxButton = (MetalComboBoxButton)this.arrowButton;
            metalComboBoxButton.setIconOnly(this.comboBox.isEditable());
            metalComboBoxButton.setFocusable(!this.comboBox.isEditable() && this.comboBox.isEnabled());
            this.comboBox.repaint();
        }
    }

    protected LayoutManager createLayoutManager() {
        return new MetalComboBoxLayoutManager();
    }

    protected void removeListeners() {
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension;
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof MetalComboBoxButton) {
            MetalComboBoxButton metalComboBoxButton = (MetalComboBoxButton)this.arrowButton;
            dimension = this.getDisplaySize();
            Insets insets = metalComboBoxButton.getInsets();
            Insets insets2 = this.comboBox.getInsets();
            Icon icon = metalComboBoxButton.getComboIcon();
            dimension.width += insets2.left + insets2.right;
            dimension.width += insets.left + insets.right;
            dimension.width += insets.right + icon.getIconWidth();
            dimension.height += insets2.top + insets2.bottom;
            dimension.height += insets.top + insets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            dimension = super.getMinimumSize(jComponent);
            Insets insets = this.arrowButton.getMargin();
            dimension.height += insets.top + insets.bottom;
            dimension.width += insets.left + insets.right;
        } else {
            dimension = super.getMinimumSize(jComponent);
        }
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    public void configureEditor() {
        super.configureEditor();
        if (this.popupKeyListener != null) {
            this.editor.removeKeyListener(this.popupKeyListener);
        }
        if (this.focusListener != null) {
            this.editor.addFocusListener(this.focusListener);
        }
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.focusListener != null) {
            this.editor.removeFocusListener(this.focusListener);
        }
    }

    public void layoutComboBox(Container container, MetalComboBoxLayoutManager metalComboBoxLayoutManager) {
        if (this.comboBox.isEditable()) {
            metalComboBoxLayoutManager.superLayout(container);
        } else if (this.arrowButton != null) {
            Insets insets = this.comboBox.getInsets();
            int n = this.comboBox.getWidth();
            int n2 = this.comboBox.getHeight();
            this.arrowButton.setBounds(insets.left, insets.top, n - (insets.left + insets.right), n2 - (insets.top + insets.bottom));
        }
    }

    public class MetalComboPopup
    extends BasicComboPopup {
        public MetalComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        public void delegateFocus(MouseEvent mouseEvent) {
            super.delegateFocus(mouseEvent);
        }
    }

    public class MetalPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("editable")) {
                MetalComboBoxUI.this.editablePropertyChanged(propertyChangeEvent);
            } else if (string.equals("enabled")) {
                if (MetalComboBoxUI.this.arrowButton instanceof MetalComboBoxButton) {
                    MetalComboBoxUI.this.arrowButton.setFocusable(!MetalComboBoxUI.this.comboBox.isEditable() && MetalComboBoxUI.this.comboBox.isEnabled());
                    MetalComboBoxUI.this.comboBox.repaint();
                }
            } else if (string.equals("background")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                MetalComboBoxUI.this.arrowButton.setBackground(color);
                MetalComboBoxUI.this.listBox.setBackground(color);
            } else if (string.equals("foreground")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                MetalComboBoxUI.this.arrowButton.setForeground(color);
                MetalComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }

    public class MetalComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        public void layoutContainer(Container container) {
            MetalComboBoxUI.this.layoutComboBox(container, this);
        }

        public void superLayout(Container container) {
            super.layoutContainer(container);
        }
    }
}

