/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class MetalComboBoxEditor
extends BasicComboBoxEditor {
    protected static Insets editorBorderInsets = new Insets(2, 2, 2, 0);

    public MetalComboBoxEditor() {
        this.editor = new EditorTextField("", 9);
        this.editor.setBorder(new MetalComboBoxEditorBorder());
    }

    private class EditorTextField
    extends JTextField {
        EditorTextField(String string, int n) {
            super(string, n);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.height += 4;
            return dimension;
        }

        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            dimension.height += 4;
            return dimension;
        }
    }

    public static class UIResource
    extends MetalComboBoxEditor
    implements javax.swing.plaf.UIResource {
    }

    static class MetalComboBoxEditorBorder
    extends AbstractBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                graphics.drawLine(0, 0, n3 - 1, 0);
                graphics.drawLine(0, 0, 0, n4 - 1);
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawLine(1, 1, n3 - 2, 1);
                graphics.drawLine(1, 1, 1, n4 - 2);
                graphics.drawLine(1, n4 - 2, n3 - 1, n4 - 2);
                graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 2);
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                graphics.drawLine(0, 0, n3 - 1, 0);
                graphics.drawLine(0, 0, 0, n4 - 2);
                graphics.drawLine(0, n4 - 2, n3 - 1, n4 - 2);
                graphics.setColor(MetalLookAndFeel.getControlHighlight());
                graphics.drawLine(1, 1, n3 - 1, 1);
                graphics.drawLine(1, 1, 1, n4 - 1);
                graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
                graphics.setColor(MetalLookAndFeel.getControl());
                graphics.drawLine(1, n4 - 2, 1, n4 - 2);
            }
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component) {
            return editorBorderInsets;
        }
    }
}

