/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.metal.MetalUtils;

public class MetalButtonUI
extends BasicButtonUI {
    private static MetalButtonUI sharedUI;
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;

    public static ComponentUI createUI(JComponent jComponent) {
        if (sharedUI == null) {
            sharedUI = new MetalButtonUI();
        }
        return sharedUI;
    }

    protected Color getFocusColor() {
        this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
        return this.focusColor;
    }

    protected Color getSelectColor() {
        this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
        return this.disabledTextColor;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled()) {
            graphics.setColor(this.getSelectColor());
            graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (abstractButton.isEnabled() && abstractButton.hasFocus() && abstractButton.isFocusPainted()) {
            Color color = graphics.getColor();
            graphics.setColor(this.getFocusColor());
            Rectangle rectangle4 = rectangle3.union(rectangle2);
            graphics.drawRect(rectangle4.x - 1, rectangle4.y, rectangle4.width + 1, rectangle4.height);
            graphics.setColor(color);
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Font font = abstractButton.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        if (abstractButton.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
        } else {
            graphics.setColor(this.getDisabledTextColor());
            graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (abstractButton.getBackground() instanceof UIResource && abstractButton.isContentAreaFilled() && abstractButton.isEnabled()) {
            ButtonModel buttonModel = abstractButton.getModel();
            String string = "Button.gradient";
            if (!this.isToolbarButton(abstractButton)) {
                if (!buttonModel.isArmed() && !buttonModel.isPressed() && this.isDrawingGradient(string)) {
                    MetalUtils.paintGradient(graphics, 0, 0, abstractButton.getWidth(), abstractButton.getHeight(), 1, string);
                    this.paint(graphics, jComponent);
                    return;
                }
            } else if (buttonModel.isRollover() && this.isDrawingGradient(string)) {
                MetalUtils.paintGradient(graphics, 0, 0, abstractButton.getWidth(), abstractButton.getHeight(), 1, string);
                this.paint(graphics, jComponent);
                return;
            }
        }
        super.update(graphics, jComponent);
    }

    private boolean isToolbarButton(Component component) {
        Container container = component.getParent();
        return container instanceof JToolBar;
    }

    private boolean isDrawingGradient(String string) {
        return UIManager.get(string) != null;
    }
}

