/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.javax.swing.tree.GnuPath;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.SharedUIDefaults;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.VariableHeightLayoutCache;

public class BasicTreeUI
extends TreeUI {
    static int WAIT_TILL_EDITING = 900;
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected Dimension preferredMinSize;
    protected boolean validCachedPreferredSize = false;
    protected AbstractLayoutCache treeState;
    protected Hashtable<TreePath, Boolean> drawingCache = new Hashtable();
    protected boolean largeModel;
    protected AbstractLayoutCache.NodeDimensions nodeDimensions = this.createNodeDimensions();
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected int depthOffset;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected int editingRow;
    protected boolean editorHasDifferentSize;
    boolean isEditing;
    TreePath currentVisiblePath;
    int gap = 4;
    int maxHeight;
    Color hashColor;
    PropertyChangeListener propertyChangeListener;
    FocusListener focusListener;
    TreeSelectionListener treeSelectionListener;
    MouseListener mouseListener;
    KeyListener keyListener;
    PropertyChangeListener selectionModelPropertyChangeListener;
    ComponentListener componentListener;
    CellEditorListener cellEditorListener;
    TreeExpansionListener treeExpansionListener;
    TreeModelListener treeModelListener;
    static Icon nullIcon;

    public BasicTreeUI() {
        this.configureLayoutCache();
        this.editingRow = -1;
        this.lastSelectedRow = -1;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTreeUI();
    }

    protected Color getHashColor() {
        return this.hashColor;
    }

    protected void setHashColor(Color color) {
        this.hashColor = color;
    }

    public void setLeftChildIndent(int n) {
        this.leftChildIndent = n;
    }

    public int getLeftChildIndent() {
        return this.leftChildIndent;
    }

    public void setRightChildIndent(int n) {
        this.rightChildIndent = n;
    }

    public int getRightChildIndent() {
        return this.rightChildIndent;
    }

    public void setExpandedIcon(Icon icon) {
        this.expandedIcon = icon;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setCollapsedIcon(Icon icon) {
        this.collapsedIcon = icon;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    protected void setLargeModel(boolean bl) {
        if (bl != this.largeModel) {
            this.completeEditing();
            this.tree.removeComponentListener(this.componentListener);
            this.largeModel = bl;
            this.tree.addComponentListener(this.componentListener);
        }
    }

    protected boolean isLargeModel() {
        return this.largeModel;
    }

    protected void setRowHeight(int n) {
        this.completeEditing();
        if (n == 0) {
            n = this.getMaxHeight(this.tree);
        }
        this.treeState.setRowHeight(n);
    }

    protected int getRowHeight() {
        return this.tree.getRowHeight();
    }

    protected void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.completeEditing();
        this.updateRenderer();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected TreeCellRenderer getCellRenderer() {
        if (this.currentCellRenderer != null) {
            return this.currentCellRenderer;
        }
        return this.createDefaultCellRenderer();
    }

    protected void setModel(TreeModel treeModel) {
        this.completeEditing();
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        this.treeModel = this.tree.getModel();
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if (this.treeState != null) {
            this.treeState.setModel(this.treeModel);
            this.updateLayoutCacheExpandedNodes();
            this.updateSize();
        }
    }

    protected TreeModel getModel() {
        return this.treeModel;
    }

    protected void setRootVisible(boolean bl) {
        this.completeEditing();
        this.tree.setRootVisible(bl);
    }

    protected boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    protected void setShowsRootHandles(boolean bl) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean getShowsRootHandles() {
        return this.tree.getShowsRootHandles();
    }

    protected void setCellEditor(TreeCellEditor treeCellEditor) {
        this.updateCellEditor();
    }

    protected TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    protected void setEditable(boolean bl) {
        this.updateCellEditor();
    }

    protected boolean isEditable() {
        return this.tree.isEditable();
    }

    protected void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        this.completeEditing();
        if (treeSelectionModel != null) {
            this.treeSelectionModel = treeSelectionModel;
            this.tree.setSelectionModel(this.treeSelectionModel);
        }
    }

    protected TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public Rectangle getPathBounds(JTree jTree, TreePath treePath) {
        Rectangle rectangle = null;
        if (jTree != null && this.treeState != null) {
            rectangle = this.treeState.getBounds(treePath, null);
            Insets insets = jTree.getInsets();
            if (rectangle != null && insets != null) {
                rectangle.x += insets.left;
                rectangle.y += insets.top;
            }
        }
        return rectangle;
    }

    int getMaxHeight(JTree jTree) {
        if (this.maxHeight != 0) {
            return this.maxHeight;
        }
        Icon icon = UIManager.getIcon("Tree.openIcon");
        Icon icon2 = UIManager.getIcon("Tree.closedIcon");
        Icon icon3 = UIManager.getIcon("Tree.leafIcon");
        int n = this.getRowCount(jTree);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = this.isLeaf(i) ? icon3.getIconHeight() : (jTree.isExpanded(i) ? icon.getIconHeight() : icon2.getIconHeight());
            this.maxHeight = Math.max(this.maxHeight, n2 + this.gap);
        }
        this.treeState.setRowHeight(this.maxHeight);
        return this.maxHeight;
    }

    Icon getNodeIcon(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (this.treeModel.isLeaf(object)) {
            return UIManager.getIcon("Tree.leafIcon");
        }
        if (this.treeState.getExpandedState(treePath)) {
            return UIManager.getIcon("Tree.openIcon");
        }
        return UIManager.getIcon("Tree.closedIcon");
    }

    public TreePath getPathForRow(JTree jTree, int n) {
        return this.treeState.getPathForRow(n);
    }

    public int getRowForPath(JTree jTree, TreePath treePath) {
        return this.treeState.getRowForPath(treePath);
    }

    public int getRowCount(JTree jTree) {
        return this.treeState.getRowCount();
    }

    public TreePath getClosestPathForLocation(JTree jTree, int n, int n2) {
        return this.treeState.getPathClosestTo(n, n2);
    }

    public boolean isEditing(JTree jTree) {
        return this.isEditing;
    }

    public boolean stopEditing(JTree jTree) {
        boolean bl = false;
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            bl = true;
        }
        return bl;
    }

    public void cancelEditing(JTree jTree) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    public void startEditingAtPath(JTree jTree, TreePath treePath) {
        jTree.scrollPathToVisible(treePath);
        if (treePath != null && jTree.isVisible(treePath)) {
            this.startEditing(treePath, null);
        }
    }

    public TreePath getEditingPath(JTree jTree) {
        return this.editingPath;
    }

    protected void prepareForUIInstall() {
        this.lastSelectedRow = -1;
        this.preferredSize = new Dimension();
        this.largeModel = this.tree.isLargeModel();
        this.preferredSize = new Dimension();
        this.stopEditingInCompleteEditing = true;
        this.setModel(this.tree.getModel());
    }

    protected void completeUIInstall() {
        this.setShowsRootHandles(this.tree.getShowsRootHandles());
        this.updateRenderer();
        this.updateDepthOffset();
        this.setSelectionModel(this.tree.getSelectionModel());
        this.configureLayoutCache();
        this.treeState.setRootVisible(this.tree.isRootVisible());
        this.treeSelectionModel.setRowMapper(this.treeState);
        this.updateSize();
    }

    protected void completeUIUninstall() {
        this.tree = null;
    }

    protected void installComponents() {
        this.currentCellRenderer = this.createDefaultCellRenderer();
        this.rendererPane = this.createCellRendererPane();
        this.createdRenderer = true;
        this.setCellRenderer(this.currentCellRenderer);
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new NodeDimensionsHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return new SelectionModelPropertyChangeHandler();
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return new TreeSelectionHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return new TreeExpansionHandler();
    }

    protected AbstractLayoutCache createLayoutCache() {
        return new VariableHeightLayoutCache();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected TreeCellEditor createDefaultCellEditor() {
        DefaultTreeCellEditor defaultTreeCellEditor = this.currentCellRenderer != null && this.currentCellRenderer instanceof DefaultTreeCellRenderer ? new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer) : new DefaultTreeCellEditor(this.tree, null);
        return defaultTreeCellEditor;
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler();
    }

    protected void uninstallListeners() {
        this.tree.removePropertyChangeListener(this.propertyChangeListener);
        this.tree.removeFocusListener(this.focusListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.tree.removeMouseListener(this.mouseListener);
        this.tree.removeKeyListener(this.keyListener);
        this.tree.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        this.tree.removeComponentListener(this.componentListener);
        this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        TreeCellEditor treeCellEditor = this.tree.getCellEditor();
        if (treeCellEditor != null) {
            treeCellEditor.removeCellEditorListener(this.cellEditorListener);
        }
        if (this.treeModel != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
    }

    protected void uninstallKeyboardActions() {
        this.tree.getInputMap(1).setParent(null);
        this.tree.getActionMap().setParent(null);
    }

    protected void uninstallComponents() {
        this.currentCellRenderer = null;
        this.rendererPane = null;
        this.createdRenderer = false;
        this.setCellRenderer(this.currentCellRenderer);
    }

    protected int getVerticalLegBuffer() {
        return this.getRowHeight() / 2;
    }

    protected int getHorizontalLegBuffer() {
        return this.rightChildIndent / 2;
    }

    protected void updateLayoutCacheExpandedNodes() {
        if (this.treeModel != null && this.treeModel.getRoot() != null) {
            this.updateExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        }
    }

    protected void updateExpandedDescendants(TreePath treePath) {
        this.completeEditing();
        Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(treePath);
        while (enumeration.hasMoreElements()) {
            this.treeState.setExpandedState(enumeration.nextElement(), true);
        }
    }

    protected TreePath getLastChildPath(TreePath treePath) {
        return (TreePath)treePath.getLastPathComponent();
    }

    protected void updateDepthOffset() {
        this.depthOffset += this.getVerticalLegBuffer();
    }

    protected void updateCellEditor() {
        this.completeEditing();
        TreeCellEditor treeCellEditor = null;
        if (this.tree != null && this.tree.isEditable() && (treeCellEditor = this.tree.getCellEditor()) == null && (treeCellEditor = this.createDefaultCellEditor()) != null) {
            this.tree.setCellEditor(treeCellEditor);
            this.createdCellEditor = true;
        }
        if (treeCellEditor != this.cellEditor) {
            if (this.cellEditor != null && this.cellEditorListener != null) {
                this.cellEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = treeCellEditor;
            if (this.cellEditorListener == null) {
                this.cellEditorListener = this.createCellEditorListener();
            }
            if (this.cellEditor != null && this.cellEditorListener != null) {
                this.cellEditor.addCellEditorListener(this.cellEditorListener);
            }
            this.createdCellEditor = false;
        }
    }

    protected void updateRenderer() {
        if (this.tree != null) {
            TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
            if (treeCellRenderer != null) {
                this.createdRenderer = false;
                this.currentCellRenderer = treeCellRenderer;
                if (this.createdCellEditor) {
                    this.tree.setCellEditor(null);
                }
            } else {
                this.tree.setCellRenderer(this.createDefaultCellRenderer());
                this.createdRenderer = true;
            }
        } else {
            this.currentCellRenderer = null;
            this.createdRenderer = false;
        }
        this.updateCellEditor();
    }

    protected void configureLayoutCache() {
        this.treeState = this.createLayoutCache();
        this.treeState.setNodeDimensions(this.nodeDimensions);
    }

    protected void updateSize() {
        this.preferredSize = null;
        this.updateCachedPreferredSize();
        this.tree.treeDidChange();
    }

    protected void updateCachedPreferredSize() {
        this.validCachedPreferredSize = false;
    }

    protected void pathWasExpanded(TreePath treePath) {
        this.validCachedPreferredSize = false;
        this.treeState.setExpandedState(treePath, true);
        this.tree.repaint();
    }

    protected void pathWasCollapsed(TreePath treePath) {
        this.validCachedPreferredSize = false;
        this.treeState.setExpandedState(treePath, false);
        this.tree.repaint();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tree, "Tree.background", "Tree.foreground", "Tree.font");
        this.hashColor = UIManager.getColor("Tree.hash");
        if (this.hashColor == null) {
            this.hashColor = Color.black;
        }
        this.tree.setOpaque(true);
        this.rightChildIndent = UIManager.getInt("Tree.rightChildIndent");
        this.leftChildIndent = UIManager.getInt("Tree.leftChildIndent");
        this.totalChildIndent = this.rightChildIndent + this.leftChildIndent;
        this.setRowHeight(UIManager.getInt("Tree.rowHeight"));
        this.tree.setRowHeight(this.getRowHeight());
        this.tree.setScrollsOnExpand(UIManager.getBoolean("Tree.scrollsOnExpand"));
        this.setExpandedIcon(UIManager.getIcon("Tree.expandedIcon"));
        this.setCollapsedIcon(UIManager.getIcon("Tree.collapsedIcon"));
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)SharedUIDefaults.get("Tree.focusInputMap");
        SwingUtilities.replaceUIInputMap(this.tree, 0, inputMap);
        InputMap inputMap2 = (InputMap)SharedUIDefaults.get("Tree.ancestorInputMap");
        SwingUtilities.replaceUIInputMap(this.tree, 1, inputMap2);
        SwingUtilities.replaceUIActionMap(this.tree, this.getActionMap());
    }

    private ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("Tree.actionMap");
        if (actionMap == null) {
            actionMap = this.createDefaultActions();
            UIManager.getLookAndFeelDefaults().put("Tree.actionMap", actionMap);
        }
        return actionMap;
    }

    private ActionMap createDefaultActions() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        AbstractAction abstractAction = new TreeHomeAction(-1, "selectFirst");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeHomeAction(-1, "selectFirstChangeLead");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeHomeAction(-1, "selectFirstExtendSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeHomeAction(1, "selectLast");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeHomeAction(1, "selectLastChangeLead");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeHomeAction(1, "selectLastExtendSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeIncrementAction(-1, "selectPrevious");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeIncrementAction(-1, "selectPreviousExtendSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeIncrementAction(-1, "selectPreviousChangeLead");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeIncrementAction(1, "selectNext");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeIncrementAction(1, "selectNextExtendSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeIncrementAction(1, "selectNextChangeLead");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeTraverseAction(-1, "selectParent");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeTraverseAction(1, "selectChild");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeToggleAction("toggleAndAnchor");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreePageAction(-1, "scrollUpChangeSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreePageAction(-1, "scrollUpExtendSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreePageAction(-1, "scrollUpChangeLead");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreePageAction(1, "scrollDownChangeSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreePageAction(1, "scrollDownExtendSelection");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreePageAction(1, "scrollDownChangeLead");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeStartEditingAction("startEditing");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        abstractAction = new TreeCancelEditingAction("cancel");
        actionMapUIResource.put(abstractAction.getValue("Name"), abstractAction);
        return actionMapUIResource;
    }

    private int convertModifiers(int n) {
        if ((n & 0x40) != 0) {
            n |= 1;
            n &= 0xFFFFFFBF;
        }
        if ((n & 0x80) != 0) {
            n |= 2;
            n &= 0xFFFFFF7F;
        }
        if ((n & 0x100) != 0) {
            n |= 4;
            n &= 0xFFFFFEFF;
        }
        if ((n & 0x200) != 0) {
            n |= 8;
            n &= 0xFFFFFDFF;
        }
        if ((n & 0x2000) != 0) {
            n |= 0x20;
            n &= 0xFFFFDFFF;
        }
        return n;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.tree.addPropertyChangeListener(this.propertyChangeListener);
        this.focusListener = this.createFocusListener();
        this.tree.addFocusListener(this.focusListener);
        this.treeSelectionListener = this.createTreeSelectionListener();
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.mouseListener = this.createMouseListener();
        this.tree.addMouseListener(this.mouseListener);
        this.keyListener = this.createKeyListener();
        this.tree.addKeyListener(this.keyListener);
        this.selectionModelPropertyChangeListener = this.createSelectionModelPropertyChangeListener();
        if (this.treeSelectionModel != null && this.selectionModelPropertyChangeListener != null) {
            this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        this.componentListener = this.createComponentListener();
        this.tree.addComponentListener(this.componentListener);
        this.treeExpansionListener = this.createTreeExpansionListener();
        this.tree.addTreeExpansionListener(this.treeExpansionListener);
        this.treeModelListener = this.createTreeModelListener();
        if (this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        this.cellEditorListener = this.createCellEditorListener();
    }

    public void installUI(JComponent jComponent) {
        this.tree = (JTree)jComponent;
        this.prepareForUIInstall();
        this.installDefaults();
        this.installComponents();
        this.installKeyboardActions();
        this.installListeners();
        this.completeUIInstall();
    }

    protected void uninstallDefaults() {
        this.tree.setFont(null);
        this.tree.setForeground(null);
        this.tree.setBackground(null);
    }

    public void uninstallUI(JComponent jComponent) {
        this.completeEditing();
        this.prepareForUIUninstall();
        this.uninstallDefaults();
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JTree jTree = (JTree)jComponent;
        int n = this.treeState.getRowCount();
        if (n == 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = jTree.getInsets();
        if (rectangle != null && this.treeModel != null) {
            Object object;
            int n2;
            int n3 = jTree.getClosestRowForLocation(rectangle.x, rectangle.y);
            int n4 = jTree.getClosestRowForLocation(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            if (n4 < n) {
                for (n2 = n4 + 1; n2 < n; ++n2) {
                    object = this.treeState.getPathForRow(n2);
                    if (!this.isLastChild((TreePath)object)) continue;
                    this.paintVerticalPartOfLeg(graphics, rectangle, insets, (TreePath)object);
                }
            }
            n2 = n4 - n3 + 1;
            object = new Rectangle[n2];
            boolean[] blArray = new boolean[n2];
            boolean[] blArray2 = new boolean[n2];
            TreePath[] treePathArray = new TreePath[n2];
            int n5 = 0;
            int n6 = n3;
            while (n6 <= n4) {
                treePathArray[n5] = this.treeState.getPathForRow(n6);
                if (treePathArray[n5] != null) {
                    blArray[n5] = this.treeModel.isLeaf(treePathArray[n5].getLastPathComponent());
                    blArray2[n5] = jTree.isExpanded(treePathArray[n5]);
                    object[n5] = this.getPathBounds(jTree, treePathArray[n5]);
                    this.paintHorizontalPartOfLeg(graphics, rectangle, insets, object[n5], treePathArray[n5], n6, blArray2[n5], false, blArray[n5]);
                }
                if (this.isLastChild(treePathArray[n5])) {
                    this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePathArray[n5]);
                }
                ++n6;
                ++n5;
            }
            n5 = 0;
            n6 = n3;
            while (n6 <= n4) {
                if (treePathArray[n5] != null) {
                    this.paintRow(graphics, rectangle, insets, object[n5], treePathArray[n5], n6, blArray2[n5], false, blArray[n5]);
                }
                ++n6;
                ++n5;
            }
        }
    }

    private boolean isLastChild(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        if (treePath instanceof GnuPath) {
            return ((GnuPath)treePath).isLastChild;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return false;
        }
        int n = this.treeState.getVisibleChildCount(treePath2);
        int n2 = this.treeModel.getIndexOfChild(treePath2, treePath.getLastPathComponent());
        return n2 == n - 1;
    }

    protected void ensureRowsAreVisible(int n, int n2) {
        int n3;
        if (n < n2) {
            n3 = n2;
            n2 = n;
            n = n3;
        }
        for (n3 = n; n3 < n2; ++n3) {
            TreePath treePath = this.getPathForRow(this.tree, n3);
            if (this.tree.isVisible(treePath)) continue;
            this.tree.makeVisible(treePath);
        }
    }

    public void setPreferredMinSize(Dimension dimension) {
        this.preferredMinSize = dimension;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return this.getPreferredSize(this.tree);
        }
        return this.preferredMinSize;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent, false);
    }

    public Dimension getPreferredSize(JComponent jComponent, boolean bl) {
        if (!this.validCachedPreferredSize) {
            Rectangle rectangle = this.tree.getBounds();
            this.preferredSize = new Dimension(this.treeState.getPreferredWidth(rectangle), this.treeState.getPreferredHeight());
            this.validCachedPreferredSize = true;
        }
        return this.preferredSize;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        this.preferredMinSize = this.getPreferredSize(jComponent);
        return this.preferredMinSize;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected void completeEditing() {
        if (this.tree.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Object object;
            Component component = this.editingComponent;
            TreePath treePath = this.editingPath;
            this.editingComponent = null;
            this.editingPath = null;
            if (bl) {
                this.cellEditor.stopCellEditing();
            } else if (bl2) {
                this.cellEditor.cancelCellEditing();
            }
            this.tree.remove(component);
            if (this.editorHasDifferentSize) {
                this.treeState.invalidatePathBounds(treePath);
                this.updateSize();
            } else {
                object = this.getPathBounds(this.tree, treePath);
                this.tree.repaint(0, ((Rectangle)object).y, this.tree.getWidth(), ((Rectangle)object).height);
            }
            if (bl3) {
                object = this.cellEditor.getCellEditorValue();
                this.treeModel.valueForPathChanged(treePath, object);
            }
        }
    }

    protected boolean startEditing(TreePath treePath, MouseEvent mouseEvent) {
        if (this.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.stopEditing(this.tree)) {
            return false;
        }
        this.completeEditing();
        TreeCellEditor treeCellEditor = this.cellEditor;
        if (treeCellEditor != null && this.tree.isPathEditable(treePath)) {
            if (treeCellEditor.isCellEditable(mouseEvent)) {
                this.editingRow = this.getRowForPath(this.tree, treePath);
                Object object = treePath.getLastPathComponent();
                boolean bl = this.tree.isPathSelected(treePath);
                boolean bl2 = this.tree.isExpanded(this.editingPath);
                boolean bl3 = this.treeModel.isLeaf(object);
                this.editingComponent = treeCellEditor.getTreeCellEditorComponent(this.tree, object, bl, bl2, bl3, this.editingRow);
                Rectangle rectangle = this.getPathBounds(this.tree, treePath);
                Dimension dimension = this.editingComponent.getPreferredSize();
                int n = this.getRowHeight();
                if (dimension.height != rectangle.height && n > 0) {
                    dimension.height = n;
                }
                if (dimension.width != rectangle.width || dimension.height != rectangle.height) {
                    this.editorHasDifferentSize = true;
                    this.treeState.invalidatePathBounds(treePath);
                    this.updateSize();
                } else {
                    this.editorHasDifferentSize = false;
                }
                this.tree.add(this.editingComponent);
                this.editingComponent.setBounds(rectangle.x, rectangle.y, dimension.width, dimension.height);
                this.editingComponent.validate();
                this.editingPath = treePath;
                if (treeCellEditor.shouldSelectCell(mouseEvent)) {
                    this.stopEditingInCompleteEditing = false;
                    this.tree.setSelectionRow(this.editingRow);
                    this.stopEditingInCompleteEditing = true;
                }
                this.editorRequestFocus(this.editingComponent);
                if (mouseEvent instanceof MouseEvent) {
                    Point point = SwingUtilities.convertPoint(this.tree, mouseEvent.getX(), mouseEvent.getY(), this.editingComponent);
                    Component component = SwingUtilities.getDeepestComponentAt(this.editingComponent, point.x, point.y);
                    if (component != null) {
                        MouseInputHandler mouseInputHandler = new MouseInputHandler(this.tree, component, mouseEvent);
                    }
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    private void editorRequestFocus(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            if (container.getComponentCount() > 0) {
                container.getComponent(0).requestFocus();
            }
        } else if (component.isFocusable()) {
            component.requestFocus();
        }
    }

    protected void checkForClickInExpandControl(TreePath treePath, int n, int n2) {
        if (this.isLocationInExpandControl(treePath, n, n2)) {
            this.handleExpandControlClick(treePath, n, n2);
        }
    }

    protected boolean isLocationInExpandControl(TreePath treePath, int n, int n2) {
        boolean bl = false;
        if (!this.treeModel.isLeaf(treePath.getLastPathComponent())) {
            Icon icon = this.getExpandedIcon();
            int n3 = icon != null ? icon.getIconWidth() : 18;
            Insets insets = this.tree.getInsets();
            int n4 = this.isRootVisible() ? treePath.getPathCount() - 1 : treePath.getPathCount() - 2;
            int n5 = this.getRowX(this.tree.getRowForPath(treePath), n4) - n3 + insets.left;
            bl = n >= n5 && n <= n5 + n3;
        }
        return bl;
    }

    protected void handleExpandControlClick(TreePath treePath, int n, int n2) {
        this.toggleExpandState(treePath);
    }

    protected void toggleExpandState(TreePath treePath) {
        if (this.treeState.isExpanded(treePath)) {
            this.tree.collapsePath(treePath);
        } else {
            this.tree.expandPath(treePath);
        }
    }

    protected boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return this.tree.getSelectionModel().getSelectionMode() != 1 && (mouseEvent.getModifiersEx() & 0x80) != 0;
    }

    protected boolean isMultiSelectEvent(MouseEvent mouseEvent) {
        return this.tree.getSelectionModel().getSelectionMode() != 1 && (mouseEvent.getModifiersEx() & 0x40) != 0;
    }

    protected boolean isToggleEvent(MouseEvent mouseEvent) {
        int n;
        boolean bl = false;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && (n = this.tree.getToggleClickCount()) > 0 && mouseEvent.getClickCount() == n) {
            bl = true;
        }
        return bl;
    }

    protected void selectPathForEvent(TreePath treePath, MouseEvent mouseEvent) {
        if (this.isToggleSelectionEvent(mouseEvent)) {
            if (this.tree.isPathSelected(treePath)) {
                this.tree.removeSelectionPath(treePath);
            } else {
                this.tree.addSelectionPath(treePath);
                this.tree.setAnchorSelectionPath(treePath);
            }
        } else if (this.isMultiSelectEvent(mouseEvent)) {
            TreePath treePath2 = this.tree.getAnchorSelectionPath();
            if (treePath2 != null) {
                int n = this.getRowForPath(this.tree, treePath2);
                this.tree.addSelectionInterval(n, this.getRowForPath(this.tree, treePath));
            } else {
                this.tree.addSelectionPath(treePath);
            }
        } else {
            this.tree.setSelectionPath(treePath);
            if (this.isToggleEvent(mouseEvent)) {
                this.toggleExpandState(treePath);
            }
        }
    }

    protected boolean isLeaf(int n) {
        TreePath treePath = this.getPathForRow(this.tree, n);
        if (treePath == null) {
            return true;
        }
        Object object = treePath.getLastPathComponent();
        return this.treeModel.isLeaf(object);
    }

    boolean hasControlIcons() {
        return this.expandedIcon != null || this.collapsedIcon != null;
    }

    Icon getCurrentControlIcon(TreePath treePath) {
        if (this.hasControlIcons()) {
            if (this.tree.isExpanded(treePath)) {
                return this.expandedIcon;
            }
            return this.collapsedIcon;
        }
        if (nullIcon == null) {
            nullIcon = new Icon(){

                public int getIconHeight() {
                    return 0;
                }

                public int getIconWidth() {
                    return 0;
                }

                public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                }
            };
        }
        return nullIcon;
    }

    Object getParent(Object object, Object object2) {
        if (object == null || object2 == null || object.equals(object2)) {
            return null;
        }
        if (object2 instanceof TreeNode) {
            return ((TreeNode)object2).getParent();
        }
        return this.findNode(object, object2);
    }

    private Object findNode(Object object, Object object2) {
        if (!this.treeModel.isLeaf(object) && !object.equals(object2)) {
            int n = this.treeModel.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object3 = this.treeModel.getChild(object, i);
                if (object2.equals(object3)) {
                    return object;
                }
                Object object4 = this.findNode(object3, object2);
                if (object4 == null) continue;
                return object4;
            }
        }
        return null;
    }

    void selectPath(JTree jTree, TreePath treePath) {
        if (treePath != null) {
            jTree.setSelectionPath(treePath);
            jTree.setLeadSelectionPath(treePath);
            jTree.makeVisible(treePath);
            jTree.scrollPathToVisible(treePath);
        }
    }

    Object[] getPathToRoot(Object object, int n) {
        if (object == null) {
            if (n == 0) {
                return null;
            }
            return new Object[n];
        }
        Object[] objectArray = this.getPathToRoot(this.getParent(this.treeModel.getRoot(), object), n + 1);
        objectArray[objectArray.length - n - 1] = object;
        return objectArray;
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        graphics.drawLine(n, n2, n, n3);
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        graphics.drawLine(n2, n, n3, n);
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        n2 -= icon.getIconHeight() / 2;
        if ((n -= icon.getIconWidth() / 2) < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        icon.paintIcon(component, graphics, n, n2);
    }

    protected void drawDashedHorizontalLine(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        for (int i = n2; i < n3; i += 2) {
            graphics.drawLine(i, n, i + 1, n);
        }
    }

    protected void drawDashedVerticalLine(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        for (int i = n2; i < n3; i += 2) {
            graphics.drawLine(n, i, n, i + 1);
        }
    }

    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.shouldPaintExpandControl(treePath, n, bl, bl2, bl3)) {
            Icon icon = this.getCurrentControlIcon(treePath);
            int n2 = icon.getIconWidth();
            int n3 = rectangle2.x - n2 - this.gap;
            icon.paintIcon(this.tree, graphics, n3, rectangle2.y + rectangle2.height / 2 - icon.getIconHeight() / 2);
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (n != 0) {
            this.paintHorizontalLine(graphics, this.tree, rectangle2.y + rectangle2.height / 2, rectangle2.x - this.leftChildIndent - this.gap, rectangle2.x - this.gap);
        }
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        boolean bl;
        Rectangle rectangle2 = this.getPathBounds(this.tree, treePath);
        TreePath treePath2 = treePath.getParentPath();
        if (this.isRootVisible()) {
            bl = treePath2 != null;
        } else {
            boolean bl2 = bl = treePath2 != null && treePath2.getPathCount() > 1;
        }
        if (bl) {
            Rectangle rectangle3 = this.getPathBounds(this.tree, treePath2);
            this.paintVerticalLine(graphics, this.tree, rectangle3.x + 2 * this.gap, rectangle3.y + rectangle3.height / 2, rectangle2.y + rectangle2.height / 2);
        }
    }

    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.tree.isPathSelected(treePath);
        boolean bl5 = false;
        Object object = treePath.getLastPathComponent();
        this.paintExpandControl(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
        TreeCellRenderer treeCellRenderer = this.currentCellRenderer;
        boolean bl6 = false;
        if (this.treeSelectionModel != null) {
            bl6 = this.treeSelectionModel.getLeadSelectionRow() == n && this.tree.isFocusOwner();
        }
        Component component = treeCellRenderer.getTreeCellRendererComponent(this.tree, object, bl4, bl, bl3, n, bl6);
        this.rendererPane.paintComponent(graphics, component, component.getParent(), rectangle2);
    }

    protected void prepareForUIUninstall() {
    }

    protected boolean shouldPaintExpandControl(TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        Object object = treePath.getLastPathComponent();
        return !bl3 && this.hasControlIcons();
    }

    protected int getRowX(int n, int n2) {
        return n2 * this.totalChildIndent;
    }

    public class TreeTraverseAction
    extends AbstractAction {
        protected int direction;

        public TreeTraverseAction(int n, String string) {
            this.direction = n;
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = BasicTreeUI.this.tree.getLeadSelectionPath();
            if (treePath == null) {
                return;
            }
            String string = (String)this.getValue("Name");
            if (string.equals("selectParent")) {
                if (treePath == null) {
                    return;
                }
                if (BasicTreeUI.this.tree.isExpanded(treePath)) {
                    BasicTreeUI.this.tree.collapsePath(treePath);
                } else {
                    TreePath treePath2 = treePath.getParentPath();
                    if (treePath2 != null && (treePath2.getPathCount() != 1 || BasicTreeUI.this.tree.isRootVisible())) {
                        BasicTreeUI.this.tree.setSelectionPath(treePath2);
                    }
                }
            } else if (string.equals("selectChild")) {
                Object object = treePath.getLastPathComponent();
                int n = BasicTreeUI.this.treeModel.getChildCount(object);
                if (n == 0 || BasicTreeUI.this.treeState.isExpanded(treePath)) {
                    int n2 = BasicTreeUI.this.tree.getLeadSelectionRow() + 1;
                    if (n2 <= BasicTreeUI.this.tree.getRowCount()) {
                        BasicTreeUI.this.tree.setSelectionRow(n2);
                    }
                } else {
                    BasicTreeUI.this.tree.expandPath(treePath);
                }
            }
            BasicTreeUI.this.tree.scrollPathToVisible(BasicTreeUI.this.tree.getLeadSelectionPath());
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeToggleAction
    extends AbstractAction {
        public TreeToggleAction(String string) {
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = BasicTreeUI.this.tree.getLeadSelectionRow();
            if (n != -1 && BasicTreeUI.this.isLeaf(n)) {
                TreePath treePath = BasicTreeUI.this.tree.getAnchorSelectionPath();
                TreePath treePath2 = BasicTreeUI.this.tree.getLeadSelectionPath();
                BasicTreeUI.this.toggleExpandState(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n));
                BasicTreeUI.this.tree.setLeadSelectionPath(treePath2);
                BasicTreeUI.this.tree.setAnchorSelectionPath(treePath);
                BasicTreeUI.this.tree.scrollPathToVisible(BasicTreeUI.this.tree.getLeadSelectionPath());
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            BasicTreeUI.this.completeEditing();
            TreePath treePath = treeSelectionEvent.getOldLeadSelectionPath();
            TreePath treePath2 = treeSelectionEvent.getNewLeadSelectionPath();
            if (treePath != treePath2) {
                Rectangle rectangle = BasicTreeUI.this.treeState.getBounds(treeSelectionEvent.getOldLeadSelectionPath(), new Rectangle());
                Rectangle rectangle2 = BasicTreeUI.this.treeState.getBounds(treeSelectionEvent.getNewLeadSelectionPath(), new Rectangle());
                if (rectangle != null) {
                    BasicTreeUI.this.tree.repaint(rectangle);
                }
                if (rectangle2 != null) {
                    BasicTreeUI.this.tree.repaint(rectangle2);
                }
            }
        }
    }

    public class TreePageAction
    extends AbstractAction {
        protected int direction;

        public TreePageAction(int n, String string) {
            this.direction = n;
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            boolean bl;
            String string = (String)this.getValue("Name");
            boolean bl2 = string.equals("scrollUpExtendSelection") || string.equals("scrollDownExtendSelection");
            boolean bl3 = bl = string.equals("scrollUpChangeSelection") || string.equals("scrollDownChangeSelection");
            if (!bl2 && !bl && BasicTreeUI.this.tree.getSelectionModel().getSelectionMode() != 4) {
                bl = true;
            }
            if ((n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree)) > 0 && BasicTreeUI.this.treeSelectionModel != null) {
                Dimension dimension = BasicTreeUI.this.tree.getSize();
                TreePath treePath = BasicTreeUI.this.tree.getLeadSelectionPath();
                TreePath treePath2 = null;
                Rectangle rectangle = BasicTreeUI.this.tree.getVisibleRect();
                if (this.direction == -1) {
                    treePath2 = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, rectangle.x, rectangle.y);
                    if (treePath2.equals(treePath)) {
                        rectangle.y = Math.max(0, rectangle.y - rectangle.height);
                        treePath2 = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, rectangle.x, rectangle.y);
                    }
                } else {
                    rectangle.y = Math.min(dimension.height, rectangle.y + rectangle.height - 1);
                    treePath2 = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, rectangle.x, rectangle.y);
                    if (treePath2.equals(treePath)) {
                        rectangle.y = Math.min(dimension.height, rectangle.y + rectangle.height - 1);
                        treePath2 = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, rectangle.x, rectangle.y);
                    }
                }
                Rectangle rectangle2 = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath2);
                rectangle2.x = rectangle.x;
                rectangle2.width = rectangle.width;
                if (this.direction == -1) {
                    rectangle2.height = rectangle.height;
                } else {
                    rectangle2.y -= rectangle.height - rectangle2.height;
                    rectangle2.height = rectangle.height;
                }
                if (bl2) {
                    TreePath treePath3 = BasicTreeUI.this.tree.getAnchorSelectionPath();
                    if (treePath3 == null) {
                        BasicTreeUI.this.tree.setSelectionPath(treePath2);
                    } else {
                        int n2 = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath2);
                        int n3 = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath3);
                        BasicTreeUI.this.tree.setSelectionInterval(Math.min(n3, n2), Math.max(n3, n2));
                        BasicTreeUI.this.tree.setAnchorSelectionPath(treePath3);
                        BasicTreeUI.this.tree.setLeadSelectionPath(treePath2);
                    }
                } else if (bl) {
                    BasicTreeUI.this.tree.setSelectionPath(treePath2);
                } else {
                    BasicTreeUI.this.tree.setLeadSelectionPath(treePath2);
                }
                BasicTreeUI.this.tree.scrollRectToVisible(rectangle2);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeModelHandler
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.treeState.treeNodesChanged(treeModelEvent);
            BasicTreeUI.this.tree.repaint();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.treeState.treeNodesInserted(treeModelEvent);
            BasicTreeUI.this.tree.repaint();
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.treeState.treeNodesRemoved(treeModelEvent);
            BasicTreeUI.this.tree.repaint();
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getPath().length == 1 && !treeModelEvent.getPath()[0].equals(BasicTreeUI.this.treeModel.getRoot())) {
                BasicTreeUI.this.tree.expandPath(new TreePath(BasicTreeUI.this.treeModel.getRoot()));
            }
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.treeState.treeStructureChanged(treeModelEvent);
            BasicTreeUI.this.tree.repaint();
        }
    }

    public class TreeIncrementAction
    extends AbstractAction {
        protected int direction;

        public TreeIncrementAction(int n, String string) {
            this.direction = n;
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = BasicTreeUI.this.tree.getLeadSelectionPath();
            int n = treePath != null ? BasicTreeUI.this.treeState.getRowForPath(treePath) : 0;
            int n2 = BasicTreeUI.this.treeState.getRowCount();
            int n3 = n + 1;
            int n4 = n - 1;
            boolean bl = n3 < n2;
            boolean bl2 = n4 >= 0 && n2 > 0;
            String string = (String)this.getValue("Name");
            if (string.equals("selectPreviousChangeLead") && bl2) {
                TreePath treePath2 = BasicTreeUI.this.treeState.getPathForRow(n4);
                BasicTreeUI.this.tree.setSelectionPath(treePath2);
                BasicTreeUI.this.tree.setAnchorSelectionPath(treePath2);
                BasicTreeUI.this.tree.setLeadSelectionPath(treePath2);
            } else if (string.equals("selectPreviousExtendSelection") && bl2) {
                TreePath treePath3 = BasicTreeUI.this.treeState.getPathForRow(n4);
                if (BasicTreeUI.this.tree.isPathSelected(treePath3)) {
                    BasicTreeUI.this.tree.getSelectionModel().removeSelectionPath(treePath);
                }
                BasicTreeUI.this.tree.addSelectionPath(treePath3);
                BasicTreeUI.this.tree.setLeadSelectionPath(treePath3);
            } else if (string.equals("selectPrevious") && bl2) {
                TreePath treePath4 = BasicTreeUI.this.treeState.getPathForRow(n4);
                BasicTreeUI.this.tree.setSelectionPath(treePath4);
            } else if (string.equals("selectNext") && bl) {
                TreePath treePath5 = BasicTreeUI.this.treeState.getPathForRow(n3);
                BasicTreeUI.this.tree.setSelectionPath(treePath5);
            } else if (string.equals("selectNextExtendSelection") && bl) {
                TreePath treePath6 = BasicTreeUI.this.treeState.getPathForRow(n3);
                if (BasicTreeUI.this.tree.isPathSelected(treePath6)) {
                    BasicTreeUI.this.tree.getSelectionModel().removeSelectionPath(treePath);
                }
                BasicTreeUI.this.tree.addSelectionPath(treePath6);
                BasicTreeUI.this.tree.setLeadSelectionPath(treePath6);
            } else if (string.equals("selectNextChangeLead") && bl) {
                TreePath treePath7 = BasicTreeUI.this.treeState.getPathForRow(n3);
                BasicTreeUI.this.tree.setSelectionPath(treePath7);
                BasicTreeUI.this.tree.setAnchorSelectionPath(treePath7);
                BasicTreeUI.this.tree.setLeadSelectionPath(treePath7);
            }
            BasicTreeUI.this.tree.scrollPathToVisible(BasicTreeUI.this.tree.getLeadSelectionPath());
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeHomeAction
    extends AbstractAction {
        protected int direction;

        public TreeHomeAction(int n, String string) {
            this.direction = n;
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                String string = (String)this.getValue("Name");
                if (string.equals("selectFirst")) {
                    BasicTreeUI.this.ensureRowsAreVisible(0, 0);
                    BasicTreeUI.this.tree.setSelectionInterval(0, 0);
                }
                if (string.equals("selectFirstChangeLead")) {
                    BasicTreeUI.this.ensureRowsAreVisible(0, 0);
                    BasicTreeUI.this.tree.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, 0));
                }
                if (string.equals("selectFirstExtendSelection")) {
                    BasicTreeUI.this.ensureRowsAreVisible(0, 0);
                    TreePath treePath = BasicTreeUI.this.tree.getAnchorSelectionPath();
                    if (treePath == null) {
                        BasicTreeUI.this.tree.setSelectionInterval(0, 0);
                    } else {
                        int n = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath);
                        BasicTreeUI.this.tree.setSelectionInterval(0, n);
                        BasicTreeUI.this.tree.setAnchorSelectionPath(treePath);
                        BasicTreeUI.this.tree.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, 0));
                    }
                } else if (string.equals("selectLast")) {
                    int n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree) - 1;
                    BasicTreeUI.this.ensureRowsAreVisible(n, n);
                    BasicTreeUI.this.tree.setSelectionInterval(n, n);
                } else if (string.equals("selectLastChangeLead")) {
                    int n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree) - 1;
                    BasicTreeUI.this.ensureRowsAreVisible(n, n);
                    BasicTreeUI.this.tree.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n));
                } else if (string.equals("selectLastExtendSelection")) {
                    int n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree) - 1;
                    BasicTreeUI.this.ensureRowsAreVisible(n, n);
                    TreePath treePath = BasicTreeUI.this.tree.getAnchorSelectionPath();
                    if (treePath == null) {
                        BasicTreeUI.this.tree.setSelectionInterval(n, n);
                    } else {
                        int n2 = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath);
                        BasicTreeUI.this.tree.setSelectionInterval(n, n2);
                        BasicTreeUI.this.tree.setAnchorSelectionPath(treePath);
                        BasicTreeUI.this.tree.setLeadSelectionPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n));
                    }
                }
            }
            BasicTreeUI.this.tree.scrollPathToVisible(BasicTreeUI.this.tree.getLeadSelectionPath());
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeExpansionHandler
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.treeState.setExpandedState(treeExpansionEvent.getPath(), true);
            BasicTreeUI.this.maxHeight = 0;
            BasicTreeUI.this.tree.revalidate();
            BasicTreeUI.this.tree.repaint();
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            BasicTreeUI.this.completeEditing();
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.treeState.setExpandedState(treeExpansionEvent.getPath(), false);
            BasicTreeUI.this.maxHeight = 0;
            BasicTreeUI.this.tree.revalidate();
            BasicTreeUI.this.tree.repaint();
        }
    }

    public class TreeCancelEditingAction
    extends AbstractAction {
        public TreeCancelEditingAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isEnabled() && BasicTreeUI.this.tree.isEditing()) {
                BasicTreeUI.this.tree.cancelEditing();
            }
        }
    }

    public class SelectionModelPropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicTreeUI.this.treeSelectionModel.resetRowSelection();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("rootVisible")) {
                BasicTreeUI.this.validCachedPreferredSize = false;
                BasicTreeUI.this.treeState.setRootVisible(BasicTreeUI.this.tree.isRootVisible());
                BasicTreeUI.this.tree.repaint();
            } else if (string.equals("selectionModel")) {
                BasicTreeUI.this.treeSelectionModel = BasicTreeUI.this.tree.getSelectionModel();
                BasicTreeUI.this.treeSelectionModel.setRowMapper(BasicTreeUI.this.treeState);
            } else if (string.equals("model")) {
                BasicTreeUI.this.setModel(BasicTreeUI.this.tree.getModel());
            } else if (string.equals("cellRenderer")) {
                BasicTreeUI.this.setCellRenderer(BasicTreeUI.this.tree.getCellRenderer());
                if (BasicTreeUI.this.treeState != null) {
                    BasicTreeUI.this.treeState.invalidateSizes();
                }
            } else if (string.equals("editable")) {
                BasicTreeUI.this.setEditable((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    public class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        public Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            Dimension dimension;
            if (BasicTreeUI.this.editingComponent != null && BasicTreeUI.this.editingRow == n) {
                dimension = BasicTreeUI.this.editingComponent.getPreferredSize();
                int n3 = BasicTreeUI.this.getRowHeight();
                if (n3 > 0 && n3 != dimension.height) {
                    dimension.height = n3;
                }
            } else {
                Component component = BasicTreeUI.this.currentCellRenderer.getTreeCellRendererComponent(BasicTreeUI.this.tree, object, BasicTreeUI.this.tree.isRowSelected(n), bl, BasicTreeUI.this.treeModel.isLeaf(object), n, false);
                BasicTreeUI.this.rendererPane.add(component);
                component.validate();
                dimension = component.getPreferredSize();
            }
            if (rectangle != null) {
                rectangle.x = this.getRowX(n, n2);
                rectangle.y = dimension.height * n;
                rectangle.width = dimension.width;
                rectangle.height = dimension.height;
            } else {
                rectangle = new Rectangle(this.getRowX(n, n2), dimension.height * n, dimension.width, dimension.height);
            }
            return rectangle;
        }

        protected int getRowX(int n, int n2) {
            return BasicTreeUI.this.getRowX(n, n2);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public MouseInputHandler(Component component, Component component2, MouseEvent mouseEvent) {
            this.source = component;
            this.destination = component2;
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            this.dispatch(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.dispatch(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.dispatch(mouseEvent);
            this.removeFromSource();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.dispatch(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
            }
            this.source = null;
            this.destination = null;
        }

        private void dispatch(MouseEvent mouseEvent) {
            if (this.destination != null) {
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination);
                this.destination.dispatchEvent(mouseEvent2);
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean selectedOnPress;

        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.handleEvent(mouseEvent);
                this.selectedOnPress = true;
            } else {
                this.selectedOnPress = false;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && !this.selectedOnPress) {
                this.handleEvent(mouseEvent);
            }
        }

        private void handleEvent(MouseEvent mouseEvent) {
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled()) {
                if (BasicTreeUI.this.isEditing(BasicTreeUI.this.tree) && BasicTreeUI.this.tree.getInvokesStopCellEditing() && !BasicTreeUI.this.stopEditing(BasicTreeUI.this.tree)) {
                    return;
                }
                BasicTreeUI.this.tree.requestFocusInWindow();
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                TreePath treePath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, n, n2);
                if (treePath != null) {
                    Rectangle rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath);
                    if (n2 <= rectangle.y + rectangle.height) {
                        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                            BasicTreeUI.this.checkForClickInExpandControl(treePath, n, n2);
                        }
                        if (n > rectangle.x && n <= rectangle.x + rectangle.width && !BasicTreeUI.this.startEditing(treePath, mouseEvent)) {
                            BasicTreeUI.this.selectPathForEvent(treePath, mouseEvent);
                        }
                    }
                }
            }
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        public void keyTyped(KeyEvent keyEvent) {
            int n;
            char c = Character.toLowerCase(keyEvent.getKeyChar());
            for (n = BasicTreeUI.this.tree.getLeadSelectionRow() + 1; n < BasicTreeUI.this.tree.getRowCount(); ++n) {
                if (!this.checkMatch(n, c)) continue;
                BasicTreeUI.this.tree.setSelectionRow(n);
                BasicTreeUI.this.tree.scrollRowToVisible(n);
                return;
            }
            for (n = 0; n < BasicTreeUI.this.tree.getLeadSelectionRow(); ++n) {
                if (!this.checkMatch(n, c)) continue;
                BasicTreeUI.this.tree.setSelectionRow(n);
                BasicTreeUI.this.tree.scrollRowToVisible(n);
                return;
            }
        }

        boolean checkMatch(int n, char c) {
            char c2;
            TreePath treePath = BasicTreeUI.this.treeState.getPathForRow(n);
            String string = treePath.getLastPathComponent().toString();
            return string.length() > 0 && c == Character.toLowerCase(c2 = string.charAt(0));
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            this.repaintLeadRow();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintLeadRow();
        }

        void repaintLeadRow() {
            TreePath treePath = BasicTreeUI.this.tree.getLeadSelectionPath();
            if (treePath != null) {
                BasicTreeUI.this.tree.repaint(BasicTreeUI.this.tree.getPathBounds(treePath));
            }
        }
    }

    public class CellEditorHandler
    implements CellEditorListener {
        public void editingStopped(ChangeEvent changeEvent) {
            BasicTreeUI.this.completeEditing(false, false, true);
        }

        public void editingCanceled(ChangeEvent changeEvent) {
            BasicTreeUI.this.completeEditing(false, false, false);
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        public void componentMoved(ComponentEvent componentEvent) {
            if (this.timer == null) {
                JScrollPane jScrollPane = this.getScrollPane();
                if (jScrollPane == null) {
                    BasicTreeUI.this.updateSize();
                } else {
                    this.scrollBar = jScrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = jScrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            BasicTreeUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            Container container;
            JScrollPane jScrollPane = null;
            for (container = BasicTreeUI.this.tree.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
            }
            if (container instanceof JScrollPane) {
                jScrollPane = (JScrollPane)container;
            }
            return jScrollPane;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                BasicTreeUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }

    class TreeStartEditingAction
    extends AbstractAction {
        public TreeStartEditingAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = BasicTreeUI.this.tree.getLeadSelectionPath();
            if (!BasicTreeUI.this.tree.isEditing()) {
                BasicTreeUI.this.tree.startEditingAtPath(treePath);
            }
        }
    }
}

