/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicToolTipUI
extends ToolTipUI {
    private static BasicToolTipUI shared;
    private String text;
    private PropertyChangeListener propertyChangeHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        if (shared == null) {
            shared = new BasicToolTipUI();
        }
        return shared;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JToolTip jToolTip = (JToolTip)jComponent;
        String string = jToolTip.getTipText();
        FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                dimension.width += (int)view.getPreferredSpan(0);
                dimension.height += (int)view.getPreferredSpan(1);
            } else {
                dimension.width += fontMetrics.stringWidth(string) + 6;
                dimension.height += fontMetrics.getHeight();
            }
        }
        return dimension;
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(jComponent, "ToolTip.border");
    }

    protected void installListeners(JComponent jComponent) {
        this.propertyChangeHandler = new PropertyChangeHandler();
        jComponent.addPropertyChangeListener(this.propertyChangeHandler);
    }

    public void installUI(JComponent jComponent) {
        jComponent.setOpaque(true);
        this.installDefaults(jComponent);
        BasicHTML.updateRenderer(jComponent, ((JToolTip)jComponent).getTipText());
        this.installListeners(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JToolTip jToolTip = (JToolTip)jComponent;
        String string = jToolTip.getTipText();
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = jComponent.getFontMetrics(font);
        int n = fontMetrics.getAscent();
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        Color color = graphics.getColor();
        Font font2 = graphics.getFont();
        graphics.setColor(Color.BLACK);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            graphics.drawString(string, rectangle.x + 3, rectangle.y + n);
        }
        graphics.setFont(font2);
        graphics.setColor(color);
    }

    protected void uninstallDefaults(JComponent jComponent) {
        jComponent.setForeground(null);
        jComponent.setBackground(null);
        jComponent.setFont(null);
        jComponent.setBorder(null);
    }

    protected void uninstallListeners(JComponent jComponent) {
        if (this.propertyChangeHandler != null) {
            jComponent.removePropertyChangeListener(this.propertyChangeHandler);
            this.propertyChangeHandler = null;
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(jComponent);
        BasicHTML.updateRenderer(jComponent, "");
        this.uninstallListeners(jComponent);
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("tiptext") || string.equals("font") || string.equals("foreground")) {
                JToolTip jToolTip = (JToolTip)propertyChangeEvent.getSource();
                String string2 = jToolTip.getTipText();
                BasicHTML.updateRenderer(jToolTip, string2);
            }
        }
    }
}

