/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.SystemProperties;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.SharedUIDefaults;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class BasicTextUI
extends TextUI
implements ViewFactory {
    private static FocusListener focusListener;
    private static EditorKit kit;
    Handler handler;
    RootView rootView;
    JTextComponent textComponent;
    private Insets cachedInsets;

    protected Caret createCaret() {
        return new BasicCaret();
    }

    protected Highlighter createHighlighter() {
        return new BasicHighlighter();
    }

    protected final JTextComponent getComponent() {
        return this.textComponent;
    }

    public void installUI(JComponent jComponent) {
        this.textComponent = (JTextComponent)jComponent;
        if (this.rootView == null) {
            this.rootView = new RootView();
        }
        this.installDefaults();
        this.installFixedDefaults();
        if (this.handler == null) {
            this.handler = new Handler();
        }
        this.textComponent.addPropertyChangeListener(this.handler);
        Document document = this.textComponent.getDocument();
        if (document == null) {
            document = this.getEditorKit(this.textComponent).createDefaultDocument();
            this.textComponent.setDocument(document);
        } else {
            document.addDocumentListener(this.handler);
            this.modelChanged();
        }
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        Insets insets;
        String string = this.getPropertyPrefix();
        LookAndFeel.installColorsAndFont(this.textComponent, string + ".background", string + ".foreground", string + ".font");
        LookAndFeel.installBorder(this.textComponent, string + ".border");
        Color color = this.textComponent.getCaretColor();
        if (color == null || color instanceof UIResource) {
            color = UIManager.getColor(string + ".caretForeground");
            this.textComponent.setCaretColor(color);
        }
        if ((color = this.textComponent.getDisabledTextColor()) == null || color instanceof UIResource) {
            color = UIManager.getColor(string + ".inactiveForeground");
            this.textComponent.setDisabledTextColor(color);
        }
        if ((color = this.textComponent.getSelectedTextColor()) == null || color instanceof UIResource) {
            color = UIManager.getColor(string + ".selectionForeground");
            this.textComponent.setSelectedTextColor(color);
        }
        if ((color = this.textComponent.getSelectionColor()) == null || color instanceof UIResource) {
            color = UIManager.getColor(string + ".selectionBackground");
            this.textComponent.setSelectionColor(color);
        }
        if ((insets = this.textComponent.getMargin()) == null || insets instanceof UIResource) {
            insets = UIManager.getInsets(string + ".margin");
            this.textComponent.setMargin(insets);
        }
    }

    private void installFixedDefaults() {
        Highlighter highlighter;
        String string = this.getPropertyPrefix();
        Caret caret = this.textComponent.getCaret();
        if (caret == null || caret instanceof UIResource) {
            caret = this.createCaret();
            this.textComponent.setCaret(caret);
            caret.setBlinkRate(UIManager.getInt(string + ".caretBlinkRate"));
        }
        if ((highlighter = this.textComponent.getHighlighter()) == null || highlighter instanceof UIResource) {
            this.textComponent.setHighlighter(this.createHighlighter());
        }
    }

    protected void installListeners() {
        if (SystemProperties.getProperty("gnu.swing.text.no-xlike-clipboard") == null) {
            if (focusListener == null) {
                focusListener = new FocusHandler();
            }
            this.textComponent.addFocusListener(focusListener);
        }
    }

    protected String getKeymapName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        return string2;
    }

    protected Keymap createKeymap() {
        String string = this.getKeymapName();
        Keymap keymap = JTextComponent.getKeymap(string);
        if (keymap == null) {
            Keymap keymap2 = JTextComponent.getKeymap("default");
            keymap = JTextComponent.addKeymap(string, keymap2);
            Object object = UIManager.get(this.getPropertyPrefix() + ".keyBindings");
            if (object != null && object instanceof JTextComponent.KeyBinding[]) {
                JTextComponent.KeyBinding[] keyBindingArray = (JTextComponent.KeyBinding[])object;
                JTextComponent.loadKeymap(keymap, keyBindingArray, this.getComponent().getActions());
            }
        }
        return keymap;
    }

    protected void installKeyboardActions() {
        this.textComponent.setKeymap(this.createKeymap());
        SwingUtilities.replaceUIInputMap(this.textComponent, 0, this.getInputMap());
        SwingUtilities.replaceUIActionMap(this.textComponent, this.getActionMap());
    }

    private ActionMap getActionMap() {
        String string = this.getPropertyPrefix();
        String string2 = string + ".actionMap";
        ActionMap actionMap = (ActionMap)UIManager.get(string2);
        if (actionMap == null) {
            actionMap = this.createActionMap();
            UIManager.put(string2, actionMap);
        }
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.setParent(actionMap);
        return actionMapUIResource;
    }

    private ActionMap createActionMap() {
        Action action;
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        Action[] actionArray = this.textComponent.getActions();
        for (int i = actionArray.length - 1; i >= 0; --i) {
            action = actionArray[i];
            actionMapUIResource.put(action.getValue("Name"), action);
        }
        Action action2 = TransferHandler.getCopyAction();
        actionMapUIResource.put(action2.getValue("Name"), action2);
        action = TransferHandler.getCutAction();
        actionMapUIResource.put(action.getValue("Name"), action);
        Action action3 = TransferHandler.getPasteAction();
        actionMapUIResource.put(action3.getValue("Name"), action3);
        return actionMapUIResource;
    }

    private InputMap getInputMap() {
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        String string = this.getPropertyPrefix();
        InputMap inputMap = (InputMap)SharedUIDefaults.get(string + ".focusInputMap");
        if (inputMap != null) {
            inputMapUIResource.setParent(inputMap);
        }
        return inputMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        this.textComponent.removePropertyChangeListener(this.handler);
        this.textComponent.getDocument().removeDocumentListener(this.handler);
        this.rootView.setView(null);
        this.uninstallDefaults();
        this.uninstallFixedDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.textComponent = null;
    }

    protected void uninstallDefaults() {
        if (this.textComponent.getCaretColor() instanceof UIResource) {
            this.textComponent.setCaretColor(null);
        }
        if (this.textComponent.getSelectionColor() instanceof UIResource) {
            this.textComponent.setSelectionColor(null);
        }
        if (this.textComponent.getDisabledTextColor() instanceof UIResource) {
            this.textComponent.setDisabledTextColor(null);
        }
        if (this.textComponent.getSelectedTextColor() instanceof UIResource) {
            this.textComponent.setSelectedTextColor(null);
        }
        LookAndFeel.uninstallBorder(this.textComponent);
        if (this.textComponent.getMargin() instanceof UIResource) {
            this.textComponent.setMargin(null);
        }
    }

    private void uninstallFixedDefaults() {
        if (this.textComponent.getCaret() instanceof UIResource) {
            this.textComponent.setCaret(null);
        }
        if (this.textComponent.getHighlighter() instanceof UIResource) {
            this.textComponent.setHighlighter(null);
        }
    }

    protected void uninstallListeners() {
        if (focusListener != null) {
            this.textComponent.removeFocusListener(focusListener);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.textComponent, 0, null);
        SwingUtilities.replaceUIActionMap(this.textComponent, null);
    }

    protected abstract String getPropertyPrefix();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize(JComponent jComponent) {
        float f;
        float f2;
        Dimension dimension = jComponent.getSize();
        Insets insets = jComponent.getInsets();
        Document document = this.textComponent.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            if (dimension.width > insets.left + insets.right && dimension.height > insets.top + insets.bottom) {
                this.rootView.setSize(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            } else {
                this.rootView.setSize(2.1474836E9f, 2.1474836E9f);
            }
            f2 = this.rootView.getPreferredSpan(0);
            f = this.rootView.getPreferredSpan(1);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        Dimension dimension2 = new Dimension((int)f2 + insets.left + insets.right, (int)f + insets.top + insets.bottom);
        return dimension2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = new Dimension();
        Insets insets = jComponent.getInsets();
        Document document = this.textComponent.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            dimension.width = (int)Math.min((long)this.rootView.getMaximumSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)this.rootView.getMaximumSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = new Dimension();
        Document document = this.textComponent.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            dimension.width = (int)this.rootView.getMinimumSpan(0);
            dimension.height = (int)this.rootView.getMinimumSpan(1);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        Insets insets = jComponent.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics graphics, JComponent jComponent) {
        Document document;
        try {
            Document document2 = this.textComponent.getDocument();
            if (document2 instanceof AbstractDocument) {
                AbstractDocument abstractDocument = (AbstractDocument)document2;
                abstractDocument.readLock();
            }
            this.paintSafely(graphics);
            Object var6_5 = null;
            document = this.textComponent.getDocument();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Document document3 = this.textComponent.getDocument();
            if (document3 instanceof AbstractDocument) {
                AbstractDocument abstractDocument = (AbstractDocument)document3;
                abstractDocument.readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            AbstractDocument abstractDocument = (AbstractDocument)document;
            abstractDocument.readUnlock();
        }
    }

    protected void paintSafely(Graphics graphics) {
        Caret caret = this.textComponent.getCaret();
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (this.textComponent.isOpaque()) {
            this.paintBackground(graphics);
        }
        if (highlighter != null) {
            Color color = graphics.getColor();
            highlighter.paint(graphics);
            graphics.setColor(color);
        }
        this.rootView.paint(graphics, this.getVisibleEditorRect());
        if (caret != null && this.textComponent.hasFocus()) {
            caret.paint(graphics);
        }
    }

    protected void paintBackground(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.textComponent.getBackground());
        graphics.fillRect(0, 0, this.textComponent.getWidth(), this.textComponent.getHeight());
        graphics.setColor(color);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2) {
        this.damageRange(jTextComponent, n, n2, Position.Bias.Forward, Position.Bias.Backward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void damageRange(JTextComponent jTextComponent, int n, int n2, Position.Bias bias, Position.Bias bias2) {
        Rectangle rectangle = this.getVisibleEditorRect();
        if (rectangle == null) return;
        Document document = jTextComponent.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            try {
                this.rootView.setSize(rectangle.width, rectangle.height);
                Shape shape = this.rootView.modelToView(n, bias, n2, bias2, rectangle);
                Rectangle rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                this.textComponent.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            catch (BadLocationException badLocationException) {
                Object var11_12 = null;
                if (!(document instanceof AbstractDocument)) return;
                ((AbstractDocument)document).readUnlock();
                return;
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!(document instanceof AbstractDocument)) throw throwable;
            ((AbstractDocument)document).readUnlock();
            throw throwable;
        }
        if (!(document instanceof AbstractDocument)) return;
        ((AbstractDocument)document).readUnlock();
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        if (kit == null) {
            kit = new DefaultEditorKit();
        }
        return kit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3 = -1;
        Document document = this.textComponent.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            Rectangle rectangle = this.getVisibleEditorRect();
            if (rectangle != null) {
                this.rootView.setSize(rectangle.width, rectangle.height);
                n3 = this.rootView.getNextVisualPositionFrom(n, bias, rectangle, n2, biasArray);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return n3;
    }

    public View getRootView(JTextComponent jTextComponent) {
        return this.rootView;
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n) throws BadLocationException {
        return this.modelToView(jTextComponent, n, Position.Bias.Forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle modelToView(JTextComponent jTextComponent, int n, Position.Bias bias) throws BadLocationException {
        Document document = this.textComponent.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        Rectangle rectangle = null;
        try {
            Rectangle rectangle2 = this.getVisibleEditorRect();
            if (rectangle2 != null) {
                this.rootView.setSize(rectangle2.width, rectangle2.height);
                Shape shape = this.rootView.modelToView(n, rectangle2, bias);
                if (shape != null) {
                    rectangle = shape.getBounds();
                }
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return rectangle;
    }

    public int viewToModel(JTextComponent jTextComponent, Point point) {
        return this.viewToModel(jTextComponent, point, new Position.Bias[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        int n = -1;
        Document document = this.textComponent.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            Rectangle rectangle = this.getVisibleEditorRect();
            if (rectangle != null) {
                this.rootView.setSize(rectangle.width, rectangle.height);
                n = this.rootView.viewToModel(point.x, point.y, rectangle, biasArray);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return n;
    }

    public View create(Element element) {
        return null;
    }

    public View create(Element element, int n, int n2) {
        return null;
    }

    protected Rectangle getVisibleEditorRect() {
        int n = this.textComponent.getWidth();
        int n2 = this.textComponent.getHeight();
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        Insets insets = this.textComponent.getInsets(this.cachedInsets);
        return new Rectangle(insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
    }

    protected final void setView(View view) {
        this.rootView.setView(view);
        this.textComponent.revalidate();
        this.textComponent.repaint();
    }

    protected void modelChanged() {
        if (this.textComponent == null || this.rootView == null) {
            return;
        }
        ViewFactory viewFactory = this.rootView.getViewFactory();
        if (viewFactory == null) {
            return;
        }
        Document document = this.textComponent.getDocument();
        if (document == null) {
            return;
        }
        Element element = document.getDefaultRootElement();
        if (element == null) {
            return;
        }
        View view = viewFactory.create(element);
        this.setView(view);
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private class RootView
    extends View {
        private View view;

        public RootView() {
            super(null);
        }

        public ViewFactory getViewFactory() {
            ViewFactory viewFactory = null;
            EditorKit editorKit = BasicTextUI.this.getEditorKit(BasicTextUI.this.getComponent());
            viewFactory = editorKit.getViewFactory();
            if (viewFactory == null) {
                viewFactory = BasicTextUI.this;
            }
            return viewFactory;
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            BasicTextUI.this.textComponent.revalidate();
        }

        public void setView(View view) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            if (view != null) {
                view.setParent(this);
            }
            this.view = view;
        }

        public View getView(int n) {
            return this.view;
        }

        public int getViewCount() {
            int n = 0;
            if (this.view != null) {
                n = 1;
            }
            return n;
        }

        public Container getContainer() {
            return BasicTextUI.this.textComponent;
        }

        public synchronized void setSize(float f, float f2) {
            if (this.view != null) {
                this.view.setSize(f, f2);
            }
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                this.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            return this.view.modelToView(n, shape, bias);
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            return this.view.viewToModel(f, f2, shape, biasArray);
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.changedUpdate(documentEvent, shape, viewFactory);
            }
        }

        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            return this.view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return this.getDocument().getLength();
        }

        public Document getDocument() {
            return BasicTextUI.this.textComponent.getDocument();
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public float getPreferredSpan(int n) {
            float f = 10.0f;
            if (this.view != null) {
                f = this.view.getPreferredSpan(n);
            }
            return f;
        }

        public float getMinimumSpan(int n) {
            float f = 10.0f;
            if (this.view != null) {
                f = this.view.getMinimumSpan(n);
            }
            return f;
        }

        public float getMaximumSpan(int n) {
            return 2.1474836E9f;
        }
    }

    private class Handler
    implements PropertyChangeListener,
    DocumentListener {
        private Handler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("document")) {
                Object object;
                Object object2 = propertyChangeEvent.getOldValue();
                if (object2 != null) {
                    object = (Document)object2;
                    object.removeDocumentListener(BasicTextUI.this.handler);
                }
                if ((object = propertyChangeEvent.getNewValue()) != null) {
                    Document document = (Document)object;
                    document.addDocumentListener(BasicTextUI.this.handler);
                }
                BasicTextUI.this.modelChanged();
            }
            BasicTextUI.this.propertyChange(propertyChangeEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            BasicTextUI.this.rootView.changedUpdate(documentEvent, BasicTextUI.this.getVisibleEditorRect(), BasicTextUI.this.rootView.getViewFactory());
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            BasicTextUI.this.rootView.insertUpdate(documentEvent, BasicTextUI.this.getVisibleEditorRect(), BasicTextUI.this.rootView.getViewFactory());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            BasicTextUI.this.rootView.removeUpdate(documentEvent, BasicTextUI.this.getVisibleEditorRect(), BasicTextUI.this.rootView.getViewFactory());
        }
    }

    private static class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            JTextComponent jTextComponent = (JTextComponent)focusEvent.getComponent();
            if (!focusEvent.isTemporary() && jTextComponent.getSelectionStart() != jTextComponent.getSelectionEnd()) {
                SecurityManager securityManager = System.getSecurityManager();
                try {
                    Clipboard clipboard;
                    if (securityManager != null) {
                        securityManager.checkSystemClipboardAccess();
                    }
                    if ((clipboard = Toolkit.getDefaultToolkit().getSystemSelection()) != null) {
                        StringSelection stringSelection = new StringSelection(jTextComponent.getSelectedText());
                        clipboard.setContents(stringSelection, stringSelection);
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (HeadlessException headlessException) {
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    public static class BasicHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    public static class BasicCaret
    extends DefaultCaret
    implements UIResource {
    }
}

