/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SliderUI;

public class BasicSliderUI
extends SliderUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ScrollListener scrollListener;
    protected ComponentListener componentListener;
    protected FocusListener focusListener;
    protected TrackListener trackListener;
    protected Insets focusInsets;
    protected Insets insetCache;
    protected Rectangle contentRect;
    protected Rectangle focusRect;
    protected Rectangle thumbRect;
    protected Rectangle tickRect;
    protected Rectangle labelRect;
    protected Rectangle trackRect;
    public static final int MAX_SCROLL = 2;
    public static final int MIN_SCROLL = -2;
    public static final int NEGATIVE_SCROLL = -1;
    public static final int POSITIVE_SCROLL = 1;
    protected int trackBuffer;
    protected boolean leftToRightCache;
    protected Timer scrollTimer;
    protected JSlider slider;
    private transient Color shadowColor;
    private transient Color highlightColor;
    private transient Color focusColor;
    boolean dragging;

    public BasicSliderUI(JSlider jSlider) {
    }

    protected boolean isDragging() {
        return this.dragging;
    }

    protected Color getShadowColor() {
        return this.shadowColor;
    }

    protected Color getHighlightColor() {
        return this.highlightColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSliderUI((JSlider)jComponent);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JSlider) {
            this.slider = (JSlider)jComponent;
            this.focusRect = new Rectangle();
            this.contentRect = new Rectangle();
            this.thumbRect = new Rectangle();
            this.trackRect = new Rectangle();
            this.tickRect = new Rectangle();
            this.labelRect = new Rectangle();
            this.insetCache = this.slider.getInsets();
            this.leftToRightCache = !this.slider.getInverted();
            this.scrollTimer = new Timer(200, null);
            this.scrollTimer.setRepeats(true);
            this.installDefaults(this.slider);
            this.installListeners(this.slider);
            this.installKeyboardActions(this.slider);
            this.calculateFocusRect();
            this.calculateContentRect();
            this.calculateThumbSize();
            this.calculateTrackBuffer();
            this.calculateTrackRect();
            this.calculateThumbLocation();
            this.calculateTickRect();
            this.calculateLabelRect();
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallKeyboardActions(this.slider);
        this.uninstallListeners(this.slider);
        this.scrollTimer = null;
        this.focusRect = null;
        this.contentRect = null;
        this.thumbRect = null;
        this.trackRect = null;
        this.tickRect = null;
        this.labelRect = null;
        this.focusInsets = null;
    }

    protected void installDefaults(JSlider jSlider) {
        LookAndFeel.installColors(jSlider, "Slider.background", "Slider.foreground");
        LookAndFeel.installBorder(jSlider, "Slider.border");
        this.shadowColor = UIManager.getColor("Slider.shadow");
        this.highlightColor = UIManager.getColor("Slider.highlight");
        this.focusColor = UIManager.getColor("Slider.focus");
        this.focusInsets = UIManager.getInsets("Slider.focusInsets");
        jSlider.setOpaque(true);
    }

    protected TrackListener createTrackListener(JSlider jSlider) {
        return new TrackListener();
    }

    protected ChangeListener createChangeListener(JSlider jSlider) {
        return new ChangeHandler();
    }

    protected ComponentListener createComponentListener(JSlider jSlider) {
        return new ComponentHandler();
    }

    protected FocusListener createFocusListener(JSlider jSlider) {
        return new FocusHandler();
    }

    protected ScrollListener createScrollListener(JSlider jSlider) {
        return new ScrollListener();
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return new PropertyChangeHandler();
    }

    protected void installListeners(JSlider jSlider) {
        this.propertyChangeListener = this.createPropertyChangeListener(jSlider);
        this.componentListener = this.createComponentListener(jSlider);
        this.trackListener = this.createTrackListener(jSlider);
        this.focusListener = this.createFocusListener(jSlider);
        this.changeListener = this.createChangeListener(jSlider);
        this.scrollListener = this.createScrollListener(jSlider);
        jSlider.addPropertyChangeListener(this.propertyChangeListener);
        jSlider.addComponentListener(this.componentListener);
        jSlider.addMouseListener(this.trackListener);
        jSlider.addMouseMotionListener(this.trackListener);
        jSlider.addFocusListener(this.focusListener);
        jSlider.getModel().addChangeListener(this.changeListener);
        this.scrollTimer.addActionListener(this.scrollListener);
    }

    protected void uninstallListeners(JSlider jSlider) {
        jSlider.removePropertyChangeListener(this.propertyChangeListener);
        jSlider.removeComponentListener(this.componentListener);
        jSlider.removeMouseListener(this.trackListener);
        jSlider.removeMouseMotionListener(this.trackListener);
        jSlider.removeFocusListener(this.focusListener);
        jSlider.getModel().removeChangeListener(this.changeListener);
        this.scrollTimer.removeActionListener(this.scrollListener);
        this.propertyChangeListener = null;
        this.componentListener = null;
        this.trackListener = null;
        this.focusListener = null;
        this.changeListener = null;
        this.scrollListener = null;
    }

    protected void installKeyboardActions(JSlider jSlider) {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(jSlider, 0, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jSlider, actionMap);
    }

    protected void uninstallKeyboardActions(JSlider jSlider) {
        SwingUtilities.replaceUIActionMap(jSlider, null);
        SwingUtilities.replaceUIInputMap(jSlider, 0, null);
    }

    public Dimension getPreferredHorizontalSize() {
        Dimension dimension = UIManager.getDimension("Slider.horizontalSize");
        if (dimension == null) {
            dimension = new Dimension(200, 21);
        }
        return dimension;
    }

    public Dimension getPreferredVerticalSize() {
        Dimension dimension = UIManager.getDimension("Slider.verticalSize");
        if (dimension == null) {
            dimension = new Dimension(21, 200);
        }
        return dimension;
    }

    public Dimension getMinimumHorizontalSize() {
        Dimension dimension = UIManager.getDimension("Slider.minimumHorizontalSize");
        if (dimension == null) {
            dimension = new Dimension(36, 21);
        }
        return dimension;
    }

    public Dimension getMinimumVerticalSize() {
        Dimension dimension = UIManager.getDimension("Slider.minimumVerticalSize");
        if (dimension == null) {
            dimension = new Dimension(21, 36);
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 0) {
            dimension = new Dimension(this.getPreferredHorizontalSize());
            dimension.height = this.insetCache.top + this.insetCache.bottom;
            dimension.height += this.focusInsets.top + this.focusInsets.bottom;
            dimension.height += this.trackRect.height + this.tickRect.height + this.labelRect.height;
        } else {
            dimension = new Dimension(this.getPreferredVerticalSize());
            dimension.width = this.insetCache.left + this.insetCache.right;
            dimension.width += this.focusInsets.left + this.focusInsets.right;
            dimension.width += this.trackRect.width + this.tickRect.width + this.labelRect.width;
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 0) {
            dimension = new Dimension(this.getMinimumHorizontalSize());
            dimension.height = this.insetCache.top + this.insetCache.bottom;
            dimension.height += this.focusInsets.top + this.focusInsets.bottom;
            dimension.height += this.trackRect.height + this.tickRect.height + this.labelRect.height;
        } else {
            dimension = new Dimension(this.getMinimumVerticalSize());
            dimension.width = this.insetCache.left + this.insetCache.right;
            dimension.width += this.focusInsets.left + this.focusInsets.right;
            dimension.width += this.trackRect.width + this.tickRect.width + this.labelRect.width;
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        if (this.slider.getOrientation() == 0) {
            dimension.width = Short.MAX_VALUE;
        } else {
            dimension.height = Short.MAX_VALUE;
        }
        return dimension;
    }

    protected void calculateGeometry() {
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateTickRect();
        this.calculateLabelRect();
        this.calculateThumbLocation();
    }

    protected void calculateFocusRect() {
        this.focusRect.x = this.insetCache.left;
        this.focusRect.y = this.insetCache.top;
        this.focusRect.width = this.slider.getWidth() - this.insetCache.left - this.insetCache.right;
        this.focusRect.height = this.slider.getHeight() - this.insetCache.top - this.insetCache.bottom;
    }

    protected void calculateThumbSize() {
        Dimension dimension = this.getThumbSize();
        this.thumbRect.width = dimension.width;
        this.thumbRect.height = dimension.height;
    }

    protected void calculateContentRect() {
        this.contentRect.x = this.focusRect.x + this.focusInsets.left;
        this.contentRect.y = this.focusRect.y + this.focusInsets.top;
        this.contentRect.width = this.focusRect.width - this.focusInsets.left - this.focusInsets.right;
        this.contentRect.height = this.focusRect.height - this.focusInsets.top - this.focusInsets.bottom;
    }

    protected void calculateThumbLocation() {
        int n = this.slider.getValue();
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.x = this.xPositionForValue(n) - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y + 1;
        } else {
            this.thumbRect.x = this.trackRect.x + 1;
            this.thumbRect.y = this.yPositionForValue(n) - this.thumbRect.height / 2;
        }
    }

    protected void calculateTrackBuffer() {
        if (this.slider.getOrientation() == 0) {
            int n = Math.max(this.getWidthOfLowValueLabel(), this.getWidthOfHighValueLabel());
            this.trackBuffer = Math.max(this.thumbRect.width / 2, n / 2);
        } else {
            int n = Math.max(this.getHeightOfLowValueLabel(), this.getHeightOfHighValueLabel());
            this.trackBuffer = Math.max(this.thumbRect.height / 2, n / 2);
        }
    }

    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 0) {
            return new Dimension(11, 20);
        }
        return new Dimension(20, 11);
    }

    protected void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            int n = this.thumbRect.height;
            if (this.slider.getPaintTicks()) {
                n += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                n += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + this.trackBuffer;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - n - 1) / 2;
            this.trackRect.width = this.contentRect.width - 2 * this.trackBuffer;
            this.trackRect.height = this.thumbRect.height;
        } else {
            int n = this.thumbRect.width;
            if (this.slider.getPaintTicks()) {
                n += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                n += this.getWidthOfWidestLabel();
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - n - 1) / 2;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - 2 * this.trackBuffer;
        }
    }

    protected int getTickLength() {
        return 8;
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            this.tickRect.x = this.trackRect.x + this.trackRect.width;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.width = this.getTickLength();
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    protected void calculateLabelRect() {
        if (this.slider.getOrientation() == 0) {
            if (this.slider.getPaintLabels()) {
                this.labelRect.x = this.tickRect.x - this.trackBuffer;
                this.labelRect.y = this.tickRect.y + this.tickRect.height;
                this.labelRect.width = this.tickRect.width + this.trackBuffer * 2;
                this.labelRect.height = this.getHeightOfTallestLabel();
            } else {
                this.labelRect.x = this.tickRect.x;
                this.labelRect.y = this.tickRect.y + this.tickRect.height;
                this.labelRect.width = this.tickRect.width;
                this.labelRect.height = 0;
            }
        } else if (this.slider.getPaintLabels()) {
            this.labelRect.x = this.tickRect.x + this.tickRect.width;
            this.labelRect.y = this.tickRect.y - this.trackBuffer;
            this.labelRect.width = this.getWidthOfWidestLabel();
            this.labelRect.height = this.tickRect.height + this.trackBuffer * 2;
        } else {
            this.labelRect.x = this.tickRect.x + this.tickRect.width;
            this.labelRect.y = this.tickRect.y;
            this.labelRect.width = 0;
            this.labelRect.height = this.tickRect.height;
        }
    }

    protected int getWidthOfWidestLabel() {
        int n = 0;
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = this.slider.getLabelTable().elements();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                n = Math.max(component.getPreferredSize().width, n);
            }
        }
        return n;
    }

    protected int getHeightOfTallestLabel() {
        int n = 0;
        if (this.slider.getLabelTable() == null) {
            return 0;
        }
        Enumeration enumeration = this.slider.getLabelTable().elements();
        while (enumeration.hasMoreElements()) {
            Component component;
            Dimension dimension;
            Object v = enumeration.nextElement();
            if (!(v instanceof Component) || (dimension = (component = (Component)v).getPreferredSize()) == null || dimension.height <= n) continue;
            n = dimension.height;
        }
        return n;
    }

    protected int getWidthOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        if (component != null) {
            return component.getPreferredSize().width;
        }
        return 0;
    }

    protected int getWidthOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        if (component != null) {
            return component.getPreferredSize().width;
        }
        return 0;
    }

    protected int getHeightOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        if (component != null) {
            return component.getPreferredSize().height;
        }
        return 0;
    }

    protected int getHeightOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        if (component != null) {
            return component.getPreferredSize().height;
        }
        return 0;
    }

    protected boolean drawInverted() {
        return this.slider.getInverted();
    }

    protected Component getLowestValueLabel() {
        Integer n = new Integer(Integer.MAX_VALUE);
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary == null) {
            return null;
        }
        Enumeration<Object> enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2;
            Object k = enumeration.nextElement();
            if (!(k instanceof Integer) || (n2 = (Integer)k) >= n) continue;
            n = n2;
        }
        enumeration = dictionary.get(n);
        if (!(enumeration instanceof Component)) {
            return null;
        }
        return (Component)((Object)enumeration);
    }

    protected Component getHighestValueLabel() {
        Integer n = new Integer(Integer.MIN_VALUE);
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary == null) {
            return null;
        }
        Enumeration<Object> enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2;
            Object k = enumeration.nextElement();
            if (!(k instanceof Integer) || (n2 = (Integer)k) <= n) continue;
            n = n2;
        }
        enumeration = dictionary.get(n);
        if (!(enumeration instanceof Component)) {
            return null;
        }
        return (Component)((Object)enumeration);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        if (this.slider.getPaintTrack() && this.hitClip(graphics, this.trackRect)) {
            this.paintTrack(graphics);
        }
        if (this.slider.getPaintTicks() && this.hitClip(graphics, this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintLabels() && this.hitClip(graphics, this.labelRect)) {
            this.paintLabels(graphics);
        }
        if (this.slider.hasFocus() && this.hitClip(graphics, this.focusRect)) {
            this.paintFocus(graphics);
        }
        if (this.hitClip(graphics, this.thumbRect)) {
            this.paintThumb(graphics);
        }
    }

    protected void recalculateIfInsetsChanged() {
        Insets insets = this.slider.getInsets();
        if (!insets.equals(this.insetCache)) {
            this.insetCache = insets;
            this.calculateGeometry();
        }
    }

    protected void recalculateIfOrientationChanged() {
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateThumbLocation();
        this.calculateTickRect();
        this.calculateLabelRect();
    }

    public void paintFocus(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
        graphics.setColor(color);
    }

    public void paintTrack(Graphics graphics) {
        int n;
        int n2;
        Color color = graphics.getColor();
        Point point = new Point(this.trackRect.x, this.trackRect.y + 1);
        Point point2 = new Point(point);
        Point point3 = new Point(point);
        Point point4 = new Point(point);
        if (this.slider.getOrientation() == 0) {
            n2 = this.trackRect.width;
            n = this.thumbRect.height / 4 == 0 ? 1 : this.thumbRect.height / 4;
            point.translate(0, this.trackRect.height / 2 - n / 2);
            point2.translate(0, this.trackRect.height / 2 + n / 2);
            point3.translate(this.trackRect.width, this.trackRect.height / 2 + n / 2);
            point4.translate(this.trackRect.width, this.trackRect.height / 2 - n / 2);
        } else {
            n2 = this.thumbRect.width / 4 == 0 ? 1 : this.thumbRect.width / 4;
            n = this.trackRect.height;
            point.translate(this.trackRect.width / 2 - n2 / 2, 0);
            point2.translate(this.trackRect.width / 2 - n2 / 2, this.trackRect.height);
            point3.translate(this.trackRect.width / 2 + n2 / 2, this.trackRect.height);
            point4.translate(this.trackRect.width / 2 + n2 / 2, 0);
        }
        graphics.setColor(Color.GRAY);
        graphics.fillRect(point.x, point.y, n2, n);
        graphics.setColor(this.getHighlightColor());
        graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
        graphics.drawLine(point3.x, point3.y, point4.x, point4.y);
        graphics.setColor(this.getShadowColor());
        graphics.drawLine(point2.x, point2.y, point.x, point.y);
        graphics.drawLine(point.x, point.y, point4.x, point4.y);
        graphics.setColor(color);
    }

    public void paintTicks(Graphics graphics) {
        int n;
        int n2 = this.slider.getMaximum();
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMajorTickSpacing();
        int n5 = this.slider.getMinorTickSpacing();
        if (n4 > 0) {
            if (this.slider.getOrientation() == 0) {
                graphics.translate(0, this.tickRect.y);
                for (n = n3; n <= n2; n += n4) {
                    this.paintMajorTickForHorizSlider(graphics, this.tickRect, this.xPositionForValue(n));
                }
                graphics.translate(0, -this.tickRect.y);
            } else {
                graphics.translate(this.tickRect.x, 0);
                for (n = n3; n <= n2; n += n4) {
                    this.paintMajorTickForVertSlider(graphics, this.tickRect, this.yPositionForValue(n));
                }
                graphics.translate(-this.tickRect.x, 0);
            }
        }
        if (n5 > 0) {
            if (this.slider.getOrientation() == 0) {
                graphics.translate(0, this.tickRect.y);
                for (n = n3; n <= n2; n += n5) {
                    this.paintMinorTickForHorizSlider(graphics, this.tickRect, this.xPositionForValue(n));
                }
                graphics.translate(0, -this.tickRect.y);
            } else {
                graphics.translate(this.tickRect.x, 0);
                for (n = n3; n <= n2; n += n5) {
                    this.paintMinorTickForVertSlider(graphics, this.tickRect, this.yPositionForValue(n));
                }
                graphics.translate(-this.tickRect.x, 0);
            }
        }
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = this.tickRect.height / 4;
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        graphics.drawLine(n, n2, n, n2 + this.tickRect.height / 4);
        graphics.setColor(color);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = this.tickRect.height / 4;
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        graphics.drawLine(n, n2, n, n2 + this.tickRect.height / 2);
        graphics.setColor(color);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = this.tickRect.width / 4;
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        graphics.drawLine(n2, n, n2 + this.tickRect.width / 4, n);
        graphics.setColor(color);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = this.tickRect.width / 4;
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        graphics.drawLine(n2, n, n2 + this.tickRect.width / 2, n);
        graphics.setColor(color);
    }

    public void paintLabels(Graphics graphics) {
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            int n = this.slider.getMinimum();
            int n2 = this.slider.getMaximum();
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Integer n3 = (Integer)enumeration.nextElement();
                int n4 = n3;
                if (n4 < n || n4 > n2) continue;
                Component component = (Component)dictionary.get(n3);
                if (this.slider.getOrientation() == 0) {
                    graphics.translate(0, this.labelRect.y);
                    this.paintHorizontalLabel(graphics, n4, component);
                    graphics.translate(0, -this.labelRect.y);
                    continue;
                }
                graphics.translate(this.labelRect.x, 0);
                this.paintVerticalLabel(graphics, n4, component);
                graphics.translate(-this.labelRect.x, 0);
            }
        }
    }

    protected void paintHorizontalLabel(Graphics graphics, int n, Component component) {
        int n2 = this.xPositionForValue(n);
        int n3 = n2 - component.getPreferredSize().width / 2;
        graphics.translate(n3, 0);
        component.paint(graphics);
        graphics.translate(-n3, 0);
    }

    protected void paintVerticalLabel(Graphics graphics, int n, Component component) {
        int n2 = this.yPositionForValue(n);
        int n3 = n2 - component.getPreferredSize().height / 2;
        graphics.translate(0, n3);
        component.paint(graphics);
        graphics.translate(0, -n3);
    }

    public void paintThumb(Graphics graphics) {
        Polygon polygon;
        Polygon polygon2;
        Polygon polygon3;
        Polygon polygon4;
        Color color = graphics.getColor();
        Point point = new Point(this.thumbRect.x, this.thumbRect.y);
        Point point2 = new Point(point);
        Point point3 = new Point(point);
        Point point4 = new Point(point);
        Point point5 = new Point(point);
        if (this.slider.getOrientation() == 0) {
            int n = this.thumbRect.height * 3 / 4;
            point2.translate(this.thumbRect.width - 1, 0);
            point3.translate(this.thumbRect.width - 1, n);
            point4.translate(this.thumbRect.width / 2 - 1, this.thumbRect.height - 1);
            point5.translate(0, n);
            polygon4 = new Polygon(new int[]{point2.x - 1, point.x, point5.x, point4.x}, new int[]{point2.y, point.y, point5.y, point4.y}, 4);
            polygon3 = new Polygon(new int[]{point2.x, point3.x, point4.x + 1}, new int[]{point2.y, point3.y - 1, point4.y}, 3);
            polygon2 = new Polygon(new int[]{point2.x - 1, point3.x - 1, point4.x + 1}, new int[]{point2.y + 1, point3.y - 1, point4.y - 1}, 3);
            polygon = new Polygon(new int[]{point.x + 1, point2.x - 2, point3.x - 2, point4.x, point5.x + 1}, new int[]{point.y + 1, point2.y + 1, point3.y - 1, point4.y - 1, point5.y}, 5);
        } else {
            int n = this.thumbRect.width * 3 / 4 - 1;
            point2.translate(n, 0);
            point3.translate(this.thumbRect.width - 1, this.thumbRect.height / 2);
            point4.translate(n, this.thumbRect.height - 1);
            point5.translate(0, this.thumbRect.height - 1);
            polygon4 = new Polygon(new int[]{point3.x - 1, point2.x, point.x, point5.x}, new int[]{point3.y - 1, point2.y, point.y, point5.y - 1}, 4);
            polygon3 = new Polygon(new int[]{point3.x, point4.x, point5.x}, new int[]{point3.y, point4.y, point5.y}, 3);
            polygon2 = new Polygon(new int[]{point3.x - 1, point4.x, point5.x + 1}, new int[]{point3.y, point4.y - 1, point5.y - 1}, 3);
            polygon = new Polygon(new int[]{point.x + 1, point2.x, point3.x - 2, point3.x - 2, point4.x, point5.x + 1}, new int[]{point.y + 1, point2.y + 1, point3.y - 1, point3.y, point4.y - 2, point5.y - 2}, 6);
        }
        graphics.setColor(Color.WHITE);
        graphics.drawPolyline(polygon4.xpoints, polygon4.ypoints, polygon4.npoints);
        graphics.setColor(Color.BLACK);
        graphics.drawPolyline(polygon3.xpoints, polygon3.ypoints, polygon3.npoints);
        graphics.setColor(Color.GRAY);
        graphics.drawPolyline(polygon2.xpoints, polygon2.ypoints, polygon2.npoints);
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
        graphics.fillPolygon(polygon);
        graphics.setColor(color);
    }

    public void setThumbLocation(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.thumbRect);
        this.thumbRect.setLocation(n, n2);
        SwingUtilities.computeUnion(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, rectangle);
        this.slider.repaint(rectangle);
    }

    public void scrollByBlock(int n) {
        int n2 = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
        int n3 = this.slider.getValue();
        n3 = n > 0 ? (n3 += n2) : (n3 -= n2);
        if (this.slider.getSnapToTicks()) {
            n3 = this.findClosestTick(n3);
        }
        this.slider.setValue(n3);
    }

    public void scrollByUnit(int n) {
        int n2 = this.slider.getValue();
        n2 = n > 0 ? ++n2 : --n2;
        if (this.slider.getSnapToTicks()) {
            n2 = this.findClosestTick(n2);
        }
        this.slider.setValue(n2);
    }

    protected void scrollDueToClickInTrack(int n) {
        this.scrollTimer.stop();
        this.scrollListener.setDirection(n);
        this.scrollListener.setScrollByBlock(true);
        this.scrollTimer.start();
    }

    protected int xPositionForValue(int n) {
        int n2 = this.slider.getMinimum();
        int n3 = this.slider.getMaximum();
        int n4 = this.trackRect.width;
        double d = n3 - n2;
        double d2 = (double)n4 / d;
        int n5 = this.trackRect.x;
        int n6 = n5 + this.trackRect.width - 1;
        int n7 = !this.drawInverted() ? n5 + (int)Math.round(d2 * ((double)n - (double)n2)) : n6 - (int)Math.round(d2 * ((double)n - (double)n2));
        n7 = Math.max(n5, n7);
        n7 = Math.min(n6, n7);
        return n7;
    }

    protected int yPositionForValue(int n) {
        int n2 = this.slider.getMinimum();
        int n3 = this.slider.getMaximum();
        int n4 = this.trackRect.height;
        double d = n3 - n2;
        double d2 = (double)n4 / d;
        int n5 = this.trackRect.y;
        int n6 = n5 + this.trackRect.height - 1;
        int n7 = !this.drawInverted() ? n5 + (int)Math.round(d2 * ((double)n3 - (double)n)) : n5 + (int)Math.round(d2 * ((double)n - (double)n2));
        n7 = Math.max(n5, n7);
        n7 = Math.min(n6, n7);
        return n7;
    }

    public int valueForYPosition(int n) {
        int n2 = this.slider.getMinimum();
        int n3 = this.slider.getMaximum();
        int n4 = this.trackRect.height;
        if (n4 == 0) {
            return (n3 - n2) / 2;
        }
        int n5 = !this.drawInverted() ? (n4 - (n - this.trackRect.y)) * (n3 - n2) / n4 + n2 : (n - this.trackRect.y) * (n3 - n2) / n4 + n2;
        if (n5 > n3) {
            n5 = n3;
        } else if (n5 < n2) {
            n5 = n2;
        }
        return n5;
    }

    public int valueForXPosition(int n) {
        int n2 = this.slider.getMinimum();
        int n3 = this.slider.getMaximum();
        int n4 = this.trackRect.width;
        if (n4 == 0) {
            return (n3 - n2) / 2;
        }
        int n5 = !this.drawInverted() ? (n - this.trackRect.x) * (n3 - n2) / n4 + n2 : (n4 - (n - this.trackRect.x)) * (n3 - n2) / n4 + n2;
        if (n5 > n3) {
            n5 = n3;
        } else if (n5 < n2) {
            n5 = n2;
        }
        return n5;
    }

    int findClosestTick(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.slider.getMinimum();
        int n6 = this.slider.getMaximum();
        int n7 = this.slider.getMajorTickSpacing();
        int n8 = this.slider.getMinorTickSpacing();
        int n9 = n5 - n;
        int n10 = n5 - n;
        if (n7 <= 0 && n8 <= 0) {
            return n;
        }
        if (n7 > 0) {
            n4 = (n - n5) / n7;
            n3 = n7 * n4 + n5;
            n2 = n7 * (n4 + 1) + n5;
            n10 = n2 <= n6 && n2 - n <= n - n3 ? n2 - n : n3 - n;
        }
        if (n8 > 0) {
            n4 = n / n8;
            n3 = n8 * n4;
            n2 = n8 * (n4 + 1);
            n9 = n2 <= n6 && n2 - n <= n - n3 ? n2 - n : n3 - n;
        }
        if (Math.abs(n9) > Math.abs(n10)) {
            return n + n10;
        }
        return n + n9;
    }

    InputMap getInputMap(int n) {
        if (n == 0) {
            return (InputMap)UIManager.get("Slider.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("Slider.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put("Slider.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("positiveUnitIncrement", new AbstractAction("positiveUnitIncrement"){

            public void actionPerformed(ActionEvent actionEvent) {
                JSlider jSlider = (JSlider)actionEvent.getSource();
                BasicSliderUI basicSliderUI = (BasicSliderUI)jSlider.getUI();
                if (jSlider.getInverted()) {
                    basicSliderUI.scrollByUnit(-1);
                } else {
                    basicSliderUI.scrollByUnit(1);
                }
            }
        });
        actionMapUIResource.put("negativeUnitIncrement", new AbstractAction("negativeUnitIncrement"){

            public void actionPerformed(ActionEvent actionEvent) {
                JSlider jSlider = (JSlider)actionEvent.getSource();
                BasicSliderUI basicSliderUI = (BasicSliderUI)jSlider.getUI();
                if (jSlider.getInverted()) {
                    basicSliderUI.scrollByUnit(1);
                } else {
                    basicSliderUI.scrollByUnit(-1);
                }
            }
        });
        actionMapUIResource.put("positiveBlockIncrement", new AbstractAction("positiveBlockIncrement"){

            public void actionPerformed(ActionEvent actionEvent) {
                JSlider jSlider = (JSlider)actionEvent.getSource();
                BasicSliderUI basicSliderUI = (BasicSliderUI)jSlider.getUI();
                if (jSlider.getInverted()) {
                    basicSliderUI.scrollByBlock(-1);
                } else {
                    basicSliderUI.scrollByBlock(1);
                }
            }
        });
        actionMapUIResource.put("negativeBlockIncrement", new AbstractAction("negativeBlockIncrement"){

            public void actionPerformed(ActionEvent actionEvent) {
                JSlider jSlider = (JSlider)actionEvent.getSource();
                BasicSliderUI basicSliderUI = (BasicSliderUI)jSlider.getUI();
                if (jSlider.getInverted()) {
                    basicSliderUI.scrollByBlock(1);
                } else {
                    basicSliderUI.scrollByBlock(-1);
                }
            }
        });
        actionMapUIResource.put("minScroll", new AbstractAction("minScroll"){

            public void actionPerformed(ActionEvent actionEvent) {
                JSlider jSlider = (JSlider)actionEvent.getSource();
                if (jSlider.getInverted()) {
                    jSlider.setValue(jSlider.getMaximum());
                } else {
                    jSlider.setValue(jSlider.getMinimum());
                }
            }
        });
        actionMapUIResource.put("maxScroll", new AbstractAction("maxScroll"){

            public void actionPerformed(ActionEvent actionEvent) {
                JSlider jSlider = (JSlider)actionEvent.getSource();
                if (jSlider.getInverted()) {
                    jSlider.setValue(jSlider.getMinimum());
                } else {
                    jSlider.setValue(jSlider.getMaximum());
                }
            }
        });
        return actionMapUIResource;
    }

    private boolean hitClip(Graphics graphics, Rectangle rectangle) {
        return graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public class ActionScroller
    extends AbstractAction {
        public ActionScroller(JSlider jSlider, int n, boolean bl) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class TrackListener
    extends MouseInputAdapter {
        protected int currentMouseX;
        protected int currentMouseY;
        protected int offset;

        public void mouseDragged(MouseEvent mouseEvent) {
            BasicSliderUI.this.dragging = true;
            if (BasicSliderUI.this.slider.isEnabled()) {
                this.currentMouseX = mouseEvent.getX();
                this.currentMouseY = mouseEvent.getY();
                if (BasicSliderUI.this.slider.getValueIsAdjusting()) {
                    int n = BasicSliderUI.this.slider.getOrientation() == 0 ? BasicSliderUI.this.valueForXPosition(this.currentMouseX) - this.offset : BasicSliderUI.this.valueForYPosition(this.currentMouseY) - this.offset;
                    BasicSliderUI.this.slider.setValue(n);
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (BasicSliderUI.this.slider.isEnabled()) {
                this.currentMouseX = mouseEvent.getX();
                this.currentMouseY = mouseEvent.getY();
                int n = BasicSliderUI.this.slider.getOrientation() == 0 ? BasicSliderUI.this.valueForXPosition(this.currentMouseX) : BasicSliderUI.this.valueForYPosition(this.currentMouseY);
                if (BasicSliderUI.this.slider.getSnapToTicks()) {
                    n = BasicSliderUI.this.findClosestTick(n);
                }
                if (!BasicSliderUI.this.thumbRect.contains(mouseEvent.getPoint())) {
                    if (n > BasicSliderUI.this.slider.getValue()) {
                        BasicSliderUI.this.scrollDueToClickInTrack(1);
                    } else {
                        BasicSliderUI.this.scrollDueToClickInTrack(-1);
                    }
                } else {
                    BasicSliderUI.this.slider.setValueIsAdjusting(true);
                    this.offset = n - BasicSliderUI.this.slider.getValue();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicSliderUI.this.dragging = false;
            if (BasicSliderUI.this.slider.isEnabled()) {
                this.currentMouseX = mouseEvent.getX();
                this.currentMouseY = mouseEvent.getY();
                if (BasicSliderUI.this.slider.getValueIsAdjusting()) {
                    BasicSliderUI.this.slider.setValueIsAdjusting(false);
                    if (BasicSliderUI.this.slider.getSnapToTicks()) {
                        BasicSliderUI.this.slider.setValue(BasicSliderUI.this.findClosestTick(BasicSliderUI.this.slider.getValue()));
                    }
                }
                if (BasicSliderUI.this.scrollTimer != null) {
                    BasicSliderUI.this.scrollTimer.stop();
                }
            }
            BasicSliderUI.this.slider.repaint();
        }

        public boolean shouldScroll(int n) {
            int n2 = BasicSliderUI.this.slider.getOrientation() == 0 ? BasicSliderUI.this.valueForXPosition(this.currentMouseX) : BasicSliderUI.this.valueForYPosition(this.currentMouseY);
            if (n == 1) {
                return n2 > BasicSliderUI.this.slider.getValue();
            }
            return n2 < BasicSliderUI.this.slider.getValue();
        }
    }

    public class ScrollListener
    implements ActionListener {
        private transient int direction;
        private transient boolean block;

        public ScrollListener() {
            this.direction = 1;
            this.block = false;
        }

        public ScrollListener(int n, boolean bl) {
            this.direction = n;
            this.block = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!BasicSliderUI.this.trackListener.shouldScroll(this.direction)) {
                BasicSliderUI.this.scrollTimer.stop();
                return;
            }
            if (this.block) {
                BasicSliderUI.this.scrollByBlock(this.direction);
            } else {
                BasicSliderUI.this.scrollByUnit(this.direction);
            }
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public void setScrollByBlock(boolean bl) {
            this.block = bl;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("orientation") || string.equals("inverted") || string.equals("labelTable") || string.equals("majorTickSpacing") || string.equals("minorTickSpacing") || string.equals("paintTicks") || string.equals("paintTrack") || string.equals("paintLabels")) {
                BasicSliderUI.this.calculateGeometry();
                BasicSliderUI.this.slider.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("model")) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)propertyChangeEvent.getOldValue();
                boundedRangeModel.removeChangeListener(BasicSliderUI.this.changeListener);
                BasicSliderUI.this.slider.getModel().addChangeListener(BasicSliderUI.this.changeListener);
                BasicSliderUI.this.calculateThumbLocation();
                BasicSliderUI.this.slider.repaint();
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            BasicSliderUI.this.slider.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicSliderUI.this.slider.repaint();
        }
    }

    public class ComponentHandler
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            BasicSliderUI.this.calculateGeometry();
            BasicSliderUI.this.slider.repaint();
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicSliderUI.this.calculateThumbLocation();
            BasicSliderUI.this.slider.repaint();
        }
    }
}

