/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.basic.BasicLookAndFeel;

public class BasicInternalFrameUI
extends InternalFrameUI {
    protected MouseInputAdapter borderListener;
    protected ComponentListener componentListener;
    protected MouseInputListener glassPaneDispatcher;
    protected PropertyChangeListener propertyChangeListener;
    private transient BasicInternalFrameListener internalFrameListener;
    protected JComponent eastPane;
    protected JComponent northPane;
    protected JComponent southPane;
    protected JComponent westPane;
    protected KeyStroke openMenuKey;
    protected BasicInternalFrameTitlePane titlePane;
    protected JInternalFrame frame;
    protected LayoutManager internalFrameLayout;
    private transient JDesktopPane desktopPane;

    public BasicInternalFrameUI(JInternalFrame jInternalFrame) {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicInternalFrameUI((JInternalFrame)jComponent);
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JInternalFrame) {
            this.frame = (JInternalFrame)jComponent;
            this.installDefaults();
            this.installListeners();
            this.installComponents();
            this.installKeyboardActions();
            if (!this.frame.isSelected()) {
                this.frame.getGlassPane().setVisible(true);
            }
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.frame.getRootPane().getGlassPane().setVisible(false);
        this.frame = null;
    }

    protected void installDefaults() {
        this.internalFrameLayout = this.createLayoutManager();
        this.frame.setLayout(this.internalFrameLayout);
        LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        this.frame.setFrameIcon(UIManager.getIcon("InternalFrame.icon"));
        Container container = this.frame.getContentPane();
        if (container != null && container.getBackground() instanceof UIResource) {
            container.setBackground(null);
        }
    }

    protected void installKeyboardActions() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("showSystemMenu", new ShowSystemMenuAction());
        BasicLookAndFeel basicLookAndFeel = (BasicLookAndFeel)UIManager.getLookAndFeel();
        ActionMap actionMap = basicLookAndFeel.getAudioActionMap();
        actionMapUIResource.setParent(actionMap);
        SwingUtilities.replaceUIActionMap(this.frame, actionMapUIResource);
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this.frame));
        this.setSouthPane(this.createSouthPane(this.frame));
        this.setEastPane(this.createEastPane(this.frame));
        this.setWestPane(this.createWestPane(this.frame));
    }

    protected void installListeners() {
        this.glassPaneDispatcher = this.createGlassPaneDispatcher();
        this.createInternalFrameListener();
        this.borderListener = this.createBorderListener(this.frame);
        this.componentListener = this.createComponentListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.frame.addMouseListener(this.borderListener);
        this.frame.addMouseMotionListener(this.borderListener);
        this.frame.addInternalFrameListener(this.internalFrameListener);
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
        this.frame.getRootPane().getGlassPane().addMouseListener(this.glassPaneDispatcher);
        this.frame.getRootPane().getGlassPane().addMouseMotionListener(this.glassPaneDispatcher);
        Container container = this.frame.getParent();
        if (container != null) {
            container.addComponentListener(this.componentListener);
        }
    }

    protected void uninstallDefaults() {
        this.frame.setBorder(null);
        this.frame.setLayout(null);
        this.internalFrameLayout = null;
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
    }

    protected void uninstallListeners() {
        Container container = this.frame.getParent();
        if (container != null) {
            container.removeComponentListener(this.componentListener);
        }
        this.componentListener = null;
        this.frame.getRootPane().getGlassPane().removeMouseMotionListener(this.glassPaneDispatcher);
        this.frame.getRootPane().getGlassPane().removeMouseListener(this.glassPaneDispatcher);
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
        this.frame.removeInternalFrameListener(this.internalFrameListener);
        this.frame.removeMouseMotionListener(this.borderListener);
        this.frame.removeMouseListener(this.borderListener);
        this.propertyChangeListener = null;
        this.borderListener = null;
        this.internalFrameListener = null;
        this.glassPaneDispatcher = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.frame, null);
        SwingUtilities.replaceUIInputMap(this.frame, 2, null);
    }

    protected LayoutManager createLayoutManager() {
        return new InternalFrameLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new InternalFramePropertyChangeListener();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = null;
        LayoutManager layoutManager = this.frame.getLayout();
        dimension = this.frame == jComponent && layoutManager != null ? layoutManager.preferredLayoutSize(this.frame) : new Dimension(100, 100);
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        LayoutManager layoutManager = this.frame.getLayout();
        dimension = this.frame == jComponent && layoutManager != null ? layoutManager.minimumLayoutSize(this.frame) : new Dimension(0, 0);
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        LayoutManager layoutManager = this.frame.getLayout();
        dimension = this.frame == jComponent && layoutManager != null && layoutManager instanceof LayoutManager2 ? ((LayoutManager2)layoutManager).maximumLayoutSize(this.frame) : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        return dimension;
    }

    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        if (jComponent != null) {
            this.deinstallMouseHandlers(jComponent);
            this.frame.remove(jComponent);
        }
        if (jComponent2 != null) {
            this.installMouseHandlers(jComponent2);
            this.frame.add(jComponent2);
        }
    }

    protected void deinstallMouseHandlers(JComponent jComponent) {
        jComponent.removeMouseListener(this.borderListener);
        jComponent.removeMouseMotionListener(this.borderListener);
    }

    protected void installMouseHandlers(JComponent jComponent) {
        jComponent.addMouseListener(this.borderListener);
        jComponent.addMouseMotionListener(this.borderListener);
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new BasicInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    protected JComponent createWestPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createSouthPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createEastPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected MouseInputAdapter createBorderListener(JInternalFrame jInternalFrame) {
        return new BorderListener();
    }

    protected void createInternalFrameListener() {
        this.internalFrameListener = new BasicInternalFrameListener();
    }

    protected final boolean isKeyBindingRegistered() {
        return false;
    }

    protected final void setKeyBindingRegistered(boolean bl) {
    }

    public final boolean isKeyBindingActive() {
        return false;
    }

    protected final void setKeyBindingActive(boolean bl) {
    }

    protected void setupMenuOpenKey() {
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this.northPane;
    }

    public void setNorthPane(JComponent jComponent) {
        this.replacePane(this.northPane, jComponent);
        this.northPane = jComponent;
        if (jComponent instanceof BasicInternalFrameTitlePane) {
            this.titlePane = (BasicInternalFrameTitlePane)jComponent;
        }
    }

    public JComponent getSouthPane() {
        return this.southPane;
    }

    public void setSouthPane(JComponent jComponent) {
        this.replacePane(this.southPane, jComponent);
        this.southPane = jComponent;
    }

    public void setEastPane(JComponent jComponent) {
        this.replacePane(this.eastPane, jComponent);
        this.eastPane = jComponent;
    }

    public JComponent getEastPane() {
        return this.eastPane;
    }

    public void setWestPane(JComponent jComponent) {
        this.replacePane(this.westPane, jComponent);
        this.westPane = jComponent;
    }

    public JComponent getWestPane() {
        return this.westPane;
    }

    protected DesktopManager getDesktopManager() {
        DesktopManager desktopManager = null;
        JDesktopPane jDesktopPane = this.frame.getDesktopPane();
        if (jDesktopPane != null) {
            desktopManager = this.frame.getDesktopPane().getDesktopManager();
        }
        if (desktopManager == null) {
            desktopManager = this.createDesktopManager();
        }
        return desktopManager;
    }

    protected DesktopManager createDesktopManager() {
        return new DefaultDesktopManager();
    }

    protected void closeFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().closeFrame(jInternalFrame);
    }

    protected void maximizeFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().maximizeFrame(jInternalFrame);
    }

    protected void minimizeFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().minimizeFrame(jInternalFrame);
    }

    protected void iconifyFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().iconifyFrame(jInternalFrame);
    }

    protected void deiconifyFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().deiconifyFrame(jInternalFrame);
    }

    protected void activateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().activateFrame(jInternalFrame);
    }

    protected void deactivateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().deactivateFrame(jInternalFrame);
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected MouseInputListener createGlassPaneDispatcher() {
        return new GlassPaneDispatcher();
    }

    private class ShowSystemMenuAction
    extends AbstractAction {
        private ShowSystemMenuAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicInternalFrameUI.this.titlePane != null) {
                BasicInternalFrameUI.this.titlePane.showSystemMenu();
            }
        }
    }

    class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        static final int bSize = 5;
        static final int cornerSize = 10;

        InternalFrameBorder() {
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(5, 5, 5, 5);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            Color color = graphics.getColor();
            Rectangle rectangle = BasicInternalFrameUI.this.frame.getBounds();
            Color color2 = component.getBackground();
            graphics.setColor(color2);
            graphics.fillRect(0, 0, 5, rectangle.height);
            graphics.fillRect(0, 0, rectangle.width, 5);
            graphics.fillRect(0, rectangle.height - 5, rectangle.width, 5);
            graphics.fillRect(rectangle.width - 5, 0, 5, rectangle.height);
            boolean bl = false;
            int n5 = 5;
            int n6 = rectangle.width - 5;
            int n7 = rectangle.width;
            boolean bl2 = false;
            int n8 = 5;
            int n9 = rectangle.height - 5;
            int n10 = rectangle.height;
            graphics.setColor(Color.GRAY);
            graphics.fillRect(0, 0, 5, n10);
            graphics.fillRect(0, 0, n7, 5);
            graphics.fillRect(0, n9, rectangle.width, 5);
            graphics.fillRect(n6, 0, 5, rectangle.height);
            graphics.fill3DRect(0, 10, 5, rectangle.height - 20, false);
            graphics.fill3DRect(10, 0, rectangle.width - 20, 5, false);
            graphics.fill3DRect(10, rectangle.height - 5, rectangle.width - 20, 5, false);
            graphics.fill3DRect(rectangle.width - 5, 10, 5, rectangle.height - 20, false);
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }
    }

    public class InternalFramePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("maximum")) {
                if (BasicInternalFrameUI.this.frame.isMaximum()) {
                    BasicInternalFrameUI.this.maximizeFrame(BasicInternalFrameUI.this.frame);
                } else {
                    BasicInternalFrameUI.this.minimizeFrame(BasicInternalFrameUI.this.frame);
                }
            } else if (string.equals("icon")) {
                if (BasicInternalFrameUI.this.frame.isIcon()) {
                    BasicInternalFrameUI.this.iconifyFrame(BasicInternalFrameUI.this.frame);
                } else {
                    BasicInternalFrameUI.this.deiconifyFrame(BasicInternalFrameUI.this.frame);
                }
            } else if (string.equals("selected")) {
                Component component = BasicInternalFrameUI.this.frame.getGlassPane();
                if (BasicInternalFrameUI.this.frame.isSelected()) {
                    BasicInternalFrameUI.this.activateFrame(BasicInternalFrameUI.this.frame);
                    component.setVisible(false);
                } else {
                    BasicInternalFrameUI.this.deactivateFrame(BasicInternalFrameUI.this.frame);
                    component.setVisible(true);
                }
            } else if (string.equals("rootPane") || string.equals("glassPane")) {
                Component component;
                Component component2 = (Component)propertyChangeEvent.getOldValue();
                if (component2 != null) {
                    component2.removeMouseListener(BasicInternalFrameUI.this.glassPaneDispatcher);
                    component2.removeMouseMotionListener(BasicInternalFrameUI.this.glassPaneDispatcher);
                }
                if ((component = (Component)propertyChangeEvent.getNewValue()) != null) {
                    component.addMouseListener(BasicInternalFrameUI.this.glassPaneDispatcher);
                    component.addMouseMotionListener(BasicInternalFrameUI.this.glassPaneDispatcher);
                }
                BasicInternalFrameUI.this.frame.revalidate();
            } else if (string.equals("closed")) {
                if (propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    Container container = BasicInternalFrameUI.this.frame.getParent();
                    if (container != null) {
                        container.removeComponentListener(BasicInternalFrameUI.this.componentListener);
                    }
                    BasicInternalFrameUI.this.closeFrame(BasicInternalFrameUI.this.frame);
                }
            } else if (string.equals("ancestor")) {
                Container container = (Container)propertyChangeEvent.getNewValue();
                Container container2 = (Container)propertyChangeEvent.getOldValue();
                if (container != null) {
                    container.addComponentListener(BasicInternalFrameUI.this.componentListener);
                } else if (container2 != null) {
                    container2.removeComponentListener(BasicInternalFrameUI.this.componentListener);
                }
            }
        }
    }

    protected class GlassPaneDispatcher
    implements MouseInputListener {
        private transient Component mouseEventTarget;
        private Component dragTarget;
        private boolean isDragging;

        protected GlassPaneDispatcher() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (BasicInternalFrameUI.this.borderListener != null) {
                BasicInternalFrameUI.this.borderListener.mousePressed(mouseEvent);
            }
            this.handleEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        private void handleEvent(MouseEvent mouseEvent) {
            Component component;
            for (component = BasicInternalFrameUI.this.frame.getLayeredPane().findComponentAt(mouseEvent.getX(), mouseEvent.getY()); component != null && component.getMouseListeners().length == 0 && component.getMouseMotionListeners().length == 0 && component.getMouseWheelListeners().length == 0; component = component.getParent()) {
            }
            if (component != null) {
                int n = mouseEvent.getID();
                switch (n) {
                    case 504: {
                        if (this.isDragging && !BasicInternalFrameUI.this.frame.isSelected()) break;
                        this.mouseEventTarget = component;
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    case 505: {
                        if (this.isDragging && !BasicInternalFrameUI.this.frame.isSelected()) break;
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    case 501: {
                        this.mouseEventTarget = component;
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        this.dragTarget = component;
                        break;
                    }
                    case 502: {
                        if (this.isDragging) {
                            this.redispatch(n, mouseEvent, this.dragTarget);
                            this.isDragging = false;
                            break;
                        }
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    case 500: {
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    case 503: {
                        if (component != this.mouseEventTarget) {
                            this.redispatch(505, mouseEvent, this.mouseEventTarget);
                            this.mouseEventTarget = component;
                            this.redispatch(504, mouseEvent, this.mouseEventTarget);
                        }
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    case 506: {
                        if (!this.isDragging) {
                            this.isDragging = true;
                        }
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    case 507: {
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    default: {
                        assert (false) : "Must not reach here";
                        break;
                    }
                }
            }
        }

        private void redispatch(int n, MouseEvent mouseEvent, Component component) {
            Point point = SwingUtilities.convertPoint(BasicInternalFrameUI.this.frame.getLayeredPane(), mouseEvent.getX(), mouseEvent.getY(), component);
            MouseEvent mouseEvent2 = new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers() | mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            component.dispatchEvent(mouseEvent2);
        }
    }

    public class InternalFrameLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Dimension dimension2;
            Dimension dimension3 = BasicInternalFrameUI.this.frame.getSize();
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            dimension3.width -= insets.left + insets.right;
            dimension3.height -= insets.top + insets.bottom;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (BasicInternalFrameUI.this.northPane != null) {
                dimension2 = BasicInternalFrameUI.this.northPane.getPreferredSize();
                n = Math.min(dimension2.height, dimension3.height);
                BasicInternalFrameUI.this.northPane.setBounds(insets.left, insets.top, dimension3.width, n);
            }
            if (BasicInternalFrameUI.this.southPane != null) {
                dimension2 = BasicInternalFrameUI.this.southPane.getPreferredSize();
                n2 = Math.min(dimension2.height, dimension3.height - n);
                BasicInternalFrameUI.this.southPane.setBounds(insets.left, insets.top + dimension3.height - n2, dimension3.width, n2);
            }
            int n5 = dimension3.height - n2 - n;
            if (BasicInternalFrameUI.this.westPane != null) {
                dimension = BasicInternalFrameUI.this.westPane.getPreferredSize();
                n4 = Math.min(dimension3.width, dimension.width);
                BasicInternalFrameUI.this.westPane.setBounds(insets.left, insets.top + n, n4, n5);
            }
            if (BasicInternalFrameUI.this.eastPane != null) {
                dimension = BasicInternalFrameUI.this.eastPane.getPreferredSize();
                n3 = Math.min(dimension.width, dimension3.width - n4);
                BasicInternalFrameUI.this.eastPane.setBounds(insets.left + dimension3.width - n3, insets.top + n, n3, n5);
            }
            int n6 = dimension3.width - n4 - n3;
            BasicInternalFrameUI.this.frame.getRootPane().setBounds(insets.left + n4, insets.top + n, n6, n5);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.getSize(container, true);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.getSize(container, false);
        }

        private Dimension getSize(Container container, boolean bl) {
            Dimension dimension;
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            Dimension dimension2 = BasicInternalFrameUI.this.frame.getContentPane().getPreferredSize();
            if (bl) {
                dimension2.height = 0;
                dimension2.width = 0;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if (BasicInternalFrameUI.this.northPane != null && (dimension = BasicInternalFrameUI.this.northPane.getPreferredSize()) != null) {
                n = dimension.width;
                n2 = dimension.height;
            }
            if (BasicInternalFrameUI.this.southPane != null && (dimension = BasicInternalFrameUI.this.southPane.getPreferredSize()) != null) {
                n3 = dimension.width;
                n4 = dimension.height;
            }
            if (BasicInternalFrameUI.this.eastPane != null && (dimension = BasicInternalFrameUI.this.eastPane.getPreferredSize()) != null) {
                n3 = dimension.width;
                n4 = dimension.height;
            }
            if (BasicInternalFrameUI.this.westPane != null && (dimension = BasicInternalFrameUI.this.westPane.getPreferredSize()) != null) {
                n7 = dimension.width;
                n8 = dimension.height;
            }
            int n9 = Math.max(n3, n);
            n9 = Math.max(n9, dimension2.width + n5 + n7);
            int n10 = Math.max(n6, n8);
            n10 = Math.max(n10, dimension2.height);
            n10 += n2 + n4;
            return new Dimension(n9 += insets.left + insets.right, n10 += insets.top + insets.bottom);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    protected class ComponentHandler
    implements ComponentListener {
        protected ComponentHandler() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (BasicInternalFrameUI.this.frame.isMaximum()) {
                Container container = BasicInternalFrameUI.this.frame.getParent();
                Insets insets = container.getInsets();
                int n = container.getWidth() - insets.left - insets.right;
                int n2 = container.getHeight() - insets.top - insets.bottom;
                BasicInternalFrameUI.this.frame.setBounds(0, 0, n, n2);
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }

    protected class BorderListener
    extends MouseInputAdapter
    implements SwingConstants {
        transient int showingCursor;
        protected final int RESIZE_NONE = 0;
        private transient int xOffset;
        private transient int yOffset;
        private transient int direction = -1;
        private transient Rectangle cacheRect = new Rectangle();

        protected BorderListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == BasicInternalFrameUI.this.titlePane && mouseEvent.getClickCount() == 2) {
                try {
                    if (BasicInternalFrameUI.this.frame.isMaximizable() && !BasicInternalFrameUI.this.frame.isMaximum()) {
                        BasicInternalFrameUI.this.frame.setMaximum(true);
                    } else if (BasicInternalFrameUI.this.frame.isMaximum()) {
                        BasicInternalFrameUI.this.frame.setMaximum(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (BasicInternalFrameUI.this.frame.isMaximum()) {
                return;
            }
            DesktopManager desktopManager = BasicInternalFrameUI.this.getDesktopManager();
            Rectangle rectangle = BasicInternalFrameUI.this.frame.getBounds();
            Dimension dimension = BasicInternalFrameUI.this.frame.getMinimumSize();
            if (dimension == null) {
                dimension = new Dimension(0, 0);
            }
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (mouseEvent.getSource() == BasicInternalFrameUI.this.frame && BasicInternalFrameUI.this.frame.isResizable()) {
                switch (this.direction) {
                    case 8: {
                        this.cacheRect.setBounds(rectangle.x, Math.min(rectangle.y + n2, rectangle.y + rectangle.height - dimension.height), rectangle.width, rectangle.height - n2);
                        break;
                    }
                    case 7: {
                        this.cacheRect.setBounds(rectangle.x, Math.min(rectangle.y + n2, rectangle.y + rectangle.height - dimension.height), n + 1, rectangle.height - n2);
                        break;
                    }
                    case 11: {
                        this.cacheRect.setBounds(rectangle.x, rectangle.y, n + 1, rectangle.height);
                        break;
                    }
                    case 5: {
                        this.cacheRect.setBounds(rectangle.x, rectangle.y, n + 1, n2 + 1);
                        break;
                    }
                    case 9: {
                        this.cacheRect.setBounds(rectangle.x, rectangle.y, rectangle.width, n2 + 1);
                        break;
                    }
                    case 4: {
                        this.cacheRect.setBounds(Math.min(rectangle.x + n, rectangle.x + rectangle.width - dimension.width), rectangle.y, rectangle.width - n, n2 + 1);
                        break;
                    }
                    case 10: {
                        this.cacheRect.setBounds(Math.min(rectangle.x + n, rectangle.x + rectangle.width - dimension.width), rectangle.y, rectangle.width - n, rectangle.height);
                        break;
                    }
                    case 6: {
                        this.cacheRect.setBounds(Math.min(rectangle.x + n, rectangle.x + rectangle.width - dimension.width), Math.min(rectangle.y + n2, rectangle.y + rectangle.height - dimension.height), rectangle.width - n, rectangle.height - n2);
                    }
                }
                desktopManager.resizeFrame(BasicInternalFrameUI.this.frame, this.cacheRect.x, this.cacheRect.y, Math.max(dimension.width, this.cacheRect.width), Math.max(dimension.height, this.cacheRect.height));
                this.setCursor(mouseEvent);
            } else if (mouseEvent.getSource() == BasicInternalFrameUI.this.titlePane) {
                Rectangle rectangle2 = BasicInternalFrameUI.this.frame.getBounds();
                BasicInternalFrameUI.this.frame.putClientProperty("bufferedDragging", Boolean.TRUE);
                desktopManager.dragFrame(BasicInternalFrameUI.this.frame, mouseEvent.getX() - this.xOffset + rectangle.x, mouseEvent.getY() - this.yOffset + rectangle.y);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.showingCursor != 0) {
                BasicInternalFrameUI.this.frame.setCursor(Cursor.getDefaultCursor());
                this.showingCursor = 0;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.showingCursor != 0 && mouseEvent.getSource() != BasicInternalFrameUI.this.frame) {
                BasicInternalFrameUI.this.frame.setCursor(Cursor.getDefaultCursor());
                this.showingCursor = 0;
            } else if (mouseEvent.getSource() == BasicInternalFrameUI.this.frame && BasicInternalFrameUI.this.frame.isResizable()) {
                this.setCursor(mouseEvent);
            }
        }

        void setCursor(MouseEvent mouseEvent) {
            int n = this.sectionOfClick(mouseEvent.getX(), mouseEvent.getY());
            if (n != this.showingCursor) {
                Cursor cursor = Cursor.getPredefinedCursor(n);
                BasicInternalFrameUI.this.frame.setCursor(cursor);
                this.showingCursor = n;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BasicInternalFrameUI.this.activateFrame(BasicInternalFrameUI.this.frame);
            DesktopManager desktopManager = BasicInternalFrameUI.this.getDesktopManager();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            if (mouseEvent.getSource() == BasicInternalFrameUI.this.frame && BasicInternalFrameUI.this.frame.isResizable()) {
                this.direction = this.sectionOfClick(n, n2);
                desktopManager.beginResizingFrame(BasicInternalFrameUI.this.frame, this.direction);
            } else if (mouseEvent.getSource() == BasicInternalFrameUI.this.titlePane) {
                Rectangle rectangle = BasicInternalFrameUI.this.titlePane.getBounds();
                this.xOffset = mouseEvent.getX() - rectangle.x + insets.left;
                this.yOffset = mouseEvent.getY() - rectangle.y + insets.top;
                desktopManager.beginDraggingFrame(BasicInternalFrameUI.this.frame);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DesktopManager desktopManager = BasicInternalFrameUI.this.getDesktopManager();
            this.xOffset = 0;
            this.yOffset = 0;
            if (mouseEvent.getSource() == BasicInternalFrameUI.this.frame && BasicInternalFrameUI.this.frame.isResizable()) {
                desktopManager.endResizingFrame(BasicInternalFrameUI.this.frame);
            } else if (mouseEvent.getSource() == BasicInternalFrameUI.this.titlePane) {
                desktopManager.endDraggingFrame(BasicInternalFrameUI.this.frame);
                BasicInternalFrameUI.this.frame.putClientProperty("bufferedDragging", null);
            }
            this.setCursor(mouseEvent);
        }

        private int sectionOfClick(int n, int n2) {
            Rectangle rectangle = BasicInternalFrameUI.this.frame.getBounds();
            int n3 = 10;
            if (n < n3 && n2 < n3) {
                return 6;
            }
            if (n > rectangle.width - n3 && n2 < n3) {
                return 7;
            }
            if (n > rectangle.width - n3 && n2 > rectangle.height - n3) {
                return 5;
            }
            if (n < n3 && n2 > rectangle.height - n3) {
                return 4;
            }
            if (n2 < n3) {
                return 8;
            }
            if (n < n3) {
                return 10;
            }
            if (n2 > rectangle.height - n3) {
                return 9;
            }
            if (n > rectangle.width - n3) {
                return 11;
            }
            return 0;
        }
    }

    protected class BasicInternalFrameListener
    implements InternalFrameListener {
        protected BasicInternalFrameListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            BasicInternalFrameUI.this.frame.getGlassPane().setVisible(false);
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            BasicInternalFrameUI.this.frame.getGlassPane().setVisible(true);
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }
    }
}

