/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.SystemProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonUI;

public class BasicGraphicsUtils {
    static final String CACHED_TEXT_LAYOUT = "BasicGraphicsUtils.cachedTextLayout";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawEtchedRect(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4) {
        Color color5 = graphics.getColor();
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        try {
            graphics.setColor(color);
            graphics.drawLine(n, n2, n5 - 1, n2);
            graphics.drawLine(n, n2 + 1, n, n6 - 1);
            graphics.setColor(color2);
            graphics.drawLine(n + 1, n2 + 1, n5 - 2, n2 + 1);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n6 - 2);
            graphics.setColor(color3);
            graphics.drawLine(n + 1, n6 - 1, n5 - 1, n6 - 1);
            graphics.drawLine(n5 - 1, n2 + 1, n5 - 1, n6 - 2);
            graphics.setColor(color4);
            graphics.drawLine(n, n6, n5, n6);
            graphics.drawLine(n5, n2, n5, n6 - 1);
            Object var13_12 = null;
            graphics.setColor(color5);
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            graphics.setColor(color5);
            throw throwable;
        }
    }

    public static Insets getEtchedInsets() {
        return new Insets(2, 2, 2, 2);
    }

    public static void drawGroove(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        BasicGraphicsUtils.drawEtchedRect(graphics, n, n2, n3, n4, color, color2, color, color2);
    }

    public static Insets getGrooveInsets() {
        return new Insets(2, 2, 2, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawBezel(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2, Color color, Color color2, Color color3, Color color4) {
        Color color5 = graphics.getColor();
        try {
            if (!bl && !bl2) {
                BasicGraphicsUtils.drawEtchedRect(graphics, n, n2, n3, n4, color4, color3, color, color2);
            }
            if (bl && !bl2) {
                graphics.setColor(color);
                graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
            }
            if (!bl && bl2) {
                graphics.setColor(color2);
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                BasicGraphicsUtils.drawEtchedRect(graphics, n + 1, n2 + 1, n3 - 2, n4 - 2, color4, color3, color, color2);
            }
            if (bl && bl2) {
                graphics.setColor(color2);
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                graphics.setColor(color);
                graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
            }
            Object var13_12 = null;
            graphics.setColor(color5);
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            graphics.setColor(color5);
            throw throwable;
        }
    }

    public static void drawLoweredBezel(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4) {
        BasicGraphicsUtils.drawEtchedRect(graphics, n, n2, n3, n4, color2, color, color3, color4);
    }

    public static void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = -1;
        if (n >= 0 || n <= 65535) {
            n4 = string.toLowerCase().indexOf(Character.toLowerCase((char)n));
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, n2, n3);
    }

    public static void drawStringUnderlineCharAt(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = string.length();
        if (n4 == 0) {
            return;
        }
        boolean bl = n >= 0 && n < n4;
        graphics.drawString(string, n2, n3);
        if (bl) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.fillRect(n2 + fontMetrics.stringWidth(string.substring(0, n)), n3 + fontMetrics.getDescent() - 1, fontMetrics.charWidth(string.charAt(n)), 1);
        }
    }

    static void drawString(JComponent jComponent, Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = -1;
        if (n >= 0 || n <= 65535) {
            n4 = string.toLowerCase().indexOf(Character.toLowerCase((char)n));
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(jComponent, graphics, string, n4, n2, n3);
    }

    static void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n, int n2, int n3) {
        boolean bl;
        int n4 = string.length();
        if (n4 == 0) {
            return;
        }
        boolean bl2 = bl = n >= 0 && n < n4;
        if (!(graphics instanceof Graphics2D) || SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") != null) {
            graphics.drawString(string, n2, n3);
            if (bl) {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                graphics.fillRect(n2 + fontMetrics.stringWidth(string.substring(0, n)), n3 + 1, fontMetrics.charWidth(string.charAt(n)), 1);
            }
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        TextLayout textLayout = (TextLayout)jComponent.getClientProperty(CACHED_TEXT_LAYOUT);
        if (textLayout == null) {
            textLayout = new TextLayout(string, font, fontRenderContext);
            System.err.println("Unable to use cached TextLayout for: " + string);
        }
        textLayout.draw(graphics2D, n2, n3);
        if (!bl) {
            return;
        }
        double d = (double)n2 + textLayout.getLogicalHighlightShape(n, n).getBounds2D().getX();
        double d2 = (double)n2 + textLayout.getLogicalHighlightShape(n + 1, n + 1).getBounds2D().getX();
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (d < d2) {
            double_.x = d;
            double_.width = d2 - d;
        } else {
            double_.x = d2;
            double_.width = d - d2;
        }
        double_.height = lineMetrics.getUnderlineThickness();
        double_.y = lineMetrics.getUnderlineOffset();
        if (double_.y == 0.0) {
            double_.y = lineMetrics.getDescent();
        }
        double_.y += (double)n3;
        graphics2D.fill(double_);
    }

    public static void drawDashedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n + n3 - 1;
        int n7 = n2 + n4 - 1;
        for (n5 = n; n5 <= n6; n5 += 2) {
            graphics.drawLine(n5, n2, n5, n2);
            graphics.drawLine(n5, n7, n5, n7);
        }
        for (n5 = n2; n5 <= n7; n5 += 2) {
            graphics.drawLine(n, n5, n, n5);
            graphics.drawLine(n6, n5, n6, n5);
        }
    }

    public static Dimension getPreferredButtonSize(AbstractButton abstractButton, int n) {
        Rectangle rectangle = BasicButtonUI.viewR;
        rectangle.x = 0;
        rectangle.y = 0;
        rectangle.width = Short.MAX_VALUE;
        rectangle.height = Short.MAX_VALUE;
        Rectangle rectangle2 = BasicButtonUI.iconR;
        rectangle2.x = 0;
        rectangle2.y = 0;
        rectangle2.width = 0;
        rectangle2.height = 0;
        Rectangle rectangle3 = BasicButtonUI.textR;
        rectangle3.x = 0;
        rectangle3.y = 0;
        rectangle3.width = 0;
        rectangle3.height = 0;
        SwingUtilities.layoutCompoundLabel(abstractButton, abstractButton.getFontMetrics(abstractButton.getFont()), abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, n);
        Rectangle rectangle4 = SwingUtilities.computeUnion(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle2);
        Insets insets = abstractButton.getInsets();
        return new Dimension(insets.left + rectangle4.width + insets.right, insets.top + rectangle4.height + insets.bottom);
    }
}

