/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private Vector contents;
    private Vector directories;
    private Vector files;
    private int listingMode;
    private JFileChooser filechooser;
    private DirectoryLoadThread loadThread;
    private Comparator comparator = new Comparator(){

        public int compare(Object object, Object object2) {
            if (BasicDirectoryModel.this.lt((File)object, (File)object2)) {
                return -1;
            }
            return 1;
        }
    };

    public BasicDirectoryModel(JFileChooser jFileChooser) {
        this.filechooser = jFileChooser;
        jFileChooser.addPropertyChangeListener(this);
        this.listingMode = jFileChooser.getFileSelectionMode();
        this.contents = new Vector();
        this.validateFileCache();
    }

    public boolean contains(Object object) {
        return this.contents.contains(object);
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getDirectories() {
        Vector vector = this.contents;
        synchronized (vector) {
            Vector vector2 = this.directories;
            if (vector2 == null) {
                this.getFiles();
                vector2 = this.directories;
            }
            return vector2;
        }
    }

    @Override
    public Object getElementAt(int n) {
        if (n > this.getSize() - 1) {
            return null;
        }
        return this.contents.elementAt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getFiles() {
        Vector vector = this.contents;
        synchronized (vector) {
            Vector<File> vector2 = this.files;
            if (vector2 == null) {
                vector2 = new Vector<File>();
                Vector<File> vector3 = new Vector<File>();
                for (File file : this.contents) {
                    if (this.filechooser.isTraversable(file)) {
                        vector3.add(file);
                        continue;
                    }
                    vector2.add(file);
                }
                this.files = vector2;
                this.directories = vector3;
            }
            return vector2;
        }
    }

    @Override
    public int getSize() {
        return this.contents.size();
    }

    public int indexOf(Object object) {
        return this.contents.indexOf(object);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public void invalidateFileCache() {
    }

    protected boolean lt(File file, File file2) {
        boolean bl;
        boolean bl2 = this.filechooser.isTraversable(file);
        if (bl2 == (bl = this.filechooser.isTraversable(file2))) {
            String string;
            String string2 = file.getName().toLowerCase();
            return string2.compareTo(string = file2.getName().toLowerCase()) < 0;
        }
        return bl2;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("directoryChanged") || string.equals("fileFilterChanged") || string.equals("FileHidingChanged") || string.equals("fileSelectionChanged") || string.equals("fileViewChanged")) {
            this.validateFileCache();
        }
    }

    public boolean renameFile(File file, File file2) {
        return file.renameTo(file2);
    }

    protected void sort(Vector<? extends File> vector) {
        Collections.sort(vector, this.comparator);
    }

    public void validateFileCache() {
        File file = this.filechooser.getCurrentDirectory();
        if (file != null) {
            if (this.loadThread != null) {
                this.loadThread.interrupt();
                this.loadThread.cancelPending();
            }
            this.loadThread = new DirectoryLoadThread(file);
            this.loadThread.start();
        }
    }

    private class DirectoryLoadThread
    extends Thread {
        File directory;
        private UpdateSwingRequest pending;

        DirectoryLoadThread(File file) {
            super("Basic L&F directory loader");
            this.directory = file;
        }

        public void run() {
            int n;
            int n2;
            FileSystemView fileSystemView = BasicDirectoryModel.this.filechooser.getFileSystemView();
            File[] fileArray = fileSystemView.getFiles(this.directory, BasicDirectoryModel.this.filechooser.isFileHidingEnabled());
            if (this.isInterrupted()) {
                return;
            }
            Vector<File> vector = new Vector<File>();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!BasicDirectoryModel.this.filechooser.accept(fileArray[i])) continue;
                vector.add(fileArray[i]);
            }
            if (this.isInterrupted()) {
                return;
            }
            BasicDirectoryModel.this.sort(vector);
            Vector<File> vector2 = new Vector<File>();
            Vector<File> vector3 = new Vector<File>();
            for (File file : vector) {
                n2 = BasicDirectoryModel.this.filechooser.isTraversable(file);
                if (n2 != 0) {
                    vector3.add(file);
                } else if (n2 == 0 && BasicDirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                    vector2.add(file);
                }
                if (!this.isInterrupted()) continue;
                return;
            }
            Object object = new Vector(vector3);
            ((Vector)object).addAll(vector2);
            int n3 = ((Vector)object).size();
            n2 = BasicDirectoryModel.this.contents.size();
            if (n3 < n2) {
                n = -1;
                int n4 = -1;
                boolean bl = false;
                for (int i = 0; i < n3 && !bl; ++i) {
                    if (((Vector)object).get(i).equals(BasicDirectoryModel.this.contents.get(i))) continue;
                    n = i;
                    n4 = i + n2 - n3;
                    bl = true;
                }
                if (n >= 0 && n4 > n && BasicDirectoryModel.this.contents.subList(n4, n2).equals(((Vector)object).subList(n, n3))) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    Vector vector4 = new Vector(BasicDirectoryModel.this.contents.subList(n, n4));
                    UpdateSwingRequest updateSwingRequest = new UpdateSwingRequest(null, 0, vector4, n);
                    this.invokeLater(updateSwingRequest);
                    object = null;
                }
            } else if (n3 > n2) {
                n = n2;
                int n5 = n3;
                boolean bl = false;
                for (int i = 0; i < n2 && !bl; ++i) {
                    if (((Vector)object).get(i).equals(BasicDirectoryModel.this.contents.get(i))) continue;
                    n = i;
                    boolean bl2 = false;
                    for (int j = i; j < n3 && !bl2; ++j) {
                        if (!((Vector)object).get(j).equals(BasicDirectoryModel.this.contents.get(i))) continue;
                        n5 = j;
                        bl2 = true;
                    }
                    n5 = i + n2 - n3;
                }
                if (n >= 0 && n5 > n && ((Vector)object).subList(n5, n3).equals(BasicDirectoryModel.this.contents.subList(n, n2))) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    List list2 = ((Vector)object).subList(n, n5);
                    UpdateSwingRequest updateSwingRequest = new UpdateSwingRequest(list2, n, null, 0);
                    this.invokeLater(updateSwingRequest);
                    object = null;
                }
            }
            if (object != null && !BasicDirectoryModel.this.contents.equals(object)) {
                if (this.isInterrupted()) {
                    return;
                }
                UpdateSwingRequest updateSwingRequest = new UpdateSwingRequest((List)object, 0, BasicDirectoryModel.this.contents, 0);
                this.invokeLater(updateSwingRequest);
            }
        }

        private void invokeLater(UpdateSwingRequest updateSwingRequest) {
            this.pending = updateSwingRequest;
            SwingUtilities.invokeLater(updateSwingRequest);
        }

        void cancelPending() {
            if (this.pending != null) {
                this.pending.cancel();
            }
        }

        private class UpdateSwingRequest
        implements Runnable {
            private List added;
            private int addIndex;
            private List removed;
            private int removeIndex;
            private boolean cancel;

            UpdateSwingRequest(List list2, int n, List list3, int n2) {
                this.added = list2;
                this.addIndex = n;
                this.removed = list3;
                this.removeIndex = n2;
                this.cancel = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!this.cancel) {
                    int n = this.removed == null ? 0 : this.removed.size();
                    int n2 = this.added == null ? 0 : this.added.size();
                    Vector vector = BasicDirectoryModel.this.contents;
                    synchronized (vector) {
                        if (n > 0) {
                            BasicDirectoryModel.this.contents.removeAll(this.removed);
                        }
                        if (n2 > 0) {
                            BasicDirectoryModel.this.contents.addAll(this.added);
                        }
                        BasicDirectoryModel.this.files = null;
                        BasicDirectoryModel.this.directories = null;
                    }
                    if (n > 0 && n2 == 0) {
                        BasicDirectoryModel.this.fireIntervalRemoved(BasicDirectoryModel.this, this.removeIndex, this.removeIndex + n - 1);
                    } else if (n == 0 && n2 > 0) {
                        BasicDirectoryModel.this.fireIntervalAdded(BasicDirectoryModel.this, this.addIndex, this.addIndex + n2 - 1);
                    } else {
                        BasicDirectoryModel.this.fireContentsChanged();
                    }
                }
            }

            void cancel() {
                this.cancel = true;
            }
        }
    }
}

