/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.SystemProperties;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicHTML;

public class BasicButtonListener
implements MouseListener,
MouseMotionListener,
FocusListener,
ChangeListener,
PropertyChangeListener {
    public BasicButtonListener(AbstractButton abstractButton) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
        if ((string.equals("text") || string.equals("font")) && SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") == null) {
            String string2 = abstractButton.getText();
            if (string2 == null) {
                string2 = "";
            }
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
            TextLayout textLayout = new TextLayout(string2, abstractButton.getFont(), fontRenderContext);
            abstractButton.putClientProperty("BasicGraphicsUtils.cachedTextLayout", textLayout);
            BasicHTML.updateRenderer(abstractButton, abstractButton.getText());
        } else if (string.equals("contentAreaFilled")) {
            this.checkOpacity(abstractButton);
        }
    }

    protected void checkOpacity(AbstractButton abstractButton) {
        abstractButton.setOpaque(abstractButton.isContentAreaFilled());
    }

    public void focusGained(FocusEvent focusEvent) {
        AbstractButton abstractButton;
        if (focusEvent.getSource() instanceof AbstractButton && (abstractButton = (AbstractButton)focusEvent.getSource()).isFocusPainted()) {
            abstractButton.repaint();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        AbstractButton abstractButton;
        if (focusEvent.getSource() instanceof AbstractButton && (abstractButton = (AbstractButton)focusEvent.getSource()).isFocusPainted()) {
            abstractButton.repaint();
        }
    }

    public void installKeyboardActions(JComponent jComponent) {
        ButtonUI buttonUI = ((AbstractButton)jComponent).getUI();
        if (buttonUI instanceof BasicButtonUI) {
            BasicButtonUI basicButtonUI = (BasicButtonUI)buttonUI;
            String string = basicButtonUI.getPropertyPrefix();
            InputMap inputMap = (InputMap)UIManager.get(string + "focusInputMap");
            SwingUtilities.replaceUIInputMap(jComponent, 0, inputMap);
            ActionMap actionMap = (ActionMap)UIManager.get(string + "actionMap");
            if (actionMap == null) {
                actionMap = this.createDefaultActionMap();
                UIManager.put(string + "actionMap", actionMap);
            }
            SwingUtilities.replaceUIActionMap(jComponent, actionMap);
        }
        jComponent.getActionMap().put("pressed", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
            }
        });
        jComponent.getActionMap().put("released", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            }
        });
    }

    private ActionMap createDefaultActionMap() {
        ButtonAction buttonAction = new ButtonAction();
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("pressed", buttonAction);
        actionMapUIResource.put("released", buttonAction);
        return actionMapUIResource;
    }

    public void uninstallKeyboardActions(JComponent jComponent) {
        SwingUtilities.replaceUIActionMap(jComponent, null);
        SwingUtilities.replaceUIInputMap(jComponent, 0, null);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        ((AbstractButton)changeEvent.getSource()).repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                if (!abstractButton.isFocusOwner() && abstractButton.isRequestFocusEnabled()) {
                    abstractButton.requestFocus();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (mouseEvent.getButton() == 1) {
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isRolloverEnabled() && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                buttonModel.setRollover(true);
            }
            if (buttonModel.isPressed()) {
                buttonModel.setArmed(true);
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isRolloverEnabled()) {
                buttonModel.setRollover(false);
            }
            buttonModel.setArmed(false);
        }
    }

    private class ButtonAction
    extends AbstractAction {
        static final String PRESSED = "pressed";
        static final String RELEASED = "released";

        private ButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.getValue("__command__");
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (PRESSED.equals(object)) {
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                if (!abstractButton.isFocusOwner()) {
                    abstractButton.requestFocus();
                }
            } else if (RELEASED.equals(object)) {
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            }
        }

        public boolean isEnabled(Object object) {
            boolean bl = true;
            if (object instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)object;
                bl = abstractButton.isEnabled();
            }
            return bl;
        }
    }
}

