/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.text.JTextComponent;

public class BasicBorders {
    private static MarginBorder sharedMarginBorder;

    public static Border getButtonBorder() {
        ButtonBorder buttonBorder = new ButtonBorder(UIManager.getColor("Button.shadow"), UIManager.getColor("Button.darkShadow"), UIManager.getColor("Button.light"), UIManager.getColor("Button.highlight"));
        return new BorderUIResource.CompoundBorderUIResource(buttonBorder, BasicBorders.getMarginBorder());
    }

    public static Border getRadioButtonBorder() {
        RadioButtonBorder radioButtonBorder = new RadioButtonBorder(UIManager.getColor("RadioButton.shadow"), UIManager.getColor("RadioButton.darkShadow"), UIManager.getColor("RadioButton.light"), UIManager.getColor("RadioButton.highlight"));
        return new BorderUIResource.CompoundBorderUIResource(radioButtonBorder, BasicBorders.getMarginBorder());
    }

    public static Border getToggleButtonBorder() {
        ToggleButtonBorder toggleButtonBorder = new ToggleButtonBorder(UIManager.getColor("ToggleButton.shadow"), UIManager.getColor("ToggleButton.darkShadow"), UIManager.getColor("ToggleButton.light"), UIManager.getColor("ToggleButton.highlight"));
        return new BorderUIResource.CompoundBorderUIResource(toggleButtonBorder, BasicBorders.getMarginBorder());
    }

    public static Border getMenuBarBorder() {
        return new MenuBarBorder(UIManager.getColor("MenuBar.shadow"), UIManager.getColor("MenuBar.highlight"));
    }

    public static Border getSplitPaneBorder() {
        return new SplitPaneBorder(UIManager.getColor("SplitPane.highlight"), UIManager.getColor("SplitPane.darkShadow"));
    }

    public static Border getSplitPaneDividerBorder() {
        return new SplitPaneDividerBorder();
    }

    public static Border getTextFieldBorder() {
        return new FieldBorder(UIManager.getColor("TextField.shadow"), UIManager.getColor("TextField.darkShadow"), UIManager.getColor("TextField.light"), UIManager.getColor("TextField.highlight"));
    }

    public static Border getProgressBarBorder() {
        return new BorderUIResource.LineBorderUIResource(Color.green, 2);
    }

    public static Border getInternalFrameBorder() {
        Color color = UIManager.getColor("InternalFrame.borderShadow");
        Color color2 = UIManager.getColor("InternalFrame.borderDarkShadow");
        Color color3 = UIManager.getColor("InternalFrame.borderLight");
        Color color4 = UIManager.getColor("InternalFrame.borderHighlight");
        Color color5 = UIManager.getColor("InternalFrame.borderColor");
        return new BorderUIResource.CompoundBorderUIResource(new BorderUIResource.BevelBorderUIResource(0, color3 != null ? color3 : Color.lightGray, color4 != null ? color4 : Color.white, color2 != null ? color2 : Color.black, color != null ? color : Color.gray), new BorderUIResource.LineBorderUIResource(color5 != null ? color5 : Color.lightGray));
    }

    static Border getMarginBorder() {
        if (sharedMarginBorder == null) {
            sharedMarginBorder = new MarginBorder();
        }
        return sharedMarginBorder;
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        static final long serialVersionUID = -3528666548001058394L;

        public ToggleButtonBorder(Color color, Color color2, Color color3, Color color4) {
            super(color, color2, color3, color4);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, false, false, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                return new Insets(2, 2, 2, 2);
            }
            insets.bottom = 2;
            insets.top = 2;
            insets.right = 2;
            insets.left = 2;
            return insets;
        }
    }

    private static class SplitPaneDividerBorder
    implements Border,
    UIResource,
    Serializable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = UIManager.getColor("SplitPane.highlight");
            Color color2 = UIManager.getColor("SplitPane.shadow");
            JSplitPane jSplitPane = this.getSplitPane(component);
            if (jSplitPane == null) {
                return;
            }
            int n5 = n + n3 - 1;
            int n6 = n2 + n4 - 1;
            Color color3 = graphics.getColor();
            Color color4 = component.getBackground();
            try {
                switch (jSplitPane.getOrientation()) {
                    case 1: {
                        graphics.setColor(color4);
                        graphics.drawLine(n + 1, n2, n5 - 1, n2);
                        graphics.drawLine(n + 1, n6, n5 - 1, n6);
                        graphics.setColor(jSplitPane.getLeftComponent() != null ? color : color4);
                        graphics.drawLine(n, n2, n, n6);
                        graphics.setColor(jSplitPane.getRightComponent() != null ? color2 : color4);
                        graphics.drawLine(n5, n2, n5, n6);
                        break;
                    }
                    case 0: {
                        graphics.setColor(color4);
                        graphics.drawLine(n, n2 + 1, n, n6 - 1);
                        graphics.drawLine(n5, n2 + 1, n5, n6 - 1);
                        graphics.setColor(jSplitPane.getTopComponent() != null ? color : color4);
                        graphics.drawLine(n, n2, n5, n2);
                        graphics.setColor(jSplitPane.getBottomComponent() != null ? color2 : color4);
                        graphics.drawLine(n, n6, n5, n6);
                    }
                }
                Object var15_14 = null;
                graphics.setColor(color3);
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                graphics.setColor(color3);
                throw throwable;
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        private JSplitPane getSplitPane(Component component) {
            if (component instanceof BasicSplitPaneDivider) {
                return ((BasicSplitPaneDivider)component).getBasicSplitPaneUI().getSplitPane();
            }
            return null;
        }
    }

    public static class SplitPaneBorder
    implements Border,
    UIResource {
        private static final int SUPPRESS_TOP = 1;
        private static final int SUPPRESS_LEFT = 2;
        private static final int SUPPRESS_BOTTOM = 4;
        private static final int SUPPRESS_RIGHT = 8;
        protected Color highlight;
        protected Color shadow;

        public SplitPaneBorder(Color color, Color color2) {
            this.shadow = color2 != null ? color2 : Color.black;
            this.highlight = color != null ? color : Color.white;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(component instanceof JSplitPane)) {
                return;
            }
            JSplitPane jSplitPane = (JSplitPane)component;
            switch (jSplitPane.getOrientation()) {
                case 1: {
                    Component component2 = jSplitPane.getLeftComponent();
                    if (component2 != null) {
                        this.paintRect(graphics, 8, true, n, n2, component2.getBounds());
                    }
                    if ((component2 = jSplitPane.getRightComponent()) == null) break;
                    this.paintRect(graphics, 2, true, n, n2, component2.getBounds());
                    break;
                }
                case 0: {
                    Component component3 = jSplitPane.getTopComponent();
                    if (component3 != null) {
                        this.paintRect(graphics, 4, false, n, n2, component3.getBounds());
                    }
                    if ((component3 = jSplitPane.getBottomComponent()) == null) break;
                    this.paintRect(graphics, 1, false, n, n2, component3.getBounds());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintRect(Graphics graphics, int n, boolean bl, int n2, int n3, Rectangle rectangle) {
            if (rectangle == null) {
                return;
            }
            int n4 = (n2 += rectangle.x - 1) + rectangle.width + 1;
            int n5 = (n3 += rectangle.y - 1) + rectangle.height + 1;
            Color color = graphics.getColor();
            try {
                graphics.setColor(this.shadow);
                if ((n & 1) == 0) {
                    graphics.drawLine(n2, n3, n4, n3);
                }
                if ((n & 2) == 0) {
                    graphics.drawLine(n2, n3, n2, n5);
                } else {
                    graphics.drawLine(n2, n5, n2, n5);
                }
                graphics.setColor(this.highlight);
                if ((n & 4) == 0) {
                    graphics.drawLine(n2 + (bl ? 1 : 0), n5, n4, n5);
                } else if (!bl) {
                    graphics.drawLine(n2, n5, n2, n5);
                }
                if ((n & 8) == 0) {
                    graphics.drawLine(n4, n3, n4, n5);
                }
                Object var11_10 = null;
                graphics.setColor(color);
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                graphics.setColor(color);
                throw throwable;
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }

    public static class RolloverButtonBorder
    extends ButtonBorder {
        static final long serialVersionUID = 1976364864896996846L;

        public RolloverButtonBorder(Color color, Color color2, Color color3, Color color4) {
            super(color, color2, color3, color4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ButtonModel buttonModel = null;
            Color color = graphics.getColor();
            if (component instanceof AbstractButton) {
                buttonModel = ((AbstractButton)component).getModel();
            }
            if (buttonModel == null || !buttonModel.isRollover()) {
                return;
            }
            if (buttonModel.isPressed() && !buttonModel.isArmed()) {
                return;
            }
            boolean bl = buttonModel.isSelected() || buttonModel.isPressed();
            int n5 = n + n3 - 1;
            int n6 = n2 + n4 - 1;
            try {
                graphics.setColor(bl ? this.shadow : this.lightHighlight);
                graphics.drawLine(n, n2, n5 - 1, n2);
                graphics.drawLine(n, n2 + 1, n, n6 - 1);
                graphics.setColor(bl ? this.lightHighlight : this.shadow);
                graphics.drawLine(n, n6, n5, n6);
                graphics.drawLine(n5, n2, n5, n6 - 1);
                Object var13_12 = null;
                graphics.setColor(color);
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                graphics.setColor(color);
                throw throwable;
            }
        }
    }

    public static class RadioButtonBorder
    extends ButtonBorder {
        static final long serialVersionUID = 1596945751743747369L;

        public RadioButtonBorder(Color color, Color color2, Color color3, Color color4) {
            super(color, color2, color3, color4);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = null;
            ButtonModel buttonModel = null;
            boolean bl = false;
            boolean bl2 = false;
            if (component instanceof AbstractButton) {
                abstractButton = (AbstractButton)component;
                buttonModel = abstractButton.getModel();
            }
            if (buttonModel != null) {
                bl = abstractButton.isSelected() || buttonModel.isArmed() && buttonModel.isPressed();
                boolean bl3 = bl2 = abstractButton.hasFocus() && abstractButton.isFocusPainted();
            }
            if (bl) {
                BasicGraphicsUtils.drawLoweredBezel(graphics, n, n2, n3, n4, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
            } else {
                BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, false, bl2, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
            }
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                return new Insets(2, 2, 2, 2);
            }
            insets.bottom = 2;
            insets.top = 2;
            insets.right = 2;
            insets.left = 2;
            return insets;
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        static final long serialVersionUID = -6909056571935227506L;
        private Color shadow;
        private Color highlight;

        public MenuBarBorder(Color color, Color color2) {
            this.shadow = color != null ? color : Color.gray;
            this.highlight = color2 != null ? color2 : Color.white;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            n2 = n2 + n4 - 2;
            try {
                graphics.setColor(this.shadow);
                graphics.drawLine(n, n2, n + n3 - 2, n2);
                graphics.drawLine(n, n2 + 1, n, n2 + 1);
                graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
                graphics.setColor(this.highlight);
                graphics.drawLine(n + 1, n2 + 1, n + n3 - 3, n2 + 1);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + 1);
                Object var9_8 = null;
                graphics.setColor(color);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                graphics.setColor(color);
                throw throwable;
            }
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                return new Insets(0, 0, 2, 0);
            }
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 2;
            return insets;
        }
    }

    public static class MarginBorder
    extends AbstractBorder
    implements Serializable,
    UIResource {
        static final long serialVersionUID = -3035848353448896090L;

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (component instanceof JPopupMenu) {
                insets2 = ((JPopupMenu)component).getMargin();
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            if (insets2 == null) {
                insets.right = 0;
                insets.bottom = 0;
                insets.left = 0;
                insets.top = 0;
            } else {
                insets.top = insets2.top;
                insets.left = insets2.left;
                insets.bottom = insets2.bottom;
                insets.right = insets2.right;
            }
            return insets;
        }
    }

    public static class FieldBorder
    extends AbstractBorder
    implements UIResource {
        static final long serialVersionUID = 949220756998454908L;
        protected Color shadow;
        protected Color darkShadow;
        protected Color highlight;
        protected Color lightHighlight;

        public FieldBorder(Color color, Color color2, Color color3, Color color4) {
            this.shadow = color != null ? color : Color.gray;
            this.darkShadow = color2 != null ? color2 : Color.black;
            this.highlight = color3 != null ? color3 : Color.lightGray;
            this.lightHighlight = color4 != null ? color4 : Color.white;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            BasicGraphicsUtils.drawEtchedRect(graphics, n, n2, n3, n4, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                insets = new Insets(2, 2, 2, 2);
            } else {
                insets.right = 2;
                insets.bottom = 2;
                insets.left = 2;
                insets.top = 2;
            }
            if (component instanceof JTextComponent) {
                Insets insets2 = ((JTextComponent)component).getMargin();
                insets.top += insets2.top;
                insets.left += insets2.left;
                insets.bottom += insets2.bottom;
                insets.right += insets2.right;
            }
            return insets;
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements Serializable,
    UIResource {
        static final long serialVersionUID = -157053874580739687L;
        protected Color shadow;
        protected Color darkShadow;
        protected Color highlight;
        protected Color lightHighlight;

        public ButtonBorder(Color color, Color color2, Color color3, Color color4) {
            this.shadow = color != null ? color : Color.gray;
            this.darkShadow = color2 != null ? color2 : Color.black;
            this.highlight = color3 != null ? color3 : Color.lightGray;
            this.lightHighlight = color4 != null ? color4 : Color.white;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ButtonModel buttonModel = null;
            if (component instanceof AbstractButton) {
                buttonModel = ((AbstractButton)component).getModel();
            }
            BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, buttonModel != null && buttonModel.isPressed() && buttonModel.isArmed(), component instanceof JButton && ((JButton)component).isDefaultButton(), this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                return new Insets(2, 3, 3, 3);
            }
            insets.top = 2;
            insets.right = 3;
            insets.left = 3;
            insets.bottom = 3;
            return insets;
        }
    }
}

