/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DefaultRGBChooserPanel
extends AbstractColorChooserPanel {
    transient boolean spinnerChange = false;
    transient boolean sliderChange = false;
    transient boolean updateChange = false;
    private transient ChangeListener colorChanger;
    private transient ChangeListener spinnerHandler;
    transient JSlider R;
    transient JSlider G;
    transient JSlider B;
    private transient JLabel RLabel;
    private transient JLabel GLabel;
    private transient JLabel BLabel;
    transient JSpinner RSpinner;
    transient JSpinner GSpinner;
    transient JSpinner BSpinner;

    public String getDisplayName() {
        return "RGB";
    }

    public void updateChooser() {
        Color color = this.getColorFromModel();
        int n = color.getRGB();
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        this.updateChange = true;
        if (!this.sliderChange) {
            if (this.R != null) {
                this.R.setValue(n2);
            }
            if (this.G != null) {
                this.G.setValue(n3);
            }
            if (this.B != null) {
                this.B.setValue(n4);
            }
        }
        if (!this.spinnerChange) {
            if (this.GSpinner != null) {
                this.GSpinner.setValue(new Integer(n3));
            }
            if (this.RSpinner != null) {
                this.RSpinner.setValue(new Integer(n2));
            }
            if (this.BSpinner != null) {
                this.BSpinner.setValue(new Integer(n4));
            }
        }
        this.updateChange = false;
        this.revalidate();
        this.repaint();
    }

    protected void buildChooser() {
        this.setLayout(new GridBagLayout());
        this.RLabel = new JLabel("Red");
        this.RLabel.setDisplayedMnemonic('d');
        this.GLabel = new JLabel("Green");
        this.GLabel.setDisplayedMnemonic('n');
        this.BLabel = new JLabel("Blue");
        this.BLabel.setDisplayedMnemonic('B');
        this.R = new JSlider(0, 0, 255, 255);
        this.G = new JSlider(0, 0, 255, 255);
        this.B = new JSlider(0, 0, 255, 255);
        this.R.setPaintTicks(true);
        this.R.setSnapToTicks(false);
        this.G.setPaintTicks(true);
        this.G.setSnapToTicks(false);
        this.B.setPaintTicks(true);
        this.B.setSnapToTicks(false);
        this.R.setLabelTable(this.R.createStandardLabels(85));
        this.R.setPaintLabels(true);
        this.G.setLabelTable(this.G.createStandardLabels(85));
        this.G.setPaintLabels(true);
        this.B.setLabelTable(this.B.createStandardLabels(85));
        this.B.setPaintLabels(true);
        this.R.setMajorTickSpacing(85);
        this.G.setMajorTickSpacing(85);
        this.B.setMajorTickSpacing(85);
        this.R.setMinorTickSpacing(17);
        this.G.setMinorTickSpacing(17);
        this.B.setMinorTickSpacing(17);
        this.RSpinner = new JSpinner(new SpinnerNumberModel(this.R.getValue(), this.R.getMinimum(), this.R.getMaximum(), 1));
        this.GSpinner = new JSpinner(new SpinnerNumberModel(this.G.getValue(), this.G.getMinimum(), this.G.getMaximum(), 1));
        this.BSpinner = new JSpinner(new SpinnerNumberModel(this.B.getValue(), this.B.getMinimum(), this.B.getMaximum(), 1));
        this.RLabel.setLabelFor(this.R);
        this.GLabel.setLabelFor(this.G);
        this.BLabel.setLabelFor(this.B);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.RLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.R, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.RSpinner, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.GLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.G, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.GSpinner, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.BLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.B, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.BSpinner, gridBagConstraints);
        this.installListeners();
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        this.uninstallListeners();
        this.removeAll();
        this.R = null;
        this.G = null;
        this.B = null;
        this.RSpinner = null;
        this.GSpinner = null;
        this.BSpinner = null;
        super.uninstallChooserPanel(jColorChooser);
    }

    private void uninstallListeners() {
        this.R.removeChangeListener(this.colorChanger);
        this.G.removeChangeListener(this.colorChanger);
        this.B.removeChangeListener(this.colorChanger);
        this.colorChanger = null;
        this.RSpinner.removeChangeListener(this.spinnerHandler);
        this.GSpinner.removeChangeListener(this.spinnerHandler);
        this.BSpinner.removeChangeListener(this.spinnerHandler);
        this.spinnerHandler = null;
    }

    private void installListeners() {
        this.colorChanger = new SliderHandler();
        this.R.addChangeListener(this.colorChanger);
        this.G.addChangeListener(this.colorChanger);
        this.B.addChangeListener(this.colorChanger);
        this.spinnerHandler = new SpinnerHandler();
        this.RSpinner.addChangeListener(this.spinnerHandler);
        this.GSpinner.addChangeListener(this.spinnerHandler);
        this.BSpinner.addChangeListener(this.spinnerHandler);
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    class SpinnerHandler
    implements ChangeListener {
        SpinnerHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (DefaultRGBChooserPanel.this.updateChange) {
                return;
            }
            int n = ((Number)DefaultRGBChooserPanel.this.RSpinner.getValue()).intValue();
            int n2 = ((Number)DefaultRGBChooserPanel.this.GSpinner.getValue()).intValue();
            int n3 = ((Number)DefaultRGBChooserPanel.this.BSpinner.getValue()).intValue();
            int n4 = n << 16 | n2 << 8 | n3;
            DefaultRGBChooserPanel.this.spinnerChange = true;
            DefaultRGBChooserPanel.this.getColorSelectionModel().setSelectedColor(new Color(n4));
            DefaultRGBChooserPanel.this.spinnerChange = false;
        }
    }

    class SliderHandler
    implements ChangeListener {
        SliderHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (DefaultRGBChooserPanel.this.updateChange) {
                return;
            }
            int n = DefaultRGBChooserPanel.this.R.getValue() << 16 | DefaultRGBChooserPanel.this.G.getValue() << 8 | DefaultRGBChooserPanel.this.B.getValue();
            DefaultRGBChooserPanel.this.sliderChange = true;
            DefaultRGBChooserPanel.this.getColorSelectionModel().setSelectedColor(new Color(n));
            DefaultRGBChooserPanel.this.sliderChange = false;
        }
    }
}

