/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DefaultHSBChooserPanel
extends AbstractColorChooserPanel {
    transient Image gradientImage;
    private transient JPanel gradientPanel;
    transient Image trackImage;
    private transient JPanel trackPanel;
    transient JSlider slider;
    transient JRadioButton hRadio;
    transient JRadioButton sRadio;
    transient JRadioButton bRadio;
    transient JSpinner hSpinner;
    transient JSpinner sSpinner;
    transient JSpinner bSpinner;
    private static final int imgWidth = 200;
    private static final int imgHeight = 200;
    private static final int trackWidth = 30;
    private static final JLabel R = new JLabel("R");
    private static final JLabel G = new JLabel("G");
    private static final JLabel B = new JLabel("B");
    private transient JLabel rFull;
    private transient JLabel gFull;
    private transient JLabel bFull;
    transient Point gradientPoint = new Point();
    transient boolean internalChange = false;
    transient boolean spinnerTrigger = false;
    transient int locked = -1;
    static final int HLOCKED = 0;
    static final int SLOCKED = 1;
    static final int BLOCKED = 2;
    transient boolean handlingMouse;

    DefaultHSBChooserPanel() {
    }

    public String getDisplayName() {
        return "HSB";
    }

    public void updateChooser() {
        Color color = this.getColorSelectionModel().getSelectedColor();
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.internalChange = true;
        if (!this.spinnerTrigger) {
            this.hSpinner.setValue(new Integer((int)(fArray[0] * 360.0f)));
            this.sSpinner.setValue(new Integer((int)(fArray[1] * 100.0f)));
            this.bSpinner.setValue(new Integer((int)(fArray[2] * 100.0f)));
        }
        switch (this.locked) {
            case 0: {
                if (this.slider != null) {
                    this.slider.setValue(((Number)this.hSpinner.getValue()).intValue());
                }
                if (this.handlingMouse) break;
                this.gradientPoint.x = (int)((1.0f - (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f) * 200.0f);
                this.gradientPoint.y = (int)((1.0f - (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f) * 200.0f);
                break;
            }
            case 1: {
                if (this.slider != null) {
                    this.slider.setValue(((Number)this.sSpinner.getValue()).intValue());
                }
                if (this.handlingMouse) break;
                this.gradientPoint.x = (int)((float)((Number)this.hSpinner.getValue()).intValue() / 360.0f * 200.0f);
                this.gradientPoint.y = (int)((1.0f - (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f) * 200.0f);
                break;
            }
            case 2: {
                if (this.slider != null) {
                    this.slider.setValue(((Number)this.bSpinner.getValue()).intValue());
                }
                if (this.handlingMouse) break;
                this.gradientPoint.x = (int)((float)((Number)this.hSpinner.getValue()).intValue() / 360.0f * 200.0f);
                this.gradientPoint.y = (int)((1.0f - (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f) * 200.0f);
            }
        }
        this.internalChange = false;
        if (!this.handlingMouse && this.slider != null && !this.slider.getValueIsAdjusting()) {
            this.updateImage();
        }
        if (!this.handlingMouse || this.locked != 0) {
            this.updateTrack();
        }
        this.updateTextFields();
    }

    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildRightPanel(), "East");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.gradientPanel = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(200, 200);
            }

            public void paint(Graphics graphics) {
                if (DefaultHSBChooserPanel.this.gradientImage != null) {
                    graphics.drawImage(DefaultHSBChooserPanel.this.gradientImage, 0, 0, this);
                }
                Color color = graphics.getColor();
                graphics.setColor(Color.WHITE);
                graphics.drawOval(DefaultHSBChooserPanel.this.gradientPoint.x - 3, DefaultHSBChooserPanel.this.gradientPoint.y - 3, 6, 6);
                graphics.setColor(color);
            }
        };
        MainGradientMouseListener mainGradientMouseListener = new MainGradientMouseListener();
        this.gradientPanel.addMouseListener(mainGradientMouseListener);
        this.gradientPanel.addMouseMotionListener(mainGradientMouseListener);
        this.trackPanel = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(30, 200);
            }

            public void paint(Graphics graphics) {
                if (DefaultHSBChooserPanel.this.trackImage != null) {
                    graphics.drawImage(DefaultHSBChooserPanel.this.trackImage, 0, 0, this);
                }
            }
        };
        this.slider = new JSlider();
        this.slider.setPaintTrack(false);
        this.slider.setPaintTicks(false);
        this.slider.setOrientation(1);
        this.updateSlider();
        jPanel.add((Component)this.gradientPanel, "West");
        jPanel.add((Component)this.slider, "Center");
        jPanel.add((Component)this.trackPanel, "East");
        this.add((Component)jPanel, "West");
        this.slider.addChangeListener(new SliderChangeListener());
        this.repaint();
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        this.trackImage = null;
        this.gradientImage = null;
        this.gradientPanel = null;
        this.slider = null;
        this.hSpinner = null;
        this.sSpinner = null;
        this.bSpinner = null;
        this.hRadio = null;
        this.sRadio = null;
        this.bRadio = null;
        this.removeAll();
        super.uninstallChooserPanel(jColorChooser);
    }

    private Container buildRightPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(6, 2));
        this.hRadio = new JRadioButton("H");
        this.sRadio = new JRadioButton("S");
        this.bRadio = new JRadioButton("B");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.hRadio);
        buttonGroup.add(this.sRadio);
        buttonGroup.add(this.bRadio);
        this.hSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 359, 1));
        this.sSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        this.bSpinner = new JSpinner(new SpinnerNumberModel(100, 0, 100, 1));
        this.hSpinner.setEnabled(false);
        this.sSpinner.setEnabled(false);
        this.bSpinner.setEnabled(false);
        RadioStateListener radioStateListener = new RadioStateListener();
        ImageScrollListener imageScrollListener = new ImageScrollListener();
        this.hRadio.addChangeListener(radioStateListener);
        this.sRadio.addChangeListener(radioStateListener);
        this.bRadio.addChangeListener(radioStateListener);
        this.hSpinner.addChangeListener(imageScrollListener);
        this.sSpinner.addChangeListener(imageScrollListener);
        this.bSpinner.addChangeListener(imageScrollListener);
        this.hRadio.setSelected(true);
        jPanel.add(this.hRadio);
        jPanel.add(this.hSpinner);
        jPanel.add(this.sRadio);
        jPanel.add(this.sSpinner);
        jPanel.add(this.bRadio);
        jPanel.add(this.bSpinner);
        this.rFull = new JLabel("red full");
        this.gFull = new JLabel("green full");
        this.bFull = new JLabel("blue full");
        jPanel.add(R);
        jPanel.add(this.rFull);
        jPanel.add(G);
        jPanel.add(this.gFull);
        jPanel.add(B);
        jPanel.add(this.bFull);
        return jPanel;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    private void updateHLockImage() {
        int n = 0;
        int[] nArray = new int[40000];
        float f = (float)((Number)this.hSpinner.getValue()).intValue() / 360.0f;
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 200; ++j) {
                nArray[n++] = Color.HSBtoRGB(f, (200.0f - (float)j * 1.0f) / 200.0f, (200.0f - (float)i * 1.0f) / 200.0f) | 0xFF000000;
            }
        }
        this.gradientImage = this.createImage(new MemoryImageSource(200, 200, nArray, 0, 200));
    }

    private void updateBLockImage() {
        int[] nArray = new int[40000];
        float f = (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f;
        int n = 0;
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 200; ++j) {
                nArray[n++] = Color.HSBtoRGB((float)j * 1.0f / 200.0f, (200.0f - (float)i * 1.0f) / 200.0f, f) | 0xFF000000;
            }
        }
        this.gradientImage = this.createImage(new MemoryImageSource(200, 200, nArray, 0, 200));
    }

    private void updateSLockImage() {
        int[] nArray = new int[40000];
        float f = (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f;
        int n = 0;
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 200; ++j) {
                nArray[n++] = Color.HSBtoRGB((float)j * 1.0f / 200.0f, f, (200.0f - (float)i * 1.0f) / 200.0f) | 0xFF000000;
            }
        }
        this.gradientImage = this.createImage(new MemoryImageSource(200, 200, nArray, 0, 200));
    }

    void updateImage() {
        switch (this.locked) {
            case 0: {
                this.updateHLockImage();
                break;
            }
            case 1: {
                this.updateSLockImage();
                break;
            }
            case 2: {
                this.updateBLockImage();
            }
        }
    }

    private void updateTextFields() {
        int n = this.getColorSelectionModel().getSelectedColor().getRGB();
        this.rFull.setText("" + (n >> 16 & 0xFF));
        this.gFull.setText("" + (n >> 8 & 0xFF));
        this.bFull.setText("" + (n & 0xFF));
        this.repaint();
    }

    void updateSlider() {
        if (this.slider == null) {
            return;
        }
        this.slider.setMinimum(0);
        if (this.locked == 0) {
            this.slider.setMaximum(359);
            this.slider.setValue(((Number)this.hSpinner.getValue()).intValue());
            this.slider.setInverted(true);
        } else {
            this.slider.setMaximum(100);
            this.slider.setInverted(false);
            if (this.sRadio.isSelected()) {
                this.slider.setValue(((Number)this.sSpinner.getValue()).intValue());
            } else {
                this.slider.setValue(((Number)this.bSpinner.getValue()).intValue());
            }
        }
        this.repaint();
    }

    void updateTrack() {
        switch (this.locked) {
            case 0: {
                this.updateHTrack();
                break;
            }
            case 1: {
                this.updateSTrack();
                break;
            }
            case 2: {
                this.updateBTrack();
            }
        }
    }

    private void updateHTrack() {
        int n = 0;
        int[] nArray = new int[6000];
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 30; ++j) {
                nArray[n++] = Color.HSBtoRGB((float)i * 1.0f / 200.0f, 1.0f, 1.0f) | 0xFF000000;
            }
        }
        this.trackImage = this.createImage(new MemoryImageSource(30, 200, nArray, 0, 30));
    }

    private void updateSTrack() {
        int[] nArray = new int[6000];
        float f = (float)((Number)this.hSpinner.getValue()).intValue() / 360.0f;
        float f2 = (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f;
        int n = 0;
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 30; ++j) {
                nArray[n++] = Color.HSBtoRGB(f, (200.0f - (float)i * 1.0f) / 200.0f, f2) | 0xFF000000;
            }
        }
        this.trackImage = this.createImage(new MemoryImageSource(30, 200, nArray, 0, 30));
    }

    private void updateBTrack() {
        int[] nArray = new int[6000];
        float f = (float)((Number)this.hSpinner.getValue()).intValue() / 360.0f;
        float f2 = (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f;
        int n = 0;
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 30; ++j) {
                nArray[n++] = Color.HSBtoRGB(f, f2, (200.0f - (float)i * 1.0f) / 200.0f) | 0xFF000000;
            }
        }
        this.trackImage = this.createImage(new MemoryImageSource(30, 200, nArray, 0, 30));
    }

    private float[] getHSBValues() {
        Color color = this.getColorFromModel();
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return fArray;
    }

    class ImageScrollListener
    implements ChangeListener {
        ImageScrollListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (DefaultHSBChooserPanel.this.internalChange) {
                return;
            }
            float f = (float)((Number)DefaultHSBChooserPanel.this.hSpinner.getValue()).intValue() / 360.0f;
            float f2 = (float)((Number)DefaultHSBChooserPanel.this.sSpinner.getValue()).intValue() / 100.0f;
            float f3 = (float)((Number)DefaultHSBChooserPanel.this.bSpinner.getValue()).intValue() / 100.0f;
            DefaultHSBChooserPanel.this.spinnerTrigger = true;
            DefaultHSBChooserPanel.this.getColorSelectionModel().setSelectedColor(new Color(Color.HSBtoRGB(f, f2, f3)));
            DefaultHSBChooserPanel.this.spinnerTrigger = false;
            if (!DefaultHSBChooserPanel.this.handlingMouse && DefaultHSBChooserPanel.this.slider != null && !DefaultHSBChooserPanel.this.slider.getValueIsAdjusting()) {
                DefaultHSBChooserPanel.this.updateImage();
                DefaultHSBChooserPanel.this.updateTrack();
            }
            DefaultHSBChooserPanel.this.repaint();
        }
    }

    class RadioStateListener
    implements ChangeListener {
        RadioStateListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner;
            if (changeEvent.getSource() == DefaultHSBChooserPanel.this.hRadio) {
                DefaultHSBChooserPanel.this.locked = 0;
                jSpinner = DefaultHSBChooserPanel.this.hSpinner;
            } else if (changeEvent.getSource() == DefaultHSBChooserPanel.this.sRadio) {
                DefaultHSBChooserPanel.this.locked = 1;
                jSpinner = DefaultHSBChooserPanel.this.sSpinner;
            } else {
                DefaultHSBChooserPanel.this.locked = 2;
                jSpinner = DefaultHSBChooserPanel.this.bSpinner;
            }
            jSpinner.setEnabled(((AbstractButton)changeEvent.getSource()).isSelected());
            DefaultHSBChooserPanel.this.updateSlider();
            DefaultHSBChooserPanel.this.updateTrack();
            DefaultHSBChooserPanel.this.updateImage();
            DefaultHSBChooserPanel.this.repaint();
        }
    }

    class SliderChangeListener
    implements ChangeListener {
        SliderChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (DefaultHSBChooserPanel.this.internalChange) {
                return;
            }
            Integer n = new Integer(DefaultHSBChooserPanel.this.slider.getValue());
            switch (DefaultHSBChooserPanel.this.locked) {
                case 0: {
                    DefaultHSBChooserPanel.this.hSpinner.setValue(n);
                    break;
                }
                case 1: {
                    DefaultHSBChooserPanel.this.sSpinner.setValue(n);
                    break;
                }
                case 2: {
                    DefaultHSBChooserPanel.this.bSpinner.setValue(n);
                }
            }
        }
    }

    class MainGradientMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        MainGradientMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            DefaultHSBChooserPanel.this.gradientPoint = mouseEvent.getPoint();
            this.update(mouseEvent.getPoint());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (point.x < 0 || point.y < 0 || point.y > 200 || point.x > 200) {
                return;
            }
            DefaultHSBChooserPanel.this.gradientPoint = point;
            this.update(point);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private void update(Point point) {
            DefaultHSBChooserPanel.this.handlingMouse = true;
            if (DefaultHSBChooserPanel.this.hSpinner.isEnabled()) {
                this.updateH(point);
            } else if (DefaultHSBChooserPanel.this.sSpinner.isEnabled()) {
                this.updateS(point);
            } else {
                this.updateB(point);
            }
            DefaultHSBChooserPanel.this.handlingMouse = false;
        }

        private void updateH(Point point) {
            float f = (200.0f - (float)point.x * 1.0f) / 200.0f;
            float f2 = (200.0f - (float)point.y * 1.0f) / 200.0f;
            DefaultHSBChooserPanel.this.internalChange = true;
            DefaultHSBChooserPanel.this.sSpinner.setValue(new Integer((int)(f * 100.0f)));
            DefaultHSBChooserPanel.this.internalChange = false;
            DefaultHSBChooserPanel.this.bSpinner.setValue(new Integer((int)(f2 * 100.0f)));
            DefaultHSBChooserPanel.this.revalidate();
        }

        private void updateS(Point point) {
            float f = (float)point.x * 1.0f / 200.0f;
            float f2 = (200.0f - (float)point.y * 1.0f) / 200.0f;
            DefaultHSBChooserPanel.this.internalChange = true;
            DefaultHSBChooserPanel.this.hSpinner.setValue(new Integer((int)(f * 365.0f)));
            DefaultHSBChooserPanel.this.internalChange = false;
            DefaultHSBChooserPanel.this.bSpinner.setValue(new Integer((int)(f2 * 100.0f)));
            DefaultHSBChooserPanel.this.revalidate();
        }

        private void updateB(Point point) {
            float f = (float)point.x * 1.0f / 200.0f;
            float f2 = (200.0f - (float)point.y * 1.0f) / 200.0f;
            DefaultHSBChooserPanel.this.internalChange = true;
            DefaultHSBChooserPanel.this.hSpinner.setValue(new Integer((int)(f * 365.0f)));
            DefaultHSBChooserPanel.this.internalChange = false;
            DefaultHSBChooserPanel.this.sSpinner.setValue(new Integer((int)(f2 * 100.0f)));
            DefaultHSBChooserPanel.this.revalidate();
        }
    }
}

