/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class UIManager
implements Serializable {
    private static final long serialVersionUID = -5547433830339189365L;
    static LookAndFeelInfo[] installed = new LookAndFeelInfo[]{new LookAndFeelInfo("Metal", "javax.swing.plaf.metal.MetalLookAndFeel"), new LookAndFeelInfo("GNU", "gnu.javax.swing.plaf.gnu.GNULookAndFeel")};
    static LookAndFeel[] auxLookAndFeels;
    static LookAndFeel currentLookAndFeel;
    static MultiplexUIDefaults currentUIDefaults;
    static UIDefaults lookAndFeelDefaults;
    static PropertyChangeSupport listeners;

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public static PropertyChangeListener[] getPropertyChangeListeners() {
        return listeners.getPropertyChangeListeners();
    }

    public static void addAuxiliaryLookAndFeel(LookAndFeel lookAndFeel) {
        if (lookAndFeel == null) {
            throw new NullPointerException("Null 'laf' argument.");
        }
        if (auxLookAndFeels == null) {
            auxLookAndFeels = new LookAndFeel[1];
            UIManager.auxLookAndFeels[0] = lookAndFeel;
            return;
        }
        LookAndFeel[] lookAndFeelArray = new LookAndFeel[auxLookAndFeels.length + 1];
        System.arraycopy(auxLookAndFeels, 0, lookAndFeelArray, 0, auxLookAndFeels.length);
        auxLookAndFeels = lookAndFeelArray;
        UIManager.auxLookAndFeels[UIManager.auxLookAndFeels.length - 1] = lookAndFeel;
    }

    public static boolean removeAuxiliaryLookAndFeel(LookAndFeel lookAndFeel) {
        if (auxLookAndFeels == null) {
            return false;
        }
        int n = auxLookAndFeels.length;
        if (n == 1 && auxLookAndFeels[0] == lookAndFeel) {
            auxLookAndFeels = null;
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (auxLookAndFeels[i] != lookAndFeel) continue;
            LookAndFeel[] lookAndFeelArray = new LookAndFeel[auxLookAndFeels.length - 1];
            if (i == 0) {
                System.arraycopy(auxLookAndFeels, 1, lookAndFeelArray, 0, n - 1);
            } else if (i == n - 1) {
                System.arraycopy(auxLookAndFeels, 0, lookAndFeelArray, 0, n - 1);
            } else {
                System.arraycopy(auxLookAndFeels, 0, lookAndFeelArray, 0, i);
                System.arraycopy(auxLookAndFeels, i + 1, lookAndFeelArray, i, n - i - 1);
            }
            auxLookAndFeels = lookAndFeelArray;
            return true;
        }
        return false;
    }

    public static LookAndFeel[] getAuxiliaryLookAndFeels() {
        return auxLookAndFeels;
    }

    public static Object get(Object object) {
        return UIManager.getDefaults().get(object);
    }

    public static Object get(Object object, Locale locale) {
        return UIManager.getDefaults().get(object, locale);
    }

    public static boolean getBoolean(Object object) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Boolean) {
            return (Boolean)object2;
        }
        return false;
    }

    public static boolean getBoolean(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Boolean) {
            return (Boolean)object2;
        }
        return false;
    }

    public static Border getBorder(Object object) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Border) {
            return (Border)object2;
        }
        return null;
    }

    public static Border getBorder(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Border) {
            return (Border)object2;
        }
        return null;
    }

    public static Color getColor(Object object) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Color) {
            return (Color)object2;
        }
        return null;
    }

    public static Color getColor(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Color) {
            return (Color)object2;
        }
        return null;
    }

    public static String getCrossPlatformLookAndFeelClassName() {
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    public static UIDefaults getDefaults() {
        if (currentUIDefaults == null) {
            currentUIDefaults = new MultiplexUIDefaults(new UIDefaults());
        }
        return currentUIDefaults;
    }

    public static Dimension getDimension(Object object) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Dimension) {
            return (Dimension)object2;
        }
        return null;
    }

    public static Dimension getDimension(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Dimension) {
            return (Dimension)object2;
        }
        return null;
    }

    public static Font getFont(Object object) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Font) {
            return (Font)object2;
        }
        return null;
    }

    public static Font getFont(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Font) {
            return (Font)object2;
        }
        return null;
    }

    public static Icon getIcon(Object object) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Icon) {
            return (Icon)object2;
        }
        return null;
    }

    public static Icon getIcon(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Icon) {
            return (Icon)object2;
        }
        return null;
    }

    public static Insets getInsets(Object object) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Insets) {
            return (Insets)object2;
        }
        return null;
    }

    public static Insets getInsets(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Insets) {
            return (Insets)object2;
        }
        return null;
    }

    public static LookAndFeelInfo[] getInstalledLookAndFeels() {
        return installed;
    }

    public static int getInt(Object object) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        return 0;
    }

    public static int getInt(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        return 0;
    }

    public static LookAndFeel getLookAndFeel() {
        return currentLookAndFeel;
    }

    public static UIDefaults getLookAndFeelDefaults() {
        return lookAndFeelDefaults;
    }

    public static String getString(Object object) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof String) {
            return (String)object2;
        }
        return null;
    }

    public static String getString(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof String) {
            return (String)object2;
        }
        return null;
    }

    public static String getSystemLookAndFeelClassName() {
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static ComponentUI getUI(JComponent jComponent) {
        return UIManager.getDefaults().getUI(jComponent);
    }

    public static void installLookAndFeel(String string, String string2) {
        UIManager.installLookAndFeel(new LookAndFeelInfo(string, string2));
    }

    public static void installLookAndFeel(LookAndFeelInfo lookAndFeelInfo) {
        LookAndFeelInfo[] lookAndFeelInfoArray = new LookAndFeelInfo[installed.length + 1];
        System.arraycopy(installed, 0, lookAndFeelInfoArray, 0, installed.length);
        lookAndFeelInfoArray[lookAndFeelInfoArray.length - 1] = lookAndFeelInfo;
        UIManager.setInstalledLookAndFeels(lookAndFeelInfoArray);
    }

    public static Object put(Object object, Object object2) {
        return UIManager.getDefaults().put(object, object2);
    }

    public static void setInstalledLookAndFeels(LookAndFeelInfo[] lookAndFeelInfoArray) {
        installed = lookAndFeelInfoArray;
    }

    public static void setLookAndFeel(LookAndFeel lookAndFeel) throws UnsupportedLookAndFeelException {
        if (lookAndFeel != null && !lookAndFeel.isSupportedLookAndFeel()) {
            throw new UnsupportedLookAndFeelException(lookAndFeel.getName() + " not supported on this platform");
        }
        LookAndFeel lookAndFeel2 = currentLookAndFeel;
        if (lookAndFeel2 != null) {
            lookAndFeel2.uninitialize();
        }
        currentLookAndFeel = lookAndFeel;
        if (lookAndFeel != null) {
            lookAndFeel.initialize();
            lookAndFeelDefaults = lookAndFeel.getDefaults();
            if (currentUIDefaults == null) {
                currentUIDefaults = new MultiplexUIDefaults(lookAndFeelDefaults);
            } else {
                UIManager.currentUIDefaults.fallback = lookAndFeelDefaults;
            }
        } else {
            currentUIDefaults = null;
        }
        listeners.firePropertyChange("lookAndFeel", lookAndFeel2, lookAndFeel);
    }

    public static void setLookAndFeel(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
        UIManager.setLookAndFeel(lookAndFeel);
    }

    static {
        listeners = new PropertyChangeSupport(UIManager.class);
        String string = System.getProperty("swing.defaultlaf");
        try {
            if (string != null) {
                UIManager.setLookAndFeel(string);
            } else {
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            }
        }
        catch (Exception exception) {
            System.err.println("cannot initialize Look and Feel: " + string);
            System.err.println("error: " + exception.toString());
            exception.printStackTrace();
            System.err.println("falling back to Metal Look and Feel");
            try {
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            }
            catch (Exception exception2) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"There must be no problem installing the MetalLookAndFeel."))).initCause(exception2);
            }
        }
    }

    private static class MultiplexUIDefaults
    extends UIDefaults {
        UIDefaults fallback;

        MultiplexUIDefaults(UIDefaults uIDefaults) {
            if (uIDefaults == null) {
                throw new NullPointerException();
            }
            this.fallback = uIDefaults;
        }

        public Object get(Object object) {
            Object object2 = super.get(object);
            if (object2 == null) {
                object2 = this.fallback.get(object);
            }
            return object2;
        }

        public Object get(Object object, Locale locale) {
            Object object2 = super.get(object, locale);
            if (object2 == null) {
                object2 = this.fallback.get(object, locale);
            }
            return object2;
        }

        public Object remove(Object object) {
            Object v = super.remove(object);
            if (v == null) {
                v = this.fallback.remove(object);
            }
            return v;
        }

        public int size() {
            return super.size() + this.fallback.size();
        }

        public Enumeration keys() {
            return new MultiplexEnumeration(super.keys(), this.fallback.keys());
        }

        public Enumeration elements() {
            return new MultiplexEnumeration(super.elements(), this.fallback.elements());
        }

        private class MultiplexEnumeration
        implements Enumeration {
            Enumeration[] enums;
            int i;

            MultiplexEnumeration(Enumeration enumeration, Enumeration enumeration2) {
                this.enums = new Enumeration[]{enumeration, enumeration2};
                this.i = 0;
            }

            public boolean hasMoreElements() {
                return this.enums[this.i].hasMoreElements() || this.i < this.enums.length - 1;
            }

            public Object nextElement() {
                Object e = this.enums[this.i].nextElement();
                if (!this.enums[this.i].hasMoreElements() && this.i < this.enums.length - 1) {
                    ++this.i;
                }
                return e;
            }
        }
    }

    public static class LookAndFeelInfo {
        String name;
        String clazz;

        public LookAndFeelInfo(String string, String string2) {
            this.name = string;
            this.clazz = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.clazz;
        }

        public String toString() {
            CPStringBuilder cPStringBuilder = new CPStringBuilder();
            cPStringBuilder.append(this.getClass().getName());
            cPStringBuilder.append('[');
            cPStringBuilder.append(this.getName());
            cPStringBuilder.append(' ');
            cPStringBuilder.append(this.getClassName());
            cPStringBuilder.append(']');
            return cPStringBuilder.toString();
        }
    }
}

