/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;

public class TransferHandler
implements Serializable {
    private static final long serialVersionUID = -967749805571669910L;
    private static final String COMMAND_COPY = "copy";
    private static final String COMMAND_CUT = "cut";
    private static final String COMMAND_PASTE = "paste";
    public static final int NONE = 0;
    public static final int COPY = 1;
    public static final int MOVE = 2;
    public static final int COPY_OR_MOVE = 3;
    private static Action copyAction = new TransferAction("copy");
    private static Action cutAction = new TransferAction("cut");
    private static Action pasteAction = new TransferAction("paste");
    private int sourceActions;
    private Icon visualRepresentation;
    private String propertyName;
    private SwingDragGestureRecognizer recognizer;

    public static Action getCopyAction() {
        return copyAction;
    }

    public static Action getCutAction() {
        return cutAction;
    }

    public static Action getPasteAction() {
        return pasteAction;
    }

    protected TransferHandler() {
        this.sourceActions = 0;
    }

    public TransferHandler(String string) {
        this.propertyName = string;
        this.sourceActions = string != null ? 1 : 0;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        DataFlavor dataFlavor;
        Class<?>[] classArray;
        Method method;
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        boolean bl = false;
        if (propertyDescriptor != null && (method = propertyDescriptor.getWriteMethod()) != null && (classArray = method.getParameterTypes()).length == 1 && (dataFlavor = this.getPropertyDataFlavor(classArray[0], dataFlavorArray)) != null) {
            bl = true;
        }
        return bl;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        PropertyDescriptor propertyDescriptor;
        PropertyTransferable propertyTransferable = null;
        if (this.propertyName != null && (propertyDescriptor = this.getPropertyDescriptor(jComponent)) != null) {
            propertyTransferable = new PropertyTransferable(jComponent, propertyDescriptor);
        }
        return propertyTransferable;
    }

    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        int n2 = this.getSourceActions(jComponent);
        int n3 = n2 & n;
        if (!(inputEvent instanceof MouseEvent)) {
            n3 = 0;
        }
        if (n3 != 0) {
            if (this.recognizer == null) {
                SwingDragHandler swingDragHandler = new SwingDragHandler();
                this.recognizer = new SwingDragGestureRecognizer(swingDragHandler);
            }
            this.recognizer.gesture(jComponent, (MouseEvent)inputEvent, n2, n3);
        } else {
            this.exportDone(jComponent, null, 0);
        }
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
    }

    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) throws IllegalStateException {
        Transferable transferable = this.createTransferable(jComponent);
        if (transferable != null && (n &= this.getSourceActions(jComponent)) != 0) {
            try {
                clipboard.setContents(transferable, null);
                this.exportDone(jComponent, transferable, n);
            }
            catch (IllegalStateException illegalStateException) {
                this.exportDone(jComponent, transferable, 0);
                throw illegalStateException;
            }
        } else {
            this.exportDone(jComponent, null, 0);
        }
    }

    public int getSourceActions(JComponent jComponent) {
        return this.sourceActions;
    }

    public Icon getVisualRepresentation(Transferable transferable) {
        return this.visualRepresentation;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        DataFlavor dataFlavor;
        Class<?>[] classArray;
        Method method;
        boolean bl = false;
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null && (method = propertyDescriptor.getWriteMethod()) != null && (classArray = method.getParameterTypes()).length == 1 && (dataFlavor = this.getPropertyDataFlavor(classArray[0], transferable.getTransferDataFlavors())) != null) {
            try {
                Object object = transferable.getTransferData(dataFlavor);
                method.invoke(jComponent, object);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private PropertyDescriptor getPropertyDescriptor(JComponent jComponent) {
        PropertyDescriptor propertyDescriptor = null;
        if (this.propertyName != null) {
            BeanInfo beanInfo;
            Class<? extends Object> clazz = jComponent.getClass();
            try {
                beanInfo = Introspector.getBeanInfo(clazz);
            }
            catch (IntrospectionException introspectionException) {
                beanInfo = null;
            }
            if (beanInfo != null) {
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                for (int i = 0; i < propertyDescriptorArray.length && propertyDescriptor == null; ++i) {
                    Class<?>[] classArray;
                    Method method;
                    PropertyDescriptor propertyDescriptor2 = propertyDescriptorArray[i];
                    if (!propertyDescriptor2.getName().equals(this.propertyName) || (method = propertyDescriptor2.getReadMethod()) == null || (classArray = method.getParameterTypes()) != null && classArray.length != 0) continue;
                    propertyDescriptor = propertyDescriptor2;
                }
            }
        }
        return propertyDescriptor;
    }

    private DataFlavor getPropertyDataFlavor(Class clazz, DataFlavor[] dataFlavorArray) {
        DataFlavor dataFlavor = null;
        for (int i = 0; i < dataFlavorArray.length && dataFlavor == null; ++i) {
            DataFlavor dataFlavor2 = dataFlavorArray[i];
            if (!dataFlavor2.getPrimaryType().equals("application") || !dataFlavor2.getSubType().equals("x-java-jvm-local-objectref") || !clazz.isAssignableFrom(dataFlavor2.getRepresentationClass())) continue;
            dataFlavor = dataFlavor2;
        }
        return dataFlavor;
    }

    private static class SwingDragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean autoscrolls;

        private SwingDragHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            JComponent jComponent = (JComponent)dragGestureEvent.getComponent();
            TransferHandler transferHandler = jComponent.getTransferHandler();
            Transferable transferable = transferHandler.createTransferable(jComponent);
            if (transferable != null) {
                this.autoscrolls = jComponent.getAutoscrolls();
                jComponent.setAutoscrolls(false);
                try {
                    dragGestureEvent.startDrag(null, transferable, this);
                    Object var6_5 = null;
                    jComponent.setAutoscrolls(this.autoscrolls);
                    return;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    jComponent.setAutoscrolls(this.autoscrolls);
                    throw throwable;
                }
            }
            transferHandler.exportDone(jComponent, transferable, 0);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DragSourceContext dragSourceContext = dragSourceDropEvent.getDragSourceContext();
            JComponent jComponent = (JComponent)dragSourceContext.getComponent();
            TransferHandler transferHandler = jComponent.getTransferHandler();
            if (dragSourceDropEvent.getDropSuccess()) {
                transferHandler.exportDone(jComponent, dragSourceContext.getTransferable(), dragSourceDropEvent.getDropAction());
            } else {
                transferHandler.exportDone(jComponent, dragSourceContext.getTransferable(), dragSourceDropEvent.getDropAction());
            }
            jComponent.setAutoscrolls(this.autoscrolls);
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }

    private static class SwingDragGestureRecognizer
    extends DragGestureRecognizer {
        protected SwingDragGestureRecognizer(DragGestureListener dragGestureListener) {
            super(DragSource.getDefaultDragSource(), null, 0, dragGestureListener);
        }

        void gesture(JComponent jComponent, MouseEvent mouseEvent, int n, int n2) {
            this.setComponent(jComponent);
            this.setSourceActions(n);
            this.appendEvent(mouseEvent);
            this.fireDragGestureRecognized(n2, mouseEvent.getPoint());
        }

        protected void registerListeners() {
        }

        protected void unregisterListeners() {
        }
    }

    static class TransferAction
    extends AbstractAction {
        private String command;

        public TransferAction(String string) {
            super(string);
            this.command = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Transferable transferable;
            JComponent jComponent = (JComponent)actionEvent.getSource();
            TransferHandler transferHandler = jComponent.getTransferHandler();
            Clipboard clipboard = TransferAction.getClipboard(jComponent);
            if (clipboard == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.command.equals(TransferHandler.COMMAND_COPY)) {
                transferHandler.exportToClipboard(jComponent, clipboard, 1);
            } else if (this.command.equals(TransferHandler.COMMAND_CUT)) {
                transferHandler.exportToClipboard(jComponent, clipboard, 2);
            } else if (this.command.equals(TransferHandler.COMMAND_PASTE) && (transferable = clipboard.getContents(null)) != null) {
                transferHandler.importData(jComponent, transferable);
            }
        }

        private static Clipboard getClipboard(JComponent jComponent) {
            try {
                return jComponent.getToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
    }

    private static class PropertyTransferable
    implements Transferable {
        private JComponent component;
        private PropertyDescriptor property;

        PropertyTransferable(JComponent jComponent, PropertyDescriptor propertyDescriptor) {
            this.component = jComponent;
            this.property = propertyDescriptor;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray;
            Class<?> clazz = this.property.getPropertyType();
            String string = "application/x-java-jvm-local-objectref; class=" + clazz.getName();
            try {
                DataFlavor dataFlavor = new DataFlavor(string);
                dataFlavorArray = new DataFlavor[]{dataFlavor};
            }
            catch (ClassNotFoundException classNotFoundException) {
                dataFlavorArray = new DataFlavor[]{};
            }
            return dataFlavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            Class<?> clazz = this.property.getPropertyType();
            return dataFlavor.getPrimaryType().equals("application") && dataFlavor.getSubType().equals("x-java-jvm-local-objectref") && clazz.isAssignableFrom(dataFlavor.getRepresentationClass());
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(dataFlavor)) {
                Method method = this.property.getReadMethod();
                try {
                    Object object = method.invoke(this.component, new Object[0]);
                    return object;
                }
                catch (Exception exception) {
                    throw new IOException("Property read failed: " + this.property.getName());
                }
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }
}

