/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    Timer enterTimer = new Timer(750, new insideTimerAction());
    Timer exitTimer;
    Timer insideTimer;
    private transient boolean enabled = true;
    protected boolean lightWeightPopupEnabled = true;
    protected boolean heavyWeightPopupEnabled = false;
    private static ToolTipManager shared;
    private JComponent currentComponent;
    private JToolTip currentTip;
    private String toolTipText;
    private Point currentPoint;
    private Popup popup;

    ToolTipManager() {
        this.enterTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
    }

    public static ToolTipManager sharedInstance() {
        if (shared == null) {
            shared = new ToolTipManager();
        }
        return shared;
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.enterTimer.stop();
            this.exitTimer.stop();
            this.insideTimer.stop();
        }
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
        this.heavyWeightPopupEnabled = !bl;
    }

    public int getInitialDelay() {
        return this.enterTimer.getDelay();
    }

    public void setInitialDelay(int n) {
        this.enterTimer.setDelay(n);
    }

    public int getDismissDelay() {
        return this.insideTimer.getDelay();
    }

    public void setDismissDelay(int n) {
        this.insideTimer.setDelay(n);
    }

    public int getReshowDelay() {
        return this.exitTimer.getDelay();
    }

    public void setReshowDelay(int n) {
        this.exitTimer.setDelay(n);
    }

    public void registerComponent(JComponent jComponent) {
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
    }

    public void unregisterComponent(JComponent jComponent) {
        jComponent.removeMouseMotionListener(this);
        jComponent.removeMouseListener(this);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.currentComponent != null && this.getContentPaneDeepestComponent(mouseEvent) == this.currentComponent) {
            return;
        }
        this.currentPoint = mouseEvent.getPoint();
        this.currentComponent = (JComponent)mouseEvent.getSource();
        this.toolTipText = this.currentComponent.getToolTipText(mouseEvent);
        if (this.exitTimer.isRunning()) {
            this.exitTimer.stop();
            this.showTip();
            return;
        }
        if (!this.enterTimer.isRunning()) {
            this.enterTimer.start();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.getContentPaneDeepestComponent(mouseEvent) == this.currentComponent) {
            return;
        }
        this.currentPoint = mouseEvent.getPoint();
        this.currentComponent = null;
        this.hideTip();
        if (!this.enterTimer.isRunning()) {
            this.exitTimer.start();
        }
        if (this.enterTimer.isRunning()) {
            this.enterTimer.stop();
        }
        if (this.insideTimer.isRunning()) {
            this.insideTimer.stop();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.currentPoint = mouseEvent.getPoint();
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        } else if (this.insideTimer.isRunning()) {
            this.insideTimer.stop();
            this.hideTip();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.currentPoint = mouseEvent.getPoint();
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.currentPoint = mouseEvent.getPoint();
        if (this.currentTip != null && this.currentTip.isShowing()) {
            this.checkTipUpdate(mouseEvent);
        } else if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        }
    }

    private void checkTipUpdate(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        String string = jComponent.getToolTipText(mouseEvent);
        String string2 = this.toolTipText;
        if (string != null) {
            if (string != null && string.equals(string2) || string == null) {
                if (this.popup == null) {
                    this.enterTimer.restart();
                } else {
                    this.insideTimer.restart();
                }
            } else {
                this.toolTipText = string;
                this.hideTip();
                this.showTip();
                this.exitTimer.stop();
            }
        } else {
            this.currentTip = null;
            this.currentPoint = null;
            this.hideTip();
            this.enterTimer.stop();
            this.exitTimer.stop();
        }
    }

    void showTip() {
        if (!(this.enabled && this.currentComponent != null && this.currentComponent.isEnabled() && this.currentComponent.isShowing())) {
            this.popup = null;
            return;
        }
        if (this.currentTip == null || this.currentTip.getComponent() != this.currentComponent) {
            this.currentTip = this.currentComponent.createToolTip();
        }
        this.currentTip.setTipText(this.toolTipText);
        Point point = this.currentPoint;
        Point point2 = this.currentComponent.getLocationOnScreen();
        Dimension dimension = this.currentTip.getPreferredSize();
        JLayeredPane jLayeredPane = null;
        JRootPane jRootPane = (JRootPane)SwingUtilities.getAncestorOfClass(JRootPane.class, this.currentComponent);
        if (jRootPane != null) {
            jLayeredPane = jRootPane.getLayeredPane();
        }
        if (jLayeredPane == null) {
            return;
        }
        point.translate(point2.x, point2.y);
        this.adjustLocation(point, jLayeredPane, dimension);
        this.currentTip.setBounds(0, 0, dimension.width, dimension.height);
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.popup = popupFactory.getPopup(this.currentComponent, this.currentTip, point.x, point.y);
        this.popup.show();
    }

    private Point adjustLocation(Point point, Component component, Dimension dimension) {
        if (point.x + dimension.width > component.getWidth()) {
            point.x -= dimension.width;
        }
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y + dimension.height < component.getHeight()) {
            point.y += dimension.height;
        }
        if (point.y + dimension.height > component.getHeight()) {
            point.y -= dimension.height;
        }
        return point;
    }

    void hideTip() {
        if (this.popup != null) {
            this.popup.hide();
        }
    }

    private Component getContentPaneDeepestComponent(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        Container container = SwingUtilities.getAncestorOfClass(JRootPane.class, this.currentComponent);
        if (container == null) {
            return null;
        }
        container = ((JRootPane)container).getContentPane();
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint(component, point, container);
        Component component2 = SwingUtilities.getDeepestComponentAt(container, point.x, point.y);
        return component2;
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManager.this.showTip();
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        protected stillInsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManager.this.hideTip();
        }
    }
}

