/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timer
implements Serializable {
    private static final long serialVersionUID = -1116180831621385484L;
    private Runnable drainer = new Runnable(){

        public void run() {
            Timer.this.drainEvents();
        }
    };
    private static java.util.Timer timer = new java.util.Timer("swing.Timer", true);
    static boolean logTimers;
    protected EventListenerList listenerList = new EventListenerList();
    boolean coalesce = true;
    boolean repeats = true;
    int delay;
    int initialDelay;
    int ticks;
    Task task;
    private long queue;
    private Object queueLock = new Object();

    public Timer(int n, ActionListener actionListener) {
        this.delay = n;
        this.initialDelay = n;
        if (actionListener != null) {
            this.addActionListener(actionListener);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void setCoalesce(boolean bl) {
        this.coalesce = bl;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public static void setLogTimers(boolean bl) {
        logTimers = bl;
    }

    public static boolean getLogTimers() {
        return logTimers;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid delay: " + n);
        }
        this.delay = n;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setInitialDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid initial delay: " + n);
        }
        this.initialDelay = n;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setRepeats(boolean bl) {
        this.repeats = bl;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public boolean isRunning() {
        return this.task != null;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void start() {
        Task task = this.task;
        if (task == null) {
            task = new Task();
            if (this.isRepeats()) {
                timer.schedule((TimerTask)task, this.getInitialDelay(), (long)this.getDelay());
            } else {
                timer.schedule((TimerTask)task, this.getInitialDelay());
            }
            this.task = task;
        }
    }

    public void stop() {
        Task task = this.task;
        if (task != null) {
            task.cancel();
            this.task = null;
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        ActionListener[] actionListenerArray = this.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            actionListenerArray[i].actionPerformed(actionEvent);
        }
    }

    void fireActionPerformed() {
        this.fireActionPerformed(new ActionEvent(this, this.ticks++, "Timer"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drainEvents() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.isCoalesce()) {
                if (this.queue > 0L) {
                    this.fireActionPerformed();
                }
            } else {
                while (this.queue > 0L) {
                    this.fireActionPerformed();
                    --this.queue;
                }
            }
            this.queue = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueEvent() {
        Object object = this.queueLock;
        synchronized (object) {
            ++this.queue;
            if (this.queue == 1L) {
                SwingUtilities.invokeLater(this.drainer);
            }
        }
    }

    private class Task
    extends TimerTask {
        private Task() {
        }

        public void run() {
            if (logTimers) {
                System.out.println("javax.swing.Timer -> queueEvent()");
            }
            Timer.this.queueEvent();
            if (!Timer.this.repeats) {
                Timer.this.task = null;
            }
        }
    }
}

