/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.text.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingUtilities
implements SwingConstants {
    private static OwnerFrame ownerFrame;

    private SwingUtilities() {
    }

    public static Rectangle calculateInnerArea(JComponent jComponent, Rectangle rectangle) {
        if (jComponent == null) {
            return null;
        }
        rectangle = jComponent.getBounds(rectangle);
        Insets insets = jComponent.getInsets();
        rectangle.x = insets.left;
        rectangle.width = rectangle.width - insets.left - insets.right;
        rectangle.y = insets.top;
        rectangle.height = rectangle.height - insets.top - insets.bottom;
        return rectangle;
    }

    public static Component findFocusOwner(Component component) {
        Component component2;
        for (Component component3 = component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); component3 != null; component3 = component3.getParent()) {
            if (component3 != component) continue;
            return component2;
        }
        return null;
    }

    public static Accessible getAccessibleAt(Component component, Point point) {
        return component.getAccessibleContext().getAccessibleComponent().getAccessibleAt(point);
    }

    public static Accessible getAccessibleChild(Component component, int n) {
        return component.getAccessibleContext().getAccessibleChild(n);
    }

    public static int getAccessibleChildrenCount(Component component) {
        return component.getAccessibleContext().getAccessibleChildrenCount();
    }

    public static int getAccessibleIndexInParent(Component component) {
        return component.getAccessibleContext().getAccessibleIndexInParent();
    }

    public static AccessibleStateSet getAccessibleStateSet(Component component) {
        return component.getAccessibleContext().getAccessibleStateSet();
    }

    public static Rectangle getLocalBounds(Component component) {
        Rectangle rectangle = component.getBounds();
        return new Rectangle(0, 0, rectangle.width, rectangle.height);
    }

    public static JRootPane getRootPane(Component component) {
        if (component instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)component)).getRootPane();
        }
        return (JRootPane)SwingUtilities.getAncestorOfClass(JRootPane.class, component);
    }

    public static Container getAncestorNamed(String string, Component component) {
        while (component != null && component.getName() != string) {
            component = component.getParent();
        }
        return (Container)component;
    }

    public static Container getAncestorOfClass(Class<?> clazz, Component component) {
        while (component != null && !clazz.isInstance(component)) {
            component = component.getParent();
        }
        return (Container)component;
    }

    public static Window getWindowAncestor(Component component) {
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, component);
    }

    public static Window windowForComponent(Component component) {
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, component);
    }

    public static Component getRoot(Component component) {
        Applet applet = null;
        Window window = null;
        while (component != null) {
            if (window == null && component instanceof Window) {
                window = (Window)component;
            } else if (component instanceof Applet) {
                applet = (Applet)component;
            }
            component = component.getParent();
        }
        if (window != null) {
            return window;
        }
        return applet;
    }

    public static boolean isDescendingFrom(Component component, Component component2) {
        while (component != null && component2 != null) {
            if (component == component2) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    public static Component getDeepestComponentAt(Component component, int n, int n2) {
        if (component == null || !component.contains(n, n2)) {
            return null;
        }
        if (!(component instanceof Container)) {
            return component;
        }
        Container container = (Container)component;
        return container.findComponentAt(n, n2);
    }

    public static void convertPointToScreen(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point.translate(point2.x, point2.y);
    }

    public static void convertPointFromScreen(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point.translate(-point2.x, -point2.y);
    }

    public static Point convertPoint(Component component, int n, int n2, Component component2) {
        Point point = new Point(n, n2);
        if (component == null && component2 == null) {
            return point;
        }
        if (component == null) {
            component = SwingUtilities.getRoot(component2);
        }
        if (component2 == null) {
            component2 = SwingUtilities.getRoot(component);
        }
        if (component.isShowing() && component2.isShowing()) {
            SwingUtilities.convertPointToScreen(point, component);
            SwingUtilities.convertPointFromScreen(point, component2);
        }
        return point;
    }

    public static Point convertPoint(Component component, Point point, Component component2) {
        return SwingUtilities.convertPoint(component, point.x, point.y, component2);
    }

    public static Rectangle convertRectangle(Component component, Rectangle rectangle, Component component2) {
        Point point = SwingUtilities.convertPoint(component, rectangle.x, rectangle.y, component2);
        return new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
    }

    public static MouseEvent convertMouseEvent(Component component, MouseEvent mouseEvent, Component component2) {
        Point point = SwingUtilities.convertPoint(component, mouseEvent.getX(), mouseEvent.getY(), component2);
        return new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    public static void updateComponentTreeUI(Component component) {
        SwingUtilities.updateComponentTreeUIImpl(component);
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.revalidate();
        } else {
            component.invalidate();
            component.validate();
        }
        component.repaint();
    }

    private static void updateComponentTreeUIImpl(Component component) {
        Component[] componentArray;
        if (component instanceof JComponent) {
            componentArray = (Component[])component;
            componentArray.updateUI();
        }
        componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                SwingUtilities.updateComponentTreeUIImpl(componentArray[i]);
            }
        }
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        boolean bl = true;
        if (jComponent != null && !jComponent.getComponentOrientation().isLeftToRight()) {
            bl = false;
        }
        switch (n4) {
            case 10: {
                n4 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n4 = bl ? 4 : 2;
                break;
            }
        }
        switch (n2) {
            case 10: {
                n2 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n2 = bl ? 4 : 2;
                break;
            }
        }
        return SwingUtilities.layoutCompoundLabelImpl(jComponent, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
    }

    public static String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        return SwingUtilities.layoutCompoundLabelImpl(null, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
    }

    private static String layoutCompoundLabelImpl(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        int n6;
        int n7;
        if (icon == null) {
            n5 = 0;
            rectangle2.width = 0;
            rectangle2.height = 0;
        } else {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        }
        if (string == null || string.equals("")) {
            n5 = 0;
            rectangle3.width = 0;
            rectangle3.height = 0;
            string = "";
        } else {
            View view;
            n7 = rectangle.width;
            if (n4 != 0) {
                n7 -= rectangle2.width + n5;
            }
            View view2 = view = jComponent == null ? null : (View)jComponent.getClientProperty("html");
            if (view != null) {
                rectangle3.width = (int)view.getPreferredSpan(0);
                rectangle3.width = Math.min(n7, rectangle3.width);
                rectangle3.height = (int)view.getPreferredSpan(1);
            } else {
                n6 = 0;
                rectangle3.width = fontMetrics.stringWidth(string);
                rectangle3.height = fontMetrics.getHeight();
                if (rectangle3.width > n7) {
                    string = SwingUtilities.clipString(jComponent, fontMetrics, string, n7);
                    rectangle3.width = fontMetrics.stringWidth(string);
                }
            }
        }
        switch (n3) {
            case 1: {
                rectangle3.y = n4 == 0 ? -rectangle3.height - n5 : 0;
                break;
            }
            case 3: {
                rectangle3.y = n4 == 0 ? rectangle2.height + n5 : rectangle2.height - rectangle3.height;
                break;
            }
            case 0: {
                rectangle3.y = rectangle2.height / 2 - rectangle3.height / 2;
            }
        }
        switch (n4) {
            case 2: {
                rectangle3.x = -(rectangle3.width + n5);
                break;
            }
            case 4: {
                rectangle3.x = rectangle2.width + n5;
                break;
            }
            case 0: {
                rectangle3.x = rectangle2.width / 2 - rectangle3.width / 2;
            }
        }
        n7 = Math.min(rectangle2.x, rectangle3.x);
        int n8 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n7;
        n6 = Math.min(rectangle2.y, rectangle3.y);
        int n9 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n6;
        int n10 = 0;
        int n11 = 0;
        switch (n) {
            case 1: {
                n11 = rectangle.y - n6;
                break;
            }
            case 3: {
                n11 = rectangle.y + rectangle.height - n6 - n9;
                break;
            }
            case 0: {
                n11 = rectangle.y + rectangle.height / 2 - n6 - n9 / 2;
            }
        }
        switch (n2) {
            case 2: {
                n10 = rectangle.x - n7;
                break;
            }
            case 4: {
                n10 = rectangle.x + rectangle.width - n7 - n8;
                break;
            }
            case 0: {
                n10 = rectangle.x + rectangle.width / 2 - (n7 + n8 / 2);
            }
        }
        rectangle2.x += n10;
        rectangle2.y += n11;
        rectangle3.x += n10;
        rectangle3.y += n11;
        return string;
    }

    private static String clipString(JComponent jComponent, FontMetrics fontMetrics, String string, int n) {
        String string2;
        int n2;
        String string3 = "...";
        int n3 = fontMetrics.stringWidth(string3);
        char[] cArray = string.toCharArray();
        for (n2 = cArray.length; fontMetrics.charsWidth(cArray, 0, n2) + n3 > n && n2 > 0; --n2) {
        }
        if (cArray.length >= n2 + 3) {
            cArray[n2] = 46;
            cArray[n2 + 1] = 46;
            cArray[n2 + 2] = 46;
            string2 = new String(cArray, 0, n2 + 3);
        } else {
            char[] cArray2 = new char[cArray.length + 3];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            cArray2[n2] = 46;
            cArray2[n2 + 1] = 46;
            cArray2[n2 + 2] = 46;
            string2 = new String(cArray2, 0, n2 + 3);
        }
        return string2;
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(runnable);
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4) {
        Container container2 = component.getParent();
        if (container2 != null) {
            container2.remove(component);
        }
        if (container != null) {
            container.add(component);
        }
        Shape shape = graphics.getClip();
        graphics.setClip(n, n2, n3, n4);
        graphics.translate(n, n2);
        component.paint(graphics);
        graphics.translate(-n, -n2);
        graphics.setClip(shape);
    }

    public static void paintComponent(Graphics graphics, Component component, Container container, Rectangle rectangle) {
        SwingUtilities.paintComponent(graphics, component, container, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static Window getOwnerFrame(Window window) {
        Window window2 = window;
        if (window2 == null) {
            if (ownerFrame == null) {
                ownerFrame = new OwnerFrame();
            }
            window2 = ownerFrame;
        }
        return window2;
    }

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 0x10) != 0;
    }

    public static boolean isMiddleMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiersEx() & 0x800) == 2048;
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiersEx() & 0x1000) == 4096;
    }

    public static boolean notifyAction(Action action, KeyStroke keyStroke, KeyEvent keyEvent, Object object, int n) {
        if (action != null && action.isEnabled()) {
            String string = (String)action.getValue("ActionCommandKey");
            if (string == null && keyEvent.getKeyChar() != '\uffff') {
                string = new String(new char[]{keyEvent.getKeyChar()});
            }
            action.actionPerformed(new ActionEvent(object, 1001, string, n));
            return true;
        }
        return false;
    }

    public static void replaceUIActionMap(JComponent jComponent, ActionMap actionMap) {
        ActionMap actionMap2 = jComponent.getActionMap();
        if (actionMap2 == null) {
            jComponent.setActionMap(actionMap);
        } else {
            ActionMap actionMap3 = actionMap2.getParent();
            while (actionMap3 != null && !(actionMap3 instanceof ActionMapUIResource)) {
                actionMap2 = actionMap3;
                actionMap3 = actionMap2.getParent();
            }
            if (actionMap2 != actionMap) {
                actionMap2.setParent(actionMap);
            }
        }
    }

    public static void replaceUIInputMap(JComponent jComponent, int n, InputMap inputMap) {
        InputMap inputMap2 = jComponent.getInputMap(n);
        if (inputMap2 == null) {
            jComponent.setInputMap(n, inputMap);
        } else {
            for (InputMap inputMap3 = inputMap2.getParent(); inputMap3 != null && !(inputMap3 instanceof InputMapUIResource); inputMap3 = inputMap3.getParent()) {
                inputMap2 = inputMap3;
            }
            if (inputMap2 != inputMap) {
                inputMap2.setParent(inputMap);
            }
        }
    }

    public static Rectangle[] computeDifference(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            return new Rectangle[0];
        }
        Rectangle[] rectangleArray = new Rectangle[4];
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rectangle2.x;
        int n6 = rectangle2.y;
        int n7 = rectangle2.width;
        int n8 = rectangle2.height;
        int n9 = n6 > n2 ? n6 - n2 : 0;
        int n10 = n6 + n8 < n2 + n4 ? n2 + n4 - n6 - n8 : 0;
        int n11 = n5 > n ? n5 - n : 0;
        int n12 = n + n3 > n5 + n7 ? n + n3 - n5 - n7 : 0;
        int n13 = n9 + n10 < n4 ? n4 - n9 - n10 : 0;
        rectangleArray[0] = n9 > 0 ? new Rectangle(n, n2, n3, n9) : null;
        rectangleArray[1] = n11 > 0 && n13 > 0 ? new Rectangle(n, n2 + n9, n11, n13) : null;
        rectangleArray[2] = n12 > 0 && n13 > 0 ? new Rectangle(n5 + n7, n2 + n9, n12, n13) : null;
        rectangleArray[3] = n10 > 0 ? new Rectangle(n, n2 + n9 + n13, n3, n10) : null;
        int n14 = 0;
        for (int i = 0; i < 4; ++i) {
            if (rectangleArray[i] == null) continue;
            ++n14;
        }
        Rectangle[] rectangleArray2 = new Rectangle[n14];
        for (int i = 3; i >= 0; --i) {
            if (rectangleArray[i] == null) continue;
            rectangleArray2[--n14] = rectangleArray[i];
        }
        return rectangleArray2;
    }

    public static Rectangle computeIntersection(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        int n10 = n > n6 ? n : n6;
        int n11 = n2 > n7 ? n2 : n7;
        int n12 = n + n3 < n6 + n8 ? n + n3 - n10 : n6 + n8 - n10;
        int n13 = n5 = n2 + n4 < n7 + n9 ? n2 + n4 - n11 : n7 + n9 - n11;
        if (n12 >= 0 && n5 >= 0) {
            rectangle.setBounds(n10, n11, n12, n5);
        } else {
            rectangle.setBounds(0, 0, 0, 0);
        }
        return rectangle;
    }

    public static int computeStringWidth(FontMetrics fontMetrics, String string) {
        return fontMetrics.stringWidth(string);
    }

    public static Rectangle computeUnion(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        int n10 = n < n6 ? n : n6;
        int n11 = n2 < n7 ? n2 : n7;
        int n12 = n + n3 > n6 + n8 ? n + n3 - n10 : n6 + n8 - n10;
        int n13 = n5 = n2 + n4 > n7 + n9 ? n2 + n4 - n11 : n7 + n9 - n11;
        if (n12 >= 0 && n5 >= 0) {
            rectangle.setBounds(n10, n11, n12, n5);
        } else {
            rectangle.setBounds(0, 0, 0, 0);
        }
        return rectangle;
    }

    public static boolean isRectangleContainingRectangle(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.width >= 0 && rectangle2.height >= 0 && rectangle2.width >= 0 && rectangle2.height >= 0 && rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width && rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
    }

    public static InputMap getUIInputMap(JComponent jComponent, int n) {
        if (UIManager.getUI(jComponent) != null) {
            return jComponent.getInputMap(n).getParent();
        }
        return null;
    }

    public static ActionMap getUIActionMap(JComponent jComponent) {
        if (UIManager.getUI(jComponent) != null) {
            return jComponent.getActionMap().getParent();
        }
        return null;
    }

    public static boolean processKeyBindings(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        KeyboardManager keyboardManager = KeyboardManager.getManager();
        return keyboardManager.processKeyStroke(component, keyStroke, keyEvent);
    }

    static String convertHorizontalAlignmentCodeToString(int n) {
        switch (n) {
            case 0: {
                return "CENTER";
            }
            case 2: {
                return "LEFT";
            }
            case 4: {
                return "RIGHT";
            }
            case 10: {
                return "LEADING";
            }
            case 11: {
                return "TRAILING";
            }
        }
        throw new IllegalArgumentException("Unrecognised code: " + n);
    }

    static String convertVerticalAlignmentCodeToString(int n) {
        switch (n) {
            case 0: {
                return "CENTER";
            }
            case 1: {
                return "TOP";
            }
            case 3: {
                return "BOTTOM";
            }
        }
        throw new IllegalArgumentException("Unrecognised code: " + n);
    }

    static String convertWindowConstantToString(int n) {
        switch (n) {
            case 0: {
                return "DO_NOTHING_ON_CLOSE";
            }
            case 1: {
                return "HIDE_ON_CLOSE";
            }
            case 2: {
                return "DISPOSE_ON_CLOSE";
            }
            case 3: {
                return "EXIT_ON_CLOSE";
            }
        }
        throw new IllegalArgumentException("Unrecognised code: " + n);
    }

    static void convertRectangleToAncestor(Component component, Rectangle rectangle, Component component2) {
        if (component == component2) {
            return;
        }
        rectangle.x += component.getX();
        rectangle.y += component.getY();
        Container container = component.getParent();
        if (container != null && container != component2) {
            SwingUtilities.convertRectangleToAncestor(container, rectangle, component2);
        }
    }

    private static class OwnerFrame
    extends Frame {
        private OwnerFrame() {
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return true;
        }
    }
}

