/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;

public abstract class Spring {
    public static final int UNSET = Integer.MIN_VALUE;

    protected Spring() {
    }

    public static Spring constant(int n) {
        return new SimpleSpring(n, n, n);
    }

    public static Spring constant(int n, int n2, int n3) {
        return new SimpleSpring(n, n2, n3);
    }

    public abstract int getMaximumValue();

    public abstract int getMinimumValue();

    public abstract int getPreferredValue();

    public abstract int getValue();

    public static Spring max(Spring spring, Spring spring2) {
        return new MaxSpring(spring, spring2);
    }

    public static Spring minus(Spring spring) {
        return new MinusSpring(spring);
    }

    public abstract void setValue(int var1);

    private int getShrinkRange() {
        return this.getPreferredValue() - this.getMinimumValue();
    }

    private int getExpandRange() {
        return this.getMaximumValue() - this.getPreferredValue();
    }

    double getStrain() {
        int n;
        int n2;
        int n3 = this.getValue();
        int n4 = n2 = n3 < (n = this.getPreferredValue()) ? this.getShrinkRange() : this.getExpandRange();
        if (n2 == 0) {
            n2 = 1;
        }
        return (double)(n3 - n) / (double)n2;
    }

    void setStrain(double d) {
        int n = d < 0.0 ? this.getShrinkRange() : this.getExpandRange();
        int n2 = this.getPreferredValue() + (int)(d * (double)n);
        this.setValue(n2);
    }

    public static Spring sum(Spring spring, Spring spring2) {
        return new AddSpring(spring, spring2);
    }

    public static Spring scale(final Spring spring, final float f) {
        if (spring == null) {
            throw new NullPointerException("spring argument is null");
        }
        return new Spring(){

            public int getMaximumValue() {
                return (int)((float)(f < 0.0f ? spring.getMinimumValue() : spring.getMaximumValue()) * f);
            }

            public int getMinimumValue() {
                return (int)((float)(f < 0.0f ? spring.getMaximumValue() : spring.getMinimumValue()) * f);
            }

            public int getPreferredValue() {
                return (int)((float)spring.getPreferredValue() * f);
            }

            public int getValue() {
                return (int)((float)spring.getValue() * f);
            }

            public void setValue(int n) {
                spring.setValue((int)((float)n / f));
            }
        };
    }

    public static Spring width(final Component component) {
        return new Spring(){

            public int getMaximumValue() {
                return component.getMaximumSize().width;
            }

            public int getMinimumValue() {
                return component.getMinimumSize().width;
            }

            public int getPreferredValue() {
                return component.getPreferredSize().width;
            }

            public int getValue() {
                return component.getSize().width;
            }

            public void setValue(int n) {
                Dimension dimension = component.getSize();
                component.setSize(n, dimension.height);
            }
        };
    }

    public static Spring height(final Component component) {
        return new Spring(){

            public int getMaximumValue() {
                return component.getMaximumSize().height;
            }

            public int getMinimumValue() {
                return component.getMinimumSize().height;
            }

            public int getPreferredValue() {
                return component.getPreferredSize().height;
            }

            public int getValue() {
                return component.getSize().height;
            }

            public void setValue(int n) {
                Dimension dimension = component.getSize();
                component.setSize(dimension.width, n);
            }
        };
    }

    private static final class MaxSpring
    extends Spring {
        private final Spring s1;
        private final Spring s2;
        private int value;

        public String toString() {
            return "MaxSpring of " + this.s1 + " and " + this.s2;
        }

        protected MaxSpring(Spring spring, Spring spring2) {
            this.s1 = spring;
            this.s2 = spring2;
            this.value = Integer.MIN_VALUE;
        }

        public int getMaximumValue() {
            int n = this.s1.getMaximumValue();
            int n2 = this.s2.getMaximumValue();
            return Math.max(n, n2);
        }

        public int getMinimumValue() {
            int n = this.s1.getMinimumValue();
            int n2 = this.s2.getMinimumValue();
            return Math.max(n, n2);
        }

        public int getPreferredValue() {
            int n = this.s1.getPreferredValue();
            int n2 = this.s2.getPreferredValue();
            return Math.max(n, n2);
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                int n = this.s1.getValue();
                int n2 = this.s2.getValue();
                this.value = Math.max(n, n2);
            }
            return this.value;
        }

        public void setValue(int n) {
            int n2;
            if (n == Integer.MIN_VALUE) {
                if (this.value != Integer.MIN_VALUE) {
                    this.s1.setValue(Integer.MIN_VALUE);
                    this.s2.setValue(Integer.MIN_VALUE);
                }
                this.value = Integer.MIN_VALUE;
                return;
            }
            this.value = n;
            int n3 = this.s1.getPreferredValue();
            if (n3 < (n2 = this.s2.getPreferredValue())) {
                this.s1.setValue(Math.min(n, n3));
                this.s2.setValue(n);
            } else {
                this.s1.setValue(n);
                this.s2.setValue(Math.min(n, n2));
            }
        }
    }

    private static final class MinusSpring
    extends Spring {
        private final Spring s;

        public String toString() {
            return "MinusSpring of " + this.s;
        }

        protected MinusSpring(Spring spring) {
            this.s = spring;
        }

        public int getMaximumValue() {
            return -this.s.getMinimumValue();
        }

        public int getMinimumValue() {
            return -this.s.getMaximumValue();
        }

        public int getPreferredValue() {
            return -this.s.getPreferredValue();
        }

        public int getValue() {
            return -this.s.getValue();
        }

        public void setValue(int n) {
            if (n == Integer.MIN_VALUE) {
                this.s.setValue(Integer.MIN_VALUE);
            } else {
                this.s.setValue(-n);
            }
        }
    }

    private static final class AddSpring
    extends Spring {
        private final Spring s1;
        private final Spring s2;
        private int value;

        public String toString() {
            return "AddSpring of " + this.s1 + " and " + this.s2;
        }

        protected AddSpring(Spring spring, Spring spring2) {
            this.s1 = spring;
            this.s2 = spring2;
            this.value = Integer.MIN_VALUE;
        }

        public int getMaximumValue() {
            int n = this.s1.getMaximumValue();
            int n2 = this.s2.getMaximumValue();
            return n + n2;
        }

        public int getMinimumValue() {
            int n = this.s1.getMinimumValue();
            int n2 = this.s2.getMinimumValue();
            return n + n2;
        }

        public int getPreferredValue() {
            int n = this.s1.getPreferredValue();
            int n2 = this.s2.getPreferredValue();
            return n + n2;
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                int n = this.s1.getValue();
                int n2 = this.s2.getValue();
                this.value = n + n2;
            }
            return this.value;
        }

        public void setValue(int n) {
            if (n == Integer.MIN_VALUE) {
                if (this.value != Integer.MIN_VALUE) {
                    this.s1.setValue(Integer.MIN_VALUE);
                    this.s2.setValue(Integer.MIN_VALUE);
                }
                this.value = Integer.MIN_VALUE;
                return;
            }
            this.value = n;
            double d = this.getStrain();
            this.s1.setStrain(d);
            int n2 = n - this.s1.getValue();
            this.s2.setValue(n2);
        }
    }

    private static final class SimpleSpring
    extends Spring {
        private final int min;
        private final int pref;
        private final int max;
        private int value;

        public String toString() {
            return "SimpleSpring of " + this.value;
        }

        public SimpleSpring(int n, int n2, int n3) {
            this.min = n;
            this.pref = n2;
            this.max = n3;
            this.value = n2;
        }

        public int getMaximumValue() {
            return this.max;
        }

        public int getMinimumValue() {
            return this.min;
        }

        public int getPreferredValue() {
            return this.pref;
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                return this.pref;
            }
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }
    }
}

