/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;

public class SizeRequirements
implements Serializable {
    private static final long serialVersionUID = 9217749429906736553L;
    public int minimum;
    public int preferred;
    public int maximum;
    public float alignment;

    public SizeRequirements() {
        this(0, 0, 0, 0.5f);
    }

    public SizeRequirements(int n, int n2, int n3, float f) {
        this.minimum = n;
        this.preferred = n2;
        this.maximum = n3;
        this.alignment = f;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<[");
        stringBuilder.append(this.minimum);
        stringBuilder.append(',');
        stringBuilder.append(this.preferred);
        stringBuilder.append(',');
        stringBuilder.append(this.maximum);
        stringBuilder.append("]@");
        stringBuilder.append(this.alignment);
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    public static SizeRequirements getTiledSizeRequirements(SizeRequirements[] sizeRequirementsArray) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < sizeRequirementsArray.length; ++i) {
            l += (long)sizeRequirementsArray[i].minimum;
            l2 += (long)sizeRequirementsArray[i].preferred;
            l3 += (long)sizeRequirementsArray[i].maximum;
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        if (l3 > Integer.MAX_VALUE) {
            l3 = Integer.MAX_VALUE;
        }
        SizeRequirements sizeRequirements = new SizeRequirements((int)l, (int)l2, (int)l3, 0.5f);
        return sizeRequirements;
    }

    public static SizeRequirements getAlignedSizeRequirements(SizeRequirements[] sizeRequirementsArray) {
        float f;
        int n;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (n = 0; n < sizeRequirementsArray.length; ++n) {
            float f8 = (float)sizeRequirementsArray[n].minimum * sizeRequirementsArray[n].alignment;
            float f9 = (float)sizeRequirementsArray[n].minimum - f8;
            f2 = Math.max(f8, f2);
            f3 = Math.max(f9, f3);
            f = (float)sizeRequirementsArray[n].preferred * sizeRequirementsArray[n].alignment;
            float f10 = (float)sizeRequirementsArray[n].preferred - f;
            f4 = Math.max(f, f4);
            f5 = Math.max(f10, f5);
            float f11 = (float)sizeRequirementsArray[n].maximum * sizeRequirementsArray[n].alignment;
            float f12 = (float)sizeRequirementsArray[n].maximum - f11;
            f6 = Math.max(f11, f6);
            f7 = Math.max(f12, f7);
        }
        n = (int)(f2 + f3);
        int n2 = (int)(f4 + f5);
        int n3 = (int)(f6 + f7);
        f = f4 / (f5 + f4);
        if (Float.isNaN(f)) {
            f = 0.0f;
        }
        return new SizeRequirements(n, n2, n3, f);
    }

    public static void calculateTiledPositions(int n, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2) {
        SizeRequirements.calculateTiledPositions(n, sizeRequirements, sizeRequirementsArray, nArray, nArray2, true);
    }

    public static void calculateTiledPositions(int n, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2, boolean bl) {
        int n2;
        int n3;
        int n4 = 0;
        if (bl) {
            n3 = 0;
            for (n2 = 0; n2 < sizeRequirementsArray.length; ++n2) {
                nArray[n2] = n3;
                nArray2[n2] = sizeRequirementsArray[n2].preferred;
                n4 += nArray2[n2];
                n3 += sizeRequirementsArray[n2].preferred;
            }
        } else {
            n3 = n;
            for (n2 = 0; n2 < sizeRequirementsArray.length; ++n2) {
                nArray[n2] = n3 -= sizeRequirementsArray[n2].preferred;
                n4 += nArray2[n2];
                nArray2[n2] = sizeRequirementsArray[n2].preferred;
            }
        }
        if (n4 > n) {
            SizeRequirements.adjustSmaller(n, sizeRequirementsArray, nArray2, n4);
        } else if (n4 < n) {
            SizeRequirements.adjustGreater(n, sizeRequirementsArray, nArray2, n4);
        }
        if (bl) {
            n3 = 0;
            for (n2 = 0; n2 < sizeRequirementsArray.length; ++n2) {
                nArray[n2] = n3;
                n3 += nArray2[n2];
            }
        } else {
            n3 = n;
            for (n2 = 0; n2 < sizeRequirementsArray.length; ++n2) {
                nArray[n2] = n3 -= nArray2[n2];
            }
        }
    }

    private static void adjustSmaller(int n, SizeRequirements[] sizeRequirementsArray, int[] nArray, int n2) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < sizeRequirementsArray.length; ++n3) {
            n4 += sizeRequirementsArray[n3].preferred - sizeRequirementsArray[n3].minimum;
        }
        if (n4 == 0) {
            return;
        }
        n3 = 0;
        while (n3 < sizeRequirementsArray.length) {
            double d = (double)(sizeRequirementsArray[n3].preferred - sizeRequirementsArray[n3].minimum) / (double)n4;
            if (Double.isNaN(d)) {
                d = 0.0;
            }
            int n5 = n3++;
            nArray[n5] = (int)((double)nArray[n5] - d * (double)(n2 - n));
        }
    }

    private static void adjustGreater(int n, SizeRequirements[] sizeRequirementsArray, int[] nArray, int n2) {
        int n3;
        long l = 0L;
        for (n3 = 0; n3 < sizeRequirementsArray.length; ++n3) {
            l += (long)(sizeRequirementsArray[n3].maximum - sizeRequirementsArray[n3].preferred);
        }
        if (l == 0L) {
            return;
        }
        n3 = 0;
        while (n3 < sizeRequirementsArray.length) {
            double d = (double)(sizeRequirementsArray[n3].maximum - sizeRequirementsArray[n3].preferred) / (double)l;
            int n4 = n3++;
            nArray[n4] = (int)((double)nArray[n4] + d * (double)(n - n2));
        }
    }

    public static void calculateAlignedPositions(int n, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2) {
        SizeRequirements.calculateAlignedPositions(n, sizeRequirements, sizeRequirementsArray, nArray, nArray2, true);
    }

    public static void calculateAlignedPositions(int n, SizeRequirements sizeRequirements, SizeRequirements[] sizeRequirementsArray, int[] nArray, int[] nArray2, boolean bl) {
        float f = (float)n * sizeRequirements.alignment;
        for (int i = 0; i < sizeRequirementsArray.length; ++i) {
            float f2 = sizeRequirementsArray[i].alignment;
            int[] nArray3 = new int[2];
            if (f2 < 0.5f || f == 0.0f) {
                SizeRequirements.adjustFromRight(sizeRequirementsArray[i], f, n, nArray3);
            } else {
                SizeRequirements.adjustFromLeft(sizeRequirementsArray[i], f, n, nArray3);
            }
            nArray2[i] = nArray3[0];
            nArray[i] = nArray3[1];
        }
    }

    private static void adjustFromRight(SizeRequirements sizeRequirements, float f, int n, int[] nArray) {
        float f2 = (float)n - f;
        float f3 = (float)sizeRequirements.maximum * (1.0f - sizeRequirements.alignment);
        if (f2 / (1.0f - sizeRequirements.alignment) > (float)sizeRequirements.maximum) {
            f2 = f3;
        }
        if (f2 / (1.0f - sizeRequirements.alignment) * sizeRequirements.alignment > (float)n - f) {
            f2 = ((float)n - f) / sizeRequirements.alignment * (1.0f - sizeRequirements.alignment);
        }
        nArray[0] = (int)(f2 / (1.0f - sizeRequirements.alignment));
        nArray[1] = (int)(f - (float)nArray[0] * sizeRequirements.alignment);
    }

    private static void adjustFromLeft(SizeRequirements sizeRequirements, float f, int n, int[] nArray) {
        float f2 = f;
        float f3 = (float)sizeRequirements.maximum * sizeRequirements.alignment;
        if (f2 / sizeRequirements.alignment > (float)sizeRequirements.maximum) {
            f2 = f3;
        }
        if (f2 / sizeRequirements.alignment * (1.0f - sizeRequirements.alignment) > (float)n - f) {
            f2 = ((float)n - f) / (1.0f - sizeRequirements.alignment) * sizeRequirements.alignment;
        }
        nArray[0] = (int)(f2 / sizeRequirements.alignment);
        nArray[1] = (int)(f - (float)nArray[0] * sizeRequirements.alignment);
    }

    public static int[] adjustSizes(int n, SizeRequirements[] sizeRequirementsArray) {
        return null;
    }
}

