/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ScrollPaneLayout
implements LayoutManager,
ScrollPaneConstants,
Serializable {
    private static final long serialVersionUID = -4480022884523193743L;
    protected JViewport viewport;
    protected JScrollBar vsb;
    protected JScrollBar hsb;
    protected JViewport rowHead;
    protected JViewport colHead;
    protected Component lowerLeft;
    protected Component lowerRight;
    protected Component upperLeft;
    protected Component upperRight;
    protected int vsbPolicy;
    protected int hsbPolicy;

    public void syncWithScrollPane(JScrollPane jScrollPane) {
        this.viewport = jScrollPane.getViewport();
        this.rowHead = jScrollPane.getRowHeader();
        this.colHead = jScrollPane.getColumnHeader();
        this.vsb = jScrollPane.getVerticalScrollBar();
        this.hsb = jScrollPane.getHorizontalScrollBar();
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        this.lowerLeft = jScrollPane.getCorner("LOWER_LEFT_CORNER");
        this.lowerRight = jScrollPane.getCorner("LOWER_RIGHT_CORNER");
        this.upperLeft = jScrollPane.getCorner("UPPER_LEFT_CORNER");
        this.upperRight = jScrollPane.getCorner("UPPER_RIGHT_CORNER");
    }

    protected Component addSingletonComponent(Component component, Component component2) {
        if (component != null && component != component2) {
            component.getParent().remove(component);
        }
        return component2;
    }

    public void addLayoutComponent(String string, Component component) {
        if (string == "VIEWPORT") {
            this.viewport = (JViewport)component;
        } else if (string == "VERTICAL_SCROLLBAR") {
            this.vsb = (JScrollBar)component;
        } else if (string == "HORIZONTAL_SCROLLBAR") {
            this.hsb = (JScrollBar)component;
        } else if (string == "ROW_HEADER") {
            this.rowHead = (JViewport)component;
        } else if (string == "COLUMN_HEADER") {
            this.colHead = (JViewport)component;
        } else if (string == "LOWER_RIGHT_CORNER") {
            this.lowerRight = component;
        } else if (string == "UPPER_RIGHT_CORNER") {
            this.upperRight = component;
        } else if (string == "LOWER_LEFT_CORNER") {
            this.lowerLeft = component;
        } else if (string == "UPPER_LEFT_CORNER") {
            this.upperLeft = component;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.viewport) {
            this.viewport = null;
        } else if (component == this.vsb) {
            this.vsb = null;
        } else if (component == this.hsb) {
            this.hsb = null;
        } else if (component == this.rowHead) {
            this.rowHead = null;
        } else if (component == this.colHead) {
            this.colHead = null;
        } else if (component == this.lowerRight) {
            this.lowerRight = null;
        } else if (component == this.upperRight) {
            this.upperRight = null;
        } else if (component == this.lowerLeft) {
            this.lowerLeft = null;
        } else if (component == this.upperLeft) {
            this.upperLeft = null;
        }
    }

    public int getVerticalScrollBarPolicy() {
        return this.vsbPolicy;
    }

    public void setVerticalScrollBarPolicy(int n) {
        if (n != 20 && n != 21 && n != 22) {
            throw new IllegalArgumentException("Illegal Scrollbar Policy");
        }
        this.vsbPolicy = n;
    }

    public int getHorizontalScrollBarPolicy() {
        return this.hsbPolicy;
    }

    public void setHorizontalScrollBarPolicy(int n) {
        if (n != 30 && n != 31 && n != 32) {
            throw new IllegalArgumentException("Illegal Scrollbar Policy");
        }
        this.hsbPolicy = n;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.hsb;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.vsb;
    }

    public JViewport getRowHeader() {
        return this.rowHead;
    }

    public JViewport getColumnHeader() {
        return this.colHead;
    }

    public Component getCorner(String string) {
        if (string == "LOWER_RIGHT_CORNER") {
            return this.lowerRight;
        }
        if (string == "UPPER_RIGHT_CORNER") {
            return this.upperRight;
        }
        if (string == "LOWER_LEFT_CORNER") {
            return this.lowerLeft;
        }
        if (string == "UPPER_LEFT_CORNER") {
            return this.upperLeft;
        }
        return null;
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets;
        Border border;
        JScrollPane jScrollPane = (JScrollPane)container;
        Dimension dimension = this.viewport.getPreferredSize();
        Dimension dimension2 = this.viewport.getViewSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.hsb != null && dimension2.width > dimension.width) {
            n2 += this.hsb.getPreferredSize().height;
        }
        if (this.vsb != null && dimension2.height > dimension.height) {
            n += this.vsb.getPreferredSize().width;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            n += this.rowHead.getPreferredSize().width;
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            n2 += this.colHead.getPreferredSize().height;
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            insets = border.getBorderInsets(jScrollPane);
            n += insets.left + insets.right;
            n2 += insets.top + insets.bottom;
        }
        insets = jScrollPane.getInsets();
        return new Dimension(n + insets.left + insets.right, n2 + insets.left + insets.right);
    }

    public Dimension minimumLayoutSize(Container container) {
        Border border;
        JScrollPane jScrollPane = (JScrollPane)container;
        Insets insets = jScrollPane.getInsets();
        Dimension dimension = jScrollPane.getViewport().getMinimumSize();
        int n = insets.left + insets.right + dimension.width;
        if (jScrollPane.getVerticalScrollBarPolicy() != 21) {
            n += jScrollPane.getVerticalScrollBar().getMinimumSize().width;
        }
        int n2 = insets.top + insets.bottom + dimension.height;
        if (jScrollPane.getHorizontalScrollBarPolicy() != 31) {
            n2 += jScrollPane.getHorizontalScrollBar().getMinimumSize().height;
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            insets = border.getBorderInsets(jScrollPane);
            n += insets.left + insets.right;
            n2 += insets.top + insets.bottom;
        }
        return new Dimension(n, n2);
    }

    public void layoutContainer(Container container) {
        boolean bl;
        boolean bl2;
        JScrollPane jScrollPane = (JScrollPane)container;
        JViewport jViewport = jScrollPane.getViewport();
        Component component = jViewport.getView();
        if (component == null) {
            return;
        }
        Dimension dimension = jViewport.getView().getPreferredSize();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        Rectangle rectangle = SwingUtilities.calculateInnerArea(jScrollPane, null);
        Border border = jScrollPane.getViewportBorder();
        Insets insets = border != null ? border.getBorderInsets(jScrollPane) : new Insets(0, 0, 0, 0);
        n = rectangle.x;
        n5 = rectangle.y;
        n4 = rectangle.x + rectangle.width;
        n8 = rectangle.y + rectangle.height;
        n6 = this.colHead != null ? n5 + this.colHead.getPreferredSize().height : n5;
        n2 = this.rowHead != null ? n + this.rowHead.getPreferredSize().width : n;
        int n9 = jScrollPane.getVerticalScrollBarPolicy();
        int n10 = jScrollPane.getHorizontalScrollBarPolicy();
        int n11 = 0;
        int n12 = 0;
        boolean bl3 = bl2 = this.vsb != null && (n9 == 22 || n9 == 20 && dimension.height > n8 - n6);
        if (bl2) {
            n11 = this.vsb.getPreferredSize().width;
        }
        boolean bl4 = bl = this.hsb != null && (n10 == 32 || n10 == 30 && dimension.width > n4 - n2 - n11);
        if (bl) {
            n12 = this.hsb.getPreferredSize().height;
        }
        if (!bl2) {
            boolean bl5 = bl2 = this.vsb != null && (n9 == 22 || n9 == 20 && dimension.height > n8 - n6);
            if (bl2) {
                n11 = this.vsb.getPreferredSize().width;
            }
        }
        n3 = n4 - n11;
        n7 = n8 - n12;
        if (jViewport != null) {
            jViewport.setBounds(new Rectangle(n2 + insets.left, n6 + insets.top, n3 - n2 - insets.left - insets.right, n7 - n6 - insets.top - insets.bottom));
        }
        if (this.colHead != null) {
            this.colHead.setBounds(new Rectangle(n2, n5, n3 - n2, n6 - n5));
        }
        if (this.rowHead != null) {
            this.rowHead.setBounds(new Rectangle(n, n6, n2 - n, n7 - n6));
        }
        if (bl2) {
            this.vsb.setVisible(true);
            this.vsb.setBounds(new Rectangle(n3, n6, n4 - n3, n7 - n6));
        } else if (this.vsb != null) {
            this.vsb.setVisible(false);
        }
        if (bl) {
            this.hsb.setVisible(true);
            this.hsb.setBounds(new Rectangle(n2, n7, n3 - n2, n8 - n7));
        } else if (this.hsb != null) {
            this.hsb.setVisible(false);
        }
        if (this.upperLeft != null) {
            this.upperLeft.setBounds(new Rectangle(n, n5, n2 - n, n6 - n5));
        }
        if (this.upperRight != null) {
            this.upperRight.setBounds(new Rectangle(n3, n5, n4 - n3, n6 - n5));
        }
        if (this.lowerLeft != null) {
            this.lowerLeft.setBounds(new Rectangle(n, n7, n2 - n, n8 - n7));
        }
        if (this.lowerRight != null) {
            this.lowerRight.setBounds(new Rectangle(n3, n7, n4 - n3, n8 - n7));
        }
    }

    public Rectangle getViewportBorderBounds(JScrollPane jScrollPane) {
        return null;
    }

    public static class UIResource
    extends ScrollPaneLayout
    implements javax.swing.plaf.UIResource {
    }
}

