/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.swing.ProgressMonitor;

public class ProgressMonitorInputStream
extends FilterInputStream {
    private ProgressMonitor monitor;
    private int read;

    public ProgressMonitorInputStream(Component component, Object object, InputStream inputStream) {
        super(inputStream);
        int n = 0;
        try {
            n = inputStream.available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.monitor = new ProgressMonitor(component, object, null, 0, n);
    }

    public void reset() throws IOException {
        super.reset();
        this.checkMonitorCanceled();
    }

    public int read() throws IOException {
        int n = super.read();
        this.monitor.setProgress(++this.read);
        this.checkMonitorCanceled();
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        if (n > 0) {
            this.read += n;
            this.monitor.setProgress(this.read);
            this.checkMonitorCanceled();
        } else {
            this.monitor.close();
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.read += n3;
            this.monitor.setProgress(this.read);
            this.checkMonitorCanceled();
        } else {
            this.monitor.close();
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        assert ((long)this.read + l2 <= Integer.MAX_VALUE);
        this.read += (int)l2;
        this.monitor.setProgress(this.read);
        this.checkMonitorCanceled();
        return l2;
    }

    public void close() throws IOException {
        super.close();
        this.monitor.close();
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    private void checkMonitorCanceled() throws InterruptedIOException {
        if (this.monitor.isCanceled()) {
            throw new InterruptedIOException("ProgressMonitor was canceled");
        }
    }
}

