/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LookAndFeel {
    public UIDefaults getDefaults() {
        return null;
    }

    public abstract String getDescription();

    public static Object getDesktopPropertyValue(String string, Object object) {
        Object object2 = Toolkit.getDefaultToolkit().getDesktopProperty(string);
        return object2 != null ? object2 : object;
    }

    public abstract String getID();

    public abstract String getName();

    public boolean getSupportsWindowDecorations() {
        return false;
    }

    public void initialize() {
    }

    public static void installBorder(JComponent jComponent, String string) {
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            jComponent.setBorder(UIManager.getBorder(string));
        }
    }

    public static void installColors(JComponent jComponent, String string, String string2) {
        Color color;
        Color color2 = jComponent.getBackground();
        if (color2 == null || color2 instanceof UIResource) {
            jComponent.setBackground(UIManager.getColor(string));
        }
        if ((color = jComponent.getForeground()) == null || color instanceof UIResource) {
            jComponent.setForeground(UIManager.getColor(string2));
        }
    }

    public static void installColorsAndFont(JComponent jComponent, String string, String string2, String string3) {
        LookAndFeel.installColors(jComponent, string, string2);
        Font font = jComponent.getFont();
        if (font == null || font instanceof UIResource) {
            jComponent.setFont(UIManager.getFont(string3));
        }
    }

    public abstract boolean isNativeLookAndFeel();

    public abstract boolean isSupportedLookAndFeel();

    public static void loadKeyBindings(InputMap inputMap, Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length - 1; i += 2) {
            Object object = objectArray[i];
            KeyStroke keyStroke = object instanceof KeyStroke ? (KeyStroke)object : KeyStroke.getKeyStroke((String)object);
            inputMap.put(keyStroke, objectArray[i + 1]);
        }
    }

    public static ComponentInputMap makeComponentInputMap(JComponent jComponent, Object[] objectArray) {
        ComponentInputMapUIResource componentInputMapUIResource = new ComponentInputMapUIResource(jComponent);
        LookAndFeel.loadKeyBindings(componentInputMapUIResource, objectArray);
        return componentInputMapUIResource;
    }

    public static Object makeIcon(Class<?> clazz, String string) {
        final URL uRL = clazz.getResource(string);
        return new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return new IconUIResource(new ImageIcon(uRL));
            }
        };
    }

    public static InputMap makeInputMap(Object[] objectArray) {
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        LookAndFeel.loadKeyBindings(inputMapUIResource, objectArray);
        return inputMapUIResource;
    }

    public static JTextComponent.KeyBinding[] makeKeyBindings(Object[] objectArray) {
        JTextComponent.KeyBinding[] keyBindingArray = new JTextComponent.KeyBinding[objectArray.length / 2];
        for (int i = 0; i < objectArray.length - 1; i += 2) {
            KeyStroke keyStroke = objectArray[i] instanceof KeyStroke ? (KeyStroke)objectArray[i] : KeyStroke.getKeyStroke((String)objectArray[i]);
            keyBindingArray[i / 2] = new JTextComponent.KeyBinding(keyStroke, (String)objectArray[i + 1]);
        }
        return keyBindingArray;
    }

    public void provideErrorFeedback(Component component) {
        Toolkit.getDefaultToolkit().beep();
    }

    public String toString() {
        return this.getDescription() + " " + this.getClass().getName();
    }

    public void uninitialize() {
    }

    public static void uninstallBorder(JComponent jComponent) {
        if (jComponent.getBorder() instanceof UIResource) {
            jComponent.setBorder(null);
        }
    }

    public static void installProperty(JComponent jComponent, String string, Object object) {
        jComponent.setUIProperty(string, object);
    }
}

