/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleStateSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.View;

public class JTextArea
extends JTextComponent {
    private static final long serialVersionUID = -6141680179310439825L;
    private int rows;
    private int columns;
    private boolean lineWrap;
    private int tabSize = 8;
    private boolean wrapStyleWord;

    public JTextArea() {
        this(null, null, 0, 0);
    }

    public JTextArea(String string) {
        this(null, string, 0, 0);
    }

    public JTextArea(int n, int n2) {
        this(null, null, n, n2);
    }

    public JTextArea(String string, int n, int n2) {
        this(null, string, n, n2);
    }

    public JTextArea(Document document) {
        this(document, null, 0, 0);
    }

    public JTextArea(Document document, String string, int n, int n2) {
        this.setDocument(document == null ? this.createDefaultModel() : document);
        if (string != null) {
            this.setText(string);
        }
        this.setRows(n);
        this.setColumns(n2);
    }

    public void append(String string) {
        try {
            this.getDocument().insertString(this.getText().length(), string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Unexpected exception occurred.", badLocationException);
        }
        if (string != null && string.length() > 0) {
            this.revalidate();
        }
    }

    protected Document createDefaultModel() {
        return new PlainDocument();
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.lineWrap ? true : super.getScrollableTracksViewportWidth();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return this.getRowHeight();
        }
        if (n == 0) {
            return this.getColumnWidth();
        }
        throw new IllegalArgumentException("orientation must be either javax.swing.SwingConstants.VERTICAL or javax.swing.SwingConstants.HORIZONTAL");
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this.rows > 0 && this.columns > 0) {
            return new Dimension(this.columns * this.getColumnWidth(), this.rows * this.getRowHeight());
        }
        return super.getPreferredScrollableViewportSize();
    }

    public String getUIClassID() {
        return "TextAreaUI";
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n != this.columns) {
            this.columns = n;
            this.revalidate();
        }
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n != this.rows) {
            this.rows = n;
            this.revalidate();
        }
    }

    public boolean getLineWrap() {
        return this.lineWrap;
    }

    public void setLineWrap(boolean bl) {
        if (this.lineWrap == bl) {
            return;
        }
        boolean bl2 = this.lineWrap;
        this.lineWrap = bl;
        this.firePropertyChange("lineWrap", bl2, this.lineWrap);
    }

    public boolean getWrapStyleWord() {
        return this.wrapStyleWord;
    }

    public void setWrapStyleWord(boolean bl) {
        if (this.wrapStyleWord == bl) {
            return;
        }
        boolean bl2 = this.wrapStyleWord;
        this.wrapStyleWord = bl;
        this.firePropertyChange("wrapStyleWord", bl2, this.wrapStyleWord);
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int n) {
        if (this.tabSize == n) {
            return;
        }
        int n2 = this.tabSize;
        this.tabSize = n;
        this.firePropertyChange("tabSize", n2, this.tabSize);
    }

    protected int getColumnWidth() {
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.getFont());
        return fontMetrics.charWidth('m');
    }

    public int getLineCount() {
        return this.getDocument().getDefaultRootElement().getElementCount();
    }

    public int getLineStartOffset(int n) throws BadLocationException {
        int n2 = this.getLineCount();
        if (n < 0 || n > n2) {
            throw new BadLocationException("Non-existing line number", n);
        }
        Element element = this.getDocument().getDefaultRootElement().getElement(n);
        return element.getStartOffset();
    }

    public int getLineEndOffset(int n) throws BadLocationException {
        int n2 = this.getLineCount();
        if (n < 0 || n > n2) {
            throw new BadLocationException("Non-existing line number", n);
        }
        Element element = this.getDocument().getDefaultRootElement().getElement(n);
        return element.getEndOffset();
    }

    public int getLineOfOffset(int n) throws BadLocationException {
        Document document = this.getDocument();
        if (n < document.getStartPosition().getOffset() || n >= document.getEndPosition().getOffset()) {
            throw new BadLocationException("offset outside of document", n);
        }
        return document.getDefaultRootElement().getElementIndex(n);
    }

    protected int getRowHeight() {
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.getFont());
        return fontMetrics.getHeight();
    }

    public void insert(String string, int n) {
        Document document = this.getDocument();
        if (document == null || string == null || string.length() == 0) {
            return;
        }
        try {
            document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalArgumentException("The supplied position, " + n + ", was invalid.");
        }
    }

    public void replaceRange(String string, int n, int n2) {
        Document document = this.getDocument();
        if (n > n2 || n < document.getStartPosition().getOffset() || n2 >= document.getEndPosition().getOffset()) {
            throw new IllegalArgumentException();
        }
        try {
            document.remove(n, n2 - n);
            document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Dimension getPreferredSize() {
        int n = this.getColumns() * this.getColumnWidth();
        int n2 = this.getRows() * this.getRowHeight();
        View view = this.getUI().getRootView(this);
        int n3 = (int)view.getPreferredSpan(0);
        int n4 = (int)view.getPreferredSpan(1);
        return new Dimension(Math.max(n, n3), Math.max(n2, n4));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextArea();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTextArea
    extends JTextComponent.AccessibleJTextComponent {
        protected AccessibleJTextArea() {
            super(JTextArea.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }
    }
}

