/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;

public class JTabbedPane
extends JComponent
implements Serializable,
Accessible,
SwingConstants {
    private static final long serialVersionUID = 1614381073220130939L;
    protected ChangeEvent changeEvent;
    protected ChangeListener changeListener;
    protected SingleSelectionModel model;
    public static final int SCROLL_TAB_LAYOUT = 1;
    public static final int WRAP_TAB_LAYOUT = 0;
    protected int tabPlacement = 1;
    private transient int layoutPolicy;
    transient Vector tabs = new Vector();

    public JTabbedPane() {
        this(1, 0);
    }

    public JTabbedPane(int n) {
        this(n, 0);
    }

    public JTabbedPane(int n, int n2) {
        if (n != 1 && n != 3 && n != 4 && n != 2) {
            throw new IllegalArgumentException("tabPlacement is not valid.");
        }
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("tabLayoutPolicy is not valid.");
        }
        this.tabPlacement = n;
        this.layoutPolicy = n2;
        this.setModel(new DefaultSingleSelectionModel());
        this.updateUI();
    }

    public TabbedPaneUI getUI() {
        return (TabbedPaneUI)this.ui;
    }

    public void setUI(TabbedPaneUI tabbedPaneUI) {
        super.setUI(tabbedPaneUI);
    }

    public void updateUI() {
        this.setUI((TabbedPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "TabbedPaneUI";
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])super.getListeners(ChangeListener.class);
    }

    public SingleSelectionModel getModel() {
        return this.model;
    }

    public void setModel(SingleSelectionModel singleSelectionModel) {
        if (singleSelectionModel != this.model) {
            SingleSelectionModel singleSelectionModel2 = this.model;
            if (singleSelectionModel2 != null && this.changeListener != null) {
                singleSelectionModel2.removeChangeListener(this.changeListener);
            }
            this.model = singleSelectionModel;
            if (this.model != null) {
                if (this.changeListener == null) {
                    this.changeListener = this.createChangeListener();
                }
                this.model.addChangeListener(this.changeListener);
            }
            this.firePropertyChange("model", singleSelectionModel2, this.model);
        }
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public void setTabPlacement(int n) {
        if (n != 1 && n != 3 && n != 4 && n != 2) {
            throw new IllegalArgumentException("tabPlacement is not valid.");
        }
        if (n != this.tabPlacement) {
            int n2 = this.tabPlacement;
            this.tabPlacement = n;
            this.firePropertyChange("tabPlacement", n2, this.tabPlacement);
        }
    }

    public int getTabLayoutPolicy() {
        return this.layoutPolicy;
    }

    public void setTabLayoutPolicy(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("tabLayoutPolicy is not valid.");
        }
        if (n != this.layoutPolicy) {
            int n2 = this.layoutPolicy;
            this.layoutPolicy = n;
            this.firePropertyChange("tabLayoutPolicy", n2, this.layoutPolicy);
        }
    }

    public int getSelectedIndex() {
        return this.model.getSelectedIndex();
    }

    private void checkIndex(int n, int n2, int n3) {
        if (n < n2 || n >= n3) {
            throw new IndexOutOfBoundsException("Index < " + n2 + " || Index >= " + n3);
        }
    }

    public void setSelectedIndex(int n) {
        this.checkIndex(n, -1, this.tabs.size());
        if (n != this.getSelectedIndex()) {
            this.model.setSelectedIndex(n);
        }
    }

    public Component getSelectedComponent() {
        int n = this.getSelectedIndex();
        Component component = null;
        if (n >= 0) {
            component = this.getComponentAt(n);
        }
        return component;
    }

    public void setSelectedComponent(Component component) {
        if (component.getParent() == this) {
            this.setSelectedIndex(this.indexOfComponent(component));
        } else {
            this.setComponentAt(this.getSelectedIndex(), component);
        }
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        if (string == null) {
            string = "";
        }
        Page page = new Page(string, icon, component, string2);
        this.tabs.insertElementAt(page, n);
        if (component != null) {
            component.hide();
            super.add(component);
        }
        if (this.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
            this.fireStateChanged();
        }
        this.revalidate();
        this.repaint();
    }

    public void addTab(String string, Icon icon, Component component, String string2) {
        this.insertTab(string, icon, component, string2, this.tabs.size());
    }

    public void addTab(String string, Icon icon, Component component) {
        this.insertTab(string, icon, component, null, this.tabs.size());
    }

    public void addTab(String string, Component component) {
        this.insertTab(string, null, component, null, this.tabs.size());
    }

    public Component add(Component component) {
        if (component instanceof UIResource) {
            super.add(component);
        } else {
            this.insertTab(component.getName(), null, component, null, this.tabs.size());
        }
        return component;
    }

    public Component add(String string, Component component) {
        if (component instanceof UIResource) {
            super.add(component);
        } else {
            this.insertTab(string, null, component, null, this.tabs.size());
        }
        return component;
    }

    public Component add(Component component, int n) {
        if (component instanceof UIResource) {
            super.add(component);
        } else {
            this.insertTab(component.getName(), null, component, null, n);
        }
        return component;
    }

    public void add(Component component, Object object) {
        this.add(component, object, this.tabs.size());
    }

    public void add(Component component, Object object, int n) {
        if (component instanceof UIResource) {
            super.add(component);
        } else if (object instanceof String) {
            this.insertTab((String)object, null, component, null, n);
        } else {
            this.insertTab(component.getName(), object instanceof Icon ? (Icon)object : null, component, null, n);
        }
    }

    public void removeTabAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        int n2 = this.getSelectedIndex();
        if (n2 >= n) {
            this.setSelectedIndex(n2 - 1);
        }
        Component component = this.getComponentAt(n);
        this.tabs.remove(n);
        if (component != null) {
            Component[] componentArray = this.getComponents();
            for (int i = componentArray.length - 1; i >= 0; --i) {
                if (componentArray[i] != component) continue;
                super.remove(i);
                component.setVisible(true);
                break;
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void remove(Component component) {
        int n = this.indexOfComponent(component);
        if (n == -1) {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] != component) continue;
                super.remove(i);
            }
        } else {
            this.removeTabAt(n);
        }
    }

    public void remove(int n) {
        this.removeTabAt(n);
    }

    public void removeAll() {
        this.setSelectedIndex(-1);
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            this.removeTabAt(i);
        }
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public int getTabRunCount() {
        return ((TabbedPaneUI)this.ui).getTabRunCount(this);
    }

    public String getTitleAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getTitle();
    }

    public Icon getIconAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getIcon();
    }

    public Icon getDisabledIconAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getDisabledIcon();
    }

    public String getToolTipTextAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getTip();
    }

    public Color getForegroundAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getForeground();
    }

    public Color getBackgroundAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getBackground();
    }

    public Component getComponentAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getComponent();
    }

    public boolean isEnabledAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).isEnabled();
    }

    public int getMnemonicAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getMnemonic();
    }

    public int getDisplayedMnemonicIndexAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((Page)this.tabs.elementAt(n)).getDisplayedMnemonicIndex();
    }

    public Rectangle getBoundsAt(int n) {
        this.checkIndex(n, 0, this.tabs.size());
        return ((TabbedPaneUI)this.ui).getTabBounds(this, n);
    }

    public void setTitleAt(int n, String string) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setTitle(string);
    }

    public void setIconAt(int n, Icon icon) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setIcon(icon);
    }

    public void setDisabledIconAt(int n, Icon icon) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setDisabledIcon(icon);
    }

    public void setToolTipTextAt(int n, String string) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setTip(string);
    }

    public void setBackgroundAt(int n, Color color) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setBackground(color);
    }

    public void setForegroundAt(int n, Color color) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setForeground(color);
    }

    public void setEnabledAt(int n, boolean bl) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setEnabled(bl);
    }

    public void setComponentAt(int n, Component component) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setComponent(component);
    }

    public void setDisplayedMnemonicIndexAt(int n, int n2) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setDisplayedMnemonicIndex(n2);
    }

    public void setMnemonicAt(int n, int n2) {
        this.checkIndex(n, 0, this.tabs.size());
        ((Page)this.tabs.elementAt(n)).setMnemonic(n2);
    }

    public int indexOfTab(String string) {
        int n = -1;
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!((Page)this.tabs.elementAt(i)).getTitle().equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public int indexOfTab(Icon icon) {
        int n = -1;
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (((Page)this.tabs.elementAt(i)).getIcon() != icon) continue;
            n = i;
            break;
        }
        return n;
    }

    public int indexOfComponent(Component component) {
        int n = -1;
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (((Page)this.tabs.elementAt(i)).getComponent() != component) continue;
            n = i;
            break;
        }
        return n;
    }

    public int indexAtLocation(int n, int n2) {
        return ((TabbedPaneUI)this.ui).tabForCoordinate(this, n, n2);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
        return ((Page)this.tabs.elementAt(n)).getTip();
    }

    protected String paramString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(super.paramString());
        cPStringBuilder.append(",tabPlacement=");
        if (this.tabPlacement == 1) {
            cPStringBuilder.append("TOP");
        }
        if (this.tabPlacement == 3) {
            cPStringBuilder.append("BOTTOM");
        }
        if (this.tabPlacement == 2) {
            cPStringBuilder.append("LEFT");
        }
        if (this.tabPlacement == 4) {
            cPStringBuilder.append("RIGHT");
        }
        return cPStringBuilder.toString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            AccessibleJTabbedPane accessibleJTabbedPane = new AccessibleJTabbedPane();
            this.addChangeListener(accessibleJTabbedPane);
            this.accessibleContext = accessibleJTabbedPane;
        }
        return this.accessibleContext;
    }

    private class Page
    extends AccessibleContext
    implements Accessible {
        private String tip;
        private Component component;
        private transient Icon icon;
        private transient Icon disabledIcon;
        private transient boolean enabled = true;
        private transient String title;
        private transient Color bg;
        private transient Color fg;
        private transient int mnemonicKey;
        private transient int underlinedChar = -1;
        private static final long serialVersionUID = 1614381073220130939L;

        protected Page(String string, Icon icon, Component component, String string2) {
            this.title = string;
            this.icon = icon;
            this.component = component;
            this.tip = string2;
        }

        public Component getComponent() {
            return this.component;
        }

        public void setComponent(Component component) {
            int n = JTabbedPane.this.indexOfComponent(this.component);
            JTabbedPane.this.insertTab(this.title, this.icon, component, this.tip, n);
            this.component = component;
            JTabbedPane.this.removeTabAt(n);
        }

        public String getTip() {
            return this.tip;
        }

        public void setTip(String string) {
            this.tip = string;
        }

        public Color getBackground() {
            Color color = this.bg == null ? JTabbedPane.this.getBackground() : this.bg;
            return color;
        }

        public void setBackground(Color color) {
            this.bg = color;
        }

        public Color getForeground() {
            Color color = this.fg == null ? JTabbedPane.this.getForeground() : this.fg;
            return color;
        }

        public void setForeground(Color color) {
            this.fg = color;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String string) {
            this.title = string;
            if (this.title != null && this.title.length() <= this.underlinedChar) {
                this.setDisplayedMnemonicIndex(this.title.length() - 1);
            }
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getDisabledIcon() {
            if (this.disabledIcon == null && this.icon instanceof ImageIcon) {
                this.setDisabledIcon(this.icon);
            }
            return this.disabledIcon;
        }

        public void setDisabledIcon(Icon icon) {
            this.disabledIcon = icon;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public int getMnemonic() {
            return this.mnemonicKey;
        }

        public void setMnemonic(int n) {
            this.setMnemonic((char)n);
        }

        public void setMnemonic(char c) {
            this.mnemonicKey = c;
            if (this.title != null) {
                this.setDisplayedMnemonicIndex(this.title.indexOf(this.mnemonicKey));
            }
        }

        public int getDisplayedMnemonicIndex() {
            return this.underlinedChar;
        }

        public void setDisplayedMnemonicIndex(int n) throws IllegalArgumentException {
            if (n < -1 || this.title != null && n >= this.title.length()) {
                throw new IllegalArgumentException();
            }
            if (this.title == null || this.mnemonicKey == 0 || n > -1 && this.title.charAt(n) != this.mnemonicKey) {
                n = -1;
            }
            this.underlinedChar = n;
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return this.title;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleContext accessibleContext = JTabbedPane.this.getAccessibleContext();
            AccessibleStateSet accessibleStateSet = accessibleContext.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (this.component == JTabbedPane.this.getSelectedComponent()) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            return accessibleStateSet;
        }

        public int getAccessibleIndexInParent() {
            return JTabbedPane.this.indexOfTab(this.title);
        }

        public int getAccessibleChildrenCount() {
            return 1;
        }

        public Accessible getAccessibleChild(int n) {
            return (Accessible)((Object)this.component);
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }
    }

    protected class ModelListener
    implements ChangeListener,
    Serializable {
        private static final long serialVersionUID = 497359819958114132L;

        protected ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane.this.fireStateChanged();
        }
    }

    protected class AccessibleJTabbedPane
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        private static final long serialVersionUID = 7610530885966830483L;

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            this.firePropertyChange("AccessibleSelection", null, object);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        public int getAccessibleChildrenCount() {
            return JTabbedPane.this.getTabCount();
        }

        public Accessible getAccessibleChild(int n) {
            Page page = null;
            if (n >= 0 && n < JTabbedPane.this.tabs.size()) {
                page = (Page)JTabbedPane.this.tabs.get(n);
            }
            return page;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = JTabbedPane.this.indexAtLocation(point.x, point.y);
            if (n >= 0) {
                return this.getAccessibleChild(n);
            }
            return this.getAccessibleSelection(0);
        }

        public int getAccessibleSelectionCount() {
            return 1;
        }

        public Accessible getAccessibleSelection(int n) {
            Page page = null;
            int n2 = JTabbedPane.this.getSelectedIndex();
            if (n2 >= 0) {
                page = (Page)JTabbedPane.this.tabs.get(n2);
            }
            return page;
        }

        public boolean isAccessibleChildSelected(int n) {
            return n == JTabbedPane.this.getSelectedIndex();
        }

        public void addAccessibleSelection(int n) {
            JTabbedPane.this.setSelectedIndex(n);
        }

        public void removeAccessibleSelection(int n) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

