/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.MenuContainer;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.UIResource;

public class JSlider
extends JComponent
implements SwingConstants,
Accessible,
ImageObserver,
MenuContainer,
Serializable {
    private static final long serialVersionUID = -1441275936141218479L;
    private transient boolean paintTicks;
    private transient boolean paintTrack = true;
    private transient boolean paintLabels;
    private transient Dictionary labelTable;
    protected BoundedRangeModel sliderModel;
    protected int majorTickSpacing;
    protected int minorTickSpacing;
    protected boolean snapToTicks;
    protected int orientation = 0;
    private transient boolean isInverted;
    protected ChangeListener changeListener;
    protected transient ChangeEvent changeEvent;

    public JSlider() {
        this(0, 0, 100, 50);
    }

    public JSlider(int n) {
        this(n, 0, 100, 50);
    }

    public JSlider(int n, int n2) {
        this(0, n, n2, (n2 + n) / 2);
    }

    public JSlider(int n, int n2, int n3) {
        this(0, n, n2, n3);
    }

    public JSlider(int n, int n2, int n3, int n4) {
        this.sliderModel = new DefaultBoundedRangeModel(n4, 0, n2, n3);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(n + " is not a legal orientation");
        }
        this.orientation = n;
        this.changeListener = this.createChangeListener();
        this.sliderModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public JSlider(BoundedRangeModel boundedRangeModel) {
        this.sliderModel = boundedRangeModel;
        this.changeListener = this.createChangeListener();
        this.sliderModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public int getValue() {
        return this.sliderModel.getValue();
    }

    public void setValue(int n) {
        this.sliderModel.setValue(n);
    }

    public SliderUI getUI() {
        return (SliderUI)this.ui;
    }

    public void setUI(SliderUI sliderUI) {
        super.setUI(sliderUI);
    }

    public void updateUI() {
        this.updateLabelUIs();
        this.setUI((SliderUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "SliderUI";
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider.this.fireStateChanged();
            }
        };
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    public BoundedRangeModel getModel() {
        return this.sliderModel;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        if (boundedRangeModel != this.sliderModel) {
            BoundedRangeModel boundedRangeModel2 = this.sliderModel;
            this.sliderModel = boundedRangeModel;
            boundedRangeModel2.removeChangeListener(this.changeListener);
            this.sliderModel.addChangeListener(this.changeListener);
            this.firePropertyChange("model", boundedRangeModel2, this.sliderModel);
        }
    }

    public int getMinimum() {
        return this.sliderModel.getMinimum();
    }

    public void setMinimum(int n) {
        int n2 = this.sliderModel.getMinimum();
        this.sliderModel.setMinimum(n);
        if (n != n2) {
            this.firePropertyChange("minimum", n2, n);
        }
    }

    public int getMaximum() {
        return this.sliderModel.getMaximum();
    }

    public void setMaximum(int n) {
        int n2 = this.sliderModel.getMaximum();
        this.sliderModel.setMaximum(n);
        if (n != n2) {
            this.firePropertyChange("maximum", n2, n);
        }
    }

    public boolean getValueIsAdjusting() {
        return this.sliderModel.getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean bl) {
        this.sliderModel.setValueIsAdjusting(bl);
    }

    public int getExtent() {
        return this.sliderModel.getExtent();
    }

    public void setExtent(int n) {
        this.sliderModel.setExtent(n);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
        }
        if (n != this.orientation) {
            int n2 = this.orientation;
            this.orientation = n;
            this.firePropertyChange("orientation", n2, this.orientation);
            this.revalidate();
        }
    }

    public Dictionary getLabelTable() {
        return this.labelTable;
    }

    public void setLabelTable(Dictionary dictionary) {
        if (dictionary != this.labelTable) {
            Dictionary dictionary2 = this.labelTable;
            this.labelTable = dictionary;
            this.updateLabelUIs();
            this.firePropertyChange("labelTable", dictionary2, this.labelTable);
            this.revalidate();
            this.repaint();
        }
    }

    protected void updateLabelUIs() {
        if (this.labelTable != null) {
            Enumeration enumeration = this.labelTable.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                if (!(v instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)v;
                jComponent.updateUI();
                jComponent.setSize(jComponent.getPreferredSize());
            }
        }
    }

    public Hashtable createStandardLabels(int n) {
        return this.createStandardLabels(n, this.sliderModel.getMinimum());
    }

    public Hashtable createStandardLabels(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("Requires 'increment' > 0.");
        }
        if (n2 < this.getMinimum() || n2 > this.getMaximum()) {
            throw new IllegalArgumentException("The 'start' value is out of range.");
        }
        Hashtable<Integer, LabelUIResource> hashtable = new Hashtable<Integer, LabelUIResource>();
        int n3 = this.getMaximum();
        for (int i = n2; i <= n3; i += n) {
            LabelUIResource labelUIResource = new LabelUIResource(String.valueOf(i), 0);
            hashtable.put(new Integer(i), labelUIResource);
        }
        return hashtable;
    }

    public boolean getInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean bl) {
        if (this.isInverted != bl) {
            boolean bl2 = this.isInverted;
            this.isInverted = bl;
            this.firePropertyChange("inverted", bl2, this.isInverted);
            this.repaint();
        }
    }

    public int getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public void setMajorTickSpacing(int n) {
        if (this.majorTickSpacing != n) {
            int n2 = this.majorTickSpacing;
            this.majorTickSpacing = n;
            if (this.labelTable == null && this.majorTickSpacing > 0 && this.getPaintLabels()) {
                this.setLabelTable(this.createStandardLabels(this.majorTickSpacing));
            }
            this.firePropertyChange("majorTickSpacing", n2, this.majorTickSpacing);
            if (this.getPaintTicks()) {
                this.repaint();
            }
        }
    }

    public int getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setMinorTickSpacing(int n) {
        if (this.minorTickSpacing != n) {
            int n2 = this.minorTickSpacing;
            this.minorTickSpacing = n;
            this.firePropertyChange("minorTickSpacing", n2, this.minorTickSpacing);
            if (this.getPaintTicks()) {
                this.repaint();
            }
        }
    }

    public boolean getSnapToTicks() {
        return this.snapToTicks;
    }

    public void setSnapToTicks(boolean bl) {
        if (bl != this.snapToTicks) {
            this.snapToTicks = bl;
            this.firePropertyChange("snapToTicks", !bl, bl);
        }
    }

    public boolean getPaintTicks() {
        return this.paintTicks;
    }

    public void setPaintTicks(boolean bl) {
        if (bl != this.paintTicks) {
            boolean bl2 = this.paintTicks;
            this.paintTicks = bl;
            this.firePropertyChange("paintTicks", bl2, this.paintTicks);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean getPaintTrack() {
        return this.paintTrack;
    }

    public void setPaintTrack(boolean bl) {
        if (this.paintTrack != bl) {
            this.paintTrack = bl;
            this.firePropertyChange("paintTrack", !bl, bl);
            this.repaint();
        }
    }

    public boolean getPaintLabels() {
        return this.paintLabels;
    }

    public void setPaintLabels(boolean bl) {
        if (bl != this.paintLabels) {
            this.paintLabels = bl;
            if (bl && this.majorTickSpacing > 0 && this.labelTable == null) {
                this.setLabelTable(this.createStandardLabels(this.majorTickSpacing));
            }
            this.firePropertyChange("paintLabels", !bl, bl);
            this.revalidate();
            this.repaint();
        }
    }

    protected String paramString() {
        String string = super.paramString();
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(",isInverted=").append(this.getInverted());
        cPStringBuilder.append(",majorTickSpacing=").append(this.getMajorTickSpacing());
        cPStringBuilder.append(",minorTickSpacing=").append(this.getMinorTickSpacing());
        cPStringBuilder.append(",orientation=");
        if (this.orientation == 0) {
            cPStringBuilder.append("HORIZONTAL");
        } else {
            cPStringBuilder.append("VERTICAL");
        }
        cPStringBuilder.append(",paintLabels=").append(this.getPaintLabels());
        cPStringBuilder.append(",paintTicks=").append(this.getPaintTicks());
        cPStringBuilder.append(",paintTrack=").append(this.getPaintTrack());
        cPStringBuilder.append(",snapToTicks=").append(this.getSnapToTicks());
        cPStringBuilder.append(",snapToValue=true");
        return string + cPStringBuilder.toString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSlider();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJSlider
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -6301740148041106789L;

        protected AccessibleJSlider() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JSlider.this.orientation == 0) {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            } else if (JSlider.this.orientation == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SLIDER;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JSlider.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number == null) {
                return false;
            }
            Number number2 = this.getCurrentAccessibleValue();
            JSlider.this.setValue(number.intValue());
            this.firePropertyChange("AccessibleValue", number2, new Integer(JSlider.this.getValue()));
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JSlider.this.getMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JSlider.this.getMaximum());
        }
    }

    private class LabelUIResource
    extends JLabel
    implements UIResource {
        LabelUIResource(String string, int n) {
            super(string, n);
            this.setName("Slider.label");
        }
    }
}

