/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollBarUI;

public class JScrollBar
extends JComponent
implements Adjustable,
Accessible {
    private static final long serialVersionUID = -8195169869225066566L;
    protected int blockIncrement = 10;
    protected BoundedRangeModel model;
    protected int orientation = 1;
    protected int unitIncrement = 1;
    private ChangeListener sbChangeListener;

    public JScrollBar() {
        this(1, 0, 10, 0, 100);
    }

    public JScrollBar(int n) {
        this(n, 0, 10, 0, 100);
    }

    public JScrollBar(int n, int n2, int n3, int n4, int n5) {
        this.model = new DefaultBoundedRangeModel(n2, n3, n4, n5);
        this.sbChangeListener = new ScrollBarChangeListener();
        this.model.addChangeListener(this.sbChangeListener);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(n + " is not a legal orientation");
        }
        this.orientation = n;
        this.updateUI();
    }

    public void setUI(ScrollBarUI scrollBarUI) {
        super.setUI(scrollBarUI);
    }

    public ScrollBarUI getUI() {
        return (ScrollBarUI)this.ui;
    }

    public void updateUI() {
        this.setUI((ScrollBarUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ScrollBarUI";
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("orientation must be one of HORIZONTAL or VERTICAL");
        }
        if (n != this.orientation) {
            int n2 = this.orientation;
            this.orientation = n;
            this.firePropertyChange("orientation", n2, this.orientation);
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        BoundedRangeModel boundedRangeModel2 = this.model;
        if (boundedRangeModel2 != null) {
            boundedRangeModel2.removeChangeListener(this.sbChangeListener);
        }
        this.model = boundedRangeModel;
        if (this.model != null) {
            this.model.addChangeListener(this.sbChangeListener);
        }
        this.firePropertyChange("model", boundedRangeModel2, this.model);
    }

    public int getUnitIncrement(int n) {
        return this.unitIncrement;
    }

    public void setUnitIncrement(int n) {
        if (n != this.unitIncrement) {
            int n2 = this.unitIncrement;
            this.unitIncrement = n;
            this.firePropertyChange("unitIncrement", n2, this.unitIncrement);
        }
    }

    public int getBlockIncrement(int n) {
        return this.blockIncrement;
    }

    public void setBlockIncrement(int n) {
        if (n != this.blockIncrement) {
            int n2 = this.blockIncrement;
            this.blockIncrement = n;
            this.firePropertyChange("blockIncrement", n2, this.blockIncrement);
        }
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public int getValue() {
        return this.model.getValue();
    }

    public void setValue(int n) {
        this.model.setValue(n);
    }

    public int getVisibleAmount() {
        return this.model.getExtent();
    }

    public void setVisibleAmount(int n) {
        this.model.setExtent(n);
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int n) {
        this.model.setMinimum(n);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int n) {
        this.model.setMaximum(n);
    }

    public boolean getValueIsAdjusting() {
        return this.model.getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean bl) {
        this.model.setValueIsAdjusting(bl);
    }

    public void setValues(int n, int n2, int n3, int n4) {
        this.model.setRangeProperties(n, n2, n3, n4, this.model.getValueIsAdjusting());
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listenerList.add(AdjustmentListener.class, adjustmentListener);
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listenerList.remove(AdjustmentListener.class, adjustmentListener);
    }

    public AdjustmentListener[] getAdjustmentListeners() {
        return (AdjustmentListener[])this.listenerList.getListeners(AdjustmentListener.class);
    }

    protected void fireAdjustmentValueChanged(int n, int n2, int n3) {
        this.fireAdjustmentValueChanged(n, n2, n3, this.getValueIsAdjusting());
    }

    void fireAdjustmentValueChanged(int n, int n2, int n3, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this, n, n2, n3, bl);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AdjustmentListener.class) continue;
            ((AdjustmentListener)objectArray[i + 1]).adjustmentValueChanged(adjustmentEvent);
        }
    }

    public Dimension getMinimumSize() {
        return this.ui.getMinimumSize(this);
    }

    public Dimension getMaximumSize() {
        return this.ui.getMaximumSize(this);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    protected String paramString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(super.paramString());
        cPStringBuilder.append(",blockIncrement=").append(this.blockIncrement);
        cPStringBuilder.append(",orientation=");
        if (this.orientation == 0) {
            cPStringBuilder.append("HORIZONTAL");
        } else {
            cPStringBuilder.append("VERTICAL");
        }
        cPStringBuilder.append(",unitIncrement=").append(this.unitIncrement);
        return cPStringBuilder.toString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJScrollBar();
        }
        return this.accessibleContext;
    }

    private class ScrollBarChangeListener
    implements ChangeListener {
        private ScrollBarChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object instanceof BoundedRangeModel) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)object;
                JScrollBar.this.fireAdjustmentValueChanged(601, 5, boundedRangeModel.getValue(), boundedRangeModel.getValueIsAdjusting());
            }
        }
    }

    protected class AccessibleJScrollBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -7758162392045586663L;

        protected AccessibleJScrollBar() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JScrollBar.this.orientation == 0) {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            } else if (JScrollBar.this.orientation == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_BAR;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JScrollBar.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number == null) {
                return false;
            }
            Number number2 = this.getCurrentAccessibleValue();
            JScrollBar.this.setValue(number.intValue());
            this.firePropertyChange("AccessibleValue", number2, new Integer(JScrollBar.this.getValue()));
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JScrollBar.this.getMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JScrollBar.this.getMaximum() - JScrollBar.this.model.getExtent());
        }
    }
}

