/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.MenuBarUI;

public class JMenuBar
extends JComponent
implements Accessible,
MenuElement {
    private static final long serialVersionUID = -8191026883931977036L;
    private transient SingleSelectionModel selectionModel = new DefaultSingleSelectionModel();
    private boolean borderPainted = true;
    private Insets margin;

    public JMenuBar() {
        this.updateUI();
    }

    public JMenu add(JMenu jMenu) {
        jMenu.setAlignmentX(0.0f);
        super.add(jMenu);
        return jMenu;
    }

    public void addNotify() {
        super.addNotify();
        KeyboardManager.getManager().registerJMenuBar(this);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenuBar();
        }
        return this.accessibleContext;
    }

    public Component getComponent() {
        return this;
    }

    public Component getComponentAtIndex(int n) {
        return this.getComponent(n);
    }

    public int getComponentIndex(Component component) {
        Component[] componentArray = this.getComponents();
        int n = -1;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].equals(component)) continue;
            n = i;
            break;
        }
        return n;
    }

    public JMenu getHelpMenu() {
        throw new Error("getHelpMenu() is not implemented");
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    public JMenu getMenu(int n) {
        if (this.getComponentAtIndex(n) instanceof JMenu) {
            return (JMenu)this.getComponentAtIndex(n);
        }
        return null;
    }

    public int getMenuCount() {
        return this.getComponentCount();
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public MenuElement[] getSubElements() {
        MenuElement[] menuElementArray = new MenuElement[this.getComponentCount()];
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JMenu jMenu = this.getMenu(i);
            if (jMenu != null) {
                menuElementArray[n++] = jMenu;
                continue;
            }
            bl = true;
        }
        if (!bl) {
            return menuElementArray;
        }
        MenuElement[] menuElementArray2 = new MenuElement[n];
        for (int i = 0; i < n; ++i) {
            menuElementArray2[i] = menuElementArray[i];
        }
        return menuElementArray2;
    }

    public MenuBarUI getUI() {
        return (MenuBarUI)this.ui;
    }

    public String getUIClassID() {
        return "MenuBarUI";
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public boolean isSelected() {
        return this.selectionModel.isSelected();
    }

    public void menuSelectionChanged(boolean bl) {
    }

    protected void paintBorder(Graphics graphics) {
        Border border;
        if (this.borderPainted && (border = this.getBorder()) != null) {
            this.getBorder().paintBorder(this, graphics, 0, 0, this.getSize(null).width, this.getSize(null).height);
        }
    }

    protected String paramString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(super.paramString());
        cPStringBuilder.append(",margin=");
        if (this.getMargin() != null) {
            cPStringBuilder.append(this.getMargin());
        }
        cPStringBuilder.append(",paintBorder=").append(this.isBorderPainted());
        return cPStringBuilder.toString();
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (super.processKeyBinding(keyStroke, keyEvent, n, bl)) {
            return true;
        }
        MenuElement[] menuElementArray = this.getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (!JMenuBar.processKeyBindingHelper(menuElementArray[i], keyStroke, keyEvent, n, bl)) continue;
            return true;
        }
        return false;
    }

    static boolean processKeyBindingHelper(MenuElement menuElement, KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (menuElement == null) {
            return false;
        }
        if (menuElement instanceof JComponent && ((JComponent)((Object)menuElement)).processKeyBinding(keyStroke, keyEvent, n, bl)) {
            return true;
        }
        MenuElement[] menuElementArray = menuElement.getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (!JMenuBar.processKeyBindingHelper(menuElementArray[i], keyStroke, keyEvent, n, bl)) continue;
            return true;
        }
        return false;
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void removeNotify() {
        KeyboardManager.getManager().unregisterJMenuBar(this);
        super.removeNotify();
    }

    public void setBorderPainted(boolean bl) {
        if (bl != this.borderPainted) {
            boolean bl2 = this.borderPainted;
            this.borderPainted = bl;
            this.firePropertyChange("borderPainted", bl2, bl);
            this.revalidate();
            this.repaint();
        }
    }

    public void setHelpMenu(JMenu jMenu) {
        throw new Error("setHelpMenu() not yet implemented.");
    }

    public void setMargin(Insets insets) {
        if (insets != this.margin) {
            Insets insets2 = this.margin;
            this.margin = insets;
            this.firePropertyChange("margin", insets2, this.margin);
        }
    }

    public void setSelected(Component component) {
        int n = this.getComponentIndex(component);
        this.selectionModel.setSelectedIndex(n);
    }

    public void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        if (this.selectionModel != singleSelectionModel) {
            SingleSelectionModel singleSelectionModel2 = this.selectionModel;
            this.selectionModel = singleSelectionModel;
            this.firePropertyChange("model", singleSelectionModel2, this.selectionModel);
        }
    }

    public void setUI(MenuBarUI menuBarUI) {
        super.setUI(menuBarUI);
    }

    public void updateUI() {
        this.setUI((MenuBarUI)UIManager.getUI(this));
    }

    protected class AccessibleJMenuBar
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        protected AccessibleJMenuBar() {
        }

        public int getAccessibleSelectionCount() {
            int n = 0;
            if (JMenuBar.this.getSelectionModel().getSelectedIndex() != -1) {
                n = 1;
            }
            return n;
        }

        public Accessible getAccessibleSelection(int n) {
            if (JMenuBar.this.getSelectionModel().getSelectedIndex() != n) {
                return null;
            }
            return JMenuBar.this.getMenu(n);
        }

        public boolean isAccessibleChildSelected(int n) {
            return JMenuBar.this.getSelectionModel().getSelectedIndex() == n;
        }

        public void addAccessibleSelection(int n) {
            JMenuBar.this.getSelectionModel().setSelectedIndex(n);
        }

        public void removeAccessibleSelection(int n) {
            if (JMenuBar.this.getSelectionModel().getSelectedIndex() == n) {
                JMenuBar.this.getSelectionModel().clearSelection();
            }
        }

        public void clearAccessibleSelection() {
            JMenuBar.this.getSelectionModel().clearSelection();
        }

        public void selectAllAccessibleSelection() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }
    }
}

