/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleText;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.View;

public class JLabel
extends JComponent
implements Accessible,
SwingConstants {
    private static final long serialVersionUID = 5496508283662221534L;
    static final String LABEL_PROPERTY = "labeledBy";
    protected Component labelFor;
    transient String text;
    private transient int horizontalAlignment = 10;
    private transient int horizontalTextPosition = 11;
    private transient int verticalAlignment = 0;
    private transient int verticalTextPosition = 0;
    private transient Icon icon;
    private transient Icon disabledIcon;
    private transient int displayedMnemonic = 0;
    private transient int displayedMnemonicIndex = -1;
    private transient int iconTextGap = 4;

    public JLabel() {
        this("", null, 10);
    }

    public JLabel(Icon icon) {
        this(null, icon, 0);
    }

    public JLabel(Icon icon, int n) {
        this(null, icon, n);
    }

    public JLabel(String string) {
        this(string, null, 10);
    }

    public JLabel(String string, int n) {
        this(string, null, n);
    }

    public JLabel(String string, Icon icon, int n) {
        if (n != 2 && n != 4 && n != 0 && n != 10 && n != 11) {
            throw new IllegalArgumentException();
        }
        this.text = string;
        this.icon = icon;
        this.horizontalAlignment = n;
        this.setAlignmentX(0.0f);
        this.setInheritsPopupMenu(true);
        this.updateUI();
    }

    public LabelUI getUI() {
        return (LabelUI)this.ui;
    }

    public void setUI(LabelUI labelUI) {
        super.setUI(labelUI);
    }

    public void updateUI() {
        this.setUI((LabelUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "LabelUI";
    }

    protected String paramString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(super.paramString());
        cPStringBuilder.append(",defaultIcon=");
        if (this.icon != null) {
            cPStringBuilder.append(this.icon);
        }
        cPStringBuilder.append(",disabledIcon=");
        if (this.disabledIcon != null) {
            cPStringBuilder.append(this.disabledIcon);
        }
        cPStringBuilder.append(",horizontalAlignment=");
        cPStringBuilder.append(SwingUtilities.convertHorizontalAlignmentCodeToString(this.horizontalAlignment));
        cPStringBuilder.append(",horizontalTextPosition=");
        cPStringBuilder.append(SwingUtilities.convertHorizontalAlignmentCodeToString(this.horizontalTextPosition));
        cPStringBuilder.append(",iconTextGap=").append(this.iconTextGap);
        cPStringBuilder.append(",labelFor=");
        if (this.labelFor != null) {
            cPStringBuilder.append(this.labelFor);
        }
        cPStringBuilder.append(",text=");
        if (this.text != null) {
            cPStringBuilder.append(this.text);
        }
        cPStringBuilder.append(",verticalAlignment=");
        cPStringBuilder.append(SwingUtilities.convertVerticalAlignmentCodeToString(this.verticalAlignment));
        cPStringBuilder.append(",verticalTextPosition=");
        cPStringBuilder.append(SwingUtilities.convertVerticalAlignmentCodeToString(this.verticalTextPosition));
        return cPStringBuilder.toString();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (this.text == null && string == null) {
            return;
        }
        if (this.text != null && this.text.equals(string)) {
            return;
        }
        String string2 = this.text;
        this.text = string;
        this.firePropertyChange("text", string2, string);
        if (this.text != null) {
            this.setDisplayedMnemonicIndex(this.text.toUpperCase().indexOf(this.displayedMnemonic));
        } else {
            this.setDisplayedMnemonicIndex(-1);
        }
        this.revalidate();
        this.repaint();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        if (this.icon != icon) {
            Icon icon2 = this.icon;
            this.icon = icon;
            this.firePropertyChange("icon", icon2, icon);
            this.repaint();
        }
    }

    public Icon getDisabledIcon() {
        if (this.disabledIcon == null && this.icon instanceof ImageIcon) {
            this.disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.icon).getImage()));
        }
        return this.disabledIcon;
    }

    public void setDisabledIcon(Icon icon) {
        if (this.disabledIcon != icon) {
            Icon icon2 = this.disabledIcon;
            this.disabledIcon = icon;
            this.firePropertyChange("disabledIcon", icon2, icon);
        }
    }

    public void setDisplayedMnemonic(int n) {
        if (this.displayedMnemonic != n) {
            int n2 = this.displayedMnemonic;
            this.displayedMnemonic = n;
            this.firePropertyChange("displayedMnemonic", n2, this.displayedMnemonic);
            if (this.text != null) {
                this.setDisplayedMnemonicIndex(this.text.toUpperCase().indexOf(n));
            }
        }
    }

    public void setDisplayedMnemonic(char c) {
        this.setDisplayedMnemonic((int)Character.toUpperCase(c));
    }

    public int getDisplayedMnemonic() {
        return this.displayedMnemonic;
    }

    public void setDisplayedMnemonicIndex(int n) throws IllegalArgumentException {
        int n2 = -1;
        if (this.text != null) {
            n2 = this.text.length() - 1;
        }
        if (n < -1 || n > n2) {
            throw new IllegalArgumentException();
        }
        if (n != this.displayedMnemonicIndex) {
            int n3 = this.displayedMnemonicIndex;
            this.displayedMnemonicIndex = n;
            this.firePropertyChange("displayedMnemonicIndex", n3, n);
        }
    }

    public int getDisplayedMnemonicIndex() {
        return this.displayedMnemonicIndex;
    }

    protected int checkHorizontalKey(int n, String string) {
        if (n != 2 && n != 0 && n != 4 && n != 10 && n != 11) {
            throw new IllegalArgumentException(string);
        }
        return n;
    }

    protected int checkVerticalKey(int n, String string) {
        if (n != 1 && n != 3 && n != 0) {
            throw new IllegalArgumentException(string);
        }
        return n;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public void setIconTextGap(int n) {
        if (this.iconTextGap != n) {
            this.firePropertyChange("iconTextGap", this.iconTextGap, n);
            this.iconTextGap = n;
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        if (n == this.verticalAlignment) {
            return;
        }
        int n2 = this.verticalAlignment;
        this.verticalAlignment = this.checkVerticalKey(n, "verticalAlignment");
        this.firePropertyChange("verticalAlignment", n2, this.verticalAlignment);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (this.horizontalAlignment == n) {
            return;
        }
        int n2 = this.horizontalAlignment;
        this.horizontalAlignment = this.checkHorizontalKey(n, "horizontalAlignment");
        this.firePropertyChange("horizontalAlignment", n2, this.horizontalAlignment);
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setVerticalTextPosition(int n) {
        if (n != this.verticalTextPosition) {
            int n2 = this.verticalTextPosition;
            this.verticalTextPosition = this.checkVerticalKey(n, "verticalTextPosition");
            this.firePropertyChange("verticalTextPosition", n2, this.verticalTextPosition);
        }
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int n) {
        if (n != this.horizontalTextPosition) {
            int n2 = this.horizontalTextPosition;
            this.horizontalTextPosition = this.checkHorizontalKey(n, "horizontalTextPosition");
            this.firePropertyChange("horizontalTextPosition", n2, this.horizontalTextPosition);
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        Icon icon;
        Icon icon2 = icon = this.isEnabled() ? this.icon : this.disabledIcon;
        if (icon != null && icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage() == image;
        }
        return false;
    }

    public Component getLabelFor() {
        return this.labelFor;
    }

    public void setLabelFor(Component component) {
        if (component != this.labelFor) {
            Component component2 = this.labelFor;
            this.labelFor = component;
            this.firePropertyChange("labelFor", component2, this.labelFor);
            if (component2 instanceof JComponent) {
                ((JComponent)component2).putClientProperty(LABEL_PROPERTY, null);
            }
            if (this.labelFor instanceof JComponent) {
                ((JComponent)this.labelFor).putClientProperty(LABEL_PROPERTY, this);
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.repaint();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLabel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJLabel
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    AccessibleExtendedComponent {
        protected AccessibleJLabel() {
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (JLabel.this.text != null) {
                return JLabel.this.text;
            }
            return super.getAccessibleName();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public String getSelectedText() {
            return null;
        }

        public int getSelectionStart() {
            return -1;
        }

        public int getSelectionEnd() {
            return -1;
        }

        public AttributeSet getCharacterAttribute(int n) {
            return new SimpleAttributeSet();
        }

        public String getAtIndex(int n, int n2) {
            String string = "";
            int n3 = -1;
            int n4 = -1;
            switch (n) {
                case 1: {
                    string = String.valueOf(JLabel.this.text.charAt(n2));
                    break;
                }
                case 2: {
                    n3 = JLabel.this.text.lastIndexOf(32, n2);
                    n4 = JLabel.this.text.indexOf(32, n3 + 1);
                    if (n4 == -1) {
                        n4 = n3 + 1;
                    }
                    string = JLabel.this.text.substring(n3 + 1, n4);
                    break;
                }
                default: {
                    n3 = JLabel.this.text.lastIndexOf(46, n2);
                    n4 = JLabel.this.text.indexOf(46, n3 + 1);
                    if (n4 == -1) {
                        n4 = n3 + 1;
                    }
                    string = JLabel.this.text.substring(n3 + 1, n4);
                }
            }
            return string;
        }

        public String getAfterIndex(int n, int n2) {
            String string = "";
            int n3 = -1;
            int n4 = -1;
            switch (n) {
                case 1: {
                    string = String.valueOf(JLabel.this.text.charAt(n2 + 1));
                    break;
                }
                case 2: {
                    n3 = JLabel.this.text.indexOf(32, n2);
                    n4 = JLabel.this.text.indexOf(32, n3 + 1);
                    if (n4 == -1) {
                        n4 = n3 + 1;
                    }
                    string = JLabel.this.text.substring(n3 + 1, n4);
                    break;
                }
                default: {
                    n3 = JLabel.this.text.indexOf(46, n2);
                    n4 = JLabel.this.text.indexOf(46, n3 + 1);
                    if (n4 == -1) {
                        n4 = n3 + 1;
                    }
                    string = JLabel.this.text.substring(n3 + 1, n4);
                }
            }
            return string;
        }

        public String getBeforeIndex(int n, int n2) {
            String string = "";
            int n3 = -1;
            int n4 = -1;
            switch (n) {
                case 1: {
                    string = String.valueOf(JLabel.this.text.charAt(n2 - 1));
                    break;
                }
                case 2: {
                    n4 = JLabel.this.text.lastIndexOf(32, n2);
                    if (n4 == -1) {
                        n4 = 0;
                    }
                    n3 = JLabel.this.text.lastIndexOf(32, n4 - 1);
                    string = JLabel.this.text.substring(n3 + 1, n4);
                    break;
                }
                default: {
                    n4 = JLabel.this.text.lastIndexOf(46, n2);
                    if (n4 == -1) {
                        n4 = 0;
                    }
                    n3 = JLabel.this.text.lastIndexOf(46, n4 - 1);
                    string = JLabel.this.text.substring(n3 + 1, n4);
                }
            }
            return string;
        }

        public int getCaretPosition() {
            return -1;
        }

        public int getCharCount() {
            return JLabel.this.text.length();
        }

        public Rectangle getCharacterBounds(int n) {
            Rectangle rectangle = null;
            View view = (View)JLabel.this.getClientProperty("html");
            if (view != null) {
                Rectangle rectangle2 = this.getTextRectangle();
                try {
                    Shape shape = view.modelToView(n, rectangle2, Position.Bias.Forward);
                    rectangle = shape.getBounds();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return rectangle;
        }

        private Rectangle getTextRectangle() {
            JLabel jLabel = JLabel.this;
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            Insets insets = jLabel.getInsets();
            int n = jLabel.getWidth();
            int n2 = jLabel.getHeight();
            Rectangle rectangle3 = new Rectangle(insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
            FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
            SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, jLabel.getText(), jLabel.getIcon(), jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle3, rectangle2, rectangle, jLabel.getIconTextGap());
            return rectangle;
        }

        public int getIndexAtPoint(Point point) {
            int n = -1;
            View view = (View)JLabel.this.getClientProperty("html");
            if (view != null) {
                Rectangle rectangle = this.getTextRectangle();
                n = view.viewToModel(point.x, point.y, rectangle, new Position.Bias[0]);
            }
            return n;
        }
    }
}

