/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Component;
import java.beans.PropertyVetoException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.UIManager;
import javax.swing.plaf.DesktopPaneUI;

public class JDesktopPane
extends JLayeredPane
implements Accessible {
    private static final long serialVersionUID = 766333777224038726L;
    public static final int LIVE_DRAG_MODE = 0;
    public static final int OUTLINE_DRAG_MODE = 1;
    private transient JInternalFrame selectedFrame;
    transient DesktopManager desktopManager;
    private transient int dragMode = 0;
    private boolean clientDragModeSet = false;

    public JDesktopPane() {
        this.setLayout(null);
        this.updateUI();
    }

    public DesktopPaneUI getUI() {
        return (DesktopPaneUI)this.ui;
    }

    public void setUI(DesktopPaneUI desktopPaneUI) {
        super.setUI(desktopPaneUI);
    }

    public void setDragMode(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Drag mode not valid.");
        }
        this.clientDragModeSet = true;
        if (n == 1) {
            n = 0;
        }
        this.dragMode = n;
    }

    public int getDragMode() {
        return this.dragMode;
    }

    public DesktopManager getDesktopManager() {
        return this.desktopManager;
    }

    public void setDesktopManager(DesktopManager desktopManager) {
        this.desktopManager = desktopManager;
    }

    public void updateUI() {
        this.setUI((DesktopPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "DesktopPaneUI";
    }

    public JInternalFrame[] getAllFrames() {
        return JDesktopPane.getFramesFromComponents(this.getComponents());
    }

    public JInternalFrame getSelectedFrame() {
        return this.selectedFrame;
    }

    public void setSelectedFrame(JInternalFrame jInternalFrame) {
        if (this.selectedFrame != null) {
            try {
                this.selectedFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.selectedFrame = null;
        try {
            if (jInternalFrame != null) {
                jInternalFrame.setSelected(true);
            }
            this.selectedFrame = jInternalFrame;
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public JInternalFrame[] getAllFramesInLayer(int n) {
        return JDesktopPane.getFramesFromComponents(this.getComponentsInLayer(n));
    }

    public boolean isOpaque() {
        return true;
    }

    protected String paramString() {
        String string = super.paramString();
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(",isOptimizedDrawingPossible=");
        cPStringBuilder.append(this.isOptimizedDrawingEnabled());
        cPStringBuilder.append(",desktopManager=");
        if (this.desktopManager != null) {
            cPStringBuilder.append(this.desktopManager);
        }
        return string + cPStringBuilder.toString();
    }

    private static JInternalFrame[] getFramesFromComponents(Component[] componentArray) {
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JInternalFrame)) continue;
            ++n;
        }
        JInternalFrame[] jInternalFrameArray = new JInternalFrame[n];
        int n2 = 0;
        for (int i = 0; i < componentArray.length && n2 != n; ++i) {
            if (!(componentArray[i] instanceof JInternalFrame)) continue;
            jInternalFrameArray[n2++] = (JInternalFrame)componentArray[i];
        }
        return jInternalFrameArray;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJDesktopPane();
        }
        return this.accessibleContext;
    }

    void setUIProperty(String string, Object object) {
        if (string.equals("dragMode")) {
            if (!this.clientDragModeSet) {
                this.setDragMode((Integer)object);
                this.clientDragModeSet = false;
            }
        } else {
            super.setUIProperty(string, object);
        }
    }

    protected class AccessibleJDesktopPane
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = 6079388927946077570L;

        protected AccessibleJDesktopPane() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DESKTOP_PANE;
        }
    }
}

