/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CompatibilityFocusTraversalPolicy;
import javax.swing.ComponentInputMap;
import javax.swing.DebugGraphics;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ComponentUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JComponent
extends Container
implements Serializable {
    private static final long serialVersionUID = -7908749299918704233L;
    protected AccessibleContext accessibleContext;
    float alignmentX = -1.0f;
    float alignmentY = -1.0f;
    Border border;
    JPopupMenu componentPopupMenu;
    boolean inheritsPopupMenu;
    boolean doubleBuffered = true;
    int debugGraphicsOptions;
    boolean opaque = false;
    protected ComponentUI ui;
    boolean requestFocusEnabled;
    boolean autoscrolls = false;
    static boolean paintingDoubleBuffered = false;
    static boolean isRepainting = false;
    protected EventListenerList listenerList = new EventListenerList();
    private VetoableChangeSupport vetoableChangeSupport;
    private Hashtable clientProperties;
    private InputMap inputMap_whenFocused;
    private InputMap inputMap_whenAncestorOfFocused;
    private ComponentInputMap inputMap_whenInFocusedWindow;
    private ActionMap actionMap;
    private boolean verifyInputWhenFocusTarget = true;
    private InputVerifier inputVerifier;
    private TransferHandler transferHandler;
    private boolean paintingTile;
    private Image dragBuffer;
    private boolean dragBufferInitialized;
    private static transient Rectangle rectCache;
    private static Locale defaultLocale;
    public static final String TOOL_TIP_TEXT_KEY = "ToolTipText";
    public static final int UNDEFINED_CONDITION = -1;
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    Component paintChild;
    private boolean clientOpaqueSet = false;
    private boolean clientAutoscrollsSet = false;

    public JComponent() {
        this.setDropTarget(new DropTarget());
        this.setLocale(JComponent.getDefaultLocale());
        this.debugGraphicsOptions = -1;
        this.setRequestFocusEnabled(true);
    }

    private Hashtable getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable();
        }
        return this.clientProperties;
    }

    public final Object getClientProperty(Object object) {
        return this.getClientProperties().get(object);
    }

    public final void putClientProperty(Object object, Object object2) {
        Hashtable hashtable = this.getClientProperties();
        Object v = hashtable.get(object);
        if (object2 != null) {
            hashtable.put(object, object2);
        } else {
            hashtable.remove(object);
        }
        if (v != null || object2 != null) {
            this.firePropertyChange(object.toString(), v, object2);
        }
    }

    public void removeAncestorListener(AncestorListener ancestorListener) {
        this.listenerList.remove(AncestorListener.class, ancestorListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void addAncestorListener(AncestorListener ancestorListener) {
        this.listenerList.add(AncestorListener.class, ancestorListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        if (clazz == PropertyChangeListener.class) {
            return this.getPropertyChangeListeners();
        }
        if (clazz == VetoableChangeListener.class) {
            return this.getVetoableChangeListeners();
        }
        return this.listenerList.getListeners(clazz);
    }

    public AncestorListener[] getAncestorListeners() {
        return (AncestorListener[])this.getListeners(AncestorListener.class);
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        return this.vetoableChangeSupport == null ? new VetoableChangeListener[]{} : this.vetoableChangeSupport.getVetoableChangeListeners();
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
        }
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
        super.firePropertyChange(string, n, n2);
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        super.firePropertyChange(string, bl, bl2);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return null;
    }

    @Override
    public float getAlignmentX() {
        float f = this.alignmentX;
        if (this.alignmentX < 0.0f) {
            f = super.getAlignmentX();
        }
        return f;
    }

    @Override
    public float getAlignmentY() {
        float f = this.alignmentY;
        if (this.alignmentY < 0.0f) {
            f = super.getAlignmentY();
        }
        return f;
    }

    public boolean getAutoscrolls() {
        return this.autoscrolls;
    }

    public void setBorder(Border border) {
        Border border2 = this.getBorder();
        if (border2 == border) {
            return;
        }
        this.border = border;
        this.firePropertyChange("border", border2, border);
        this.repaint();
    }

    public Border getBorder() {
        return this.border;
    }

    @Override
    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        Graphics graphics2 = graphics;
        int n = this.getDebugGraphicsOptions();
        if (n != -1) {
            if (!(graphics2 instanceof DebugGraphics)) {
                graphics2 = new DebugGraphics(graphics);
            }
            DebugGraphics debugGraphics = (DebugGraphics)graphics2;
            debugGraphics.setDebugOptions(debugGraphics.getDebugOptions() | n);
        }
        graphics2.setFont(this.getFont());
        graphics2.setColor(this.getForeground());
        return graphics2;
    }

    public int getDebugGraphicsOptions() {
        String string = System.getProperty("gnu.javax.swing.DebugGraphics");
        int n = this.debugGraphicsOptions;
        if (string != null && string.length() != 0) {
            if (n < 0) {
                n = 0;
            }
            if (string.equals("LOG")) {
                n |= 1;
            } else if (string.equals("FLASH")) {
                n |= 2;
            }
        }
        return n;
    }

    @Override
    public Insets getInsets() {
        if (this.border == null) {
            return super.getInsets();
        }
        return this.getBorder().getBorderInsets(this);
    }

    public Insets getInsets(Insets insets) {
        Insets insets2 = this.getInsets();
        if (insets == null) {
            return insets2;
        }
        insets.left = insets2.left;
        insets.right = insets2.right;
        insets.top = insets2.top;
        insets.bottom = insets2.bottom;
        return insets;
    }

    @Override
    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = null;
        if (this.isMaximumSizeSet()) {
            dimension = super.getMaximumSize();
        } else {
            if (this.ui != null) {
                dimension = this.ui.getMaximumSize(this);
            }
            if (dimension == null) {
                dimension = super.getMaximumSize();
            }
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = null;
        if (this.isMinimumSizeSet()) {
            dimension = super.getMinimumSize();
        } else {
            if (this.ui != null) {
                dimension = this.ui.getMinimumSize(this);
            }
            if (dimension == null) {
                dimension = super.getMinimumSize();
            }
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = null;
        if (this.isPreferredSizeSet()) {
            dimension = super.getPreferredSize();
        } else {
            if (this.ui != null) {
                dimension = this.ui.getPreferredSize(this);
            }
            if (dimension == null) {
                dimension = super.getPreferredSize();
            }
        }
        return dimension;
    }

    public Component getNextFocusableComponent() {
        Container container = this;
        if (!this.isFocusCycleRoot()) {
            container = this.getFocusCycleRootAncestor();
        }
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        return focusTraversalPolicy.getComponentAfter(container, this);
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        KeyStroke[] keyStrokeArray = this.inputMap_whenFocused != null ? this.inputMap_whenFocused.keys() : new KeyStroke[]{};
        KeyStroke[] keyStrokeArray2 = this.inputMap_whenAncestorOfFocused != null ? this.inputMap_whenAncestorOfFocused.keys() : new KeyStroke[]{};
        KeyStroke[] keyStrokeArray3 = this.inputMap_whenInFocusedWindow != null ? this.inputMap_whenInFocusedWindow.keys() : new KeyStroke[]{};
        int n = keyStrokeArray.length + keyStrokeArray2.length + keyStrokeArray3.length;
        KeyStroke[] keyStrokeArray4 = new KeyStroke[n];
        System.arraycopy(keyStrokeArray, 0, keyStrokeArray4, 0, keyStrokeArray.length);
        System.arraycopy(keyStrokeArray2, 0, keyStrokeArray4, keyStrokeArray.length, keyStrokeArray2.length);
        System.arraycopy(keyStrokeArray3, 0, keyStrokeArray4, keyStrokeArray.length + keyStrokeArray2.length, keyStrokeArray3.length);
        return keyStrokeArray4;
    }

    public JRootPane getRootPane() {
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        return jRootPane;
    }

    @Override
    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    public JToolTip createToolTip() {
        JToolTip jToolTip = new JToolTip();
        jToolTip.setComponent(this);
        return jToolTip;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return null;
    }

    public void setToolTipText(String string) {
        String string2 = this.getToolTipText();
        this.putClientProperty(TOOL_TIP_TEXT_KEY, string);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (string == null) {
            toolTipManager.unregisterComponent(this);
        } else if (string2 == null) {
            toolTipManager.registerComponent(this);
        }
    }

    public String getToolTipText() {
        return (String)this.getClientProperty(TOOL_TIP_TEXT_KEY);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipText();
    }

    public boolean getInheritsPopupMenu() {
        return this.inheritsPopupMenu;
    }

    public void setInheritsPopupMenu(boolean bl) {
        if (this.inheritsPopupMenu != bl) {
            this.inheritsPopupMenu = bl;
            this.firePropertyChange("inheritsPopupMenu", !bl, bl);
        }
    }

    public JPopupMenu getComponentPopupMenu() {
        if (this.componentPopupMenu == null && this.getInheritsPopupMenu()) {
            Container container = this.getParent();
            if (container instanceof JComponent) {
                return ((JComponent)container).getComponentPopupMenu();
            }
            return null;
        }
        return this.componentPopupMenu;
    }

    public void setComponentPopupMenu(JPopupMenu jPopupMenu) {
        if (this.componentPopupMenu != jPopupMenu) {
            JPopupMenu jPopupMenu2 = this.componentPopupMenu;
            this.componentPopupMenu = jPopupMenu;
            this.firePropertyChange("componentPopupMenu", jPopupMenu2, jPopupMenu);
        }
    }

    public Container getTopLevelAncestor() {
        Container container;
        for (Container container2 = container = this.getParent(); container2 != null; container2 = container2.getParent()) {
            container = container2;
        }
        return container;
    }

    public void computeVisibleRect(Rectangle rectangle) {
        Container container = this.getParent();
        if (container != null && container instanceof JComponent) {
            ((JComponent)container).computeVisibleRect(rectangle);
            rectangle.translate(-this.getX(), -this.getY());
            rectangle = SwingUtilities.computeIntersection(0, 0, this.getWidth(), this.getHeight(), rectangle);
        } else {
            rectangle.setRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    public Rectangle getVisibleRect() {
        Rectangle rectangle = new Rectangle();
        this.computeVisibleRect(rectangle);
        return rectangle;
    }

    public void grabFocus() {
        this.requestFocus();
    }

    @Override
    public boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    public static boolean isLightweightComponent(Component component) {
        return component.getPeer() instanceof LightweightPeer;
    }

    public boolean isManagingFocus() {
        return false;
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public boolean isPaintingTile() {
        return this.paintingTile;
    }

    public boolean isRequestFocusEnabled() {
        return this.requestFocusEnabled;
    }

    public boolean isValidateRoot() {
        return false;
    }

    @Override
    public void paint(Graphics graphics) {
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        if (!paintingDoubleBuffered && this.isDoubleBuffered() && repaintManager.isDoubleBufferingEnabled()) {
            Rectangle rectangle = graphics.getClipBounds();
            this.paintDoubleBuffered(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.getClientProperty("bufferedDragging") != null && this.dragBuffer == null) {
                this.initializeDragBuffer();
            } else if (this.getClientProperty("bufferedDragging") == null && this.dragBuffer != null) {
                this.dragBuffer = null;
            }
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                n4 = 0;
                n3 = 0;
                n2 = this.getWidth();
                n = this.getHeight();
            } else {
                n4 = rectangle.x;
                n3 = rectangle.y;
                n2 = rectangle.width;
                n = rectangle.height;
            }
            if (this.dragBuffer != null && this.dragBufferInitialized) {
                graphics.drawImage(this.dragBuffer, 0, 0, this);
            } else {
                Graphics graphics2 = this.getComponentGraphics(graphics);
                if (!this.isOccupiedByChild(n4, n3, n2, n)) {
                    this.paintComponent(graphics2);
                    this.paintBorder(graphics2);
                }
                this.paintChildren(graphics2);
            }
        }
    }

    private boolean isOccupiedByChild(int n, int n2, int n3, int n4) {
        boolean bl = false;
        int n5 = this.getComponentCount();
        for (int i = 0; i < n5; ++i) {
            Component component = this.getComponent(i);
            int n6 = component.getX();
            int n7 = component.getY();
            int n8 = component.getWidth();
            int n9 = component.getHeight();
            if (!component.isVisible() || n < n6 || n + n3 > n6 + n8 || n2 < n7 || n2 + n4 > n7 + n9) continue;
            bl = component.isOpaque();
            break;
        }
        return bl;
    }

    private void initializeDragBuffer() {
        this.dragBufferInitialized = false;
        if (this.dragBuffer == null || this.dragBuffer.getWidth(this) < this.getWidth() || this.dragBuffer.getHeight(this) < this.getHeight()) {
            this.dragBuffer = this.createImage(this.getWidth(), this.getHeight());
        }
        Graphics graphics = this.dragBuffer.getGraphics();
        this.paint(graphics);
        graphics.dispose();
        this.dragBufferInitialized = true;
    }

    protected void paintBorder(Graphics graphics) {
        if (this.getBorder() != null) {
            this.getBorder().paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintChildren(Graphics graphics) {
        block11: {
            if (this.getComponentCount() <= 0) break block11;
            Object object = this.getTreeLock();
            synchronized (object) {
                int n;
                if (this.paintChild != null && this.paintChild.isOpaque()) {
                    for (n = this.getComponentCount() - 1; n >= 0 && this.getComponent(n) != this.paintChild; --n) {
                    }
                }
                while (n >= 0) {
                    block12: {
                        Object var11_10;
                        Object object2;
                        int n2;
                        int n3;
                        int n4;
                        int n5;
                        Component component;
                        block13: {
                            component = this.getComponent(n);
                            if (component == null || !component.isLightweight() || !component.isVisible() || !graphics.hitClip(n5 = component.getX(), n4 = component.getY(), n3 = component.getWidth(), n2 = component.getHeight())) break block12;
                            if (this.isOptimizedDrawingEnabled() || n <= 0) break block13;
                            object2 = graphics.getClipBounds();
                            SwingUtilities.computeIntersection(n5, n4, n3, n2, (Rectangle)object2);
                            if (this.isCompletelyObscured(n, ((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height)) break block12;
                        }
                        object2 = graphics.create(n5, n4, n3, n2);
                        ((Graphics)object2).setColor(component.getForeground());
                        ((Graphics)object2).setFont(component.getFont());
                        try {
                            component.paint((Graphics)object2);
                            var11_10 = null;
                            ((Graphics)object2).dispose();
                        }
                        catch (Throwable throwable) {
                            var11_10 = null;
                            ((Graphics)object2).dispose();
                            throw throwable;
                        }
                    }
                    --n;
                }
            }
        }
    }

    private boolean isCompletelyObscured(int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        for (int i = n - 1; i >= 0 && !bl; --i) {
            Component component = this.getComponent(i);
            if (!component.isVisible()) continue;
            Rectangle rectangle = component.getBounds(rectCache);
            if (!component.isOpaque() || n2 < rectangle.x || n2 + n4 > rectangle.x + rectangle.width || n3 < rectangle.y || n3 + n5 > rectangle.y + rectangle.height) continue;
            bl = true;
        }
        return bl;
    }

    private boolean isPartiallyObscured(int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        for (int i = n - 1; i >= 0 && !bl; --i) {
            Component component = this.getComponent(i);
            if (!component.isVisible()) continue;
            Rectangle rectangle = component.getBounds(rectCache);
            if (n2 + n4 <= rectangle.x && n3 + n5 > rectangle.y && n2 < rectangle.x + rectangle.width && n3 < rectangle.y + rectangle.height) continue;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            Graphics graphics2 = graphics.create();
            try {
                this.ui.update(graphics2, this);
                Object var4_3 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
    }

    public void paintImmediately(int n, int n2, int n3, int n4) {
        if (this.isShowing()) {
            Container container = this;
            while (container != null && !((Component)container).isOpaque()) {
                Container container2 = container.getParent();
                if (container2 == null) continue;
                n += ((Component)container).getX();
                n2 += ((Component)container).getY();
                container = container2;
            }
            if (container instanceof JComponent) {
                container.paintImmediately2(n, n2, n3, n4);
            } else {
                container.repaint(n, n2, n3, n4);
            }
        }
    }

    public void paintImmediately(Rectangle rectangle) {
        this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintImmediately2(int n, int n2, int n3, int n4) {
        Container container;
        boolean bl = this.onTop() && this.isOpaque();
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        boolean bl2 = false;
        JComponent jComponent = this;
        int n9 = -1;
        int n10 = 0;
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        int n11 = 0;
        int n12 = 0;
        JComponent jComponent2 = null;
        for (container = this; container != null && !(container instanceof Window) && !(container instanceof Applet); container = container.getParent()) {
            int n13;
            int n14;
            JComponent jComponent3 = container instanceof JComponent ? container : null;
            arrayList.add((JComponent)container);
            if (!bl && jComponent3 != null && !jComponent3.isOptimizedDrawingEnabled()) {
                n14 = 0;
                if (container != this) {
                    if (jComponent3.isPaintRoot()) {
                        n14 = 1;
                    } else {
                        int n15;
                        n13 = container.getComponentCount();
                        for (n15 = 0; n15 < n13 && container.getComponent(n15) != jComponent2; ++n15) {
                        }
                        if (jComponent3.isCompletelyObscured(n15, n5, n6, n7, n8)) {
                            return;
                        }
                        if (jComponent3.isPartiallyObscured(n15, n5, n6, n7, n8)) {
                            n14 = 1;
                        }
                    }
                }
                if (n14 != 0) {
                    jComponent = jComponent3;
                    n9 = n10;
                    n11 = 0;
                    n12 = 0;
                    bl2 = false;
                }
            }
            ++n10;
            if (repaintManager.isDoubleBufferingEnabled() && jComponent3 != null && jComponent3.isDoubleBuffered()) {
                bl2 = true;
            }
            if (!bl) {
                n5 = Math.max(0, n5);
                n6 = Math.max(0, n6);
                n7 = Math.min(container.getWidth(), n7 + n5) - n5;
                n8 = Math.min(container.getHeight(), n8 + n6) - n6;
                n14 = container.getX();
                n13 = container.getY();
                n5 += n14;
                n6 += n13;
                n11 += n14;
                n12 += n13;
            }
            jComponent2 = container;
        }
        if (container != null && container.getPeer() != null && n7 > 0 && n8 > 0) {
            isRepainting = true;
            n5 -= n11;
            n6 -= n12;
            if (jComponent != this) {
                for (int i = n9; i > 0; --i) {
                    Component component = (Component)arrayList.get(i);
                    if (!(component instanceof JComponent)) continue;
                    ((JComponent)component).paintChild = (Component)arrayList.get(i - 1);
                }
            }
            if (bl2) {
                jComponent.paintDoubleBuffered(n5, n6, n7, n8);
            } else {
                Graphics graphics = jComponent.getGraphics();
                try {
                    graphics.setClip(n5, n6, n7, n8);
                    jComponent.paint(graphics);
                    Object var25_30 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    Object var25_31 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
            if (jComponent != this) {
                for (int i = n9; i > 0; --i) {
                    Component component = (Component)arrayList.get(i);
                    if (!(component instanceof JComponent)) continue;
                    ((JComponent)component).paintChild = null;
                }
            }
            isRepainting = false;
        }
    }

    boolean onTop() {
        return false;
    }

    boolean isPaintRoot() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintDoubleBuffered(int n, int n2, int n3, int n4) {
        Component component;
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        Image image = repaintManager.getVolatileOffscreenBuffer(this, (component = SwingUtilities.getRoot(this)).getWidth(), component.getHeight());
        if (image == null) {
            image = repaintManager.getOffscreenBuffer(this, component.getWidth(), component.getHeight());
        }
        Graphics graphics = image.getGraphics();
        this.clipAndTranslateGraphics(component, this, graphics);
        graphics.clipRect(n, n2, n3, n4);
        graphics = this.getComponentGraphics(graphics);
        paintingDoubleBuffered = true;
        try {
            if (isRepainting) {
                this.paint(graphics);
            } else {
                this.paintComponent(graphics);
                this.paintBorder(graphics);
                this.paintChildren(graphics);
            }
            Object var10_9 = null;
            paintingDoubleBuffered = false;
            graphics.dispose();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            paintingDoubleBuffered = false;
            graphics.dispose();
            throw throwable;
        }
        repaintManager.commitBuffer(this, n, n2, n3, n4);
    }

    private void clipAndTranslateGraphics(Component component, Component component2, Graphics graphics) {
        int n = 0;
        int n2 = 0;
        for (Component component3 = component2; component3 != component; component3 = component3.getParent()) {
            n += component3.getX();
            n2 += component3.getY();
        }
        graphics.translate(n, n2);
        graphics.clipRect(0, 0, component2.getWidth(), component2.getHeight());
    }

    void paintSimple(Rectangle rectangle) {
        Graphics graphics = this.getGraphics();
        Graphics graphics2 = this.getComponentGraphics(graphics);
        graphics2.setClip(rectangle);
        this.paint(graphics2);
        graphics2.dispose();
        if (graphics != graphics2) {
            graphics.dispose();
        }
    }

    @Override
    protected String paramString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(super.paramString());
        cPStringBuilder.append(",alignmentX=").append(this.getAlignmentX());
        cPStringBuilder.append(",alignmentY=").append(this.getAlignmentY());
        cPStringBuilder.append(",border=");
        if (this.getBorder() != null) {
            cPStringBuilder.append(this.getBorder());
        }
        cPStringBuilder.append(",maximumSize=");
        if (this.getMaximumSize() != null) {
            cPStringBuilder.append(this.getMaximumSize());
        }
        cPStringBuilder.append(",minimumSize=");
        if (this.getMinimumSize() != null) {
            cPStringBuilder.append(this.getMinimumSize());
        }
        cPStringBuilder.append(",preferredSize=");
        if (this.getPreferredSize() != null) {
            cPStringBuilder.append(this.getPreferredSize());
        }
        return cPStringBuilder.toString();
    }

    public void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke, int n) {
        this.registerKeyboardAction(actionListener, null, keyStroke, n);
    }

    public void registerKeyboardAction(ActionListener actionListener, String string, KeyStroke keyStroke, int n) {
        ActionListenerProxy actionListenerProxy = new ActionListenerProxy(actionListener, string);
        this.getInputMap(n).put(keyStroke, actionListenerProxy);
        this.getActionMap().put(actionListenerProxy, actionListenerProxy);
    }

    public final void setInputMap(int n, InputMap inputMap) {
        this.enableEvents(8L);
        switch (n) {
            case 0: {
                this.inputMap_whenFocused = inputMap;
                break;
            }
            case 1: {
                this.inputMap_whenAncestorOfFocused = inputMap;
                break;
            }
            case 2: {
                if (inputMap != null && !(inputMap instanceof ComponentInputMap)) {
                    throw new IllegalArgumentException("WHEN_IN_FOCUSED_WINDOW InputMap must be a ComponentInputMap");
                }
                this.inputMap_whenInFocusedWindow = (ComponentInputMap)inputMap;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final InputMap getInputMap(int n) {
        this.enableEvents(8L);
        switch (n) {
            case 0: {
                if (this.inputMap_whenFocused == null) {
                    this.inputMap_whenFocused = new InputMap();
                }
                return this.inputMap_whenFocused;
            }
            case 1: {
                if (this.inputMap_whenAncestorOfFocused == null) {
                    this.inputMap_whenAncestorOfFocused = new InputMap();
                }
                return this.inputMap_whenAncestorOfFocused;
            }
            case 2: {
                if (this.inputMap_whenInFocusedWindow == null) {
                    this.inputMap_whenInFocusedWindow = new ComponentInputMap(this);
                }
                return this.inputMap_whenInFocusedWindow;
            }
        }
        throw new IllegalArgumentException("Invalid 'condition' argument: " + n);
    }

    public final InputMap getInputMap() {
        return this.getInputMap(0);
    }

    public final ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
        }
        return this.actionMap;
    }

    public final void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
    }

    public int getConditionForKeyStroke(KeyStroke keyStroke) {
        if (this.inputMap_whenFocused != null && this.inputMap_whenFocused.get(keyStroke) != null) {
            return 0;
        }
        if (this.inputMap_whenAncestorOfFocused != null && this.inputMap_whenAncestorOfFocused.get(keyStroke) != null) {
            return 1;
        }
        if (this.inputMap_whenInFocusedWindow != null && this.inputMap_whenInFocusedWindow.get(keyStroke) != null) {
            return 2;
        }
        return -1;
    }

    public ActionListener getActionForKeyStroke(KeyStroke keyStroke) {
        Object object = this.getInputMap(0).get(keyStroke);
        if (object == null) {
            object = this.getInputMap(1).get(keyStroke);
        }
        if (object == null) {
            object = this.getInputMap(2).get(keyStroke);
        }
        if (object != null) {
            if (object instanceof ActionListenerProxy) {
                return ((ActionListenerProxy)object).target;
            }
            return this.getActionMap().get(object);
        }
        return null;
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        Container container;
        boolean bl;
        super.processKeyEvent(keyEvent);
        this.processComponentKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        boolean bl2 = bl = keyEvent.getID() == 401;
        if (this.processKeyBinding(keyStroke, keyEvent, 0, bl)) {
            keyEvent.consume();
            return;
        }
        if (this.processKeyBinding(keyStroke, keyEvent, 1, bl)) {
            keyEvent.consume();
            return;
        }
        for (container = this.getParent(); container != null; container = container.getParent()) {
            if (container instanceof JComponent && ((JComponent)container).processKeyBinding(keyStroke, keyEvent, 1, bl)) {
                keyEvent.consume();
                return;
            }
            if (container instanceof Window || container instanceof Applet) break;
        }
        if (container == null || keyEvent.isConsumed()) {
            return;
        }
        if (KeyboardManager.getManager().processKeyStroke(container, keyStroke, keyEvent)) {
            keyEvent.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (this.isEnabled()) {
            Action action = null;
            Object object = null;
            InputMap inputMap = this.getInputMap(n);
            if (inputMap != null && (object = inputMap.get(keyStroke)) != null) {
                action = object instanceof ActionListenerProxy ? (Action)object : this.getActionMap().get(object);
            }
            if (action != null && action.isEnabled()) {
                Action action2 = action;
                synchronized (action2) {
                    action.putValue("__command__", object);
                    return SwingUtilities.notifyAction(action, keyStroke, keyEvent, this, keyEvent.getModifiers());
                }
            }
        }
        return false;
    }

    public void unregisterKeyboardAction(KeyStroke keyStroke) {
        ActionMap actionMap = this.getActionMap();
        for (int i = 0; i < 3; ++i) {
            InputMap inputMap = this.getInputMap(i);
            if (inputMap == null) continue;
            Object object = inputMap.get(keyStroke);
            if (object != null && actionMap != null) {
                actionMap.remove(object);
            }
            inputMap.remove(keyStroke);
        }
    }

    public void resetKeyboardActions() {
        if (this.inputMap_whenFocused != null) {
            this.inputMap_whenFocused.clear();
        }
        if (this.inputMap_whenAncestorOfFocused != null) {
            this.inputMap_whenAncestorOfFocused.clear();
        }
        if (this.inputMap_whenInFocusedWindow != null) {
            this.inputMap_whenInFocusedWindow.clear();
        }
        if (this.actionMap != null) {
            this.actionMap.clear();
        }
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        RepaintManager.currentManager(this).addDirtyRegion(this, n, n2, n3, n4);
    }

    public void repaint(Rectangle rectangle) {
        RepaintManager.currentManager(this).addDirtyRegion(this, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean requestDefaultFocus() {
        return false;
    }

    public void revalidate() {
        if (this.getParent() == null) {
            return;
        }
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JComponent.this.revalidate();
                }
            });
        } else {
            this.invalidate();
            RepaintManager.currentManager(this).addInvalidComponent(this);
        }
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Container container;
        int n = this.getX();
        int n2 = this.getY();
        for (container = this.getParent(); container != null && !(container instanceof JComponent); container = container.getParent()) {
            n += container.getX();
            n2 += container.getY();
        }
        if (container != null) {
            rectangle.x += n;
            rectangle.y += n2;
            JComponent jComponent = (JComponent)container;
            jComponent.scrollRectToVisible(rectangle);
            rectangle.x -= n;
            rectangle.y -= n2;
        }
    }

    public void setAlignmentX(float f) {
        this.alignmentX = f < 0.0f ? 0.0f : ((double)f > 1.0 ? 1.0f : f);
    }

    public void setAlignmentY(float f) {
        this.alignmentY = f < 0.0f ? 0.0f : ((double)f > 1.0 ? 1.0f : f);
    }

    public void setAutoscrolls(boolean bl) {
        this.autoscrolls = bl;
        this.clientAutoscrollsSet = true;
    }

    public void setDebugGraphicsOptions(int n) {
        this.debugGraphicsOptions = n;
    }

    public void setDoubleBuffered(boolean bl) {
        this.doubleBuffered = bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl == this.isEnabled()) {
            return;
        }
        super.setEnabled(bl);
        this.firePropertyChange("enabled", !bl, bl);
        this.repaint();
    }

    @Override
    public void setFont(Font font) {
        if (font == this.getFont()) {
            return;
        }
        super.setFont(font);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setBackground(Color color) {
        if (color == this.getBackground()) {
            return;
        }
        super.setBackground(color);
        this.repaint();
    }

    @Override
    public void setForeground(Color color) {
        if (color == this.getForeground()) {
            return;
        }
        super.setForeground(color);
        this.repaint();
    }

    public void setNextFocusableComponent(Component component) {
        FocusTraversalPolicy focusTraversalPolicy;
        Container container = this;
        if (!this.isFocusCycleRoot()) {
            container = this.getFocusCycleRootAncestor();
        }
        if ((focusTraversalPolicy = container.getFocusTraversalPolicy()) instanceof CompatibilityFocusTraversalPolicy) {
            focusTraversalPolicy = new CompatibilityFocusTraversalPolicy(focusTraversalPolicy);
            container.setFocusTraversalPolicy(focusTraversalPolicy);
        }
        CompatibilityFocusTraversalPolicy compatibilityFocusTraversalPolicy = (CompatibilityFocusTraversalPolicy)focusTraversalPolicy;
        Component component2 = this.getNextFocusableComponent();
        if (component2 != null) {
            compatibilityFocusTraversalPolicy.removeNextFocusableComponent(this, component2);
        }
        if (component != null) {
            compatibilityFocusTraversalPolicy.addNextFocusableComponent(this, component);
        }
    }

    public void setRequestFocusEnabled(boolean bl) {
        this.requestFocusEnabled = bl;
    }

    public TransferHandler getTransferHandler() {
        return this.transferHandler;
    }

    public void setTransferHandler(TransferHandler transferHandler) {
        if (this.transferHandler == transferHandler) {
            return;
        }
        TransferHandler transferHandler2 = this.transferHandler;
        this.transferHandler = transferHandler;
        this.firePropertyChange("transferHandler", transferHandler2, transferHandler);
    }

    public void setOpaque(boolean bl) {
        boolean bl2 = this.opaque;
        this.opaque = bl;
        this.clientOpaqueSet = true;
        this.firePropertyChange("opaque", bl2, this.opaque);
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.isVisible() == bl) {
            return;
        }
        super.setVisible(bl);
        if (bl) {
            this.fireAncestorEvent(this, 1);
        } else {
            this.fireAncestorEvent(this, 2);
        }
        Container container = this.getParent();
        if (container != null) {
            container.repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        this.revalidate();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public String getUIClassID() {
        return "ComponentUI";
    }

    protected void setUI(ComponentUI componentUI) {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        ComponentUI componentUI2 = this.ui;
        this.ui = componentUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.firePropertyChange("UI", componentUI2, componentUI);
        this.revalidate();
        this.repaint();
    }

    public void updateUI() {
    }

    public static Locale getDefaultLocale() {
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault();
        }
        return defaultLocale;
    }

    public static void setDefaultLocale(Locale locale) {
        defaultLocale = locale;
    }

    public InputVerifier getInputVerifier() {
        return this.inputVerifier;
    }

    public void setInputVerifier(InputVerifier inputVerifier) {
        InputVerifier inputVerifier2 = this.inputVerifier;
        this.inputVerifier = inputVerifier;
        this.firePropertyChange("inputVerifier", inputVerifier2, inputVerifier);
    }

    public boolean getVerifyInputWhenFocusTarget() {
        return this.verifyInputWhenFocusTarget;
    }

    public void setVerifyInputWhenFocusTarget(boolean bl) {
        if (this.verifyInputWhenFocusTarget == bl) {
            return;
        }
        this.verifyInputWhenFocusTarget = bl;
        this.firePropertyChange("verifyInputWhenFocusTarget", !bl, bl);
    }

    @Override
    public void requestFocus() {
        if (this.isRequestFocusEnabled()) {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean bl) {
        return super.requestFocus(bl);
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.isRequestFocusEnabled()) {
            return super.requestFocusInWindow();
        }
        return false;
    }

    @Override
    protected boolean requestFocusInWindow(boolean bl) {
        return super.requestFocusInWindow(bl);
    }

    @Override
    public void addNotify() {
        KeyboardManager keyboardManager = KeyboardManager.getManager();
        keyboardManager.clearBindingsForComp(this);
        keyboardManager.registerEntireMap((ComponentInputMap)this.getInputMap(2));
        super.addNotify();
        this.fireAncestorEvent(this, 1);
        this.firePropertyChange("ancestor", null, this.getParent());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KeyboardManager.getManager().clearBindingsForComp(this);
        this.fireAncestorEvent(this, 2);
        this.firePropertyChange("ancestor", this.getParent(), null);
    }

    @Override
    public boolean contains(int n, int n2) {
        if (this.ui == null) {
            return super.contains(n, n2);
        }
        return this.ui.contains(this, n, n2);
    }

    @Override
    public void disable() {
        super.disable();
    }

    @Override
    public void enable() {
        super.enable();
    }

    @Override
    public Graphics getGraphics() {
        return super.getGraphics();
    }

    @Override
    public int getX() {
        return super.getX();
    }

    @Override
    public int getY() {
        return super.getY();
    }

    @Override
    public int getHeight() {
        return super.getHeight();
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }

    @Override
    public void print(Graphics graphics) {
        boolean bl = this.isDoubleBuffered();
        this.setDoubleBuffered(false);
        this.printComponent(graphics);
        this.printBorder(graphics);
        this.printChildren(graphics);
        this.setDoubleBuffered(bl);
    }

    @Override
    public void printAll(Graphics graphics) {
        this.print(graphics);
    }

    protected void printComponent(Graphics graphics) {
        this.paintComponent(graphics);
    }

    protected void printChildren(Graphics graphics) {
        this.paintChildren(graphics);
    }

    protected void printBorder(Graphics graphics) {
        this.paintBorder(graphics);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        int n5 = this.getX();
        int n6 = this.getY();
        super.reshape(n, n2, n3, n4);
        if (n5 != this.getX() || n6 != this.getY()) {
            this.fireAncestorEvent(this, 3);
        }
    }

    void fireAncestorEvent(JComponent jComponent, int n) {
        int n2;
        AncestorListener[] ancestorListenerArray = this.getAncestorListeners();
        if (ancestorListenerArray.length > 0) {
            AncestorEvent ancestorEvent = new AncestorEvent(this, n, jComponent, jComponent.getParent());
            block5: for (n2 = 0; n2 < ancestorListenerArray.length; ++n2) {
                switch (n) {
                    case 3: {
                        ancestorListenerArray[n2].ancestorMoved(ancestorEvent);
                        continue block5;
                    }
                    case 1: {
                        ancestorListenerArray[n2].ancestorAdded(ancestorEvent);
                        continue block5;
                    }
                    case 2: {
                        ancestorListenerArray[n2].ancestorRemoved(ancestorEvent);
                    }
                }
            }
        }
        int n3 = this.getComponentCount();
        for (n2 = 0; n2 < n3; ++n2) {
            Component component = this.getComponent(n2);
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent2 = (JComponent)component;
            jComponent2.fireAncestorEvent(jComponent, n);
        }
    }

    void updateComponentInputMap(ComponentInputMap componentInputMap) {
        InputMap inputMap;
        for (inputMap = this.getInputMap(2); inputMap != null && inputMap != componentInputMap; inputMap = inputMap.getParent()) {
        }
        if (inputMap == null) {
            return;
        }
        KeyboardManager keyboardManager = KeyboardManager.getManager();
        keyboardManager.clearBindingsForComp(componentInputMap.getComponent());
        keyboardManager.registerEntireMap((ComponentInputMap)this.getInputMap(2));
    }

    void setUIProperty(String string, Object object) {
        if (string.equals("opaque")) {
            if (!this.clientOpaqueSet) {
                this.setOpaque((Boolean)object);
                this.clientOpaqueSet = false;
            }
        } else if (string.equals("autoscrolls")) {
            if (!this.clientAutoscrollsSet) {
                this.setAutoscrolls((Boolean)object);
                this.clientAutoscrollsSet = false;
            }
        } else {
            throw new IllegalArgumentException("Unsupported property for LookAndFeel.installProperty(): " + string);
        }
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public ActionListenerProxy(ActionListener actionListener, String string) {
            this.target = actionListener;
            this.bindingCommandName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionEvent actionEvent2 = new ActionEvent(actionEvent.getSource(), actionEvent.getID(), this.bindingCommandName, actionEvent.getModifiers());
            this.target.actionPerformed(actionEvent2);
        }
    }

    public abstract class AccessibleJComponent
    extends Container.AccessibleAWTContainer
    implements AccessibleExtendedComponent {
        private static final long serialVersionUID = -7047089700479897799L;
        protected ContainerListener accessibleContainerHandler;
        protected FocusListener accessibleFocusHandler;

        protected AccessibleJComponent() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleContainerHandler == null) {
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                JComponent.this.addContainerListener(this.accessibleContainerHandler);
            }
            if (this.accessibleFocusHandler == null) {
                this.accessibleFocusHandler = new AccessibleFocusHandler();
                this.addFocusListener(this.accessibleFocusHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleContainerHandler != null) {
                JComponent.this.removeContainerListener(this.accessibleContainerHandler);
                this.accessibleContainerHandler = null;
            }
            if (this.accessibleFocusHandler != null) {
                this.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount();
        }

        public Accessible getAccessibleChild(int n) {
            return super.getAccessibleChild(n);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JComponent.this.isOpaque()) {
                accessibleStateSet.add(AccessibleState.OPAQUE);
            }
            return accessibleStateSet;
        }

        public String getAccessibleName() {
            Object object;
            String string = super.getAccessibleName();
            if (string == null) {
                string = this.getTitledBorderText();
            }
            if (string == null && (object = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible) {
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                string = accessibleContext.getAccessibleName();
            }
            return string;
        }

        public String getAccessibleDescription() {
            Object object;
            String string = super.getAccessibleDescription();
            if (string == null) {
                string = this.getToolTipText();
            }
            if (string == null && (object = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible) {
                AccessibleContext accessibleContext = ((Accessible)object).getAccessibleContext();
                string = accessibleContext.getAccessibleName();
            }
            return string;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        protected String getBorderTitle(Border border) {
            String string = null;
            if (border instanceof CompoundBorder) {
                CompoundBorder compoundBorder = (CompoundBorder)border;
                Border border2 = compoundBorder.getInsideBorder();
                string = this.getBorderTitle(border2);
                if (string == null) {
                    Border border3 = compoundBorder.getOutsideBorder();
                    string = this.getBorderTitle(border3);
                }
            } else if (border instanceof TitledBorder) {
                TitledBorder titledBorder = (TitledBorder)border;
                string = titledBorder.getTitle();
            }
            return string;
        }

        public String getToolTipText() {
            return JComponent.this.getToolTipText();
        }

        public String getTitledBorderText() {
            return this.getBorderTitle(JComponent.this.getBorder());
        }

        public AccessibleKeyBinding getAccessibleKeyBinding() {
            return null;
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleContext accessibleContext = component.getAccessibleContext();
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", null, accessibleContext);
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleContext accessibleContext = component.getAccessibleContext();
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", accessibleContext, null);
                }
            }
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            protected AccessibleFocusHandler() {
            }

            public void focusGained(FocusEvent focusEvent) {
                AccessibleJComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }

            public void focusLost(FocusEvent focusEvent) {
                AccessibleJComponent.this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }
    }
}

