/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.BitSet;
import java.util.EventListener;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListSelectionModel
implements Cloneable,
ListSelectionModel,
Serializable {
    private static final long serialVersionUID = -5718799865110415860L;
    protected EventListenerList listenerList = new EventListenerList();
    int selectionMode = 2;
    int leadSelectionIndex = -1;
    int anchorSelectionIndex = -1;
    protected boolean leadAnchorNotificationEnabled = true;
    boolean valueIsAdjusting = false;
    BitSet sel = new BitSet();
    Object oldSel;
    boolean setLeadCalledFromAdd = false;

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionMode(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Unrecognised mode: " + n);
        }
        this.selectionMode = n;
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.anchorSelectionIndex;
    }

    @Override
    public void setAnchorSelectionIndex(int n) {
        if (this.anchorSelectionIndex != n) {
            int n2 = this.anchorSelectionIndex;
            this.anchorSelectionIndex = n;
            if (this.leadAnchorNotificationEnabled) {
                this.fireValueChanged(n, n2);
            }
        }
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.leadSelectionIndex;
    }

    @Override
    public void setLeadSelectionIndex(int n) {
        int n2;
        if (n < 0) {
            if (this.anchorSelectionIndex < 0) {
                this.leadSelectionIndex = -1;
            } else {
                return;
            }
        }
        if (this.anchorSelectionIndex < 0) {
            return;
        }
        if (this.selectionMode == 0) {
            this.setSelectionInterval(n, n);
        }
        if ((n2 = this.leadSelectionIndex) == -1) {
            n2 = n;
        }
        if (!this.setLeadCalledFromAdd) {
            this.oldSel = this.sel.clone();
        }
        this.leadSelectionIndex = n;
        if (this.anchorSelectionIndex == -1) {
            return;
        }
        int n3 = Math.min(this.anchorSelectionIndex, n2);
        int n4 = Math.max(this.anchorSelectionIndex, n2);
        int n5 = Math.min(this.anchorSelectionIndex, n);
        int n6 = Math.max(this.anchorSelectionIndex, n);
        int n7 = Math.min(n3, n5);
        int n8 = Math.max(n4, n6);
        if (this.isSelectedIndex(this.anchorSelectionIndex)) {
            this.sel.clear(n3, n4 + 1);
            this.sel.set(n5, n6 + 1);
        } else {
            this.sel.set(n3, n4 + 1);
            this.sel.clear(n5, n6 + 1);
        }
        int n9 = this.sel.nextSetBit(0);
        int n10 = -1;
        int n11 = n9;
        while (n11 >= 0) {
            n10 = n11;
            n11 = this.sel.nextSetBit(n11 + 1);
        }
        BitSet bitSet = (BitSet)this.oldSel;
        bitSet.set(n2, !this.sel.get(n2));
        bitSet.set(this.leadSelectionIndex, !this.sel.get(this.leadSelectionIndex));
        this.fireDifference(this.sel, bitSet);
    }

    public void moveLeadSelectionIndex(int n) {
        if (this.leadSelectionIndex == n) {
            return;
        }
        this.leadSelectionIndex = n;
        if (this.isLeadAnchorNotificationEnabled()) {
            this.fireValueChanged(Math.min(this.leadSelectionIndex, n), Math.max(this.leadSelectionIndex, n));
        }
    }

    public boolean isLeadAnchorNotificationEnabled() {
        return this.leadAnchorNotificationEnabled;
    }

    public void setLeadAnchorNotificationEnabled(boolean bl) {
        this.leadAnchorNotificationEnabled = bl;
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        this.valueIsAdjusting = bl;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.sel.isEmpty();
    }

    @Override
    public int getMinSelectionIndex() {
        if (this.isSelectionEmpty()) {
            return -1;
        }
        return this.sel.nextSetBit(0);
    }

    @Override
    public int getMaxSelectionIndex() {
        if (this.isSelectionEmpty()) {
            return -1;
        }
        int n = -1;
        int n2 = this.sel.nextSetBit(0);
        while (n2 >= 0) {
            n = n2;
            n2 = this.sel.nextSetBit(n2 + 1);
        }
        return n;
    }

    @Override
    public boolean isSelectedIndex(int n) {
        if (n >= this.sel.length() || n < 0) {
            return false;
        }
        return this.sel.get(n);
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return;
        }
        if (this.selectionMode == 0) {
            this.setSelectionInterval(n, n2);
        } else {
            int n3 = Math.min(n, n2);
            int n4 = Math.max(n, n2);
            this.oldSel = this.sel.clone();
            if (!(this.selectionMode != 1 || this.isSelectedIndex(n) || this.isSelectedIndex(n2) || this.isSelectedIndex(Math.max(n3 - 1, 0)) || this.isSelectedIndex(Math.min(n4 + 1, this.sel.size())))) {
                this.sel.clear();
            }
            if (this.isSelectedIndex(this.leadSelectionIndex) && (n - 1 == this.leadSelectionIndex && n2 >= n && this.leadSelectionIndex >= this.anchorSelectionIndex || n + 1 == this.leadSelectionIndex && n2 <= n && this.leadSelectionIndex <= this.anchorSelectionIndex) && (this.anchorSelectionIndex != -1 || this.leadSelectionIndex != -1)) {
                this.setLeadCalledFromAdd = true;
                this.setLeadSelectionIndex(n2);
                this.setLeadCalledFromAdd = false;
            } else {
                this.leadSelectionIndex = n2;
                this.anchorSelectionIndex = n;
                this.sel.set(n3, n4 + 1);
                this.fireDifference(this.sel, (BitSet)this.oldSel);
            }
        }
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return;
        }
        this.oldSel = this.sel.clone();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        if (this.getMinSelectionIndex() > 0 && this.getMinSelectionIndex() < n3 && this.selectionMode == 1) {
            n4 = this.sel.size() - 1;
        }
        this.sel.clear(n3, n4 + 1);
        this.setAnchorSelectionIndex(n);
        this.leadSelectionIndex = n2;
        this.fireDifference(this.sel, (BitSet)this.oldSel);
    }

    @Override
    public void clearSelection() {
        int n = this.sel.nextSetBit(0);
        if (n < 0) {
            return;
        }
        int n2 = n;
        int n3 = n;
        while (n3 >= 0) {
            n2 = n3;
            n3 = this.sel.nextSetBit(n3 + 1);
        }
        this.sel.clear();
        this.fireValueChanged(n, n2, this.valueIsAdjusting);
    }

    private void fireDifference(BitSet bitSet, BitSet bitSet2) {
        bitSet2.xor(bitSet);
        int n = bitSet2.nextSetBit(0);
        if (n < 0) {
            return;
        }
        int n2 = n;
        int n3 = n;
        while (n3 >= 0) {
            n2 = n3;
            n3 = bitSet2.nextSetBit(n3 + 1);
        }
        this.fireValueChanged(n, n2, this.valueIsAdjusting);
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return;
        }
        if (this.selectionMode == 0) {
            int n3 = n2;
            int n4 = n2;
            int n5 = this.sel.nextSetBit(0);
            if (n5 == n2) {
                return;
            }
            if (n5 >= 0) {
                n3 = Math.min(n3, n5);
                n4 = Math.max(n4, n5);
            }
            if (this.anchorSelectionIndex >= 0) {
                n3 = Math.min(n3, this.anchorSelectionIndex);
                n4 = Math.max(n4, this.anchorSelectionIndex);
            }
            this.sel.clear();
            this.sel.set(n2);
            this.leadSelectionIndex = n2;
            this.anchorSelectionIndex = n2;
            this.fireValueChanged(n3, n4);
        } else if (this.selectionMode == 1) {
            int n6;
            int n7 = n6 = this.sel.nextSetBit(0);
            if (n6 >= 0) {
                n7 += this.sel.cardinality() - 1;
            }
            int n8 = Math.min(n, n2);
            int n9 = Math.max(n, n2);
            if (n8 == n6 && n9 == n7) {
                return;
            }
            this.sel.clear();
            this.sel.set(n8, n9 + 1);
            if (n6 >= 0) {
                n8 = Math.min(n8, n6);
            }
            if (n7 >= 0) {
                n9 = Math.max(n9, n7);
            }
            if (this.anchorSelectionIndex >= 0) {
                n8 = Math.min(n8, this.anchorSelectionIndex);
                n9 = Math.max(n9, this.anchorSelectionIndex);
            }
            this.anchorSelectionIndex = n;
            this.leadSelectionIndex = n2;
            this.fireValueChanged(n8, n9);
        } else {
            BitSet bitSet = (BitSet)this.sel.clone();
            this.sel.clear();
            if (this.selectionMode == 0) {
                n = n2;
            }
            int n10 = Math.min(n, n2);
            int n11 = Math.max(n, n2);
            this.sel.set(n10, n11 + 1);
            this.setAnchorSelectionIndex(n);
            this.leadSelectionIndex = n2;
            this.fireDifference(this.sel, bitSet);
        }
    }

    @Override
    public void insertIndexInterval(int n, int n2, boolean bl) {
        if (!bl) {
            ++n;
            --n2;
        }
        BitSet bitSet = this.sel.get(n, this.sel.size());
        this.sel.clear(n, this.sel.size());
        int n3 = bitSet.size();
        for (int i = 0; i < n3; ++i) {
            this.sel.set(n + n2 + i, bitSet.get(i));
        }
    }

    @Override
    public void removeIndexInterval(int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        BitSet bitSet = this.sel.get(n4, this.sel.size());
        this.sel.clear(n3, this.sel.size());
        int n5 = bitSet.size();
        for (int i = 0; i < n5; ++i) {
            this.sel.set(n3 + i, bitSet.get(i));
        }
    }

    protected void fireValueChanged(boolean bl) {
        this.fireValueChanged(this.getMinSelectionIndex(), this.getMaxSelectionIndex(), bl);
    }

    protected void fireValueChanged(int n, int n2) {
        this.fireValueChanged(n, n2, this.getValueIsAdjusting());
    }

    protected void fireValueChanged(int n, int n2, boolean bl) {
        ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
        ListSelectionListener[] listSelectionListenerArray = this.getListSelectionListeners();
        for (int i = 0; i < listSelectionListenerArray.length; ++i) {
            listSelectionListenerArray[i].valueChanged(listSelectionEvent);
        }
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(ListSelectionListener.class, listSelectionListener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this.getListeners(ListSelectionListener.class);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)super.clone();
        defaultListSelectionModel.sel = (BitSet)this.sel.clone();
        defaultListSelectionModel.listenerList = new EventListenerList();
        return defaultListSelectionModel;
    }
}

