/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel,
Serializable {
    private static final long serialVersionUID = 6698657703676921904L;
    private Vector list;
    private Object selectedItem = null;

    public DefaultComboBoxModel() {
        this.list = new Vector();
    }

    public DefaultComboBoxModel(Object[] objectArray) {
        this.list = new Vector<Object>(Arrays.asList(objectArray));
        if (this.list.size() > 0) {
            this.selectedItem = this.list.get(0);
        }
    }

    public DefaultComboBoxModel(Vector<?> vector) {
        this.list = vector;
        if (this.getSize() > 0) {
            this.selectedItem = vector.get(0);
        }
    }

    @Override
    public void addElement(Object object) {
        this.list.addElement(object);
        int n = this.list.size() - 1;
        this.fireIntervalAdded(this, n, n);
        if (this.list.size() == 1 && this.selectedItem == null) {
            this.setSelectedItem(object);
        }
    }

    @Override
    public void removeElementAt(int n) {
        int n2 = this.getIndexOf(this.selectedItem);
        if (n2 == n) {
            if (n2 > 0) {
                this.setSelectedItem(this.getElementAt(n2 - 1));
            } else {
                this.setSelectedItem(this.getElementAt(n2 + 1));
            }
        }
        this.list.removeElementAt(n);
        this.fireIntervalRemoved(this, n, n);
    }

    @Override
    public void insertElementAt(Object object, int n) {
        this.list.insertElementAt(object, n);
        this.fireIntervalAdded(this, n, n);
    }

    @Override
    public void removeElement(Object object) {
        int n = this.getIndexOf(object);
        if (n != -1) {
            this.removeElementAt(n);
        }
    }

    public void removeAllElements() {
        this.selectedItem = null;
        int n = this.getSize();
        if (n > 0) {
            this.list.clear();
            this.fireIntervalRemoved(this, 0, n - 1);
        }
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public void setSelectedItem(Object object) {
        if (this.selectedItem == null && object == null) {
            return;
        }
        if (this.selectedItem != null && this.selectedItem.equals(object)) {
            return;
        }
        if (object != null && this.getIndexOf(object) == -1) {
            return;
        }
        this.selectedItem = object;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public Object getElementAt(int n) {
        if (n < 0 || n >= this.list.size()) {
            return null;
        }
        return this.list.elementAt(n);
    }

    public int getIndexOf(Object object) {
        return this.list.indexOf(object);
    }
}

