/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultButtonModel
implements ButtonModel,
Serializable {
    private static final long serialVersionUID = -5342609566534980231L;
    public static final int ARMED = 1;
    public static final int ENABLED = 8;
    public static final int PRESSED = 4;
    public static final int ROLLOVER = 16;
    public static final int SELECTED = 2;
    protected int stateMask = 8;
    protected EventListenerList listenerList = new EventListenerList();
    protected ChangeEvent changeEvent = new ChangeEvent(this);
    protected ButtonGroup group;
    protected int mnemonic = 0;
    protected String actionCommand;

    @Override
    public Object[] getSelectedObjects() {
        return null;
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(ItemListener.class, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(ItemListener.class, itemListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        ItemListener[] itemListenerArray = this.getItemListeners();
        for (int i = 0; i < itemListenerArray.length; ++i) {
            itemListenerArray[i].itemStateChanged(itemEvent);
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        ActionListener[] actionListenerArray = this.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            actionListenerArray[i].actionPerformed(actionEvent);
        }
    }

    protected void fireStateChanged() {
        ChangeListener[] changeListenerArray = this.getChangeListeners();
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged(this.changeEvent);
        }
    }

    @Override
    public boolean isArmed() {
        return (this.stateMask & 1) == 1;
    }

    @Override
    public void setArmed(boolean bl) {
        if (bl && this.isArmed() || !bl && !this.isArmed()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 1) : (this.stateMask &= 0xFFFFFFFE);
        this.fireStateChanged();
    }

    @Override
    public boolean isEnabled() {
        return (this.stateMask & 8) == 8;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl && this.isEnabled() || !bl && !this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 8) : this.stateMask & 0xFFFFFFF7 & 0xFFFFFFFE & 0xFFFFFFFB;
        this.fireStateChanged();
    }

    @Override
    public void setPressed(boolean bl) {
        if (bl && this.isPressed() || !bl && !this.isPressed()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        if (!bl && this.isArmed()) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
        this.fireStateChanged();
    }

    @Override
    public boolean isPressed() {
        return (this.stateMask & 4) == 4;
    }

    @Override
    public void setRollover(boolean bl) {
        if (bl == this.isRollover()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 0x10) : (this.stateMask &= 0xFFFFFFEF);
        this.fireStateChanged();
    }

    @Override
    public void setSelected(boolean bl) {
        if (bl && this.isSelected() || !bl && !this.isSelected()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
        this.fireStateChanged();
        if (bl) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this, 1));
            if (this.group != null) {
                this.group.setSelected(this, true);
            }
        } else {
            this.fireItemStateChanged(new ItemEvent(this, 701, this, 2));
            if (this.group != null) {
                this.group.setSelected(this, false);
            }
        }
    }

    @Override
    public boolean isSelected() {
        return (this.stateMask & 2) == 2;
    }

    @Override
    public boolean isRollover() {
        return (this.stateMask & 0x10) == 16;
    }

    @Override
    public int getMnemonic() {
        return this.mnemonic;
    }

    @Override
    public void setMnemonic(int n) {
        if (this.mnemonic != n) {
            this.mnemonic = n;
            this.fireStateChanged();
        }
    }

    @Override
    public void setActionCommand(String string) {
        if (this.actionCommand != string) {
            this.actionCommand = string;
            this.fireStateChanged();
        }
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public void setGroup(ButtonGroup buttonGroup) {
        this.group = buttonGroup;
    }

    public ButtonGroup getGroup() {
        return this.group;
    }
}

