/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import javax.swing.SizeRequirements;

public class BoxLayout
implements LayoutManager2,
Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private static final long serialVersionUID = -2474455742719112368L;
    private Container container;
    private int way = 0;
    private SizeRequirements[] xChildren;
    private SizeRequirements[] yChildren;
    private SizeRequirements xTotal;
    private SizeRequirements yTotal;
    private int[] offsetsX;
    private int[] offsetsY;
    private int[] spansX;
    private int[] spansY;

    public BoxLayout(Container container, int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new AWTError("Invalid axis");
        }
        boolean bl = false;
        boolean bl2 = false;
        this.container = container;
        this.way = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    private boolean isHorizontalIn(Container container) {
        ComponentOrientation componentOrientation = container.getComponentOrientation();
        return this.way == 0 || this.way == 2 && componentOrientation.isHorizontal() || this.way == 3 && !componentOrientation.isHorizontal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = this.container.getTreeLock();
        synchronized (object) {
            if (this.container != container) {
                throw new AWTError("BoxLayout can't be shared");
            }
            this.checkTotalRequirements();
            Insets insets = this.container.getInsets();
            return new Dimension(this.xTotal.preferred + insets.left + insets.right, this.yTotal.preferred + insets.top + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = this.container.getTreeLock();
        synchronized (object) {
            if (this.container != container) {
                throw new AWTError("BoxLayout can't be shared");
            }
            this.checkTotalRequirements();
            Insets insets = this.container.getInsets();
            return new Dimension(this.xTotal.minimum + insets.left + insets.right, this.yTotal.minimum + insets.top + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = this.container.getTreeLock();
        synchronized (object) {
            if (this.container != container) {
                throw new AWTError("BoxLayout can't be shared");
            }
            this.checkLayout();
            Component[] componentArray = this.container.getComponents();
            Insets insets = this.container.getInsets();
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].setBounds(this.offsetsX[i] + insets.left, this.offsetsY[i] + insets.top, this.spansX[i], this.spansY[i]);
            }
        }
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getLayoutAlignmentX(Container container) {
        Object object = this.container.getTreeLock();
        synchronized (object) {
            if (this.container != container) {
                throw new AWTError("BoxLayout can't be shared");
            }
            this.checkTotalRequirements();
            return this.xTotal.alignment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getLayoutAlignmentY(Container container) {
        Object object = this.container.getTreeLock();
        synchronized (object) {
            if (this.container != container) {
                throw new AWTError("BoxLayout can't be shared");
            }
            this.checkTotalRequirements();
            return this.yTotal.alignment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateLayout(Container container) {
        if (this.container != container) {
            throw new AWTError("BoxLayout can't be shared");
        }
        Object object = this.container.getTreeLock();
        synchronized (object) {
            this.xChildren = null;
            this.yChildren = null;
            this.xTotal = null;
            this.yTotal = null;
            this.offsetsX = null;
            this.offsetsY = null;
            this.spansX = null;
            this.spansY = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension maximumLayoutSize(Container container) {
        Object object = this.container.getTreeLock();
        synchronized (object) {
            if (this.container != container) {
                throw new AWTError("BoxLayout can't be shared");
            }
            this.checkTotalRequirements();
            Insets insets = this.container.getInsets();
            int n = this.xTotal.maximum + insets.left + insets.right;
            int n2 = this.yTotal.maximum + insets.top + insets.bottom;
            if (n < this.xTotal.maximum) {
                n = Integer.MAX_VALUE;
            }
            if (n2 < this.yTotal.maximum) {
                n2 = Integer.MAX_VALUE;
            }
            return new Dimension(n, n2);
        }
    }

    private void checkTotalRequirements() {
        if (this.xTotal == null || this.yTotal == null) {
            this.checkRequirements();
            if (this.isHorizontalIn(this.container)) {
                this.xTotal = SizeRequirements.getTiledSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
            } else {
                this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getTiledSizeRequirements(this.yChildren);
            }
        }
    }

    private void checkRequirements() {
        if (this.xChildren == null || this.yChildren == null) {
            Component[] componentArray = this.container.getComponents();
            this.xChildren = new SizeRequirements[componentArray.length];
            this.yChildren = new SizeRequirements[componentArray.length];
            for (int i = 0; i < componentArray.length; ++i) {
                if (!componentArray[i].isVisible()) {
                    this.xChildren[i] = new SizeRequirements();
                    this.yChildren[i] = new SizeRequirements();
                    continue;
                }
                this.xChildren[i] = new SizeRequirements(componentArray[i].getMinimumSize().width, componentArray[i].getPreferredSize().width, componentArray[i].getMaximumSize().width, componentArray[i].getAlignmentX());
                this.yChildren[i] = new SizeRequirements(componentArray[i].getMinimumSize().height, componentArray[i].getPreferredSize().height, componentArray[i].getMaximumSize().height, componentArray[i].getAlignmentY());
            }
        }
    }

    private void checkLayout() {
        if (this.offsetsX == null || this.offsetsY == null || this.spansX == null || this.spansY == null) {
            this.checkRequirements();
            this.checkTotalRequirements();
            int n = this.container.getComponents().length;
            this.offsetsX = new int[n];
            this.offsetsY = new int[n];
            this.spansX = new int[n];
            this.spansY = new int[n];
            Insets insets = this.container.getInsets();
            int n2 = this.container.getWidth() - insets.left - insets.right;
            int n3 = this.container.getHeight() - insets.top - insets.bottom;
            if (this.isHorizontalIn(this.container)) {
                SizeRequirements.calculateTiledPositions(n2, this.xTotal, this.xChildren, this.offsetsX, this.spansX);
                SizeRequirements.calculateAlignedPositions(n3, this.yTotal, this.yChildren, this.offsetsY, this.spansY);
            } else {
                SizeRequirements.calculateAlignedPositions(n2, this.xTotal, this.xChildren, this.offsetsX, this.spansX);
                SizeRequirements.calculateTiledPositions(n3, this.yTotal, this.yChildren, this.offsetsY, this.spansY);
            }
        }
    }
}

