/*
 * Decompiled with CFR 0.152.
 */
package javax.security.sasl;

import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sasl {
    public static final String QOP = "javax.security.sasl.qop";
    public static final String STRENGTH = "javax.security.sasl.strength";
    public static final String SERVER_AUTH = "javax.security.sasl.server.authentication";
    public static final String MAX_BUFFER = "javax.security.sasl.maxbuffer";
    public static final String RAW_SEND_SIZE = "javax.security.sasl.rawsendsize";
    public static final String POLICY_NOPLAINTEXT = "javax.security.sasl.policy.noplaintext";
    public static final String POLICY_NOACTIVE = "javax.security.sasl.policy.noactive";
    public static final String POLICY_NODICTIONARY = "javax.security.sasl.policy.nodictionary";
    public static final String POLICY_NOANONYMOUS = "javax.security.sasl.policy.noanonymous";
    public static final String POLICY_FORWARD_SECRECY = "javax.security.sasl.policy.forward";
    public static final String POLICY_PASS_CREDENTIALS = "javax.security.sasl.policy.credentials";
    public static final String REUSE = "javax.security.sasl.reuse";
    private static final String CLIENT_FACTORY_SVC = "SaslClientFactory.";
    private static final String SERVER_FACTORY_SVC = "SaslServerFactory.";
    private static final String ALIAS = "Alg.Alias.";

    private Sasl() {
    }

    public static SaslClient createSaslClient(String[] stringArray, String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        if (stringArray == null) {
            return null;
        }
        Provider[] providerArray = Security.getProviders();
        if (providerArray == null || providerArray.length == 0) {
            return null;
        }
        SaslClient saslClient = null;
        SaslClientFactory saslClientFactory = null;
        String string4 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string5 = stringArray[i];
            if (string5 == null) continue;
            for (int j = 0; j < providerArray.length; ++j) {
                Provider provider = providerArray[j];
                if (provider != null) {
                    string4 = provider.getProperty(CLIENT_FACTORY_SVC + string5);
                    if (string4 == null) {
                        String string6 = string5.toUpperCase();
                        string4 = provider.getProperty(CLIENT_FACTORY_SVC + string6);
                        if (string4 == null) {
                            String string7 = provider.getProperty("Alg.Alias.SaslClientFactory." + string5);
                            if (string7 == null && (string7 = provider.getProperty("Alg.Alias.SaslClientFactory." + string6)) == null) continue;
                            string4 = provider.getProperty(CLIENT_FACTORY_SVC + string7);
                        }
                    }
                    if (string4 == null) continue;
                    string4 = string4.trim();
                }
                try {
                    saslClient = null;
                    saslClientFactory = (SaslClientFactory)Class.forName(string4).newInstance();
                    saslClient = saslClientFactory.createSaslClient(stringArray, string, string2, string3, map, callbackHandler);
                }
                catch (ClassCastException classCastException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (saslClient == null) continue;
                return saslClient;
            }
        }
        return null;
    }

    public static Enumeration<SaslClientFactory> getSaslClientFactories() {
        Vector<SaslClientFactory> vector = new Vector<SaslClientFactory>();
        HashSet<String> hashSet = new HashSet<String>();
        Provider[] providerArray = Security.getProviders();
        if (providerArray != null) {
            block5: for (int i = 0; i < providerArray.length; ++i) {
                Provider object = providerArray[i];
                for (Object classNotFoundException : object.keySet()) {
                    if (!((String)classNotFoundException).startsWith(CLIENT_FACTORY_SVC) || ((String)classNotFoundException).indexOf(" ") != -1) continue;
                    hashSet.add(object.getProperty((String)classNotFoundException));
                    continue block5;
                }
            }
        }
        for (String string : hashSet) {
            try {
                Object classNotFoundException;
                classNotFoundException = (SaslClientFactory)Class.forName(string).newInstance();
                if (classNotFoundException == null) continue;
                vector.add((SaslClientFactory)classNotFoundException);
            }
            catch (ClassCastException instantiationException) {
            }
            catch (ClassNotFoundException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return vector.elements();
    }

    public static SaslServer createSaslServer(String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        if (string == null) {
            return null;
        }
        Provider[] providerArray = Security.getProviders();
        if (providerArray == null || providerArray.length == 0) {
            return null;
        }
        SaslServer saslServer = null;
        SaslServerFactory saslServerFactory = null;
        String string4 = null;
        String string5 = null;
        for (int i = 0; i < providerArray.length; ++i) {
            Provider provider = providerArray[i];
            if (provider != null && (string4 = provider.getProperty(SERVER_FACTORY_SVC + string)) == null) {
                String string6 = string.toUpperCase();
                string4 = provider.getProperty(SERVER_FACTORY_SVC + string6);
                if (string4 == null && (string5 = provider.getProperty("Alg.Alias.SaslServerFactory." + string)) == null && (string5 = provider.getProperty("Alg.Alias.SaslServerFactory." + string6)) == null) continue;
                string4 = provider.getProperty(SERVER_FACTORY_SVC + string5);
            }
            if (string4 == null) continue;
            string4 = string4.trim();
            try {
                saslServer = null;
                saslServerFactory = (SaslServerFactory)Class.forName(string4).newInstance();
                saslServer = saslServerFactory.createSaslServer(string, string2, string3, map, callbackHandler);
            }
            catch (ClassCastException classCastException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (saslServer == null) continue;
            return saslServer;
        }
        return null;
    }

    public static Enumeration<SaslServerFactory> getSaslServerFactories() {
        Vector<SaslServerFactory> vector = new Vector<SaslServerFactory>();
        HashSet<String> hashSet = new HashSet<String>();
        Provider[] providerArray = Security.getProviders();
        if (providerArray != null) {
            block5: for (int i = 0; i < providerArray.length; ++i) {
                Provider object = providerArray[i];
                for (Object classNotFoundException : object.keySet()) {
                    if (!((String)classNotFoundException).startsWith(SERVER_FACTORY_SVC) || ((String)classNotFoundException).indexOf(" ") != -1) continue;
                    hashSet.add(object.getProperty((String)classNotFoundException));
                    continue block5;
                }
            }
        }
        for (String string : hashSet) {
            try {
                Object classNotFoundException;
                classNotFoundException = (SaslServerFactory)Class.forName(string).newInstance();
                if (classNotFoundException == null) continue;
                vector.add((SaslServerFactory)classNotFoundException);
            }
            catch (ClassCastException instantiationException) {
            }
            catch (ClassNotFoundException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return vector.elements();
    }
}

