/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppConfigurationEntry {
    private final String loginModuleName;
    private final LoginModuleControlFlag controlFlag;
    private final Map options;

    public AppConfigurationEntry(String string, LoginModuleControlFlag loginModuleControlFlag, Map<String, ?> map) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("module name cannot be null nor empty");
        }
        if (LoginModuleControlFlag.OPTIONAL != loginModuleControlFlag && LoginModuleControlFlag.REQUIRED != loginModuleControlFlag && LoginModuleControlFlag.REQUISITE != loginModuleControlFlag && LoginModuleControlFlag.SUFFICIENT != loginModuleControlFlag) {
            throw new IllegalArgumentException("invalid controlFlag");
        }
        if (map == null) {
            throw new IllegalArgumentException("options cannot be null");
        }
        this.loginModuleName = string;
        this.controlFlag = loginModuleControlFlag;
        this.options = Collections.unmodifiableMap(new HashMap(map));
    }

    public LoginModuleControlFlag getControlFlag() {
        return this.controlFlag;
    }

    public String getLoginModuleName() {
        return this.loginModuleName;
    }

    public Map<String, ?> getOptions() {
        return this.options;
    }

    public String toString() {
        return this.loginModuleName + "\t" + String.valueOf(this.controlFlag) + "\t" + String.valueOf(this.options);
    }

    public static class LoginModuleControlFlag {
        public static final LoginModuleControlFlag OPTIONAL = new LoginModuleControlFlag();
        public static final LoginModuleControlFlag REQUIRED = new LoginModuleControlFlag();
        public static final LoginModuleControlFlag REQUISITE = new LoginModuleControlFlag();
        public static final LoginModuleControlFlag SUFFICIENT = new LoginModuleControlFlag();

        private LoginModuleControlFlag() {
        }

        public String toString() {
            if (this == REQUIRED) {
                return "REQUIRED";
            }
            if (this == REQUISITE) {
                return "REQUISITE";
            }
            if (this == SUFFICIENT) {
                return "SUFFICIENT";
            }
            if (this == OPTIONAL) {
                return "OPTIONAL";
            }
            return "???";
        }
    }
}

